package projector.language;


import projector.core.*;
import projector.gui.*;
import java.util.Vector;
import java.util.Hashtable;
import java.awt.*;
import java.awt.event.*;

/*************
	Written by Sayantan Chakravorty
	October 2002
	This class is used to do language specific interpretations of EventObject Data and
	for Intervals etc
*********/

public class Interpreter_ampi extends Interpreter{
	Hashtable funcTable;
	Color [] colorTable;
	int maxfuncNo;
	public Interpreter_ampi(){
		funcTable = new Hashtable();		
		colorTable = null;
		maxfuncNo = -1;
	}

	public boolean isBeginType(EventObject obj){
		if(obj.language == 4 && obj.eventType == EventType._E_BEGIN_AMPI_PROCESSING )
			return true;
		else
			return false;
	}
	
	public boolean isEndType(EventObject obj){
		if(obj.language == 4 && obj.eventType == EventType._E_END_AMPI_PROCESSING)
			return true;
		else
			return false;
	}
	
	public TimelineObject [] createTLO(Vector intervalVect,int pnum,TimelineData data){
		int numIntervals = intervalVect.size();
		EventInterval intervalElement;
		long btime, etime, rtime;
	  	int tag,index, pSrc,funcNo, numMsgs, numpacks, msglen;
	  	int EventID;
          	ObjectId tid;
		AmpiEventObject aeObjstart,aeObjend;

		
		
		tid = new ObjectId(); // not used by ampi will have to be removed later  meaningless in ampi .. is preserved to avoid rewriting constructor for TimelineObject 
		
		TimelineObject [] tlo = new TimelineObject[numIntervals];
		for(int i=0;i<numIntervals;i++){
			intervalElement = (EventInterval )intervalVect.elementAt(i);
			btime = (long )(intervalElement.startTime*1000000.0);
			etime = (long )(intervalElement.endTime * 1000000.0);
			try{
			  if(intervalElement.beginObj != null){
				aeObjstart = new AmpiEventObject (intervalElement.beginObj);
				aeObjstart.parseIData(aeObjstart.iData);
				aeObjend = new AmpiEventObject (intervalElement.endObj);
				aeObjend.parseIData(aeObjend.iData);
				//System.out.println("Object EventID " + ceObjstart.eventID + " of type " + ceObjstart.entry);
				index = aeObjstart.index;
		 		pSrc  = aeObjstart.src;
				funcNo = aeObjstart.funcNo;
		
		 		//msglen  = ceObjstart.msgLen;
				msglen = -1;
				// all fields of TimelineObject are not traced at present by Projector
 		 		
		 		rtime = 0;
		 		EventID = -1; // no sense for ampi 
			  }else{					
				  index = -1;
					pSrc = pnum;
					msglen = -1;
					rtime = 0;
					EventID = -1;					
					funcNo = -1;
			  }
				
				//The first traversal is used to count the number of messages
				
				numMsgs = 0;
				numpacks = 0;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					if(eventObj.eventType == EventType._E_AMPI_MSG_SEND){
						numMsgs++;
					}else{
						if(eventObj.eventType == EventType._E_AMPI_BEGIN_FUNC){
							// Hack should actually go through the ampi event Object......
							String funcName = (String )funcTable.get(new Integer(eventObj.iData[1]));
							if(funcName == null){
								funcTable.put(new Integer(eventObj.iData[1]),eventObj.sData);
									//maxfuncNo is used to create the color map
								if(eventObj.iData[1] > maxfuncNo){
									maxfuncNo = eventObj.iData[1];
								}
							}
							//this is where you catch the begin_func event
							//System.out.println("xxxy" + eventObj.sData);							
						}
					}					
				}

				TimelineMessage[] msgs = new TimelineMessage[numMsgs];
				PackTime[] packs = new PackTime[numpacks];
				int countMsgs=0,countPacks=0;
	  			PackTime          PT          = null;
				TimelineMessage  TM = null;
				for(int j=0;j<intervalElement.eventVector.size();j++){
					GeneralEventObject eventObj = (GeneralEventObject )intervalElement.eventVector.elementAt(j);
					AmpiEventObject ampiEventObj = new AmpiEventObject(eventObj);
					ampiEventObj.parseIData(eventObj.iData);
					if(ampiEventObj.eventType == EventType._E_AMPI_MSG_SEND){
						msgs[countMsgs] = (TM=new TimelineMessage((long )(ampiEventObj.timestamp*1000000.0),ampiEventObj.tag,ampiEventObj.size,-1));
						//System.out.println("TimelineMessage Time " + TM.Time+"Event time " + charmEventObj.timestamp);
						countMsgs++;
					}
					

				}

				tlo[i] = new TimelineObject(data, btime, etime, index, msgs, packs, pnum, pSrc, msglen, rtime, tid,funcNo,this);

			}catch(Exception e){
				System.out.println("Exception due to parseIData");
				e.printStackTrace();
			}
		}
		createColorTable();
		return tlo;
	}
	
	public String[] getBubbleText(TimelineObject t){
		String [] bubbletext = new String [7];
		bubbletext[0] = "Virtual Processor :" + t.entry;
		bubbletext[1] = "Begin Time: " + t.format_.format(t.beginTime);
		bubbletext[2] = "End Time: " + t.format_.format(t.endTime);
		bubbletext[3] = "Total Time: " + U.t(t.endTime-t.beginTime);
		bubbletext[4] = "Msgs created: " + t.messages.length;
		if(t.pCreation < 0){
			if(t.pCreation == -1){
				bubbletext[5] = "Result of MPI_Reduce";
			}
			if(t.pCreation == -2){
				bubbletext[5] = "Result of MPI_AllReduce";
			}
		}else{		
			bubbletext[5] = "Created by Virtual processor " + t.pCreation;
		}
		bubbletext[6] = "Function :" + (String )funcTable.get(new Integer(t.EventID));
		return bubbletext;
	}
	
	public void handleTimelineClick(TimelineObject t,MouseEvent evt){
		if(t.entry >= 0){
       		if(evt.getModifiers()==MouseEvent.BUTTON1_MASK){
			 t.OpenMessageWindow();
		}
		}
	}	
	private void createColorTable(){
		colorTable = new Color[maxfuncNo+1];		
		float deltaR =(float) 255.0/(float)(maxfuncNo+1.0);
		float deltaB = (float) 255.0/(float)(maxfuncNo+1.0);
		float R= (float )0.0;
		float G=(float )128.0;
		float B=(float )255.0;
		for(int i=0;i<=maxfuncNo;i++){
			colorTable[i] = new Color((int)R,(int )G,(int )B);
			R += deltaR;
			B -= deltaB;
		}
	}
		public Color getTimelineObjectColor(TimelineObject t){
		    // a temporary hack ... what do colors mean in
		    // AMPI?
		    if (t.EventID != -1) {
			return colorTable[t.EventID];
		    } else {
			return Color.red;
		    }
		}	
	
}	
