/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class GdbProcess {
    ParDebug mainThread;
    Process gdb = null;
    public BufferedWriter gdbIn;
    public BufferedReader gdbOut;
    private FileWriter debugOutput;

    public GdbProcess(ParDebug pd) {
        this.mainThread = pd;
        try {
            this.debugOutput = new FileWriter("servthread_debug.out");
        }
        catch (IOException e) {
            System.out.println("Error while opening dubug output");
        }
    }

    public String infoCommand(String command) {
        if (this.gdb == null) {
            String executable = new File(this.mainThread.getFilename()).getAbsolutePath();
            String totCommandLine = "gdb " + executable;
            String hostname = this.mainThread.getHostname();
            if (!hostname.equals("localhost")) {
                totCommandLine = hostname + " " + totCommandLine;
                String username = this.mainThread.getUsername();
                if (!username.equals("")) {
                    totCommandLine = "-l " + username + " " + totCommandLine;
                }
                totCommandLine = "ssh " + totCommandLine;
            }
            try {
                this.gdb = Runtime.getRuntime().exec(totCommandLine);
                this.gdbIn = new BufferedWriter(new OutputStreamWriter(this.gdb.getOutputStream()));
                this.gdbOut = new BufferedReader(new InputStreamReader(this.gdb.getInputStream()));
            }
            catch (Exception e) {
                System.out.println("Failed to start gdb info program");
                return "error";
            }
            this.infoCommand(" ");
        }
        try {
            this.gdbIn.write(command);
            this.gdbIn.flush();
            this.debugOutput.write("request: {" + command + "}");
            StringBuffer reply = new StringBuffer();
            while (!reply.toString().endsWith("(gdb) ")) {
                while (this.gdbOut.ready()) {
                    reply.append((char)this.gdbOut.read());
                }
            }
            reply.setLength(reply.length() - 6);
            this.debugOutput.write("reply: |" + reply + "|");
            this.debugOutput.flush();
            return reply.toString();
        }
        catch (IOException e) {
            return "error";
        }
    }

    public void terminate() {
        if (this.gdb != null) {
            this.gdb.destroy();
        }
        this.gdb = null;
    }
}

