/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import projections.analysis.ViewerEvent;
import projections.gui.LogFileViewerDialog;
import projections.gui.LogFileViewerTextArea;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.misc.LogLoadException;

public class LogFileViewerWindow
extends ProjectionsWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private LogFileViewerDialog dialog;
    private int logfilenum = -1;
    private int oldlogfilenum = -1;
    static int myRun = 0;
    private LogFileViewerTextArea textArea;
    private Label lTitle;
    private Button bOpen;
    private Button bClose;
    private Panel titlePanel;

    protected void windowInit() {
    }

    public LogFileViewerWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Log File Viewer - " + MainWindow.runObject[myRun].getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof MenuItem) {
            MenuItem m = (MenuItem)evt.getSource();
            if (m.getLabel().equals("Open File")) {
                this.showDialog();
            } else if (m.getLabel().equals("Close")) {
                this.close();
            }
        } else if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bOpen) {
                this.showDialog();
            } else if (b == this.bClose) {
                this.close();
            }
        }
    }

    public void CloseDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        this.setCursor(new Cursor(3));
        if (this.logfilenum != this.oldlogfilenum) {
            this.textArea.setText(LogFileViewerWindow.getLogFileText(this.logfilenum));
        }
        this.setCursor(new Cursor(0));
    }

    private void CreateLayout() {
        Panel p = new Panel();
        p.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.getContentPane().add(p);
        this.textArea = new LogFileViewerTextArea();
        p.setLayout(gbl);
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new Label("", 1);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        Util.gblAdd(p, this.titlePanel, gbc, 0, 0, 1, 1, 1, 0, 5, 5, 0, 5);
        Util.gblAdd(p, this.textArea, gbc, 0, 1, 1, 1, 1, 1, 0, 5, 5, 5);
        Panel p2 = new Panel();
        this.bOpen = new Button("Open File");
        this.bClose = new Button("Close Window");
        this.bOpen.addActionListener(this);
        this.bClose.addActionListener(this);
        p2.add(this.bOpen);
        p2.add(this.bClose);
        Util.gblAdd(p, p2, gbc, 0, 2, 1, 1, 1, 0, 0, 5, 5, 5);
    }

    private void CreateMenus() {
        MenuBar mbar = new MenuBar();
        mbar.add(Util.makeMenu("File", new Object[]{"Open File", null, "Close"}, this));
        Menu helpMenu = new Menu("Help");
        mbar.add(Util.makeMenu(helpMenu, new Object[]{"Index", "About"}, this));
        mbar.setHelpMenu(helpMenu);
        this.setMenuBar(mbar);
    }

    public void setLogFileNum(int p) {
        this.logfilenum = p;
        this.lTitle.setText("LOG FILE FOR PROCESSOR " + p);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    public void showDialog() {
        this.oldlogfilenum = this.logfilenum;
        if (this.dialog == null) {
            this.dialog = new LogFileViewerDialog(this);
        }
        this.dialog.setVisible(true);
    }

    public static String[][] getLogFileText(int num) {
        if (!MainWindow.runObject[myRun].hasLogData()) {
            return null;
        }
        Vector v = null;
        try {
            v = MainWindow.runObject[LogFileViewerWindow.myRun].logLoader.view(num);
        }
        catch (LogLoadException e) {
            System.err.println("Failed to load Log files");
            return null;
        }
        if (v == null) {
            return null;
        }
        int length = v.size();
        if (length == 0) {
            return null;
        }
        String[][] text = new String[length][2];
        block16: for (int i = 0; i < length; ++i) {
            ViewerEvent ve = (ViewerEvent)v.elementAt(i);
            text[i][0] = "" + ve.Time;
            switch (ve.EventType) {
                case 1: {
                    text[i][1] = "CREATE message to be sent to " + ve.Dest;
                    continue block16;
                }
                case 20: {
                    if (ve.numDestPEs == MainWindow.runObject[myRun].getNumProcessors()) {
                        text[i][1] = "GROUP BROADCAST (" + ve.numDestPEs + " processors)";
                        continue block16;
                    }
                    text[i][1] = "NODEGROUP BROADCAST (" + ve.numDestPEs + " processors)";
                    continue block16;
                }
                case 21: {
                    text[i][1] = "MULTICAST message sent to " + ve.numDestPEs + " processors";
                    continue block16;
                }
                case 2: {
                    text[i][1] = "BEGIN PROCESSING of message sent to " + ve.Dest;
                    String[] stringArray = text[i];
                    stringArray[1] = stringArray[1] + " from processor " + ve.SrcPe;
                    continue block16;
                }
                case 3: {
                    text[i][1] = "END PROCESSING of message sent to " + ve.Dest;
                    String[] stringArray = text[i];
                    stringArray[1] = stringArray[1] + " from processor " + ve.SrcPe;
                    continue block16;
                }
                case 4: {
                    text[i][1] = "ENQUEUEING message received from processor " + ve.SrcPe + " destined for " + ve.Dest;
                    continue block16;
                }
                case 14: {
                    text[i][1] = "IDLE begin";
                    continue block16;
                }
                case 15: {
                    text[i][1] = "IDLE end";
                    continue block16;
                }
                case 16: {
                    text[i][1] = "BEGIN PACKING a message to be sent";
                    continue block16;
                }
                case 17: {
                    text[i][1] = "FINISHED PACKING a message to be sent";
                    continue block16;
                }
                case 18: {
                    text[i][1] = "BEGIN UNPACKING a received message";
                    continue block16;
                }
                case 19: {
                    text[i][1] = "FINISHED UNPACKING a received message";
                    continue block16;
                }
                default: {
                    text[i][1] = "!!!! ADD EVENT TYPE " + ve.EventType + " !!!";
                }
            }
        }
        return text;
    }

    public void showWindow() {
    }

    public void getDialogData() {
    }
}

