/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitor;
import projections.gui.AmpiTimeProfileWindow;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class TimeProfileWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private static final long serialVersionUID = 1L;
    TimeProfileWindow thisWindow;
    static int myRun = 0;
    private EntrySelectionDialog entryDialog;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    private JButton saveColors;
    private JButton loadColors;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    int numEPs;
    private String[] typeLabelNames = new String[]{"Entry Points"};
    boolean[][] stateArray;
    boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] entryNames;
    double[][] graphData;
    private double[][] outputData;
    private Color[] outColors;
    boolean startFlag;
    private JTabbedPane tabPane = null;
    AmpiTimeProfileWindow ampiGraphPanel = null;
    private JPanel epPanel = null;
    boolean ampiTraceOn = false;
    protected int ampiPanelTabIndex;
    protected int epPanelTabIndex;

    protected void windowInit() {
        super.windowInit();
        this.intervalSize = 1000L;
        this.startInterval = 0;
        this.endInterval = this.endTime % this.intervalSize == 0L ? (int)(this.endTime / this.intervalSize - 1L) : (int)(this.endTime / this.intervalSize);
        this.processorList = MainWindow.runObject[myRun].getValidProcessorList();
    }

    public TimeProfileWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Time Profile Graph - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow, myWindowID);
        this.setGraphSpecificData();
        this.numEPs = MainWindow.runObject[myRun].getNumUserEntries();
        this.stateArray = new boolean[1][this.numEPs];
        this.existsArray = new boolean[1][this.numEPs];
        this.colorArray = new Color[1][];
        this.colorArray[0] = MainWindow.runObject[myRun].getColorMap();
        this.entryNames = new String[this.numEPs];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.entryNames[ep] = MainWindow.runObject[myRun].getEntryName(ep);
        }
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        if (MainWindow.runObject[myRun].getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        if (this.ampiTraceOn) {
            this.tabPane = new JTabbedPane();
            this.ampiGraphPanel = new AmpiTimeProfileWindow(mainWindow, myWindowID);
        }
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.thisWindow.setLocationRelativeTo(null);
        this.showDialog();
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        this.setJMenuBar(mbar);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.epSelection = new JButton("Select Entry Points");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.saveColors = new JButton("Save Entry Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Entry Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.epSelection, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gbc, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gbc, 3, 0, 1, 1, 0, 0);
        if (this.ampiTraceOn) {
            this.epPanel = new JPanel();
            this.epPanel.setLayout(gbl);
            JPanel graphPanel = this.getMainPanel();
            Util.gblAdd(this.epPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.epPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
            JPanel ampiPanel = this.ampiGraphPanel.getAmpiMainPanel();
            this.tabPane.add("Entry Points", this.epPanel);
            this.tabPane.add("AMPI Functions", ampiPanel);
            this.epPanelTabIndex = this.tabPane.indexOfComponent(this.epPanel);
            this.ampiPanelTabIndex = this.tabPane.indexOfComponent(ampiPanel);
            this.mainPanel.setLayout(new GridLayout(1, 1));
            this.mainPanel.add(this.tabPane);
        } else {
            JPanel graphPanel = this.getMainPanel();
            Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
        }
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Entry point execution time", "us");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.ampiTraceOn) {
                this.ampiGraphPanel.getRangeVals(this.dialog.getStartTime(), this.dialog.getEndTime(), this.startInterval, this.endInterval, this.intervalSize, this.processorList);
            }
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (TimeProfileWindow.this.dialog.isModified()) {
                        int nextPe = 0;
                        int count = 0;
                        int numIntervals = TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1;
                        TimeProfileWindow.this.graphData = new double[numIntervals][TimeProfileWindow.this.numEPs];
                        long progressStart = System.currentTimeMillis();
                        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[TimeProfileWindow.myRun].guiRoot, "Reading log files", "", 0, TimeProfileWindow.this.processorList.size());
                        progressBar.setNote("Reading");
                        progressBar.setProgress(0);
                        while (TimeProfileWindow.this.processorList.hasMoreElements()) {
                            nextPe = TimeProfileWindow.this.processorList.nextElement();
                            progressBar.setProgress(count);
                            progressBar.setNote("[PE: " + nextPe + " ] Reading Data.");
                            if (progressBar.isCanceled()) {
                                return null;
                            }
                            OrderedIntList tempList = new OrderedIntList();
                            tempList.insert(nextPe);
                            MainWindow.runObject[myRun].LoadGraphData(TimeProfileWindow.this.intervalSize, TimeProfileWindow.this.startInterval, TimeProfileWindow.this.endInterval, true, tempList);
                            if (TimeProfileWindow.this.ampiTraceOn) {
                                TimeProfileWindow.this.ampiGraphPanel.createAMPITimeProfileData(nextPe, count);
                            }
                            TimeProfileWindow.this.fillGraphData();
                            ++count;
                        }
                        progressBar.close();
                        if (TimeProfileWindow.this.startFlag) {
                            block1: for (int ep = 0; ep < TimeProfileWindow.this.numEPs; ++ep) {
                                for (int interval = 0; interval < TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1; ++interval) {
                                    if (!(TimeProfileWindow.this.graphData[interval][ep] > 0.0)) continue;
                                    TimeProfileWindow.this.existsArray[0][ep] = true;
                                    TimeProfileWindow.this.stateArray[0][ep] = true;
                                    continue block1;
                                }
                            }
                        }
                        if (TimeProfileWindow.this.startFlag) {
                            TimeProfileWindow.this.startFlag = false;
                        }
                    }
                    return null;
                }

                public void finished() {
                    TimeProfileWindow.this.setOutputGraphData();
                    if (TimeProfileWindow.this.ampiTraceOn) {
                        TimeProfileWindow.this.ampiGraphPanel.setOutputGraphData(true);
                    }
                    TimeProfileWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        this.startInterval = (int)dialog.getStartInterval();
        this.endInterval = (int)dialog.getEndInterval();
        this.processorList = dialog.getValidProcessors();
        super.getDialogData();
    }

    public void showWindow() {
    }

    void fillGraphData() {
        for (int ep = 0; ep < this.numEPs; ++ep) {
            int[][] entryData = MainWindow.runObject[myRun].getUserEntryData(ep, 2);
            for (int interval = 0; interval < this.graphData.length; ++interval) {
                double[] dArray = this.graphData[interval];
                int n = ep;
                dArray[n] = dArray[n] + (double)entryData[0][interval];
            }
        }
    }

    public void applyDialogColors() {
        this.setOutputGraphData();
    }

    void setOutputGraphData() {
        int outSize = 0;
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[0][ep]) continue;
            ++outSize;
        }
        if (outSize != 0) {
            int numIntervals = this.endInterval - this.startInterval + 1;
            this.outputData = new double[numIntervals][outSize];
            this.outColors = new Color[outSize];
            for (int i = 0; i < numIntervals; ++i) {
                int count = 0;
                for (int ep = 0; ep < this.numEPs; ++ep) {
                    if (!this.stateArray[0][ep]) continue;
                    this.outputData[i][count] = this.graphData[i][ep];
                    this.outColors[count++] = this.colorArray[0][ep];
                }
            }
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Entry point execution time", "us");
            this.setDataSource("Time Profile Graph", this.outputData, this.outColors, this.thisWindow);
            this.refreshGraph();
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        int count = 0;
        String epName = "";
        String epClassName = "";
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[0][ep] || count++ != yVal) continue;
            epName = MainWindow.runObject[myRun].getEntryName(ep);
            epClassName = MainWindow.runObject[myRun].getEntryChareName(ep);
            break;
        }
        String[] rString = new String[]{"Time Interval: " + U.t((long)(xVal + this.startInterval) * this.intervalSize) + " to " + U.t((long)(xVal + this.startInterval + 1) * this.intervalSize), "Chare Name: " + epClassName, "Entry Method: " + epName, "Execution Time = " + U.t((long)this.outputData[xVal][yVal])};
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.entryNames);
                }
                this.entryDialog.showDialog();
            } else if (b == this.setRanges) {
                this.showDialog();
            } else if (b == this.saveColors) {
                MainWindow.runObject[myRun].saveColors();
            } else if (b == this.loadColors) {
                try {
                    ColorManager.loadActivityColors(0, this.colorArray[0]);
                    this.setOutputGraphData();
                }
                catch (IOException exception) {
                    System.err.println("Failed to load colors!!");
                }
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }
}

