/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ToolTipManager;
import projections.analysis.PackTime;
import projections.analysis.ThreadManager;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MessageStructures;
import projections.gui.Timeline.ThreadedFileReader;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Timeline.UserEventObject;
import projections.misc.LogLoadException;

public class Data {
    int myRun = 0;
    private MainHandler modificationHandler = null;
    private float scaleFactor = 1.0f;
    private double preferredViewTime = -1.0;
    private int mostRecentScaledScreenWidth;
    private OrderedIntList processorList;
    HashMap peToLine;
    private boolean colorByObjectId;
    private boolean colorByMemoryUsage;
    private boolean colorByUserSupplied;
    private int[] entries;
    private Color[] entryColor;
    public TreeMap allEntryMethodObjects;
    public TreeMap allUserEventObjects;
    float[] processorUsage;
    float[] idleUsage;
    float[] packUsage;
    OrderedUsageList[] entryUsageList;
    private long beginTime;
    private long endTime;
    long oldBT;
    long oldET;
    long minMem;
    long maxMem;
    MessageStructures messageStructures;
    private boolean showPacks;
    private boolean showIdle;
    private boolean showMsgs;
    private boolean showUserEvents;
    public Font labelFont;
    public Font axisFont;
    private boolean useMinimalView = false;
    public Set drawMessagesForTheseObjects;
    public Set drawMessagesForTheseObjectsAlt;
    public float messageLineThickness = 2.5f;
    private boolean useCustomColors = false;
    private Color customForeground;
    private Color customBackground;
    private int selection1 = -1;
    private int selection2 = -1;
    private int highlight = -1;
    private boolean keepViewCentered = false;
    private Set highlightedObjects;
    private boolean traceMessagesOnHover;
    private boolean traceOIDOnHover;
    private boolean useCompactView;
    private Component guiRoot;

    public boolean useMinimalView() {
        return this.useMinimalView;
    }

    public Data(MainHandler rh) {
        this.modificationHandler = rh;
        this.showPacks = false;
        this.showMsgs = true;
        this.showIdle = true;
        this.showUserEvents = true;
        this.processorList = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.messageStructures = new MessageStructures(this);
        this.oldBT = -1L;
        this.oldET = -1L;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.minMem = Integer.MAX_VALUE;
        this.maxMem = Integer.MIN_VALUE;
        this.beginTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.drawMessagesForTheseObjects = new HashSet();
        this.drawMessagesForTheseObjectsAlt = new HashSet();
        this.allEntryMethodObjects = null;
        this.entries = new int[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.entryColor = MainWindow.runObject[this.myRun].getColorMap();
        this.labelFont = new Font("SansSerif", 0, 12);
        this.axisFont = new Font("SansSerif", 0, 10);
        this.highlightedObjects = new HashSet();
        this.colorByMemoryUsage = false;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
    }

    public void addProcessor(int pCreation) {
        int oldNumP = this.processorList.size();
        this.processorList.insert(pCreation);
        int newNumP = this.processorList.size();
        if (oldNumP != newNumP) {
            this.modificationHandler.notifyProcessorListHasChanged();
        }
    }

    public void setFontSizes(int labelFontSize, int axisFontSize, boolean useBoldForLabel) {
        this.labelFont = useBoldForLabel ? new Font("SansSerif", 1, labelFontSize) : new Font("SansSerif", 0, labelFontSize);
        this.axisFont = new Font("SansSerif", 0, axisFontSize);
    }

    public long beginTime() {
        return this.beginTime;
    }

    public boolean colorbyObjectId() {
        return this.colorByObjectId;
    }

    public void createTLOArray(boolean useHelperThreads, Component rootWindow) {
        this.messageStructures.kill();
        if (this.beginTime >= this.oldBT && this.endTime <= this.oldET) {
            TreeMap oldEntryMethodObjects = this.allEntryMethodObjects;
            TreeMap oldUserEventObjects = this.allUserEventObjects;
            this.allEntryMethodObjects = new TreeMap();
            this.allUserEventObjects = new TreeMap();
            this.processorList.reset();
            int p = this.processorList.nextElement();
            while (p != -1) {
                Integer pe = new Integer(p);
                if (oldEntryMethodObjects.containsKey(pe)) {
                    this.allEntryMethodObjects.put(pe, oldEntryMethodObjects.get(pe));
                    this.allUserEventObjects.put(pe, oldUserEventObjects.get(pe));
                    Iterator iter = ((LinkedList)this.allEntryMethodObjects.get(pe)).iterator();
                    while (iter.hasNext()) {
                        EntryMethodObject obj = (EntryMethodObject)iter.next();
                        if (obj.getEndTime() >= this.beginTime && obj.getBeginTime() <= this.endTime) continue;
                        iter.remove();
                    }
                    Iterator iter2 = ((LinkedList)this.allUserEventObjects.get(pe)).iterator();
                    while (iter2.hasNext()) {
                        UserEventObject obj = (UserEventObject)iter2.next();
                        if (obj.EndTime >= this.beginTime && obj.BeginTime <= this.endTime) continue;
                        iter2.remove();
                    }
                }
                p = this.processorList.nextElement();
            }
        } else {
            this.allEntryMethodObjects = new TreeMap();
            this.allUserEventObjects = new TreeMap();
        }
        this.oldBT = this.beginTime;
        this.oldET = this.endTime;
        Date startReadingTime = new Date();
        this.processorList.reset();
        int numPs = this.processorList.size();
        LinkedList<ThreadedFileReader> readyReaders = new LinkedList<ThreadedFileReader>();
        for (int p = 0; p < numPs; ++p) {
            int pe = this.processorList.nextElement();
            if (this.allEntryMethodObjects.containsKey(new Integer(pe))) continue;
            readyReaders.add(new ThreadedFileReader(pe, p, this));
        }
        if (rootWindow == null) {
            rootWindow = MainWindow.runObject[this.myRun].guiRoot;
        }
        ThreadManager threadManager = new ThreadManager("Loading Files in Parallel", readyReaders, rootWindow);
        threadManager.runThreads();
        if (threadManager.numInitialThreads > 0) {
            Date endReadingTime = new Date();
            System.out.println("Time to read " + threadManager.numInitialThreads + " input files(using " + threadManager.numConcurrentThreads + " concurrent threads): " + (double)(endReadingTime.getTime() - startReadingTime.getTime()) / 1000.0 + "sec");
        }
        for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
            this.entries[e] = 0;
        }
        this.processorUsage = new float[this.numPEs()];
        this.entryUsageList = new OrderedUsageList[this.numPEs()];
        float[] entryUsageArray = new float[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.idleUsage = new float[this.numPEs()];
        this.packUsage = new float[this.numPEs()];
        for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
            entryUsageArray[i] = 0.0f;
        }
        for (int p = 0; p < this.numPEs(); ++p) {
            this.processorUsage[p] = 0.0f;
            this.idleUsage[p] = 0.0f;
            this.packUsage[p] = 0.0f;
        }
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            LinkedList objs = (LinkedList)this.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                float usage = obj.getUsage();
                int entrynum = obj.getEntry();
                if (entrynum >= 0) {
                    int n = entrynum;
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = pe;
                    this.processorUsage[n2] = this.processorUsage[n2] + usage;
                    int n3 = pe;
                    this.packUsage[n3] = this.packUsage[n3] + obj.getPackUsage();
                    int n4 = entrynum;
                    entryUsageArray[n4] = entryUsageArray[n4] + obj.getNonPackUsage();
                    continue;
                }
                int n = pe;
                this.idleUsage[n] = this.idleUsage[n] + usage;
            }
            this.entryUsageList[pe.intValue()] = new OrderedUsageList();
            for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
                if (!(entryUsageArray[i] > 0.0f)) continue;
                this.entryUsageList[pe].insert(entryUsageArray[i], i);
            }
        }
        this.updatePEVerticalOrdering();
        this.messageStructures.create(useHelperThreads);
    }

    public void decreaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) - 1) / 4.0f);
    }

    private void displayMustBeRedrawn() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(true);
        }
    }

    public void displayMustBeRepainted() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void clearAllLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
        this.displayMustBeRepainted();
    }

    public void toggleMessageSendLine(EntryMethodObject obj) {
        TimelineMessage created_message = obj.creationMessage();
        if (created_message != null) {
            if (this.drawMessagesForTheseObjects.contains(obj)) {
                this.drawMessagesForTheseObjects.remove(obj);
            } else {
                this.drawMessagesForTheseObjects.add(obj);
            }
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("Message was sent from outside the current time range");
        }
    }

    public void addMessageSendLine(EntryMethodObject obj) {
        this.drawMessagesForTheseObjects.add(obj);
    }

    public void addMessageSendLineAlt(Set s) {
        this.drawMessagesForTheseObjectsAlt.addAll(s);
    }

    public void addMessageSendLine(Set s) {
        this.drawMessagesForTheseObjects.addAll(s);
    }

    public void removeMessageSendLine(Set s) {
        this.drawMessagesForTheseObjects.removeAll(s);
        this.drawMessagesForTheseObjectsAlt.removeAll(s);
    }

    public void clearMessageSendLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
    }

    public long endTime() {
        return this.endTime;
    }

    public int[] entries() {
        return this.entries;
    }

    public Color[] entryColor() {
        return this.entryColor;
    }

    public Color getBackgroundColor() {
        if (this.useCustomColors) {
            return this.customBackground;
        }
        return MainWindow.runObject[this.myRun].background;
    }

    void getData(Integer pe) {
        LinkedList tl = new LinkedList();
        LinkedList userEvents = new LinkedList();
        LinkedList<EntryMethodObject> perPEObjects = new LinkedList<EntryMethodObject>();
        if (perPEObjects == null) {
            System.err.println("perPEOBjects was not allocated successfully!!!!");
        }
        try {
            if (!MainWindow.runObject[this.myRun].hasLogData()) {
                System.err.println("createTL: No log files available!");
                return;
            }
            MainWindow.runObject[this.myRun].logLoader.createtimeline(pe, this.beginTime, this.endTime, tl, userEvents);
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION");
            return;
        }
        this.getDataSyncSaveObjectLists(pe, perPEObjects, userEvents);
        long minMemThisPE = Long.MAX_VALUE;
        long maxMemThisPE = 0L;
        for (TimelineEvent tle : tl) {
            Vector packlist;
            Vector msglist = tle.MsgsSent;
            TreeSet msgs = new TreeSet();
            if (msglist != null) {
                msgs.addAll(msglist);
            }
            int numpacks = (packlist = tle.PackTimes) == null ? 0 : packlist.size();
            PackTime[] packs = new PackTime[numpacks];
            for (int p = 0; p < numpacks; ++p) {
                packs[p] = (PackTime)packlist.elementAt(p);
            }
            if (tle == null) {
                System.out.println("tle is NULL");
            }
            if (msgs == null) {
                System.out.println("msgs is NULL");
            }
            if (pe == null) {
                System.out.println("pe is NULL");
            }
            if (perPEObjects == null) {
                System.out.println("perPEObjects is NULL");
            }
            perPEObjects.add(new EntryMethodObject(this, tle, msgs, packs, pe));
            if (tle == null || tle.memoryUsage == null) continue;
            if (tle.memoryUsage.longValue() > maxMemThisPE) {
                maxMemThisPE = tle.memoryUsage.longValue();
            }
            if (tle.memoryUsage.longValue() >= minMemThisPE) continue;
            minMemThisPE = tle.memoryUsage.longValue();
        }
        this.getDataSyncSaveMemUsage(minMemThisPE, maxMemThisPE);
    }

    synchronized void getDataSyncSaveObjectLists(Integer pe, LinkedList perPEObjects, LinkedList userEvents) {
        this.allUserEventObjects.put(pe, userEvents);
        this.allEntryMethodObjects.put(pe, perPEObjects);
    }

    synchronized void getDataSyncSaveMemUsage(long minMemThisPE, long maxMemThisPE) {
        if (minMemThisPE < this.minMem) {
            this.minMem = minMemThisPE;
        }
        if (maxMemThisPE > this.maxMem) {
            this.maxMem = maxMemThisPE;
        }
        if (this.memoryUsageValid()) {
            System.out.println("memory usage seen in the logs ranges from : " + this.minMem / 1024L / 1024L + "MB to " + this.maxMem / 1024L / 1024L + "MB");
        }
    }

    private boolean memoryUsageValid() {
        return this.maxMem != Integer.MIN_VALUE && this.minMem != Integer.MAX_VALUE && this.maxMem != 0L;
    }

    public Color getForegroundColor() {
        if (this.useCustomColors) {
            return this.customForeground;
        }
        return MainWindow.runObject[this.myRun].foreground;
    }

    public int getNumUserEvents() {
        Iterator iter = this.allUserEventObjects.values().iterator();
        int num = 0;
        while (iter.hasNext()) {
            num += ((LinkedList)iter.next()).size();
        }
        return num;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void increaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) + 1) / 4.0f);
    }

    public int lineWidth(int actualDisplayWidth) {
        return actualDisplayWidth - 2 * this.offset();
    }

    public int maxLabelLen() {
        return 70;
    }

    public int numPs() {
        return this.processorList.size();
    }

    public int numPEs() {
        return MainWindow.runObject[this.myRun].getNumProcessors();
    }

    public int offset() {
        if (this.useMinimalView()) {
            return this.maxLabelLen() / 2;
        }
        return 5 + this.maxLabelLen() / 2;
    }

    public int leftOffset() {
        return this.offset();
    }

    public int rightOffset() {
        return this.offset();
    }

    public OrderedIntList processorList() {
        return this.processorList;
    }

    public int scaledScreenWidth(int actualDisplayWidth) {
        this.mostRecentScaledScreenWidth = (int)((float)actualDisplayWidth * this.scaleFactor);
        return this.mostRecentScaledScreenWidth;
    }

    public int screenHeight() {
        if (this.useMinimalView()) {
            return this.singleTimelineHeight() * this.numPs();
        }
        return this.singleTimelineHeight() * this.numPs() + 15;
    }

    public int barheight() {
        if (this.useCompactView()) {
            return 12;
        }
        return 16;
    }

    public int singleTimelineHeight() {
        if (this.useCompactView()) {
            return this.barheight() + 1;
        }
        if (this.useMinimalView()) {
            return this.barheight() + 10;
        }
        return this.barheight() + 18;
    }

    public int userEventRectHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        return 5;
    }

    public void setColors(Color backgroundColor, Color foregroundColor) {
        this.customForeground = foregroundColor;
        this.customBackground = backgroundColor;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setHandler(MainHandler rh) {
        this.modificationHandler = rh;
        this.displayMustBeRedrawn();
    }

    public void setProcessorList(OrderedIntList procs) {
        this.processorList = procs.copyOf();
    }

    public void setNewRange(long beginTime, long endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.setScaleFactor(1.0f);
    }

    public void setRange(long beginTime, long endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public void setScaleFactor(float scale_) {
        this.scaleFactor = scale_;
        if ((double)this.scaleFactor < 1.0) {
            this.scaleFactor = 1.0f;
        }
        this.displayMustBeRedrawn();
    }

    public long startTime() {
        return this.beginTime();
    }

    public long totalTime() {
        return this.endTime - this.beginTime;
    }

    public boolean selectionValid() {
        return this.selection1 >= 0 && this.selection2 >= 0 && this.selection1 != this.selection2;
    }

    public boolean highlightValid() {
        return this.highlight >= 0;
    }

    public void invalidateSelection() {
        this.selection1 = -1;
        this.selection2 = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public int leftSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection1;
        }
        return this.selection2;
    }

    public int rightSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection2;
        }
        return this.selection1;
    }

    public int selectionWidth() {
        return this.rightSelection() - this.leftSelection();
    }

    public void setSelection1(int value) {
        this.selection1 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void setSelection2(int value) {
        this.selection2 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void removeHighlight() {
        this.highlight = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public void setHighlight(int x) {
        this.highlight = x;
        this.modificationHandler.refreshDisplay(false);
    }

    public int getHighlight() {
        return this.highlight;
    }

    public double getHighlightTime() {
        return this.screenToTime(this.getHighlight());
    }

    public double leftSelectionTime() {
        return this.screenToTime(this.leftSelection());
    }

    public double rightSelectionTime() {
        return this.screenToTime(this.rightSelection());
    }

    public long screenToTime(int xPixelCoord) {
        double fractionAlongAxis = (double)(xPixelCoord - this.leftOffset()) / (double)(this.mostRecentScaledScreenWidth - 2 * this.offset());
        return Math.round((double)this.beginTime + fractionAlongAxis * (double)(this.endTime - this.beginTime));
    }

    public int timeToScreenPixel(double time) {
        double fractionAlongTimeAxis = (time - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.round(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelRight(double time) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixel(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelRight(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public void setPreferredViewTimeCenter(double time) {
        if (time > (double)this.beginTime && time < (double)this.endTime) {
            this.preferredViewTime = time;
        }
    }

    public int getNewPreferredViewCenter(int newScreenWidth) {
        double value = this.preferredViewTime;
        int coord = this.timeToScreenPixel(value, newScreenWidth);
        return coord;
    }

    public void resetPreferredView() {
        this.preferredViewTime = -1.0;
    }

    public boolean hasNewPreferredView() {
        return this.preferredViewTime >= 0.0 && (double)this.scaleFactor > 1.0;
    }

    public void setUseMinimalMargins(boolean useMinimalMargins) {
        this.useMinimalView = useMinimalMargins;
    }

    public void keepViewCentered(boolean b) {
        this.keepViewCentered = b;
    }

    public boolean keepViewCentered() {
        return this.keepViewCentered;
    }

    public int messageSendHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        return 5;
    }

    public int messagePackHeight() {
        return 3;
    }

    public void entryMethodObjectRightClick(EntryMethodObject obj) {
        if (!this.useMinimalView()) {
            this.addProcessor(obj.pCreation);
            this.toggleMessageSendLine(obj);
        }
    }

    public void clearObjectHighlights() {
        this.highlightedObjects.clear();
    }

    public void HighlightObjects(Set objects) {
        this.highlightedObjects.addAll(objects);
    }

    public boolean isObjectDimmed(Object o) {
        if (this.highlightedObjects.size() == 0) {
            return false;
        }
        return !this.highlightedObjects.contains(o);
    }

    public boolean isAnyObjectDimmed() {
        return this.highlightedObjects.size() > 0;
    }

    public boolean traceMessagesOnHover() {
        return this.traceMessagesOnHover;
    }

    public boolean traceOIDOnHover() {
        return this.traceOIDOnHover;
    }

    public void setTraceMessagesOnHover(boolean traceMessagesOnHover) {
        this.traceMessagesOnHover = traceMessagesOnHover;
        if (traceMessagesOnHover) {
            this.SetToolTipDelayLarge();
        } else {
            this.SetToolTipDelaySmall();
        }
    }

    public void setTraceOIDOnHover(boolean showOIDOnHover) {
        this.traceOIDOnHover = showOIDOnHover;
    }

    public void SetToolTipDelaySmall() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    public void SetToolTipDelayLarge() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public Color getMessageColor() {
        return Color.white;
    }

    public Color getMessageAltColor() {
        return Color.yellow;
    }

    public void showUserEvents(boolean b) {
        this.showUserEvents = b;
    }

    public boolean showUserEvents() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showUserEvents;
    }

    public void setColorByDefault() {
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.displayMustBeRepainted();
    }

    public void setColorByMemoryUsage() {
        if (this.memoryUsageValid()) {
            this.colorByMemoryUsage = true;
            this.colorByObjectId = false;
            this.colorByUserSupplied = false;
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("No memory usage entries found. Use traceMemoryUsage() and gnu malloc in the application");
        }
    }

    public void setColorByUserSupplied() {
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.displayMustBeRepainted();
    }

    public void setColorByIndex() {
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.displayMustBeRepainted();
    }

    public boolean colorByUserSupplied() {
        return this.colorByUserSupplied;
    }

    public boolean colorByMemoryUsage() {
        return this.colorByMemoryUsage;
    }

    public void fixTachyons() {
        System.out.println("The fix tachyons feature is still experimental. It will probably not work well if new processors are loaded, or ranges are changed");
        int numIterations = 100;
        long threshold_us = 10L;
        System.out.println("Executing at most " + numIterations + " times or until no tachyons longer than " + threshold_us + "us are found");
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            long minLatency = Integer.MAX_VALUE;
            int minSender = -1;
            int minDest = -1;
            for (Integer pe : this.allEntryMethodObjects.keySet()) {
                LinkedList objs = (LinkedList)this.allEntryMethodObjects.get(pe);
                for (EntryMethodObject obj : objs) {
                    TimelineMessage m = obj.creationMessage();
                    if (m == null) continue;
                    long sendTime = m.Time;
                    long executeTime = obj.getBeginTime();
                    long latency = executeTime - sendTime;
                    int senderPE = m.srcPE;
                    int executingPE = obj.pCurrent;
                    if (minLatency <= latency) continue;
                    minLatency = latency;
                    minSender = senderPE;
                    minDest = executingPE;
                }
            }
            System.out.println("Processor " + minDest + " is lagging behind by " + -1L * minLatency + "us");
            Integer laggingPE = new Integer(minDest);
            long shift = -1L * minLatency;
            if (shift < threshold_us) {
                System.out.println("No tachyons go back further than " + threshold_us + " us");
                break;
            }
            for (EntryMethodObject e : (LinkedList)this.allEntryMethodObjects.get(laggingPE)) {
                e.shiftTimesBy(shift);
                for (TimelineMessage msg : e.messages) {
                    msg.shiftTimesBy(shift);
                }
            }
            for (UserEventObject obj : (LinkedList)this.allUserEventObjects.get(laggingPE)) {
                obj.shiftTimesBy(shift);
            }
        }
        this.displayMustBeRedrawn();
    }

    public void setCompactView(boolean b) {
        this.useCompactView = b;
        this.displayMustBeRedrawn();
    }

    public boolean showPacks() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showPacks;
    }

    public boolean showMsgs() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showMsgs;
    }

    public boolean showIdle() {
        return this.showIdle;
    }

    public void showIdle(boolean b) {
        this.showIdle = b;
    }

    public void showPacks(boolean b) {
        this.showPacks = b;
    }

    public void showMsgs(boolean b) {
        this.showMsgs = b;
    }

    public boolean useCompactView() {
        return this.useCompactView;
    }

    public Component guiRoot() {
        if (this.guiRoot != null) {
            return this.guiRoot;
        }
        return MainWindow.runObject[this.myRun].guiRoot;
    }

    public void guiRoot(TimelineWindow timelineWindow) {
        this.guiRoot = timelineWindow;
    }

    public int whichTimelineVerticalPosition(int PE) {
        if (this.peToLine == null) {
            throw new RuntimeException("peToLine is null");
        }
        if (!this.peToLine.containsKey(new Integer(PE))) {
            throw new RuntimeException("peToLine does not contain pe " + PE);
        }
        if (this.peToLine.get(new Integer(PE)) == null) {
            throw new RuntimeException("peToLine is null");
        }
        return (Integer)this.peToLine.get(new Integer(PE));
    }

    void updatePEVerticalOrdering() {
        int i;
        Integer pos;
        HashMap oldPeToLine = this.peToLine;
        this.peToLine = new HashMap();
        this.processorList.reset();
        int p = this.processorList.nextElement();
        while (p != -1) {
            Integer pe = new Integer(p);
            if (oldPeToLine != null && oldPeToLine.containsKey(pe)) {
                pos = (Integer)oldPeToLine.get(pe);
                this.peToLine.put(pe, pos);
            }
            p = this.processorList.nextElement();
        }
        for (i = 0; i < this.peToLine.size(); ++i) {
            pos = new Integer(i);
            if (this.peToLine.containsValue(pos)) continue;
            for (Integer pe : this.peToLine.keySet()) {
                int line = (Integer)this.peToLine.get(pe);
                if (line <= i) continue;
                this.peToLine.put(pe, new Integer(line - 1));
            }
        }
        this.processorList.reset();
        p = this.processorList.nextElement();
        i = this.peToLine.size();
        while (p != -1) {
            Integer pe = new Integer(p);
            if (!this.peToLine.containsKey(pe)) {
                this.peToLine.put(pe, new Integer(i));
                ++i;
            }
            p = this.processorList.nextElement();
        }
    }

    public int whichPE(int verticalPosition) {
        for (Integer pe : this.peToLine.keySet()) {
            if ((Integer)this.peToLine.get(pe) != verticalPosition) continue;
            return pe;
        }
        return -1;
    }

    public void dumpPEOrder() {
        for (Integer pe : this.peToLine.keySet()) {
            int line = (Integer)this.peToLine.get(pe);
            System.out.println("pe " + pe + " is at " + line);
        }
    }

    public void movePEToLine(int PE, int newPos) {
        int oldPos = this.whichTimelineVerticalPosition(PE);
        if (newPos >= this.peToLine.size()) {
            newPos = this.peToLine.size() - 1;
        }
        if (oldPos < newPos) {
            for (Integer pe : this.peToLine.keySet()) {
                int line = (Integer)this.peToLine.get(pe);
                if (line <= oldPos || line > newPos) continue;
                this.peToLine.put(pe, new Integer(line - 1));
            }
        } else {
            for (Integer pe : this.peToLine.keySet()) {
                int line = (Integer)this.peToLine.get(pe);
                if (line >= oldPos || line < newPos) continue;
                this.peToLine.put(pe, new Integer(line + 1));
            }
        }
        this.peToLine.put(new Integer(PE), new Integer(newPos));
        this.displayMustBeRedrawn();
    }
}

