/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import projections.gui.Timeline.AxisPanel;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.MainPanel;

public class LayeredPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private Data data;
    JLayeredPane jLayeredPane = null;
    JPanel mainPanel = null;
    JPanel overlayPanel = null;

    public LayeredPanel(Data data, JPanel main, JPanel overlay, LayoutManager lay) {
        this.data = data;
        this.mainPanel = main;
        this.overlayPanel = overlay;
        this.jLayeredPane = new JLayeredPane();
        this.jLayeredPane.setLayout(lay);
        this.jLayeredPane.add((Component)main, new Integer(10));
        this.jLayeredPane.add((Component)overlay, new Integer(20));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jLayeredPane, "Center");
    }

    public void repaint() {
        if (this.mainPanel != null) {
            this.mainPanel.repaint();
        }
        if (this.overlayPanel != null) {
            this.overlayPanel.repaint();
        }
        if (this.jLayeredPane != null) {
            this.jLayeredPane.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public Data getData() {
        return this.data;
    }

    public int getDesiredHeight() {
        return this.mainPanel.getPreferredSize().height;
    }

    public Dimension getPreferredSize() {
        if (this.mainPanel != null) {
            return new Dimension(this.getWidth(), this.mainPanel.getPreferredSize().height);
        }
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public JPanel getSizingPanel() {
        return this.mainPanel;
    }

    public MainPanel getMainPanel() {
        if (this.mainPanel instanceof MainPanel) {
            return (MainPanel)this.mainPanel;
        }
        return null;
    }

    public AxisPanel getAxisPanel() {
        if (this.mainPanel instanceof AxisPanel) {
            return (AxisPanel)this.mainPanel;
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return this.mainPanel.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

