/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;
import projections.gui.Timeline.Data;

public class TimelineScrollPaneLayout
extends ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    Data data;

    public TimelineScrollPaneLayout(Data data) {
        this.data = data;
        this.vsbPolicy = 22;
        this.hsbPolicy = 32;
    }

    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        this.vsbPolicy = 22;
        this.hsbPolicy = 32;
    }

    private void adjustForVSB(Rectangle available, Rectangle vsbR, Insets vpbInsets) {
        int vsbWidth = Math.max(0, Math.min(this.vsb.getPreferredSize().width, available.width));
        available.width -= vsbWidth;
        vsbR.width = vsbWidth;
        vsbR.x = available.x + available.width + vpbInsets.right;
    }

    private void adjustForHSB(Rectangle available, Rectangle hsbR, Insets vpbInsets) {
        int hsbHeight = Math.max(0, Math.min(available.height, this.hsb.getPreferredSize().height));
        available.height -= hsbHeight;
        hsbR.y = available.y + available.height + vpbInsets.bottom;
        hsbR.height = hsbHeight;
    }

    public void layoutContainer(Container parent) {
        Insets vpbInsets;
        Border viewportBorder;
        Point originalViewPosition = this.viewport.getViewPosition();
        int originalScaledWidth = this.viewport.getView().getWidth();
        int originalViewWidth = this.viewport.getWidth();
        super.layoutContainer(parent);
        Rectangle availR = new Rectangle();
        JScrollPane scrollPane = (JScrollPane)parent;
        availR = parent.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = Math.min(availR.height, this.colHead.getPreferredSize().height);
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth;
            rowHeadR.width = rowHeadWidth = Math.min(availR.width, this.rowHead.getPreferredSize().width);
            availR.width -= rowHeadWidth;
            rowHeadR.x = availR.x;
            availR.x += rowHeadWidth;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Rectangle vsbR = new Rectangle(0, availR.y - vpbInsets.top, 0, 0);
        if (this.vsb != null) {
            this.adjustForVSB(availR, vsbR, vpbInsets);
        }
        Rectangle hsbR = new Rectangle(availR.x - vpbInsets.left, 0, 0, 0);
        if (this.hsb != null) {
            this.adjustForHSB(availR, hsbR, vpbInsets);
        }
        int scaledWidth = this.data.scaledScreenWidth(availR.width);
        if (this.viewport != null) {
            Component c = this.viewport.getView();
            this.viewport.setBounds(availR);
            int requiredScreenHeight = this.data.screenHeight();
            if (scaledWidth != c.getWidth()) {
                c.setBounds(0, 0, scaledWidth, requiredScreenHeight);
            }
        }
        vsbR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        hsbR.width = availR.width + vpbInsets.left + vpbInsets.right;
        rowHeadR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        rowHeadR.y = availR.y - vpbInsets.top;
        colHeadR.width = availR.width + vpbInsets.left + vpbInsets.right;
        colHeadR.x = availR.x - vpbInsets.left;
        if (this.rowHead != null) {
            int rowHeadR_x = rowHeadR.x;
            int rowHeadR_y = rowHeadR.y;
            int rowHeadR_width = rowHeadR.width;
            int rowHeadR_height = rowHeadR.height;
            this.rowHead.setBounds(rowHeadR_x, rowHeadR_y, rowHeadR_width, rowHeadR_height);
        }
        if (this.colHead != null) {
            int colHeadR_x = colHeadR.x;
            int colHeadR_y = colHeadR.y;
            int colHeadR_width = colHeadR.width;
            int colHeadR_height = colHeadR.height;
            Point goodPosition = this.colHead.getViewPosition();
            this.colHead.setBounds(colHeadR_x, colHeadR_y, colHeadR_width, colHeadR_height);
            Component c = this.colHead.getView();
            c.setBounds(0, 0, scaledWidth, colHeadR_height);
            this.colHead.setViewPosition(goodPosition);
        }
        if (this.vsb != null) {
            this.vsb.setVisible(true);
            this.vsb.setBounds(vsbR);
        }
        if (this.hsb != null) {
            this.hsb.setVisible(true);
            this.hsb.setBounds(hsbR);
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(rowHeadR.x, hsbR.y, rowHeadR.width, hsbR.height);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(vsbR.x, hsbR.y, vsbR.width, hsbR.height);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(vsbR.x, colHeadR.y, vsbR.width, colHeadR.height);
        }
        if (this.viewport != null) {
            boolean doMoveView = false;
            int newViewPositionCenter = 0;
            if (this.data.hasNewPreferredView()) {
                newViewPositionCenter = this.data.getNewPreferredViewCenter(scaledWidth);
                doMoveView = true;
            } else if (this.data.keepViewCentered()) {
                int oldViewPositionCenter = originalViewPosition.x + originalViewWidth / 2;
                double relativePosition = (double)(oldViewPositionCenter - this.data.offset()) / (double)(originalScaledWidth - 2 * this.data.offset());
                newViewPositionCenter = this.data.offset() + (int)(relativePosition * (double)(scaledWidth - 2 * this.data.offset()));
                this.data.keepViewCentered(false);
                doMoveView = true;
            }
            if (doMoveView) {
                int newViewPositionLeft = newViewPositionCenter - availR.width / 2;
                if (newViewPositionLeft < 0) {
                    newViewPositionLeft = 0;
                }
                if (newViewPositionLeft > scaledWidth - availR.width) {
                    newViewPositionLeft = scaledWidth - availR.width;
                }
                Point p = this.viewport.getViewPosition();
                p.x = newViewPositionLeft;
                this.viewport.setViewPosition(p);
                this.data.resetPreferredView();
            }
        }
    }
}

