/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

public class BackGroundImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image bgimage = null;
    private boolean tile;

    public BackGroundImagePanel(Image bgimage, boolean tile) {
        this.bgimage = bgimage;
        this.tile = tile;
    }

    public BackGroundImagePanel(Image bgimage) {
        this(bgimage, true);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bgimage != null) {
            this.wallPaper(this, g, this.bgimage);
        }
    }

    private void wallPaper(Component component, Graphics g, Image image) {
        Dimension compsize = component.getSize();
        this.waitForImage(component, image);
        int patchW = image.getWidth(component);
        int patchH = image.getHeight(component);
        if (this.tile) {
            for (int r = 0; r < compsize.width; r += patchW) {
                for (int c = 0; c < compsize.height; c += patchH) {
                    g.drawImage(image, r, c, component);
                }
            }
        } else {
            this.setPreferredSize(new Dimension(patchW, patchH));
            g.drawImage(image, 0, 0, component);
        }
    }

    private void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

