/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjMain;
import projections.gui.Analysis;
import projections.gui.BackGroundImagePanel;
import projections.gui.GraphWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.ProjectionsWindow;
import projections.gui.ScalePanel;
import projections.gui.ScreenInfo;
import projections.gui.SwingWorker;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ScalePanel.StatusDisplay {
    private static final long serialVersionUID = 1L;
    protected static final int NUM_RUNS = 1;
    int myRun = 0;
    protected static final int NUM_WINDOWS = 18;
    protected static final int GRAPH_WIN = 0;
    protected static final int TIMELINE_WIN = 1;
    protected static final int PROFILE_WIN = 2;
    protected static final int COMM_WIN = 3;
    protected static final int COMM_TIME_WIN = 4;
    protected static final int CALL_TABLE_WIN = 5;
    protected static final int LOGVIEW_WIN = 6;
    protected static final int HIST_WIN = 7;
    protected static final int OVERVIEW_WIN = 8;
    protected static final int ANIMATION_WIN = 9;
    protected static final int TIME_PROF_WIN = 10;
    protected static final int USER_EVENTS_WIN = 11;
    protected static final int OUTLIER_WIN = 12;
    protected static final int MULTI_WIN = 13;
    protected static final int FUNCTION_WIN = 14;
    protected static final int AMPI_PROFILE_WIN = 16;
    public static final String[] windowMenuNames = new String[]{"Graphs", "Timelines", "Usage Profile", "Communication", "Communication vs Time", "Call Table", "View Log Files", "Histograms", "Overview", "Animation", "Time Profile Graph", "User Events", "Outlier Analysis", "Multirun Analysis", "Function Tool", "AMPI Usage Profile", "Noise Miner"};
    public static final String[] windowClassNames = new String[]{"GraphWindow", "Timeline.TimelineWindow", "ProfileWindow", "CommWindow", "CommTimeWindow", "CallTableWindow", "LogFileViewerWindow", "HistogramWindow", "StlWindow", "AnimationWindow", "TimeProfileWindow", "UserEventsWindow", "OutlierAnalysisWindow", "MultiRunWindow", "FunctionTool", "AmpiProfileWindow", "NoiseMinerWindow"};
    public static final boolean[][] menuDataStates = new boolean[][]{new boolean[0], new boolean[0]};
    private static final int DEFAULT_NUM_RUNS = 1;
    public static double CUR_VERSION;
    public static boolean IGNORE_IDLE;
    public static boolean BLUEGENE;
    public static int[] BLUEGENE_SIZE;
    public static boolean PRINT_USAGE;
    public static PrintWriter dataDump;
    MainWindow thisWindow = this;
    public static Analysis[] runObject;
    protected JFrame[][] childWindows;
    private GraphWindow graphWindow;
    private MainTitlePanel titlePanel;
    private BackGroundImagePanel background;
    MainMenuManager menuManager;
    MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    SummaryDataSource sumDataSource;
    SummaryXAxis sumXAxis;
    SummaryYAxis sumYAxis;
    GraphPanel graphPanel;
    private Label status;
    private Image bgimage;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;

    public MainWindow() {
        CUR_VERSION = ProjMain.CUR_VERSION;
        IGNORE_IDLE = ProjMain.IGNORE_IDLE;
        BLUEGENE = ProjMain.BLUEGENE;
        BLUEGENE_SIZE = ProjMain.BLUEGENE_SIZE;
        PRINT_USAGE = ProjMain.PRINT_USAGE;
        ScreenInfo.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjMain.shutdown(0);
            }
        });
        this.setBackground(Color.lightGray);
        runObject = new Analysis[1];
        MainWindow.runObject[0] = new Analysis();
        this.childWindows = new JFrame[18][1];
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    private void createLayout() {
        try {
            URL imageURL = this.getClass().getResource("/projections/images/bgimage.jpg");
            this.bgimage = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.background = new BackGroundImagePanel(this.bgimage, true);
        }
        catch (Exception E) {
            System.out.println("Error loading background image.  Continuing.");
            this.background = new BackGroundImagePanel(null);
        }
        this.setContentPane(this.background);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.background.setLayout(this.gbl);
        this.titlePanel = new MainTitlePanel(this);
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this, this.runStatusPanel);
        Util.gblAdd(this.background, this.titlePanel, this.gbc, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.background, this.runStatusPanel, this.gbc, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.background, this.summaryGraphPanel, this.gbc, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.background.setPreferredSize(new Dimension(ScreenInfo.screenWidth, ScreenInfo.screenHeight));
        this.pack();
    }

    public void changeBackground() {
        JColorChooser colorWindow = new JColorChooser();
        Color returnColor = JColorChooser.showDialog(this, "Background Color", MainWindow.runObject[this.myRun].background);
        if (returnColor != null) {
            MainWindow.runObject[this.myRun].background = returnColor;
            this.repaintAllWindows();
        }
    }

    public void changeForeground() {
        JColorChooser colorWindow = new JColorChooser();
        Color returnColor = JColorChooser.showDialog(this, "Foreground Color", MainWindow.runObject[this.myRun].foreground);
        if (returnColor != null) {
            MainWindow.runObject[this.myRun].foreground = returnColor;
            this.repaintAllWindows();
        }
    }

    public void setGrayscale() {
        runObject[this.myRun].setGrayscale();
        this.repaintAllWindows();
    }

    public void setFullColor() {
        runObject[this.myRun].setFullColor();
        this.repaintAllWindows();
    }

    private void repaintAllWindows() {
        for (int i = 0; i < 18; ++i) {
            if (this.childWindows[i][0] == null) continue;
            if (this.childWindows[i][0] instanceof GraphWindow) {
                ((GraphWindow)this.childWindows[i][0]).refreshDisplay();
                continue;
            }
            if (this.childWindows[i][0] instanceof TimelineWindow) {
                ((TimelineWindow)this.childWindows[i][0]).refreshDisplay(false);
                continue;
            }
            this.childWindows[i][0].repaint();
        }
        this.repaint();
    }

    public void showChildWindow(String childClass, int windowIndex) {
        try {
            if (this.childWindows[windowIndex][0] == null) {
                String className = this.getClass().getPackage().getName() + "." + childClass;
                Class<?> cls = Class.forName(className);
                Constructor<?> ctr = cls.getConstructor(this.getClass(), Class.forName("java.lang.Integer"));
                this.childWindows[windowIndex][0] = (ProjectionsWindow)ctr.newInstance(this, new Integer(windowIndex));
            } else if (this.childWindows[windowIndex][0] instanceof ProjectionsWindow) {
                ((ProjectionsWindow)this.childWindows[windowIndex][0]).showDialog();
            } else {
                this.childWindows[windowIndex][0].setVisible(true);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (LinkageError e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Tool not available. You should use a different version of java(>=1.5) to compile projections.", "Tool Not Available", 0);
        }
    }

    public void showOpenFileDialog() {
        JFileChooser d = new JFileChooser(System.getProperty("user.dir"));
        d.setFileFilter(new MainFileFilter());
        int returnval = d.showOpenDialog(this);
        if (returnval == 0) {
            this.setTitle("Projections -" + d.getSelectedFile());
            this.openFile(d.getSelectedFile().getAbsolutePath());
        }
    }

    public void openFile(String filename) {
        final String newfile = filename;
        this.sumDataSource = null;
        this.sumXAxis = null;
        this.sumYAxis = null;
        this.graphPanel = null;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    runObject[MainWindow.this.myRun].initAnalysis(newfile, MainWindow.this.thisWindow);
                }
                catch (IOException e) {
                    InvalidFileDialog ifd = new InvalidFileDialog((Frame)MainWindow.this.thisWindow, e);
                    ifd.setVisible(true);
                }
                catch (StringIndexOutOfBoundsException e) {
                    e.printStackTrace();
                    InvalidFileDialog ifd = new InvalidFileDialog((Frame)MainWindow.this.thisWindow, e);
                    ifd.setVisible(true);
                }
                return null;
            }

            public void finished() {
                MainWindow.this.setTitle("Projections - " + newfile);
                if (runObject[MainWindow.this.myRun].hasSummaryData()) {
                    int i;
                    double[] data = runObject[MainWindow.this.myRun].getSummaryAverageData();
                    long originalSize = runObject[MainWindow.this.myRun].getSummaryIntervalSize();
                    if (ProjMain.SUM_OVERRIDE && (ProjMain.SUM_END_INT <= ProjMain.SUM_START_INT || (long)data.length * originalSize < (long)ProjMain.SUM_END_INT * ProjMain.SUM_INT_SIZE)) {
                        System.out.println("Warning: Specified Summary parameters of [" + ProjMain.SUM_START_INT + "," + ProjMain.SUM_END_INT + "," + ProjMain.SUM_INT_SIZE + "] " + "is inconsistent. " + "Real Summary Data " + "has [" + 0 + "," + data.length + "," + originalSize + "]. " + "Reverting to default " + "main summary display.");
                        ProjMain.SUM_OVERRIDE = false;
                    }
                    long bestSize = 0L;
                    bestSize = ProjMain.SUM_OVERRIDE ? ProjMain.SUM_INT_SIZE : (long)IntervalUtils.getBestIntervalSize(originalSize, data.length);
                    double[] tempdata = data;
                    double[] newdata = data;
                    if (bestSize != originalSize) {
                        IntervalUtils.utilToTime(data, (double)originalSize);
                        tempdata = IntervalUtils.rebin(data, (double)originalSize, bestSize);
                        IntervalUtils.timeToUtil(tempdata, (double)bestSize);
                        newdata = tempdata;
                        if (ProjMain.SUM_OVERRIDE) {
                            newdata = new double[ProjMain.SUM_END_INT - ProjMain.SUM_START_INT + 1];
                            for (i = 0; i < newdata.length; ++i) {
                                newdata[i] = tempdata[i + ProjMain.SUM_START_INT];
                            }
                        }
                    } else if (ProjMain.SUM_OVERRIDE) {
                        newdata = new double[ProjMain.SUM_END_INT - ProjMain.SUM_START_INT + 1];
                        for (i = 0; i < newdata.length; ++i) {
                            newdata[i] = tempdata[i + ProjMain.SUM_START_INT];
                        }
                    }
                    try {
                        dataDump = new PrintWriter(new FileWriter(runObject[MainWindow.this.myRun].getLogDirectory() + File.separator + "SummaryDump.out"));
                        dataDump.println("--- Summary Graph ---");
                        for (i = 0; i < newdata.length; ++i) {
                            if (ProjMain.SUM_OVERRIDE) {
                                dataDump.print(i + ProjMain.SUM_START_INT + " ");
                            } else {
                                dataDump.print(i);
                            }
                            dataDump.println(newdata[i]);
                        }
                        dataDump.flush();
                    }
                    catch (IOException e) {
                        System.err.println("WARNING: Failed to handle dump file SummaryDump.out. Reason: ");
                        System.err.println(e);
                    }
                    MainWindow.this.sumDataSource = new SummaryDataSource(newdata);
                    MainWindow.this.sumXAxis = ProjMain.SUM_OVERRIDE ? new SummaryXAxis(ProjMain.SUM_START_INT, ProjMain.SUM_END_INT, ProjMain.SUM_INT_SIZE) : new SummaryXAxis(0, newdata.length, bestSize);
                    MainWindow.this.sumYAxis = new SummaryYAxis();
                    MainWindow.this.graphPanel = new GraphPanel(new Graph(MainWindow.this.sumDataSource, MainWindow.this.sumXAxis, MainWindow.this.sumYAxis));
                    MainWindow.this.summaryGraphPanel.add("data", MainWindow.this.graphPanel, "run data");
                }
                if (runObject[MainWindow.this.myRun].hasLogData()) {
                    MainWindow.this.menuManager.fileOpened();
                } else if (runObject[MainWindow.this.myRun].hasSummaryData()) {
                    MainWindow.this.menuManager.summaryOnly();
                }
            }
        };
        worker.start();
    }

    public void closeChildWindow(int childID) {
        this.childWindows[childID][0] = null;
    }

    public void shutdown() {
        runObject[this.myRun].closeRC();
    }

    public void closeCurrent() {
        this.closeAll();
    }

    public void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        runObject[this.myRun].closeRC();
        this.setTitle("Projections");
    }

    public Color getGraphColor(int e) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(e);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    static {
        dataDump = null;
    }
}

