/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import projections.analysis.PoseDopReader;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PoseRTDopDisplayPanel;
import projections.gui.PoseRangeDialog;
import projections.gui.PoseVTDopDisplayPanel;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.Util;

public class PoseAnalysisWindow
extends ProjectionsWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    PoseAnalysisWindow thisWindow;
    int myRun = 0;
    private JPanel mainPanel = new JPanel();
    private JPanel controlPanel;
    private JButton setRanges;
    private JTabbedPane subToolsPanel;
    PoseRTDopDisplayPanel realTimeDopDisplayPanel;
    PoseVTDopDisplayPanel virtTimeDopDisplayPanel;
    PoseRangeDialog dialog;
    long realStartTime;
    long realEndTime;
    int realStartInterval;
    int realEndInterval;
    long realIntervalSize;
    long virtStartTime;
    long virtEndTime;
    int virtStartInterval;
    int virtEndInterval;
    long virtIntervalSize;
    OrderedIntList processorList;
    PoseDopReader reader;
    int[][] dopRealData;
    int[] dopVirtData;
    boolean startFlag;

    protected void windowInit() {
        this.realStartTime = 0L;
        this.realEndTime = MainWindow.runObject[this.myRun].getPoseTotalTime();
        this.realIntervalSize = 1000L;
        this.realStartInterval = 0;
        this.realEndInterval = this.realEndTime % this.realIntervalSize == 0L ? (int)(this.realEndTime / this.realIntervalSize - 1L) : (int)(this.realEndTime / this.realIntervalSize);
        this.virtStartTime = 0L;
        this.virtEndTime = MainWindow.runObject[this.myRun].getPoseTotalVirtualTime();
        this.virtIntervalSize = this.virtEndTime / 100L + 1L;
        this.virtStartInterval = 0;
        this.virtEndInterval = this.virtEndTime % this.virtIntervalSize == 0L ? (int)(this.virtEndTime / this.virtIntervalSize - 1L) : (int)(this.virtEndTime / this.virtIntervalSize);
        this.processorList = MainWindow.runObject[this.myRun].getValidProcessorList(3);
    }

    public PoseAnalysisWindow(MainWindow mainWindow, Integer myWindowID) {
        super("POSE Analysis Tools", mainWindow, myWindowID);
        this.getContentPane().add(this.mainPanel);
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.showDialog();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.subToolsPanel = new JTabbedPane();
        this.realTimeDopDisplayPanel = new PoseRTDopDisplayPanel();
        this.virtTimeDopDisplayPanel = new PoseVTDopDisplayPanel();
        this.subToolsPanel.insertTab("DOP: Real", null, this.realTimeDopDisplayPanel, "Degrees of Parallelism in Real Time", 0);
        this.subToolsPanel.insertTab("DOP: Virtual", null, this.virtTimeDopDisplayPanel, "Degrees of Parallelism in Virtual Time", 0);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.subToolsPanel, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 1, 1, 0);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new PoseRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (PoseAnalysisWindow.this.dialog.isModified()) {
                        PoseAnalysisWindow.this.reader = MainWindow.runObject[PoseAnalysisWindow.this.myRun].getPoseDopReader();
                        PoseAnalysisWindow.this.realStartInterval = (int)(PoseAnalysisWindow.this.realStartTime / PoseAnalysisWindow.this.realIntervalSize);
                        PoseAnalysisWindow.this.realEndInterval = (int)(PoseAnalysisWindow.this.realEndTime / PoseAnalysisWindow.this.realIntervalSize);
                        PoseAnalysisWindow.this.virtStartInterval = (int)(PoseAnalysisWindow.this.virtStartTime / PoseAnalysisWindow.this.virtIntervalSize);
                        PoseAnalysisWindow.this.virtEndInterval = (int)(PoseAnalysisWindow.this.virtEndTime / PoseAnalysisWindow.this.virtIntervalSize);
                        PoseAnalysisWindow.this.reader.read(PoseAnalysisWindow.this.realIntervalSize, PoseAnalysisWindow.this.realStartInterval, PoseAnalysisWindow.this.realEndInterval, PoseAnalysisWindow.this.virtIntervalSize, PoseAnalysisWindow.this.virtStartInterval, PoseAnalysisWindow.this.virtEndInterval, PoseAnalysisWindow.this.processorList);
                    }
                    return null;
                }

                public void finished() {
                    PoseAnalysisWindow.this.dopRealData = PoseAnalysisWindow.this.reader.getRealTimeDopData();
                    PoseAnalysisWindow.this.realTimeDopDisplayPanel.setGraphData(PoseAnalysisWindow.this.dopRealData, PoseAnalysisWindow.this.realIntervalSize, PoseAnalysisWindow.this.realStartInterval, PoseAnalysisWindow.this.realEndInterval);
                    PoseAnalysisWindow.this.dopVirtData = PoseAnalysisWindow.this.reader.getVirtualTimeDopData();
                    PoseAnalysisWindow.this.virtTimeDopDisplayPanel.setGraphData(PoseAnalysisWindow.this.dopVirtData, PoseAnalysisWindow.this.virtIntervalSize, PoseAnalysisWindow.this.virtStartInterval, PoseAnalysisWindow.this.virtEndInterval);
                    if (PoseAnalysisWindow.this.startFlag) {
                        PoseAnalysisWindow.this.thisWindow.setVisible(true);
                    }
                    if (PoseAnalysisWindow.this.startFlag) {
                        PoseAnalysisWindow.this.startFlag = false;
                    }
                    PoseAnalysisWindow.this.realTimeDopDisplayPanel.refreshGraph();
                    PoseAnalysisWindow.this.virtTimeDopDisplayPanel.refreshGraph();
                }
            };
            worker.start();
        }
    }

    public void getDialogData() {
        PoseRangeDialog dialog = this.dialog;
        this.realStartTime = dialog.getRealStartTime();
        this.realEndTime = dialog.getRealEndTime();
        this.realIntervalSize = dialog.getRealIntervalSize();
        this.virtStartTime = dialog.getVirtStartTime();
        this.virtEndTime = dialog.getVirtEndTime();
        this.virtIntervalSize = dialog.getVirtIntervalSize();
        this.processorList = dialog.getValidProcessors();
    }

    public void setDialogData() {
        PoseRangeDialog dialog = this.dialog;
        dialog.setRealIntervalSize(this.realIntervalSize);
        dialog.setRealStartTime(this.realStartTime);
        dialog.setRealEndTime(this.realEndTime);
        dialog.setVirtIntervalSize(this.virtIntervalSize);
        dialog.setVirtStartTime(this.virtStartTime);
        dialog.setVirtEndTime(this.virtEndTime);
        dialog.setValidProcessors(this.processorList);
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent e) {
        JButton b;
        if (e.getSource() instanceof JButton && (b = (JButton)e.getSource()) == this.setRanges) {
            this.showDialog();
        }
    }
}

