/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryDialog;
import charm.debug.ScrollableMemory;
import charm.debug.inspect.InspectPanel;
import charm.debug.pdata.Slot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class MemoryPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
ItemListener {
    private JMenuBar menuBar;
    private JMenu menuAction;
    private JMenuItem menuLeak;
    private JMenuItem menuLeakFast;
    private JMenu menuInfo;
    private JMenuItem menuStat;
    private JMenuItem menuInspect;
    private JCheckBoxMenuItem menuDim;
    private JScrollPane displayPane;
    private JPanel topPane;
    private JPanel controlPane;
    private ScrollableMemory memoryData;
    private JButton update;
    private JTextField horizontalPixels;
    private JTextField verticalLines;
    private JTextField lineSize;
    private JLabel bytesPixel;
    private JButton minusLines;
    private JButton plusLines;
    private JButton minusVert;
    private JButton plusVert;
    private JButton minusHPixels;
    private JButton plusHPixels;
    private JTextArea info;
    private JScrollPane infoScrollPane;
    private boolean traceWrite;

    public MemoryPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.menuBar = new JMenuBar();
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuLeak = new JMenuItem("Search Leaks", 76);
        this.menuAction.add(this.menuLeak);
        this.menuLeak.addActionListener(this);
        this.menuLeakFast = new JMenuItem("Quick Search Leaks", 81);
        this.menuAction.add(this.menuLeakFast);
        this.menuLeakFast.addActionListener(this);
        this.menuInfo = new JMenu("Info");
        this.menuBar.add(this.menuInfo);
        this.menuInfo.setMnemonic('I');
        this.menuStat = new JMenuItem("Show Statistics", 76);
        this.menuInfo.add(this.menuStat);
        this.menuStat.addActionListener(this);
        this.menuInspect = new JMenuItem("Inspect", 73);
        this.menuInfo.add(this.menuInspect);
        this.menuInspect.addActionListener(this);
        this.menuDim = new JCheckBoxMenuItem("Dim by chare ID");
        this.menuInfo.add(this.menuDim);
        this.menuDim.addItemListener(this);
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        JPanel controlPaneFlow = new JPanel();
        controlPaneFlow.setLayout(new FlowLayout(0));
        this.controlPane = new JPanel();
        GridBagLayout controlLayout = new GridBagLayout();
        this.controlPane.setLayout(controlLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.insets = new Insets(1, 1, 1, 1);
        JLabel spacing0 = new JLabel();
        spacing0.setPreferredSize(new Dimension(50, 1));
        spacing0.setMinimumSize(new Dimension(10, 1));
        c.weightx = 1.0;
        c.gridheight = 2;
        controlLayout.setConstraints(spacing0, c);
        this.controlPane.add(spacing0);
        c.weightx = 0.0;
        c.gridheight = 1;
        this.minusLines = new JButton("-");
        this.minusLines.addActionListener(this);
        controlLayout.setConstraints(this.minusLines, c);
        this.controlPane.add(this.minusLines);
        JPanel linesPane = new JPanel();
        linesPane.setLayout(new BoxLayout(linesPane, 1));
        this.verticalLines = new JTextField();
        this.verticalLines.setHorizontalAlignment(4);
        this.verticalLines.addActionListener(this);
        JLabel textLines = new JLabel("Number of lines");
        linesPane.add(this.verticalLines);
        linesPane.add(textLines);
        controlLayout.setConstraints(linesPane, c);
        this.controlPane.add(linesPane);
        this.plusLines = new JButton("+");
        this.plusLines.addActionListener(this);
        controlLayout.setConstraints(this.plusLines, c);
        this.controlPane.add(this.plusLines);
        JLabel spacing1 = new JLabel();
        spacing1.setPreferredSize(new Dimension(50, 1));
        spacing1.setMinimumSize(new Dimension(10, 1));
        c.weightx = 1.0;
        controlLayout.setConstraints(spacing1, c);
        this.controlPane.add(spacing1);
        c.weightx = 0.0;
        this.minusHPixels = new JButton("-");
        this.minusHPixels.addActionListener(this);
        controlLayout.setConstraints(this.minusHPixels, c);
        this.controlPane.add(this.minusHPixels);
        JPanel hPixelsPane = new JPanel();
        hPixelsPane.setLayout(new BoxLayout(hPixelsPane, 1));
        this.horizontalPixels = new JTextField();
        this.horizontalPixels.setHorizontalAlignment(4);
        this.horizontalPixels.addActionListener(this);
        JLabel textHPixels = new JLabel("Horizontal pixels", 0);
        hPixelsPane.add(this.horizontalPixels);
        hPixelsPane.add(textHPixels);
        controlLayout.setConstraints(hPixelsPane, c);
        this.controlPane.add(hPixelsPane);
        this.plusHPixels = new JButton("+");
        this.plusHPixels.addActionListener(this);
        controlLayout.setConstraints(this.plusHPixels, c);
        this.controlPane.add(this.plusHPixels);
        JLabel spacing2 = new JLabel();
        spacing2.setPreferredSize(new Dimension(50, 1));
        spacing2.setMinimumSize(new Dimension(10, 1));
        c.weightx = 1.0;
        controlLayout.setConstraints(spacing2, c);
        this.controlPane.add(spacing2);
        this.update = new JButton("Update");
        this.update.setActionCommand("update");
        this.update.addActionListener(this);
        c.weightx = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        controlLayout.setConstraints(this.update, c);
        this.controlPane.add(this.update);
        JLabel spacing3 = new JLabel();
        spacing3.setPreferredSize(new Dimension(1, 1));
        spacing3.setMinimumSize(new Dimension(1, 1));
        c.weightx = 1000.0;
        c.fill = 3;
        c.gridwidth = 0;
        controlLayout.setConstraints(spacing3, c);
        this.controlPane.add(spacing3);
        this.minusVert = new JButton("-");
        this.minusVert.addActionListener(this);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.gridx = 1;
        controlLayout.setConstraints(this.minusVert, c);
        this.controlPane.add(this.minusVert);
        JPanel vertPane = new JPanel();
        vertPane.setLayout(new BoxLayout(vertPane, 1));
        this.lineSize = new JTextField();
        this.lineSize.setHorizontalAlignment(4);
        this.lineSize.addActionListener(this);
        JLabel textVert = new JLabel("Line size");
        vertPane.add(this.lineSize);
        vertPane.add(textVert);
        c.gridx = 2;
        controlLayout.setConstraints(vertPane, c);
        this.controlPane.add(vertPane);
        this.plusVert = new JButton("+");
        this.plusVert.addActionListener(this);
        c.gridx = 3;
        controlLayout.setConstraints(this.plusVert, c);
        this.controlPane.add(this.plusVert);
        this.bytesPixel = new JLabel(" ");
        this.bytesPixel.setHorizontalAlignment(0);
        c.gridx = 5;
        c.gridwidth = 3;
        c.fill = 1;
        controlLayout.setConstraints(this.bytesPixel, c);
        this.controlPane.add(this.bytesPixel);
        this.topPane.add((Component)this.controlPane, "North");
        this.displayPane = new JScrollPane();
        this.topPane.add((Component)this.displayPane, "Center");
        this.info = new JTextArea();
        this.info.setText("Prova di scrittura\ndi una frase lunga.");
        this.info.setEditable(false);
        this.infoScrollPane = new JScrollPane(this.info);
        this.infoScrollPane.setBorder(BorderFactory.createTitledBorder("Information"));
        this.infoScrollPane.setPreferredSize(new Dimension(100, 150));
        JSplitPane mainPane = new JSplitPane(0, this.topPane, this.infoScrollPane);
        mainPane.setResizeWeight(1.0);
        this.add(mainPane);
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void loadData(MemoryDialog input) {
        int pe = input.getPe();
        int scan = input.getScan();
        int lines = input.getLines();
        int hPixels = input.getHPixels();
        this.verticalLines.setText("" + lines);
        this.horizontalPixels.setText("" + hPixels);
        this.lineSize.setText("" + scan);
        this.memoryData = new ScrollableMemory(this, pe, scan, lines, hPixels);
        this.memoryData.addMouseListener(this);
        this.memoryData.addMouseMotionListener(this);
        this.displayBytes();
        this.displayPane.setViewportView(this.memoryData);
        this.traceWrite = true;
    }

    private void displayBytes() {
        int bytes = this.memoryData.getBytes() / this.memoryData.getPixels();
        if (bytes >= 10) {
            this.bytesPixel.setText("Bytes per pixel: " + bytes);
        } else {
            int decimal1 = (int)((long)this.memoryData.getBytes() * 10L / (long)this.memoryData.getPixels()) % 10;
            int decimal2 = (int)((long)this.memoryData.getBytes() * 100L / (long)this.memoryData.getPixels()) % 10;
            this.bytesPixel.setText("Bytes per pixel: " + bytes + "." + decimal1 + decimal2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuLeak || e.getSource() == this.menuLeakFast) {
            System.out.println("Leak search");
            this.memoryData.loadImage(true, e.getSource() == this.menuLeakFast ? 1 : 0);
            this.traceWrite = true;
            this.displayBytes();
            this.repaint();
        } else if (e.getSource() == this.menuStat) {
            JOptionPane.showMessageDialog(this, "Memory Usage: " + NumberFormat.getInstance().format(this.memoryData.getAllocatedMemory()) + " bytes\nAllocated blocks: " + NumberFormat.getInstance().format(this.memoryData.getNumAllocations()), "Memory Statistics", 1);
        } else if (e.getSource() == this.menuInspect) {
            Slot sl = this.memoryData.getSelectedSlot();
            if (sl != null) {
                InspectPanel inspect;
                JFrame frame = new JFrame("Memory inspector");
                frame.setDefaultCloseOperation(2);
                InspectPanel newContentPane = inspect = new InspectPanel();
                newContentPane.setOpaque(true);
                inspect.load(this.memoryData.getPe(), sl.getLocation(), null);
                frame.setContentPane(newContentPane);
                frame.pack();
                frame.setVisible(true);
            }
        } else if (e.getActionCommand().equals("update")) {
            this.memoryData.loadImage(false, 0);
            this.traceWrite = true;
            this.displayBytes();
            this.repaint();
        } else {
            int horiz;
            int scan;
            int lines;
            try {
                lines = Integer.parseInt(this.verticalLines.getText());
                scan = Integer.parseInt(this.lineSize.getText());
                horiz = Integer.parseInt(this.horizontalPixels.getText());
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
                return;
            }
            if (scan <= 3) {
                JOptionPane.showMessageDialog(this, "The width of the line must be greater than 3", "Error", 0);
                this.lineSize.requestFocus();
            } else if (lines <= 0) {
                JOptionPane.showMessageDialog(this, "The number of lines must be positive", "Error", 0);
                this.verticalLines.requestFocus();
            } else if (horiz <= 10) {
                JOptionPane.showMessageDialog(this, "The number of horizontal pixels must be greater than 10", "Error", 0);
                this.horizontalPixels.requestFocus();
            } else {
                if (e.getSource() == this.minusLines) {
                    lines = (int)((double)lines - (double)lines * 0.1);
                    this.verticalLines.setText("" + lines);
                }
                if (e.getSource() == this.plusLines) {
                    lines = (int)((double)lines + (double)lines * 0.1);
                    this.verticalLines.setText("" + lines);
                }
                if (e.getSource() == this.verticalLines) {
                    // empty if block
                }
                if (e.getSource() == this.minusVert) {
                    if ((scan = (int)((double)scan - (double)scan * 0.1)) < 4) {
                        scan = 4;
                    }
                    this.lineSize.setText("" + scan);
                }
                if (e.getSource() == this.plusVert) {
                    scan = (int)((double)scan + (double)scan * 0.1);
                    this.lineSize.setText("" + scan);
                }
                if (e.getSource() == this.lineSize) {
                    // empty if block
                }
                if (e.getSource() == this.minusHPixels) {
                    horiz = (int)((double)horiz - (double)horiz * 0.1);
                    this.horizontalPixels.setText("" + horiz);
                }
                if (e.getSource() == this.plusHPixels) {
                    horiz = (int)((double)horiz + (double)horiz * 0.1);
                    this.horizontalPixels.setText("" + horiz);
                }
                if (e.getSource() == this.horizontalPixels) {
                    // empty if block
                }
                if (lines != this.memoryData.getNumLines() || scan != this.memoryData.getLineSize() || horiz != this.memoryData.getHPixels()) {
                    this.memoryData.resizeImage(scan, lines, horiz);
                    this.displayBytes();
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.menuDim) {
            this.memoryData.dimByChareID(e.getStateChange() == 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.memoryData) {
            this.traceWrite = !this.traceWrite;
            this.updatePosition(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.deletePosition();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.memoryData) {
            this.memoryData.viewX = e.getX();
            this.memoryData.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updatePosition(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.memoryData) {
            JViewport jv = (JViewport)this.memoryData.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.memoryData.viewX);
            int newY = p.y - (e.getY() - this.memoryData.viewY);
            int maxX = this.memoryData.getWidth() - jv.getWidth();
            int maxY = this.memoryData.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.memoryData) {
            this.updatePosition(e);
        } else {
            this.deletePosition();
        }
    }

    private void updatePosition(MouseEvent e) {
        if (this.traceWrite) {
            Slot sl = this.memoryData.getMemorySlot(e.getX(), e.getY());
            if (sl != null) {
                this.info.setText(sl.toString());
                this.info.setCaretPosition(0);
                this.memoryData.selectSlot(sl);
            } else {
                this.info.setText("");
                this.memoryData.selectSlot(null);
            }
        }
    }

    private void deletePosition() {
        if (this.traceWrite) {
            this.info.setText("");
            this.memoryData.selectSlot(null);
        }
    }
}

