/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.preference;

import charm.debug.preference.Recent;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Preference
extends JPanel {
    public Dimension size = null;
    public Point location = null;
    public Recent recentConfig = new Recent();

    public Object[] getRecent() {
        return this.recentConfig.getList();
    }

    public void addRecent(String file) {
        this.recentConfig.add(file);
    }

    public void load() {
        BufferedReader in;
        try {
            in = new BufferedReader(new FileReader(System.getProperty("user.home") + "/.cpdrc"));
        }
        catch (FileNotFoundException e) {
            return;
        }
        System.out.println("Loading preference file " + System.getProperty("user.home") + "/.cpdrc");
        try {
            String str = in.readLine();
            str = str.substring(str.indexOf(32) + 1);
            try {
                this.size = new Dimension(Integer.parseInt(str.substring(0, str.indexOf(32))), Integer.parseInt(str.substring(str.indexOf(32) + 1)));
            }
            catch (Exception e) {
                // empty catch block
            }
            str = in.readLine();
            str = str.substring(str.indexOf(32) + 1);
            try {
                this.location = new Point(Integer.parseInt(str.substring(0, str.indexOf(32))), Integer.parseInt(str.substring(str.indexOf(32) + 1)));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.recentConfig.load(in);
            in.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not load configuration file.\nPlease delete the file '.cpdrc' from your home directory.", "Failed to load configuration", 0);
            return;
        }
    }

    public void save() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(System.getProperty("user.home") + "/.cpdrc"));
            out.write("WindowSize " + (this.size != null ? this.size.width + " " + this.size.height : "?") + "\n");
            out.write("WindowPosition " + (this.location != null ? this.location.x + " " + this.location.y : "?") + "\n");
            this.recentConfig.save(out);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Failed to save configuration file");
        }
    }
}

