#ifndef _DECL_msa_H_
#define _DECL_msa_H_
#include "charm++.h"
#ifdef CMK_CHECK_CRC
extern "C" void checkAllCRC(int);
#endif
/* DECLS: template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > group MSA_CacheGroup: IrrGroup{
MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
void AckPage(unsigned int page);
void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
void enroll(unsigned int numberOfWorkerThreads);
void enrollAck(int originator);
void enrollDone(void);
void SyncAck(void);
void SyncDone(void);
void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
};
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class MSA_CacheGroup;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CkIndex_MSA_CacheGroup;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxy_MSA_CacheGroup;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxyElement_MSA_CacheGroup;
/* --------------- index object ------------------ */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > class CkIndex_MSA_CacheGroup:public CProxyElement_IrrGroup{
  public:
    typedef MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
 */
    static int __idx_MSA_CacheGroup_marshall1;
    static int ckNew(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads) { return __idx_MSA_CacheGroup_marshall1; }
    static void _call_MSA_CacheGroup_marshall1(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_MSA_CacheGroup_marshall1(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_MSA_CacheGroup_marshall1(PUP::er &p,void *msg);

/* DECLS: void AckPage(unsigned int page);
 */
    static int __idx_AckPage_marshall2;
    static int AckPage(unsigned int page) { return __idx_AckPage_marshall2; }
    static void _call_AckPage_marshall2(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_AckPage_marshall2(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_AckPage_marshall2(PUP::er &p,void *msg);

/* DECLS: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
 */
    static int __idx_ReceivePage_marshall3;
    static int ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size) { return __idx_ReceivePage_marshall3; }
    static void _call_ReceivePage_marshall3(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_ReceivePage_marshall3(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_ReceivePage_marshall3(PUP::er &p,void *msg);

/* DECLS: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
 */
    static int __idx_ReceivePageWithPUP_marshall4;
    static int ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size) { return __idx_ReceivePageWithPUP_marshall4; }
    static void _call_ReceivePageWithPUP_marshall4(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_ReceivePageWithPUP_marshall4(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_ReceivePageWithPUP_marshall4(PUP::er &p,void *msg);

/* DECLS: void enroll(unsigned int numberOfWorkerThreads);
 */
    static int __idx_enroll_marshall5;
    static int enroll(unsigned int numberOfWorkerThreads) { return __idx_enroll_marshall5; }
    static void _call_enroll_marshall5(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_enroll_marshall5(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_enroll_marshall5(PUP::er &p,void *msg);

/* DECLS: void enrollAck(int originator);
 */
    static int __idx_enrollAck_marshall6;
    static int enrollAck(int originator) { return __idx_enrollAck_marshall6; }
    static void _call_enrollAck_marshall6(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_enrollAck_marshall6(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_enrollAck_marshall6(PUP::er &p,void *msg);

/* DECLS: void enrollDone(void);
 */
    static int __idx_enrollDone_void;
    static int enrollDone(void) { return __idx_enrollDone_void; }
    static void _call_enrollDone_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: void SyncAck(void);
 */
    static int __idx_SyncAck_void;
    static int SyncAck(void) { return __idx_SyncAck_void; }
    static void _call_SyncAck_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: void SyncDone(void);
 */
    static int __idx_SyncDone_void;
    static int SyncDone(void) { return __idx_SyncDone_void; }
    static void _call_SyncDone_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
 */
    static int __idx_emitBufferValue_marshall10;
    static int emitBufferValue(int ID, unsigned int pageNum, unsigned int offset) { return __idx_emitBufferValue_marshall10; }
    static void _call_emitBufferValue_marshall10(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_emitBufferValue_marshall10(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_emitBufferValue_marshall10(PUP::er &p,void *msg);
};
/* --------------- element proxy ------------------ */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > class CProxyElement_MSA_CacheGroup: public CProxyElement_IrrGroup{
  public:
    typedef MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;

    CProxyElement_MSA_CacheGroup(void) {}
    CProxyElement_MSA_CacheGroup(const IrrGroup *g) : CProxyElement_IrrGroup(g){  }
    CProxyElement_MSA_CacheGroup(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_IrrGroup(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_MSA_CacheGroup(CkGroupID _gid,int _onPE) : CProxyElement_IrrGroup(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_IrrGroup)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_IrrGroup::ckSetGroupID(g);
    }
    MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * ckLocalBranch(CkGroupID gID) {
      return (MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > *)CkLocalBranch(gID);
    }
/* DECLS: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
 */

/* DECLS: void AckPage(unsigned int page);
 */
    void AckPage(unsigned int page, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
 */
    void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
 */
    void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enroll(unsigned int numberOfWorkerThreads);
 */
    void enroll(unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enrollAck(int originator);
 */
    void enrollAck(int originator, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enrollDone(void);
 */
    void enrollDone(void);

/* DECLS: void SyncAck(void);
 */
    void SyncAck(void);

/* DECLS: void SyncDone(void);
 */
    void SyncDone(void);

/* DECLS: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
 */
    void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, const CkEntryOptions *impl_e_opts=NULL);
};
/* ---------------- collective proxy -------------- */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > class CProxy_MSA_CacheGroup: public CProxy_IrrGroup{
  public:
    typedef MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;

    CProxy_MSA_CacheGroup(void) {}
    CProxy_MSA_CacheGroup(const IrrGroup *g) : CProxy_IrrGroup(g){  }
    CProxy_MSA_CacheGroup(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_IrrGroup(_gid,CK_DELCTOR_ARGS){  }
    CProxy_MSA_CacheGroup(CkGroupID _gid) : CProxy_IrrGroup(_gid){  }
    CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator[](int onPE) const
      {return CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_IrrGroup)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_IrrGroup::ckSetGroupID(g);
    }
    MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * ckLocalBranch(CkGroupID gID) {
      return (MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > *)CkLocalBranch(gID);
    }
/* DECLS: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
 */
    static CkGroupID ckNew(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void AckPage(unsigned int page);
 */
    void AckPage(unsigned int page, const CkEntryOptions *impl_e_opts=NULL);
    void AckPage(unsigned int page, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
 */
    void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, const CkEntryOptions *impl_e_opts=NULL);
    void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
 */
    void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, const CkEntryOptions *impl_e_opts=NULL);
    void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enroll(unsigned int numberOfWorkerThreads);
 */
    void enroll(unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts=NULL);
    void enroll(unsigned int numberOfWorkerThreads, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enrollAck(int originator);
 */
    void enrollAck(int originator, const CkEntryOptions *impl_e_opts=NULL);
    void enrollAck(int originator, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void enrollDone(void);
 */
    void enrollDone(void);
    void enrollDone(int npes, int *pes);

/* DECLS: void SyncAck(void);
 */
    void SyncAck(void);
    void SyncAck(int npes, int *pes);

/* DECLS: void SyncDone(void);
 */
    void SyncDone(void);
    void SyncDone(int npes, int *pes);

/* DECLS: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
 */
    void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, const CkEntryOptions *impl_e_opts=NULL);
    void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
};

/* DECLS: template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > array MSA_PageArray: ArrayElement{
MSA_PageArray(CkMigrateMessage* impl_msg);
MSA_PageArray(void);
void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
void GetPage(int pe);
void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
void Sync(void);
void emit(int ID, int offset);
};
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class MSA_PageArray;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CkIndex_MSA_PageArray;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxy_MSA_PageArray;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxyElement_MSA_PageArray;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxySection_MSA_PageArray;
/* --------------- index object ------------------ */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > class CkIndex_MSA_PageArray:public CProxyElement_ArrayElement{
  public:
    typedef MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;
    typedef CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */
    static int __idx_MSA_PageArray_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_MSA_PageArray_CkMigrateMessage; }
    static void _call_MSA_PageArray_CkMigrateMessage(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: MSA_PageArray(void);
 */
    static int __idx_MSA_PageArray_void;
    static int ckNew(void) { return __idx_MSA_PageArray_void; }
    static void _call_MSA_PageArray_void(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
    static int __idx_setCacheProxy_marshall2;
    static int setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache) { return __idx_setCacheProxy_marshall2; }
    static void _call_setCacheProxy_marshall2(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_setCacheProxy_marshall2(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_setCacheProxy_marshall2(PUP::er &p,void *msg);

/* DECLS: void GetPage(int pe);
 */
    static int __idx_GetPage_marshall3;
    static int GetPage(int pe) { return __idx_GetPage_marshall3; }
    static void _call_GetPage_marshall3(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_GetPage_marshall3(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_GetPage_marshall3(PUP::er &p,void *msg);

/* DECLS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
    static int __idx_PAReceivePage_marshall4;
    static int PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState) { return __idx_PAReceivePage_marshall4; }
    static void _call_PAReceivePage_marshall4(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_PAReceivePage_marshall4(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_PAReceivePage_marshall4(PUP::er &p,void *msg);

/* DECLS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    static int __idx_PAReceiveRLEPage_marshall5;
    static int PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState) { return __idx_PAReceiveRLEPage_marshall5; }
    static void _call_PAReceiveRLEPage_marshall5(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_PAReceiveRLEPage_marshall5(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_PAReceiveRLEPage_marshall5(PUP::er &p,void *msg);

/* DECLS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    static int __idx_PAReceiveRLEPageWithPup_marshall6;
    static int PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState) { return __idx_PAReceiveRLEPageWithPup_marshall6; }
    static void _call_PAReceiveRLEPageWithPup_marshall6(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_PAReceiveRLEPageWithPup_marshall6(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_PAReceiveRLEPageWithPup_marshall6(PUP::er &p,void *msg);

/* DECLS: void Sync(void);
 */
    static int __idx_Sync_void;
    static int Sync(void) { return __idx_Sync_void; }
    static void _call_Sync_void(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);

/* DECLS: void emit(int ID, int offset);
 */
    static int __idx_emit_marshall8;
    static int emit(int ID, int offset) { return __idx_emit_marshall8; }
    static void _call_emit_marshall8(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static int _callmarshall_emit_marshall8(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > * impl_obj);
    static void _marshallmessagepup_emit_marshall8(PUP::er &p,void *msg);
};
/* --------------- element proxy ------------------ */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxyElement_MSA_PageArray : public CProxyElement_ArrayElement{
  public:
    typedef MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;
    typedef CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  section_t;

    CProxyElement_MSA_PageArray(void) {}
    CProxyElement_MSA_PageArray(const ArrayElement *e) : CProxyElement_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_ArrayElement::pup(p);
    }
    CK_DISAMBIG_ARRAY_ELEMENT(CProxyElement_ArrayElement)
    MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  *ckLocal(void) const
      { return (MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  *)CProxyElement_ArrayElement::ckLocal(); }
    CProxyElement_MSA_PageArray(const CkArrayID &aid,const CkArrayIndex1D &idx,CK_DELCTOR_PARAM)
        :CProxyElement_ArrayElement(aid,idx,CK_DELCTOR_ARGS) {}
    CProxyElement_MSA_PageArray(const CkArrayID &aid,const CkArrayIndex1D &idx)
        :CProxyElement_ArrayElement(aid,idx) {}
/* DECLS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: MSA_PageArray(void);
 */
    void insert(int onPE=-1);
/* DECLS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
    void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void GetPage(int pe);
 */
    void GetPage(int pe, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void Sync(void);
 */
    void Sync(void) ;

/* DECLS: void emit(int ID, int offset);
 */
    void emit(int ID, int offset, const CkEntryOptions *impl_e_opts=NULL) ;
};
/* ---------------- collective proxy -------------- */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxy_MSA_PageArray : public CProxy_ArrayElement{
  public:
    typedef MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;
    typedef CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  section_t;

    CProxy_MSA_PageArray(void) {}
    CProxy_MSA_PageArray(const ArrayElement *e) : CProxy_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_ArrayElement::pup(p);
    }
    CK_DISAMBIG_ARRAY(CProxy_ArrayElement)
    static CkArrayID ckNew(void) {return ckCreateEmptyArray();}
//Generalized array indexing:
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator [] (const CkArrayIndex1D &idx) const
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator() (const CkArrayIndex1D &idx) const
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator [] (int idx) const 
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), CkArrayIndex1D(idx), CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator () (int idx) const 
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), CkArrayIndex1D(idx), CK_DELCTOR_CALL);}
    CProxy_MSA_PageArray(const CkArrayID &aid,CK_DELCTOR_PARAM) 
        :CProxy_ArrayElement(aid,CK_DELCTOR_ARGS) {}
    CProxy_MSA_PageArray(const CkArrayID &aid) 
        :CProxy_ArrayElement(aid) {}
/* DECLS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: MSA_PageArray(void);
 */
    static CkArrayID ckNew(const CkArrayOptions &opts);
    static CkArrayID ckNew(const int s1);

/* DECLS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
    void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void GetPage(int pe);
 */
    void GetPage(int pe, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void Sync(void);
 */
    void Sync(void) ;

/* DECLS: void emit(int ID, int offset);
 */
    void emit(int ID, int offset, const CkEntryOptions *impl_e_opts=NULL) ;
};
/* ---------------- section proxy -------------- */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  class CProxySection_MSA_PageArray : public CProxySection_ArrayElement{
  public:
    typedef MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  local_t;
    typedef CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  index_t;
    typedef CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  proxy_t;
    typedef CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  element_t;
    typedef CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  section_t;

    CProxySection_MSA_PageArray(void) {}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_ArrayElement::pup(p);
    }
    CK_DISAMBIG_ARRAY_SECTION(CProxySection_ArrayElement)
//Generalized array indexing:
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator [] (const CkArrayIndex1D &idx) const
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator() (const CkArrayIndex1D &idx) const
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator [] (int idx) const 
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), *(CkArrayIndex1D*)&ckGetArrayElements()[idx], CK_DELCTOR_CALL);}
    CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  operator () (int idx) const 
        {return CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (ckGetArrayID(), *(CkArrayIndex1D*)&ckGetArrayElements()[idx], CK_DELCTOR_CALL);}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndex1D *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
    static CkSectionID ckNew(const CkArrayID &aid, int l, int u, int s) {
      CkVec<CkArrayIndex1D> al;
      for (int i=l; i<=u; i+=s) al.push_back(CkArrayIndex1D(i));
      return CkSectionID(aid, al.getVec(), al.size());
    } 
    CProxySection_MSA_PageArray(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayElement(aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_MSA_PageArray(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) 
        :CProxySection_ArrayElement(aid,elems,nElems) {}
    CProxySection_MSA_PageArray(const CkSectionID &sid)       :CProxySection_ArrayElement(sid) {}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
/* DECLS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: MSA_PageArray(void);
 */

/* DECLS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
    void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void GetPage(int pe);
 */
    void GetPage(int pe, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
    void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts=NULL) ;

/* DECLS: void Sync(void);
 */
    void Sync(void) ;

/* DECLS: void emit(int ID, int offset);
 */
    void emit(int ID, int offset, const CkEntryOptions *impl_e_opts=NULL) ;
};

extern void _registermsa(void);
#endif
