/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Stack;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class CallTable
extends ProjDefs {
    int myRun = 0;
    private int numPe;
    private int numEPs;
    private double[][] byteSum;
    private double[][] msgCount;
    private double[][] sumSquares;
    private int[][] minStats;
    private int[][] maxStats;
    private double[][] varStats;
    private boolean[] exists;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;
    private DecimalFormat _format;

    public CallTable(long startInterval, long endInterval, OrderedIntList processorList) {
        this.peList = processorList;
        this.numPe = this.peList.size();
        this.numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.startTime = startInterval;
        this.endTime = endInterval;
        this.byteSum = new double[this.numEPs][this.numEPs];
        this.msgCount = new double[this.numEPs][this.numEPs];
        this.sumSquares = new double[this.numEPs][this.numEPs];
        this.minStats = new int[this.numEPs][this.numEPs];
        this.maxStats = new int[this.numEPs][this.numEPs];
        this.varStats = new double[this.numEPs][this.numEPs];
        this.exists = new boolean[this.numEPs];
        this._format = new DecimalFormat("###,###.###");
    }

    public void GatherData(Component parent) {
        int currPeIndex = 0;
        ProgressMonitor progressBar = new ProgressMonitor(parent, "Generating Call Table", "", 0, this.numPe);
        while (this.peList.hasMoreElements()) {
            int currPe = this.peList.nextElement();
            if (progressBar.isCanceled()) {
                progressBar.close();
                break;
            }
            progressBar.setNote("[PE: " + currPe + " ] Reading data.");
            progressBar.setProgress(currPeIndex + 1);
            GenericLogReader LogFile = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(currPe), MainWindow.runObject[this.myRun].getVersion());
            try {
                int destEP;
                int msglen;
                int sourceEP;
                LogEntryData logdata = LogFile.nextEventOnOrAfter(this.startTime);
                Stack<Integer> creationStack = new Stack<Integer>();
                while (logdata.time < this.endTime && logdata.type != 2) {
                    if (logdata.type == 1) {
                        creationStack.push(new Integer(logdata.entry));
                        creationStack.push(new Integer(logdata.msglen));
                    }
                    if (logdata.type == 3) {
                        sourceEP = logdata.entry;
                        while (!creationStack.empty()) {
                            msglen = (Integer)creationStack.pop();
                            destEP = (Integer)creationStack.pop();
                            if (this.minStats[sourceEP][destEP] > msglen || this.minStats[sourceEP][destEP] == 0) {
                                this.minStats[sourceEP][destEP] = msglen;
                            }
                            if (this.maxStats[sourceEP][destEP] < msglen) {
                                this.maxStats[sourceEP][destEP] = msglen;
                            }
                            double[] dArray = this.msgCount[sourceEP];
                            int n = destEP;
                            dArray[n] = dArray[n] + 1.0;
                            double[] dArray2 = this.byteSum[sourceEP];
                            int n2 = destEP;
                            dArray2[n2] = dArray2[n2] + (double)msglen;
                            double[] dArray3 = this.sumSquares[sourceEP];
                            int n3 = destEP;
                            dArray3[n3] = dArray3[n3] + (double)msglen * (double)msglen;
                            if (this.exists[sourceEP]) continue;
                            this.exists[sourceEP] = true;
                        }
                        logdata = LogFile.nextEvent();
                        break;
                    }
                    logdata = LogFile.nextEvent();
                }
                while (logdata.time < this.endTime) {
                    if (logdata.type == 2) {
                        sourceEP = logdata.entry;
                        logdata = LogFile.nextEvent();
                        while (logdata.type != 3 && logdata.type != 7 && logdata.time < this.endTime) {
                            if (logdata.type == 1) {
                                destEP = logdata.entry;
                                msglen = logdata.msglen;
                                if (this.minStats[sourceEP][destEP] > msglen || this.minStats[sourceEP][destEP] == 0) {
                                    this.minStats[sourceEP][destEP] = msglen;
                                }
                                if (this.maxStats[sourceEP][destEP] < msglen) {
                                    this.maxStats[sourceEP][destEP] = msglen;
                                }
                                double[] dArray = this.msgCount[sourceEP];
                                int n = destEP;
                                dArray[n] = dArray[n] + 1.0;
                                double[] dArray4 = this.byteSum[sourceEP];
                                int n4 = destEP;
                                dArray4[n4] = dArray4[n4] + (double)msglen;
                                double[] dArray5 = this.sumSquares[sourceEP];
                                int n5 = destEP;
                                dArray5[n5] = dArray5[n5] + (double)msglen * (double)msglen;
                                if (!this.exists[sourceEP]) {
                                    this.exists[sourceEP] = true;
                                }
                            }
                            logdata = LogFile.nextEvent();
                        }
                    }
                    logdata = LogFile.nextEvent();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            ++currPeIndex;
        }
        for (int srcEP = 0; srcEP < this.numEPs; ++srcEP) {
            if (!this.exists[srcEP]) continue;
            for (int destEP = 0; destEP < this.numEPs; ++destEP) {
                if (this.msgCount[srcEP][destEP] == 1.0) {
                    this.varStats[srcEP][destEP] = 0.0;
                    continue;
                }
                if (!(this.msgCount[srcEP][destEP] > 1.0)) continue;
                double mean = this.byteSum[srcEP][destEP] / this.msgCount[srcEP][destEP];
                this.varStats[srcEP][destEP] = (this.sumSquares[srcEP][destEP] - 2.0 * mean * this.byteSum[srcEP][destEP] + mean * mean * this.msgCount[srcEP][destEP]) / (this.msgCount[srcEP][destEP] - 1.0);
            }
        }
        progressBar.close();
    }

    public String[][] getCallTableText(boolean epDetailToggle, boolean statsToggle) {
        int length = 0;
        for (int sourceEP = 0; sourceEP < this.numEPs; ++sourceEP) {
            if (!this.exists[sourceEP]) continue;
            ++length;
            for (int destEP = 0; destEP < this.numEPs; ++destEP) {
                if (!(this.msgCount[sourceEP][destEP] > 0.0)) continue;
                length += 2;
            }
            length += 2;
        }
        String[][] text = new String[length][1];
        int lengthCounter = 0;
        for (int sourceEP = 0; sourceEP < this.numEPs; ++sourceEP) {
            if (!this.exists[sourceEP]) continue;
            if (epDetailToggle) {
                text[lengthCounter][0] = MainWindow.runObject[this.myRun].getEntryFullNameByIndex(sourceEP);
            } else {
                String s = MainWindow.runObject[this.myRun].getEntryNameByIndex(sourceEP);
                int parenthIndex = s.indexOf(40);
                if (parenthIndex != -1) {
                    s = s.substring(0, parenthIndex);
                }
                text[lengthCounter][0] = s;
            }
            ++lengthCounter;
            for (int destEP = 0; destEP < this.numEPs; ++destEP) {
                if (!(this.msgCount[sourceEP][destEP] > 0.0)) continue;
                if (epDetailToggle) {
                    text[lengthCounter][0] = "        " + MainWindow.runObject[this.myRun].getEntryFullNameByIndex(destEP);
                } else {
                    String s = MainWindow.runObject[this.myRun].getEntryNameByIndex(destEP);
                    int parenthIndex = s.indexOf(40);
                    if (parenthIndex != -1) {
                        s = s.substring(0, parenthIndex);
                    }
                    text[lengthCounter][0] = "        " + s;
                }
                text[++lengthCounter][0] = statsToggle ? "                Msg's Rec'd=" + this._format.format(this.msgCount[sourceEP][destEP]) + "  Bytes Rec'd=" + this._format.format(this.byteSum[sourceEP][destEP]) + "  Min=" + this._format.format(this.minStats[sourceEP][destEP]) + "  Max=" + this._format.format(this.maxStats[sourceEP][destEP]) + "  Mean=" + this._format.format(this.byteSum[sourceEP][destEP] / this.msgCount[sourceEP][destEP]) + "  Variance=" + this._format.format(this.varStats[sourceEP][destEP]) : "";
                ++lengthCounter;
            }
            text[lengthCounter][0] = "";
            text[++lengthCounter][0] = "";
            ++lengthCounter;
        }
        return text;
    }
}

