#ifndef _DECL_CkArray_H_
#define _DECL_CkArray_H_
#include "charm++.h"
#include "CkReduction.decl.h"

#include "CkLocation.decl.h"

#include "CkArrayReductionMgr.decl.h"

/* DECLS: readonly CmiBool isAnytimeMigration;
 */

/* DECLS: group CkArray: CkReductionMgr{
CkArray(CkMigrateMessage* impl_msg);
CkArray(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
void insertElement(CkMessage* impl_msg);
void remoteDoneInserting(void);
void sendBroadcast(CkMessage* impl_msg);
void recvBroadcast(CkMessage* impl_msg);
void sendExpeditedBroadcast(CkMessage* impl_msg);
void recvExpeditedBroadcast(CkMessage* impl_msg);
};
 */
 class CkArray;
 class CkIndex_CkArray;
 class CProxy_CkArray;
 class CProxyElement_CkArray;
/* --------------- index object ------------------ */
class CkIndex_CkArray:public CProxyElement_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */
    static int __idx_CkArray_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_CkArray_CkMigrateMessage; }
    static void _call_CkArray_CkMigrateMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: CkArray(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */
    static int __idx_CkArray_marshall1;
    static int ckNew(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy) { return __idx_CkArray_marshall1; }
    static void _call_CkArray_marshall1(void* impl_msg,CkArray* impl_obj);
    static int _callmarshall_CkArray_marshall1(char* impl_buf,CkArray* impl_obj);
    static void _marshallmessagepup_CkArray_marshall1(PUP::er &p,void *msg);

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    static int __idx_insertElement_CkMessage;
    static int insertElement(CkMessage* impl_msg) { return __idx_insertElement_CkMessage; }
    static void _call_insertElement_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void remoteDoneInserting(void);
 */
    static int __idx_remoteDoneInserting_void;
    static int remoteDoneInserting(void) { return __idx_remoteDoneInserting_void; }
    static void _call_remoteDoneInserting_void(void* impl_msg,CkArray* impl_obj);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    static int __idx_sendBroadcast_CkMessage;
    static int sendBroadcast(CkMessage* impl_msg) { return __idx_sendBroadcast_CkMessage; }
    static void _call_sendBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    static int __idx_recvBroadcast_CkMessage;
    static int recvBroadcast(CkMessage* impl_msg) { return __idx_recvBroadcast_CkMessage; }
    static void _call_recvBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    static int __idx_sendExpeditedBroadcast_CkMessage;
    static int sendExpeditedBroadcast(CkMessage* impl_msg) { return __idx_sendExpeditedBroadcast_CkMessage; }
    static void _call_sendExpeditedBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    static int __idx_recvExpeditedBroadcast_CkMessage;
    static int recvExpeditedBroadcast(CkMessage* impl_msg) { return __idx_recvExpeditedBroadcast_CkMessage; }
    static void _call_recvExpeditedBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);
};
/* --------------- element proxy ------------------ */
class CProxyElement_CkArray: public CProxyElement_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;

    CProxyElement_CkArray(void) {}
    CProxyElement_CkArray(const IrrGroup *g) : CProxyElement_CkReductionMgr(g){  }
    CProxyElement_CkArray(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_CkReductionMgr(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_CkArray(CkGroupID _gid,int _onPE) : CProxyElement_CkReductionMgr(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_CkReductionMgr)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_CkReductionMgr::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_CkReductionMgr::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_CkReductionMgr::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_CkReductionMgr::ckSetGroupID(g);
    }
    CkArray* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray*)CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: CkArray(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    void insertElement(CkMessage* impl_msg);

/* DECLS: void remoteDoneInserting(void);
 */
    void remoteDoneInserting(void);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    void sendBroadcast(CkMessage* impl_msg);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    void sendExpeditedBroadcast(CkMessage* impl_msg);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    void recvExpeditedBroadcast(CkMessage* impl_msg);
};
PUPmarshall(CProxyElement_CkArray);
/* ---------------- collective proxy -------------- */
class CProxy_CkArray: public CProxy_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;

    CProxy_CkArray(void) {}
    CProxy_CkArray(const IrrGroup *g) : CProxy_CkReductionMgr(g){  }
    CProxy_CkArray(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_CkReductionMgr(_gid,CK_DELCTOR_ARGS){  }
    CProxy_CkArray(CkGroupID _gid) : CProxy_CkReductionMgr(_gid){  }
    CProxyElement_CkArray operator[](int onPE) const
      {return CProxyElement_CkArray(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_CkReductionMgr)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_CkReductionMgr::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_CkReductionMgr::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_CkReductionMgr::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_CkReductionMgr::ckSetGroupID(g);
    }
    CkArray* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray*)CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: CkArray(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */
    static CkGroupID ckNew(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_CkArray(const CkArrayOptions &i, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    void insertElement(CkMessage* impl_msg);
    void insertElement(CkMessage* impl_msg, int npes, int *pes);

/* DECLS: void remoteDoneInserting(void);
 */
    void remoteDoneInserting(void);
    void remoteDoneInserting(int npes, int *pes);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    void sendBroadcast(CkMessage* impl_msg);
    void sendBroadcast(CkMessage* impl_msg, int npes, int *pes);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg);
    void recvBroadcast(CkMessage* impl_msg, int npes, int *pes);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    void sendExpeditedBroadcast(CkMessage* impl_msg);
    void sendExpeditedBroadcast(CkMessage* impl_msg, int npes, int *pes);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    void recvExpeditedBroadcast(CkMessage* impl_msg);
    void recvExpeditedBroadcast(CkMessage* impl_msg, int npes, int *pes);
};
PUPmarshall(CProxy_CkArray);
typedef CBaseT<CkReductionMgr,CProxy_CkArray>  CBase_CkArray;






/* DECLS: array ArrayElement: ArrayBase{
ArrayElement(CkMigrateMessage* impl_msg);
ArrayElement(void);
void ckDestroy(void);
void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
};
 */
 class ArrayElement;
 class CkIndex_ArrayElement;
 class CProxy_ArrayElement;
 class CProxyElement_ArrayElement;
 class CProxySection_ArrayElement;
/* --------------- index object ------------------ */
class CkIndex_ArrayElement:public CProxyElement_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */
    static int __idx_ArrayElement_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_ArrayElement_CkMigrateMessage; }
    static void _call_ArrayElement_CkMigrateMessage(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: ArrayElement(void);
 */
    static int __idx_ArrayElement_void;
    static int ckNew(void) { return __idx_ArrayElement_void; }
    static void _call_ArrayElement_void(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: void ckDestroy(void);
 */
    static int __idx_ckDestroy_void;
    static int ckDestroy(void) { return __idx_ckDestroy_void; }
    static void _call_ckDestroy_void(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    static int __idx_inmem_checkpoint_CkArrayCheckPTReqMessage;
    static int inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) { return __idx_inmem_checkpoint_CkArrayCheckPTReqMessage; }
    static void _call_inmem_checkpoint_CkArrayCheckPTReqMessage(void* impl_msg,ArrayElement* impl_obj);
};
/* --------------- element proxy ------------------ */
 class CProxyElement_ArrayElement : public CProxyElement_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxyElement_ArrayElement(void) {}
    CProxyElement_ArrayElement(const ArrayElement *e) : CProxyElement_ArrayBase(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_ArrayBase::pup(p);
    }
    CK_DISAMBIG_ARRAY_ELEMENT(CProxyElement_ArrayBase)
    ArrayElement *ckLocal(void) const
      { return (ArrayElement *)CProxyElement_ArrayBase::ckLocal(); }
    CProxyElement_ArrayElement(const CkArrayID &aid,const CkArrayIndex &idx,CK_DELCTOR_PARAM)
        :CProxyElement_ArrayBase(aid,idx,CK_DELCTOR_ARGS) {}
    CProxyElement_ArrayElement(const CkArrayID &aid,const CkArrayIndex &idx)
        :CProxyElement_ArrayBase(aid,idx) {}
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */
    void insert(int onPE=-1);
/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;
};
PUPmarshall(CProxyElement_ArrayElement);
/* ---------------- collective proxy -------------- */
 class CProxy_ArrayElement : public CProxy_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxy_ArrayElement(void) {}
    CProxy_ArrayElement(const ArrayElement *e) : CProxy_ArrayBase(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_ArrayBase::pup(p);
    }
    CK_DISAMBIG_ARRAY(CProxy_ArrayBase)
    static CkArrayID ckNew(void) {return ckCreateEmptyArray();}
    CProxy_ArrayElement(const CkArrayID &aid,CK_DELCTOR_PARAM) 
        :CProxy_ArrayBase(aid,CK_DELCTOR_ARGS) {}
    CProxy_ArrayElement(const CkArrayID &aid) 
        :CProxy_ArrayBase(aid) {}
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */
    static CkArrayID ckNew(const CkArrayOptions &opts);

/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;
};
PUPmarshall(CProxy_ArrayElement);
/* ---------------- section proxy -------------- */
 class CProxySection_ArrayElement : public CProxySection_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxySection_ArrayElement(void) {}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_ArrayBase::pup(p);
    }
    CK_DISAMBIG_ARRAY_SECTION(CProxySection_ArrayBase)
    CProxySection_ArrayElement(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayBase(aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_ArrayElement(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) 
        :CProxySection_ArrayBase(aid,elems,nElems) {}
    CProxySection_ArrayElement(const CkSectionID &sid)       :CProxySection_ArrayBase(sid) {}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */

/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;
};
PUPmarshall(CProxySection_ArrayElement);
typedef CBaseT<ArrayBase,CProxy_ArrayElement>  CBase_ArrayElement;

extern void _registerCkArray(void);
#endif
