package projector.gui;

/*** Static class that acts as an interface between the gui and the core classes
****/

import java.io.*;
import java.util.*;
import java.awt.*;
import projector.core.*;
import projector.language.*;

public class Analysis {
	/*******Version *****************/
	private static double version;
	public static double getVersion() { return version;}
	public static void setVersion(double v){ version = v; }
	
	/***Initialization ********/
	private static StsReader sts;
	private static String logDirectory;	
	private static InitDataReader initDataReader;
	private static EventIntervalGenerator igen;
	
	 private static Color[] entryColors;
	
	public static void initAnalysis(String fileName) throws IOException{
		sts = new StsReader(fileName);
		logDirectory = dirFromFile(fileName);
		entryColors = createColorMap(sts.getEntryCount());
		initDataReader = new InitDataReader(sts);
		
		igen = new EventIntervalGenerator(getFilename());
	}
	
	public static Color[] createColorMap(int numColors) {
		Color[] colors = new Color[numColors];
		float H = (float)1.0;
		float S = (float)1.0;
		float B = (float)1.0;
		float delta = (float)(1.0/numColors);
		for(int i=0; i<numColors; i++) {
			colors[i] = Color.getHSBColor(H, S, B);
			H -= delta;
			if(H < 0.0) { H = (float)1.0; }
		}
		return colors;
	}
	public static String getUserEventName(int eventID) {
  	  if (sts != null) {
	  	 return sts.getUserEventName(eventID); }
	  else {
	  	 return null; 
	  }
  	}

	public static String[] getUserEventNames() {
		return sts.getUserEventNames();
    	}

	public static Color getUserEventColor(int eventID) {
		if (sts != null) {
			return sts.getUserEventColor(eventID);
		}
		else {
			return null; 
		}
  	}
	
	public static long getTotalTime() {
		//return sts.getTotalTime(); //projector
		return initDataReader.getEndTime();
	}

	public static Color getEntryColor(int entryIdx) {
		if (entryIdx < sts.getEntryCount()) {
		    return entryColors[entryIdx];
		} else {
		    return null;
		}
	}
	
	public static void setEntryColor(int entryIdx, Color color) {
		if (entryIdx < sts.getEntryCount()) {
		    entryColors[entryIdx] = color;
		} else {
		    System.err.println("Warning: entry point index " + entryIdx +
			       " not found. Cannot set color");
		}
    	}
	
	public static String getValidProcessorString() {
	//return logLoader.getValidProcessorString(); trying something for projector
		return initDataReader.getValidPEString();	
    	}

	public static int getNumProcessors() {
		return sts.getProcessorCount();
	}
	
	/***Timeline Stuff**/
	
	public static TimelineObject [] createTLO(int p, long bt, long et, int language,TimelineData data){
		Vector intervalVect = igen.getLanguageIntervals(language,p,(double )bt/1000000,(double )et/1000000);
		

		System.out.println("Size of intervalVect = " + intervalVect.size());
		Interpreter [] interpreters = igen.getInterpreters();
		return  interpreters[language].createTLO(intervalVect,p,data);
	}

	
	/**user event stuff*/
	public static int getNumUserEntries() {
		return sts.getEntryCount();
	}
	public static int getNumUserDefinedEvents() {
		return sts.getNumUserDefinedEvents();
    	}

	public static String[][] getUserEntryNames() {
		return sts.getEntryNames();
	}
	public static int getUserEntryCount() {
		return sts.getEntryCount();
	}
	
	/**some utility functions for extracting the directory from the path */
	private static String dirFromFile(String filename) {
		// pre condition - filename is a full path name
		int index = filename.lastIndexOf(File.separator);
		if(index != -1)
			return filename.substring(0,index);
		return(".");	//present directory
    	}
	public static String getLogDirectory() {
		return logDirectory;
    	}
	
	public static String getFilename() {return sts.getFilename();}
	
}
