/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PList
extends PAbstract {
    private PAbstract head;
    private PAbstract tail;
    private int size;

    PList() {
        this.emptyList();
    }

    public void emptyList() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public void add(PAbstract pAbstract) {
        if (this.tail == null) {
            this.head = this.tail = pAbstract;
            this.size = 1;
        } else {
            this.tail.setNext(pAbstract);
            this.tail = pAbstract;
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public PAbstract elementAt(int n) {
        int n2 = 0;
        for (PAbstract pAbstract = this.head; pAbstract != null; pAbstract = pAbstract.getNext()) {
            if (n2 == n) {
                return pAbstract;
            }
            ++n2;
        }
        return null;
    }

    public PAbstract elementNamed(String string) {
        for (PAbstract pAbstract = this.head; pAbstract != null; pAbstract = pAbstract.getNext()) {
            if (!pAbstract.getName().equals(string)) continue;
            return pAbstract;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "{");
        for (PAbstract pAbstract = this.head; pAbstract != null; pAbstract = pAbstract.getNext()) {
            stringBuffer.append(pAbstract.toString());
            if (pAbstract.getNext() == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }

    private boolean hasFew() {
        return this.head == this.tail;
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        if (!this.hasFew()) {
            super.draw(pDisplayStyle, n);
            pDisplayStyle.drawString("{");
        }
        if (n == 1) {
            pDisplayStyle.addIndent(1);
            for (PAbstract pAbstract = this.head; pAbstract != null; pAbstract = pAbstract.getNext()) {
                pAbstract.draw(pDisplayStyle);
                if (pAbstract.getNext() == null) continue;
                pDisplayStyle.newRow();
            }
            pDisplayStyle.addIndent(-1);
        } else {
            for (PAbstract pAbstract = this.head; pAbstract != null; pAbstract = pAbstract.getNext()) {
                if (pAbstract.draw(pDisplayStyle)) continue;
                return false;
            }
        }
        if (!this.hasFew()) {
            pDisplayStyle.drawString("}");
        }
        return true;
    }
}

