/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

class AsciiIntegerReader {
    private Reader file;
    private char[] buffer = new char[1000];
    private int idx = 0;
    private int len = 0;
    private char last;

    public AsciiIntegerReader(Reader reader) {
        this.file = reader;
        this.last = '\u0000';
    }

    public void close() throws IOException {
        this.len = 0;
        this.idx = 0;
        this.buffer = null;
        this.file.close();
        this.file = null;
    }

    public void fillBuffer() throws IOException {
        this.idx = 0;
        this.len = this.file.read(this.buffer, 0, 1000);
        if (this.len <= 0) {
            throw new EOFException();
        }
    }

    public long skip(long l) throws IOException {
        int n = 0;
        if ((long)this.idx + l <= (long)this.len) {
            n = (int)((long)n + l);
            this.idx = (int)((long)this.idx + l);
        } else {
            this.idx += (n += this.len - this.idx);
            long l2 = this.file.skip(l - (long)n);
            if (l2 > 0L) {
                n = (int)((long)n + l2);
                try {
                    this.fillBuffer();
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }

    public final char nextChar() throws IOException {
        if (this.idx >= this.len) {
            this.fillBuffer();
        }
        return this.buffer[this.idx++];
    }

    public final int nextInt() throws IOException {
        return (int)this.nextLong();
    }

    public void nextLine() throws IOException {
        if (this.last == '\n') {
            this.last = '\u0000';
            return;
        }
        while (this.nextChar() != '\n') {
        }
    }

    public String readLine() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.last == '\n') {
            this.last = '\u0000';
            return "";
        }
        while ((c = this.nextChar()) != '\n') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public final long nextLong() throws IOException {
        char c;
        while (this.isSpace(c = this.nextChar())) {
        }
        long l = this.toDigit(c);
        while (true) {
            this.last = c = this.nextChar();
            if (this.isSpace(c)) break;
            l = 10L * l + (long)this.toDigit(c);
        }
        return l;
    }

    public String nextString() throws IOException {
        char c;
        while (this.isSpace(c = this.nextChar())) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        while (true) {
            this.last = c = this.nextChar();
            if (this.isSpace(c)) break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public final int toDigit(char c) {
        return c - 48;
    }
}

