/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.misc.LogEntryData;

class LogEntry {
    public int Replay;
    public int TransactionType;
    public int MsgType;
    public int Entry;
    long Time;
    int EventID;
    int Pe;
    int MsgLen;
    ObjectId id;
    long recvTime;
    long sendTime;
    int[] destPEs;
    long cpuBegin;
    long cpuEnd;
    int numPapiCounts;
    long[] papiCounts;
    int FunctionID;
    AmpiFunctionData ampiData;

    LogEntry() {
    }

    public void setAmpiData(int n, int n2, String string) {
        this.ampiData = new AmpiFunctionData();
        this.ampiData.FunctionID = n;
        this.ampiData.LineNo = n2;
        this.ampiData.sourceFileName = string;
    }

    public static LogEntry adapt(LogEntryData logEntryData) {
        int n;
        LogEntry logEntry = new LogEntry();
        logEntry.TransactionType = logEntryData.type;
        logEntry.MsgType = logEntryData.mtype;
        logEntry.Time = logEntryData.time;
        logEntry.Entry = logEntryData.entry;
        logEntry.EventID = logEntryData.event;
        logEntry.Pe = logEntryData.pe;
        logEntry.MsgLen = logEntryData.msglen;
        logEntry.sendTime = logEntryData.sendTime;
        logEntry.recvTime = logEntryData.recvTime;
        logEntry.id = new ObjectId(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
        if (logEntryData.destPEs != null) {
            logEntry.destPEs = new int[logEntryData.destPEs.length];
            for (n = 0; n < logEntry.destPEs.length; ++n) {
                logEntry.destPEs[n] = logEntryData.destPEs[n];
            }
        }
        logEntry.cpuBegin = logEntryData.cpuStartTime;
        logEntry.cpuEnd = logEntryData.cpuEndTime;
        logEntry.numPapiCounts = logEntryData.numPerfCounts;
        logEntry.papiCounts = new long[logEntry.numPapiCounts];
        for (n = 0; n < logEntry.numPapiCounts; ++n) {
            logEntry.papiCounts[n] = logEntryData.perfCounts[n];
        }
        logEntry.FunctionID = logEntryData.entry;
        if (logEntryData.funcName != null) {
            logEntry.setAmpiData(logEntryData.entry, logEntryData.lineNo, new String(logEntryData.funcName));
        }
        return logEntry;
    }
}

