/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Bubble
extends Window
implements MouseListener {
    private FontMetrics fm;
    private String[] text;

    public Bubble(Component component, String[] stringArray) {
        super(Bubble.getFrame(component));
        this.text = stringArray;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.addMouseListener(this);
        this.setBackground(new Color(255, 255, 200));
        this.setForeground(Color.black);
        this.setSize(this.getPreferredSize());
    }

    static Frame getFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
        }
        return frame;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setVisible(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Graphics graphics;
        int n = 10;
        int n2 = 10;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics();
            graphics.dispose();
        }
        if (this.text == null) {
            return new Dimension(n, n2);
        }
        if (this.fm != null) {
            int n3 = this.fm.getHeight() + 2;
            n2 = n3 * this.text.length + 6;
            n = this.fm.stringWidth(this.text[0]);
            for (int i = 1; i < this.text.length; ++i) {
                n = Math.max(this.fm.stringWidth(this.text[i]), n);
            }
            n += 16;
        } else {
            n = this.text[0].length();
            for (int i = 1; i < this.text.length; ++i) {
                n = Math.max(this.text[i].length(), n);
            }
            n *= 8;
            n += 8;
            n2 = this.text.length * 15;
            n2 += 8;
        }
        return new Dimension(n, n2);
    }

    public void paint(Graphics graphics) {
        if (this.text == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        int n3 = this.fm.getHeight() + 2;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this.text.length; ++i) {
            graphics.drawString(this.text[i], 4, (i + 1) * n3);
        }
    }

    public void setBubbleText(String[] stringArray) {
        this.text = stringArray;
    }

    public void setVisible(boolean bl) {
        this.pack();
        super.setVisible(bl);
    }
}

