/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.analysis.CallGraph;
import projections.analysis.ColorSaver;
import projections.gui.Analysis;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class CommTimeWindow
extends GenericGraphWindow
implements ItemListener,
ActionListener,
ColorSelectable {
    private CommTimeWindow thisWindow;
    private EntrySelectionDialog entryDialog;
    private JPanel mainPanel;
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel controlPanel;
    private JButton setRanges;
    private JButton epSelection;
    private JButton saveColors;
    private JButton loadColors;
    private CheckboxGroup cbg;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox receivedExternalMsgs;
    private Checkbox receivedExternalBytes;
    private int startInterval;
    private int endInterval;
    private int numIntervals;
    private int numEPs;
    private long intervalSize;
    private OrderedIntList processorList;
    private String currentArrayName;
    private String[] typeLabelNames = new String[]{"Entry Points"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] receivedExternalMsgCount;
    private double[][] receivedExternalByteCount;
    private Color[] outColors;
    private double[][] sentMsgOutput;
    private double[][] sentByteOutput;
    private double[][] receivedMsgOutput;
    private double[][] receivedByteOutput;
    private double[][] receivedExternalMsgOutput;
    private double[][] receivedExternalByteOutput;
    private boolean startFlag;
    private DecimalFormat _format;

    void windowInit() {
        super.windowInit();
        this.intervalSize = 1000L;
        this.startInterval = 0;
        this.endInterval = this.endTime % this.intervalSize == 0L ? (int)(this.endTime / this.intervalSize - 1L) : (int)(this.endTime / this.intervalSize);
        this.numIntervals = this.endInterval - this.startInterval + 1;
        this.processorList = Analysis.getValidProcessorList();
    }

    public CommTimeWindow(MainWindow mainWindow, Integer n) {
        super("Projections Communication vs Time Graph - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.setGraphSpecificData();
        this.numEPs = Analysis.getNumUserEntries();
        this.stateArray = new boolean[1][this.numEPs];
        this.existsArray = new boolean[1][this.numEPs];
        this.colorArray = new Color[1][this.numEPs];
        this.entryNames = new String[this.numEPs];
        for (int i = 0; i < this.numEPs; ++i) {
            this.colorArray[0][i] = Analysis.getEntryColor(i);
            this.entryNames[i] = Analysis.getEntryName(i);
        }
        this.mainPanel = new JPanel();
        this._format = new DecimalFormat("###,###.###");
        this.setLayout(this.mainPanel);
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.showDialog();
    }

    protected void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.cbg = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent To", this.cbg, true);
        this.sentMsgs.addItemListener(this);
        this.sentBytes = new Checkbox("Bytes Sent To", this.cbg, false);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs = new Checkbox("Msgs Recv By", this.cbg, false);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes = new Checkbox("Bytes Recv By", this.cbg, false);
        this.receivedBytes.addItemListener(this);
        this.receivedExternalMsgs = new Checkbox("External Msgs Recv By", this.cbg, false);
        this.receivedExternalMsgs.addItemListener(this);
        this.receivedExternalBytes = new Checkbox("External Bytes Recv By", this.cbg, false);
        this.receivedExternalBytes.addItemListener(this);
        this.checkBoxPanel = new JPanel();
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalMsgs, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalBytes, gridBagConstraints, 5, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.epSelection = new JButton("Select Entry Points");
        this.epSelection.addActionListener(this);
        this.saveColors = new JButton("Save Entry Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Entry Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.epSelection, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gridBagConstraints, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        this.graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, this.graphPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gridBagConstraints, 0, 2, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 3, 1, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            this.setCheckboxData(checkbox);
            this.setCursor(new Cursor(0));
        }
    }

    public void setCheckboxData(Checkbox checkbox) {
        if (checkbox == this.sentMsgs) {
            this.setDataSource("Communication vs Time", this.sentMsgOutput, this.outColors, this);
            this.setPopupText("sentMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Sent", "");
            super.refreshGraph();
        } else if (checkbox == this.sentBytes) {
            this.setDataSource("Communication vs Time", this.sentByteOutput, this.outColors, this);
            this.setPopupText("sentByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Sent", "");
            super.refreshGraph();
        } else if (checkbox == this.receivedMsgs) {
            this.setDataSource("Communication vs Time", this.receivedMsgOutput, this.outColors, this);
            this.setPopupText("receivedMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Received", "");
            super.refreshGraph();
        } else if (checkbox == this.receivedBytes) {
            this.setDataSource("Communication vs Time", this.receivedByteOutput, this.outColors, this);
            this.setPopupText("receivedByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Received", "");
            super.refreshGraph();
        } else if (checkbox == this.receivedExternalMsgs) {
            this.setDataSource("Communication vs Time", this.receivedExternalMsgOutput, this.outColors, this);
            this.setPopupText("receivedExternalMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Received Externally", "");
            super.refreshGraph();
        } else if (checkbox == this.receivedExternalBytes) {
            this.setDataSource("Communication vs Time", this.receivedExternalByteOutput, this.outColors, this);
            this.setPopupText("receivedExternalByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Received Externally", "");
            super.refreshGraph();
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time", "");
        this.setYAxis("Count", "");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    CommTimeWindow.this.fillGraphData();
                    return null;
                }

                public void finished() {
                    CommTimeWindow.this.setOutputGraphData();
                    Checkbox checkbox = CommTimeWindow.this.cbg.getSelectedCheckbox();
                    CommTimeWindow.this.setCheckboxData(checkbox);
                    CommTimeWindow.this.thisWindow.setVisible(true);
                    CommTimeWindow.this.thisWindow.repaint();
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.startInterval = (int)intervalRangeDialog.getStartInterval();
        this.endInterval = (int)intervalRangeDialog.getEndInterval();
        this.numIntervals = this.endInterval - this.startInterval + 1;
        this.processorList = intervalRangeDialog.getValidProcessors();
    }

    public void setDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        intervalRangeDialog.setIntervalSize(this.intervalSize);
        intervalRangeDialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    public void showWindow() {
    }

    public void fillGraphData() {
        int n;
        int n2;
        CallGraph callGraph = new CallGraph(this.startInterval, this.endInterval, this.intervalSize, this.processorList);
        callGraph.GatherData(this);
        double[][] dArray = callGraph.getMessageArray();
        double[][] dArray2 = callGraph.getByteArray();
        double[][] dArray3 = callGraph.getExternalMessageArray();
        double[][] dArray4 = callGraph.getExternalByteArray();
        this.sentMsgCount = new double[this.numIntervals][this.numEPs];
        this.sentByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalByteCount = new double[this.numIntervals][this.numEPs];
        for (n2 = 0; n2 < this.numIntervals; ++n2) {
            for (n = 0; n < this.numEPs; ++n) {
                this.sentMsgCount[n2][n] = dArray[n2][n];
                this.sentByteCount[n2][n] = dArray2[n2][n];
                this.receivedMsgCount[n2][n] = dArray[n2][n + this.numEPs];
                this.receivedByteCount[n2][n] = dArray2[n2][n + this.numEPs];
                this.receivedExternalMsgCount[n2][n] = dArray3[n2][n + this.numEPs];
                this.receivedExternalByteCount[n2][n] = dArray4[n2][n + this.numEPs];
            }
        }
        if (this.startFlag) {
            block2: for (n2 = 0; n2 < this.numEPs; ++n2) {
                for (n = 0; n < this.numIntervals; ++n) {
                    if (!(dArray[n][n2] > 0.0) && !(dArray[n][n2 + this.numEPs] > 0.0)) continue;
                    this.existsArray[0][n2] = true;
                    this.stateArray[0][n2] = true;
                    continue block2;
                }
            }
            this.startFlag = false;
        }
    }

    public void applyDialogColors() {
        this.setOutputGraphData();
        this.repaint();
    }

    private void setOutputGraphData() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numEPs; ++n) {
            if (!this.stateArray[0][n]) continue;
            ++n2;
        }
        if (n2 != 0) {
            this.sentMsgOutput = new double[this.numIntervals][n2];
            this.sentByteOutput = new double[this.numIntervals][n2];
            this.receivedMsgOutput = new double[this.numIntervals][n2];
            this.receivedByteOutput = new double[this.numIntervals][n2];
            this.receivedExternalMsgOutput = new double[this.numIntervals][n2];
            this.receivedExternalByteOutput = new double[this.numIntervals][n2];
            this.outColors = new Color[n2];
            n = 0;
            for (int i = 0; i < this.numEPs; ++i) {
                if (!this.stateArray[0][i]) continue;
                for (int j = 0; j < this.numIntervals; ++j) {
                    this.sentMsgOutput[j][n] = this.sentMsgCount[j][i];
                    this.sentByteOutput[j][n] = this.sentByteCount[j][i];
                    this.receivedMsgOutput[j][n] = this.receivedMsgCount[j][i];
                    this.receivedByteOutput[j][n] = this.receivedByteCount[j][i];
                    this.receivedExternalMsgOutput[j][n] = this.receivedExternalMsgCount[j][i];
                    this.receivedExternalByteOutput[j][n] = this.receivedExternalByteCount[j][i];
                }
                this.outColors[n++] = this.colorArray[0][i];
            }
        }
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0 || this.currentArrayName == null) {
            return null;
        }
        int n3 = 0;
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.numEPs; ++i) {
            if (!this.stateArray[0][i] || n3++ != n2) continue;
            string = Analysis.getEntryName(i);
            string2 = Analysis.getEntryChareName(i);
            break;
        }
        String[] stringArray = new String[3];
        if (this.currentArrayName.equals("sentMsgCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Count = " + this._format.format(this.sentMsgOutput[n][n2]);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Bytes = " + this._format.format(this.sentByteOutput[n][n2]);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Count = " + this._format.format(this.receivedMsgOutput[n][n2]);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Bytes = " + this._format.format(this.receivedByteOutput[n][n2]);
        } else if (this.currentArrayName.equals("receivedExternalMsgCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Count = " + this._format.format(this.receivedExternalMsgOutput[n][n2]);
        } else if (this.currentArrayName.equals("receivedExternalByteCount")) {
            stringArray[0] = "Dest. Chare: " + string2;
            stringArray[1] = "Dest. EPid: " + string;
            stringArray[2] = "Bytes = " + this._format.format(this.receivedExternalByteOutput[n][n2]);
        }
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.entryNames);
                }
                this.entryDialog.showDialog();
                this.setOutputGraphData();
                Checkbox checkbox = this.cbg.getSelectedCheckbox();
                this.setCheckboxData(checkbox);
            } else if (jButton == this.setRanges) {
                this.showDialog();
            } else if (jButton == this.saveColors) {
                try {
                    ColorSaver.save(this.colorArray[0]);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to save colors!!");
                }
            } else if (jButton == this.loadColors) {
                try {
                    this.colorArray[0] = ColorSaver.loadColors();
                    this.setOutputGraphData();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load colors!!");
                }
            }
        }
    }

    public void repaint() {
        super.refreshGraph();
    }

    private void setPopupText(String string) {
        this.currentArrayName = string;
    }
}

