/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PopUpAble;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class FunctionTool
extends GenericGraphWindow
implements PopUpAble {
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel radioButtonPanel;
    private JRadioButton countCB;
    private JRadioButton timeCB;
    private ButtonGroup buttonGroup;
    private double[][] countData;
    private double[][] timeData;
    private String currentArrayName = "";
    private FunctionTool thisWindow;

    public FunctionTool(MainWindow mainWindow, Integer n) {
        super("Function tracing", mainWindow, n);
        this.setLayout(this.mainPanel);
        this.createLayout();
        this.setPopupText("timeData");
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void setPopupText(String string) {
        this.currentArrayName = string;
    }

    protected void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.graphPanel = this.getMainPanel();
        this.radioButtonPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.countCB = new JRadioButton("Call Counts", false);
        this.timeCB = new JRadioButton("Time Spent", true);
        buttonGroup.add(this.countCB);
        buttonGroup.add(this.timeCB);
        this.countCB.addActionListener(this);
        this.timeCB.addActionListener(this);
        Util.gblAdd(this.radioButtonPanel, this.countCB, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.radioButtonPanel, this.timeCB, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.graphPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.radioButtonPanel, gridBagConstraints, 0, 2, 1, 1, 0, 0);
    }

    protected void setGraphSpecificData() {
        if (this.currentArrayName.equals("timeData")) {
            this.setDataSource("Total Function Time", this.timeData, Analysis.getFunctionColors(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("Time Spent in Function", "us");
        } else if (this.currentArrayName.equals("countData")) {
            this.setDataSource("Total Function Calls", this.countData, Analysis.getFunctionColors(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("# Times Called", "");
        }
        super.refreshGraph();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    FunctionTool.this.getData();
                    return null;
                }

                public void finished() {
                    FunctionTool.this.setGraphSpecificData();
                    FunctionTool.this.thisWindow.setVisible(true);
                    FunctionTool.this.thisWindow.repaint();
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void repaint() {
        super.refreshGraph();
    }

    private void getData() {
        LogEntryData logEntryData = new LogEntryData();
        OrderedIntList orderedIntList = Analysis.getValidProcessorList();
        orderedIntList.reset();
        int n = Analysis.getNumFunctionEvents();
        CallStackManager callStackManager = new CallStackManager();
        int[] nArray = new int[3];
        this.countData = new double[orderedIntList.size()][n];
        this.timeData = new double[orderedIntList.size()][n];
        int n2 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Reading log files", "", 0, orderedIntList.size());
        while (orderedIntList.hasMoreElements()) {
            int n3 = orderedIntList.nextElement();
            try {
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
                progressMonitor.setNote("[PE: " + n3 + " ] Reading data");
                progressMonitor.setProgress(n2 + 1);
                this.validate();
                GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n3), Analysis.getVersion());
                double d = 0.0;
                genericLogReader.nextEventOfType(2, logEntryData);
                while (true) {
                    switch (logEntryData.type) {
                        case 2: {
                            if (logEntryData.entry != 0) break;
                            d = logEntryData.time;
                            nArray[0] = logEntryData.id[0];
                            nArray[1] = logEntryData.id[1];
                            nArray[2] = logEntryData.id[2];
                            break;
                        }
                        case 3: {
                            if (logEntryData.entry != 0) break;
                            Integer n4 = (Integer)callStackManager.read(nArray[0], nArray[1], nArray[2]);
                            if (n4 != null) {
                                double[] dArray = this.timeData[n2];
                                int n5 = n4;
                                dArray[n5] = dArray[n5] + ((double)logEntryData.time - d);
                            }
                            nArray[0] = -1;
                            nArray[1] = -1;
                            nArray[2] = -1;
                            break;
                        }
                        case 22: {
                            Integer n4 = (Integer)callStackManager.read(nArray[0], nArray[1], nArray[2]);
                            if (n4 != null) {
                                double[] dArray = this.timeData[n2];
                                int n6 = n4;
                                dArray[n6] = dArray[n6] + ((double)logEntryData.time - d);
                            }
                            callStackManager.push(new Integer(logEntryData.entry), nArray[0], nArray[1], nArray[2]);
                            d = logEntryData.time;
                            double[] dArray = this.countData[n2];
                            int n7 = logEntryData.entry;
                            dArray[n7] = dArray[n7] + 1.0;
                            break;
                        }
                        case 23: {
                            Integer n4 = (Integer)callStackManager.pop(nArray[0], nArray[1], nArray[2]);
                            if (n4 != null) {
                                if (logEntryData.entry != n4) {
                                    System.err.println("ERROR: Function end type " + logEntryData.entry + " does not match stack " + "type " + n4);
                                    System.exit(-1);
                                }
                                double[] dArray = this.timeData[n2];
                                int n8 = logEntryData.entry;
                                dArray[n8] = dArray[n8] + ((double)logEntryData.time - d);
                            } else {
                                System.err.println("ERROR: Impossible for an empty stack when processing end of function");
                                System.exit(-1);
                            }
                            d = logEntryData.time;
                        }
                    }
                    genericLogReader.nextEvent(logEntryData);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.err.println("Failed to read log at processor [" + n3 + "]");
            }
            ++n2;
        }
        progressMonitor.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == this.countCB) {
                this.setPopupText("countData");
                this.setGraphSpecificData();
            } else if (jRadioButton == this.timeCB) {
                this.setPopupText("timeData");
                this.setGraphSpecificData();
            }
        }
        super.actionPerformed(actionEvent);
    }

    public String[] getPopup(int n, int n2) {
        String[] stringArray = new String[3];
        if (this.currentArrayName.equals("timeData")) {
            stringArray[0] = "Processor: " + n;
            stringArray[1] = "Function: " + Analysis.getFunctionName(n2);
            stringArray[2] = "Time spent (us): " + (long)this.timeData[n][n2];
        } else if (this.currentArrayName.equals("countData")) {
            stringArray[0] = "Processor: " + n;
            stringArray[1] = "Function: " + Analysis.getFunctionName(n2);
            stringArray[2] = "Times called: " + (int)this.countData[n][n2];
        }
        return stringArray;
    }
}

