/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import projections.gui.Analysis;

public class LogFileViewerTextArea
extends Panel
implements AdjustmentListener {
    private Scrollbar VSB;
    private String[][] text;
    private FontMetrics fm;
    private int lineheight;
    private int titleheight;
    private Image offscreen;
    private int linenumwidth;
    private int timewidth;

    public LogFileViewerTextArea() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                LogFileViewerTextArea.this.setBounds();
            }
        });
        this.setLayout(null);
        this.setBackground(Color.black);
        this.VSB = new Scrollbar(1, 0, 1, 0, 1);
        this.VSB.setVisible(false);
        this.VSB.setBackground(Color.lightGray);
        this.VSB.addAdjustmentListener(this);
        this.add(this.VSB);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    public void paint(Graphics graphics) {
        int n;
        String string;
        int n2;
        if (this.fm == null) {
            this.setBounds();
        }
        if (this.text == null) {
            return;
        }
        Graphics graphics2 = graphics;
        graphics = this.offscreen.getGraphics();
        int n3 = this.VSB.getValue();
        graphics.translate(0, -n3);
        int n4 = this.getSize().width - 20;
        int n5 = this.getSize().height - this.titleheight;
        int n6 = (n3 - this.lineheight) / this.lineheight;
        int n7 = (n3 - this.lineheight + n5) / this.lineheight + 1;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < n6) {
            n7 = n6;
        }
        if (n7 > this.text.length - 1) {
            n7 = this.text.length - 1;
        }
        graphics.setColor(Color.white);
        for (int i = n6; i <= n7; ++i) {
            n2 = (i + 1) * this.lineheight + this.titleheight;
            string = "" + i;
            n = 10 + (this.linenumwidth - this.fm.stringWidth(string)) / 2;
            graphics.setColor(Color.yellow);
            graphics.drawString("" + i, n, n2);
            string = this.text[i][0];
            n = 10 + this.linenumwidth + 10 + this.timewidth - this.fm.stringWidth(string);
            graphics.setColor(Color.red);
            graphics.drawString(string, n, n2);
            string = this.text[i][1];
            n = 10 + this.linenumwidth + 10 + this.timewidth + 10;
            graphics.setColor(Color.white);
            graphics.drawString(string, n, n2);
        }
        graphics.translate(0, n3);
        graphics.clearRect(0, 0, n4, this.titleheight);
        graphics.setColor(Color.white);
        string = "LINE";
        n = (this.linenumwidth - this.fm.stringWidth(string)) / 2 + 10;
        n2 = (this.titleheight + this.fm.getHeight()) / 2;
        graphics.drawString(string, n, n2);
        graphics.drawLine(n, n2 + 2, n + this.fm.stringWidth(string), n2 + 2);
        string = "TIME";
        n = 10 + this.linenumwidth + 10 + (this.timewidth - this.fm.stringWidth(string)) / 2;
        graphics.drawString(string, n, n2);
        graphics.drawLine(n, n2 + 2, n + this.fm.stringWidth(string), n2 + 2);
        string = "EVENT";
        n = 10 + this.linenumwidth + 10 + this.timewidth + 10;
        graphics.drawString(string, n, n2);
        graphics.drawLine(n, n2 + 2, n + this.fm.stringWidth(string), n2 + 2);
        graphics2.drawImage(this.offscreen, 0, 0, n4, n5 + this.titleheight, 0, 0, n4, n5 + this.titleheight, null);
    }

    public void setBounds() {
        Graphics graphics;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.lineheight = this.fm.getHeight() + 2;
        }
        if (this.fm == null || this.text == null) {
            return;
        }
        int n = this.text.length;
        int n2 = this.lineheight * (n + 1);
        this.titleheight = this.lineheight + 20;
        this.linenumwidth = this.fm.stringWidth("" + n);
        if (this.linenumwidth < this.fm.stringWidth("LINE")) {
            this.linenumwidth = this.fm.stringWidth("LINE");
        }
        this.timewidth = this.fm.stringWidth("" + Analysis.getTotalTime());
        if (this.timewidth < this.fm.stringWidth("TIME")) {
            this.timewidth = this.fm.stringWidth("TIME");
        }
        int n3 = this.getSize().width - 20;
        int n4 = this.getSize().height - this.titleheight;
        this.VSB.setBounds(n3, this.titleheight, 20, n4);
        if (n2 > n4) {
            this.VSB.setMaximum(n2);
            this.VSB.setVisibleAmount(n4);
            this.VSB.setBlockIncrement(n4);
            this.VSB.setUnitIncrement(this.lineheight);
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        try {
            this.offscreen = this.createImage(n3, n4 + this.titleheight);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("NOT ENOUGH MEMORY!");
        }
        this.repaint();
    }

    public void setText(String[][] stringArray) {
        this.text = stringArray;
        if (stringArray == null) {
            this.text = new String[1][2];
            this.text[0][0] = "";
            this.text[0][1] = "THIS LOG FILE IS EMPTY";
        }
        this.setBounds();
    }

    public void update(Graphics graphics) {
        int n = this.getSize().width - 20;
        int n2 = this.getSize().height;
        if (this.offscreen != null) {
            Graphics graphics2 = this.offscreen.getGraphics();
            graphics2.clearRect(0, 0, n, n2);
        }
        this.paint(graphics);
    }
}

