/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.count.TableSorter;
import projections.misc.MultiRunTableModel;

public class MultiRunTables
extends JTabbedPane {
    private MultiRunDataAnalyzer analysisModule;

    public MultiRunTables(int n, MultiRunDataAnalyzer multiRunDataAnalyzer) {
        this.analysisModule = multiRunDataAnalyzer;
        String[] stringArray = multiRunDataAnalyzer.getCategoryNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.makeTable(stringArray[i], null, Color.black, n, i);
        }
    }

    public void setType(int n) {
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            JTable jTable = (JTable)((JScrollPane)this.getComponentAt(i)).getViewport().getView();
            MultiRunTableModel multiRunTableModel = (MultiRunTableModel)((TableSorter)jTable.getModel()).getModel();
            multiRunTableModel.setType(n);
            jTable.repaint();
        }
    }

    public void makeTable(String string, String string2, Color color, int n, int n2) {
        MultiRunTableModel multiRunTableModel = new MultiRunTableModel(string, this.analysisModule, n, n2);
        TableSorter tableSorter = new TableSorter(multiRunTableModel);
        JTable jTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(jTable);
        this.initColumnSizes(jTable);
        jTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.addTab(string, null, jScrollPane, string2);
        this.setForegroundAt(this.indexOfComponent(jScrollPane), color);
    }

    private void initColumnSizes(JTable jTable) {
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(tableCellRenderer);
            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            int n = component.getPreferredSize().width;
            tableColumn.setPreferredWidth(n);
        }
    }
}

