/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MyButton
extends Component
implements MouseListener {
    private String text;
    private FontMetrics fm;
    private boolean highlighted = false;
    private boolean pressed = false;
    private boolean enabled = true;
    private ActionListener actionListener = null;
    private Color border;

    public MyButton(String string, Color color) {
        this.text = string;
        this.border = color;
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public Dimension getMinimumSize() {
        Graphics graphics;
        int n = 20;
        int n2 = 20;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics();
        }
        if (this.fm != null) {
            n = this.fm.stringWidth(this.text) + 20;
            n2 = this.fm.getHeight() + 10;
        }
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.enabled) {
            this.processActionEvent();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.enabled && !this.highlighted) {
            this.highlighted = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.enabled && (this.highlighted || this.pressed)) {
            this.highlighted = false;
            this.pressed = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.enabled) {
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled) {
            this.pressed = false;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
        }
        graphics.setColor(this.border);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        if (!this.enabled) {
            graphics.setColor(Color.gray);
        } else if (this.pressed) {
            graphics.setColor(Color.red);
        } else if (this.highlighted) {
            graphics.setColor(Color.yellow);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawString(this.text, 5, (n2 + this.fm.getHeight()) / 2 - 3);
        super.paint(graphics);
    }

    public void processActionEvent() {
        if (this.enabled && this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "MyButton Action");
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

