/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.Analysis;
import projections.gui.ProfileData;
import projections.gui.Util;

public class ProfileLabelCanvas
extends Canvas {
    private ProfileData data;
    private Image offscreen;
    private int maxwidth;
    private FontMetrics fm;
    private int labelincrement;

    public ProfileLabelCanvas(ProfileData profileData) {
        this.data = profileData;
        this.offscreen = null;
        this.maxwidth = 0;
        this.setForeground(Analysis.foreground);
        this.setBackground(Analysis.background);
    }

    private void drawLabels(Graphics graphics) {
        graphics.setColor(this.getForeground());
        int n = this.getSize().height;
        float f = (float)(this.data.dcw - 2 * this.data.offset) / (float)this.data.numPs;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.maxwidth = this.fm.stringWidth("" + Analysis.getNumProcessors()) + 20;
        }
        this.labelincrement = (int)Math.ceil((double)this.maxwidth / (double)f);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        int n2 = this.fm.getHeight();
        int n3 = n - n2 - 2;
        int n4 = n3 / 2;
        this.data.plist.reset();
        String string = "Avg";
        int n5 = (int)(0.5 * (double)f) + this.data.offset;
        graphics.drawLine(n5, 0, n5, n3);
        graphics.drawString(string, n5 -= (int)(0.5 * (double)this.fm.stringWidth(string)), n);
        for (int i = 1; i < this.data.numPs; ++i) {
            String string2 = "" + this.data.plist.nextElement();
            int n6 = (int)(((double)i + 0.5) * (double)f) + this.data.offset;
            if (i % this.labelincrement == 0) {
                graphics.drawLine(n6, 0, n6, n3);
                graphics.drawString(string2, n6 -= (int)(0.5 * (double)this.fm.stringWidth(string2)), n);
                continue;
            }
            graphics.drawLine(n6, 0, n6, n4);
        }
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.plist == null) {
            return;
        }
        int n = this.getSize().height;
        if (this.data.dcw > 0 && n > 0) {
            this.offscreen = this.createImage(this.data.dcw, n);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, this.data.dcw, n);
            this.drawLabels(graphics);
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.profileWindow.getHSBValue();
            int n2 = this.getSize().height;
            graphics.drawImage(this.offscreen, 0, 0, this.data.vpw, n2, n, 0, this.data.vpw + n, n2, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

