/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;

public class ProjectionsFileMgr {
    private File[] stsFiles_ = null;
    private File[][] logFiles_ = null;
    String base_ = null;
    String extention_ = null;

    public ProjectionsFileMgr(String[] stringArray) throws IOException {
        this.stsFiles_ = new File[stringArray.length];
        this.logFiles_ = new File[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            this.stsFiles_[i] = new File(stringArray[i]);
            this.logFiles_[i] = this.findFiles(stringArray[i]);
        }
    }

    public ProjectionsFileMgr(Vector vector) throws IOException {
        this.stsFiles_ = new File[vector.size()];
        this.logFiles_ = new File[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            this.stsFiles_[i] = (File)vector.elementAt(i);
            this.logFiles_[i] = this.findFiles(this.stsFiles_[i].getCanonicalPath());
        }
    }

    public void printSts() throws IOException {
        for (int i = 0; i < this.stsFiles_.length; ++i) {
            for (int j = 0; j < this.logFiles_[i].length; ++j) {
                if (this.logFiles_[i] == null) continue;
            }
        }
    }

    public File getStsFile(int n) {
        if (this.stsFiles_ != null) {
            return this.stsFiles_[n];
        }
        return null;
    }

    public int getNumFiles() {
        if (this.stsFiles_ != null) {
            return this.stsFiles_.length;
        }
        return 0;
    }

    public File[] getLogFiles(int n) {
        if (this.logFiles_ != null) {
            return this.logFiles_[n];
        }
        return null;
    }

    private File[] findFiles(String string) throws IOException {
        int n;
        File file = new File(string);
        File file2 = new File(file.getParent());
        if (!file2.isDirectory()) {
            return null;
        }
        String string2 = file.getName();
        int n2 = string2.lastIndexOf(".", (n = string2.lastIndexOf(".")) - 1);
        if (n2 != -1) {
            this.base_ = string2.substring(0, n2);
            this.extention_ = string.endsWith(".sts") ? string2.substring(n2 + 1, n) : string2.substring(n + 1, string2.length());
        } else {
            this.base_ = string2.substring(0, n - 1);
            this.extention_ = ".log";
        }
        String[] stringArray = file2.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(ProjectionsFileMgr.this.base_) && string.endsWith(ProjectionsFileMgr.this.extention_) && string.indexOf(".sts") == -1;
            }
        });
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(file2, stringArray[i]);
        }
        return fileArray;
    }
}

