/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

public class ProjectionsStatistics {
    protected long count;
    protected double sum;
    protected double sumOfSquares;
    protected double max;
    protected double min;

    public void accumulate(double d) {
        this.addData(d);
    }

    public void accumulate(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addData(dArray[i]);
        }
    }

    public void reset() {
        this.count = 0L;
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
    }

    private void addData(double d) {
        ++this.count;
        this.sum += d;
        this.sumOfSquares += d * d;
        if (d > this.max) {
            this.max = d;
        }
        if (d < this.min) {
            this.min = d;
        }
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getVariance() {
        double d = this.getMean();
        return (this.sumOfSquares - 2.0 * d * this.sum + d * d * (double)this.count) / (double)(this.count - 1L);
    }

    public double getVariance(double d) {
        return (this.sumOfSquares - 2.0 * d * this.sum + d * d * (double)this.count) / (double)(this.count - 1L);
    }

    public double getStdDeviation() {
        double d = this.getVariance();
        return Math.sqrt(d);
    }

    public double getStdDeviation(double d) {
        return Math.sqrt(d);
    }
}

