/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.Clickable;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class CommWindow
extends GenericGraphWindow
implements ItemListener,
ActionListener,
Clickable {
    private static final long serialVersionUID = 1L;
    static int myRun = 0;
    double[][] sentMsgCount;
    double[][] sentByteCount;
    double[][] receivedMsgCount;
    double[][] receivedByteCount;
    double[][] exclusiveRecv;
    double[][] exclusiveBytesRecv;
    int[][] hopCount;
    private double[][] avgHopCount;
    private double[][] avgPeHopCount;
    private ArrayList histogram;
    private int[] histArray;
    private String currentArrayName;
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel blueGenePanel;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox recvExclusive;
    private Checkbox recvExclusiveBytes;
    private Checkbox hopCountCB;
    private Checkbox peHopCountCB;
    CommWindow thisWindow;
    OrderedIntList peList;

    protected void windowInit() {
        super.windowInit();
    }

    public CommWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Communication - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow, myWindowID);
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    public void repaint() {
        super.refreshGraph();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent ae) {
        if (ae.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox cb = (Checkbox)ae.getSource();
            if (cb == this.sentMsgs) {
                this.setDataSource("Total #Msgs Sent", this.sentMsgCount, (GenericGraphWindow)this);
                this.setPopupText("sentMsgCount");
                this.setYAxis("Messages Sent", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.sentBytes) {
                this.setDataSource("Total Bytes Sent", this.sentByteCount, (GenericGraphWindow)this);
                this.setPopupText("sentByteCount");
                this.setYAxis("Bytes Sent", "bytes");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.receivedMsgs) {
                this.setDataSource("Total #Msgs Received", this.receivedMsgCount, (GenericGraphWindow)this);
                this.setPopupText("receivedMsgCount");
                this.setYAxis("Messages Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.receivedBytes) {
                this.setDataSource("Total Bytes Received", this.receivedByteCount, (GenericGraphWindow)this);
                this.setPopupText("receivedByteCount");
                this.setYAxis("Bytes Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.recvExclusive) {
                this.setDataSource("#Msgs Received Externally", this.exclusiveRecv, (GenericGraphWindow)this);
                this.setPopupText("exclusiveRecv");
                this.setYAxis("Messages Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.recvExclusiveBytes) {
                this.setDataSource("Bytes Received Externally", this.exclusiveBytesRecv, (GenericGraphWindow)this);
                this.setPopupText("exclusiveBytesRecv");
                this.setYAxis("Bytes Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.hopCountCB) {
                if (this.avgHopCount == null) {
                    this.avgHopCount = this.averageHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Entry Point", this.avgHopCount, (GenericGraphWindow)this);
                this.setPopupText("avgHopCount");
                this.setYAxis("Average Message Hop Counts", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.peHopCountCB) {
                if (this.avgPeHopCount == null) {
                    this.avgPeHopCount = this.averagePEHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Processor", this.avgPeHopCount, (GenericGraphWindow)this);
                this.setPopupText("avgPeHopCount");
                this.setYAxis("Average Message Hop Counts (by PE)", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            }
            this.setCursor(new Cursor(0));
        }
    }

    void setPopupText(String input) {
        this.currentArrayName = input;
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0 || this.currentArrayName == null) {
            return null;
        }
        Analysis a = MainWindow.runObject[myRun];
        String[] rString = new String[4];
        rString[0] = "Processor " + xVal;
        if (this.currentArrayName.equals("sentMsgCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.sentMsgCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Bytes = " + this.sentByteCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.receivedMsgCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.receivedByteCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("exclusiveRecv")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.exclusiveRecv[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("exclusiveBytesRecv")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Bytes = " + this.exclusiveBytesRecv[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("avgHopCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.avgHopCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("avgPeHopCount")) {
            rString[1] = "Count = " + this.avgPeHopCount[xVal][yVal];
            rString[2] = "Processor = " + this.xAxis.getIndexName(xVal);
            rString[3] = "";
        }
        return rString;
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (this.parentWindow.childWindows[1][0] != null) {
            final int myX = xVal;
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ((TimelineWindow)CommWindow.this.parentWindow.childWindows[1][0]).addProcessor(myX);
                    return null;
                }

                public void finished() {
                }
            };
            worker.start();
        } else {
            System.err.println("You wanted to load processor " + xVal + "'s data onto Timeline. However," + "the ability to open a new " + "timeline window from Communication Window " + "is not supported yet!");
        }
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.graphPanel = this.getMainPanel();
        this.checkBoxPanel = new JPanel();
        if (MainWindow.BLUEGENE) {
            this.blueGenePanel = new JPanel();
        }
        CheckboxGroup cbg = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent To", cbg, true);
        this.sentBytes = new Checkbox("Bytes Sent To", cbg, false);
        this.receivedMsgs = new Checkbox("Msgs Recv By", cbg, false);
        this.receivedBytes = new Checkbox("Bytes Recv By", cbg, false);
        this.recvExclusive = new Checkbox("External Msgs Recv By", cbg, false);
        this.recvExclusiveBytes = new Checkbox("External Bytes Recv By", cbg, false);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB = new Checkbox("Avg Hop Count (EP)", cbg, false);
            this.peHopCountCB = new Checkbox("Avg Hop Count (procs)", cbg, false);
        }
        this.sentMsgs.addItemListener(this);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes.addItemListener(this);
        this.recvExclusive.addItemListener(this);
        this.recvExclusiveBytes.addItemListener(this);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB.addItemListener(this);
            this.peHopCountCB.addItemListener(this);
        }
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusive, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusiveBytes, gbc, 5, 0, 1, 1, 1, 1);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.blueGenePanel, this.hopCountCB, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.blueGenePanel, this.peHopCountCB, gbc, 1, 0, 1, 1, 1, 1);
        }
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gbc, 0, 2, 1, 1, 0, 0);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.mainPanel, this.blueGenePanel, gbc, 0, 3, 1, 1, 0, 0);
        }
    }

    public void setGraphSpecificData() {
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    CommWindow.this.sentMsgCount = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.sentByteCount = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.receivedMsgCount = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.receivedByteCount = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.exclusiveRecv = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.exclusiveBytesRecv = new double[CommWindow.this.validPEs.size()][];
                    CommWindow.this.hopCount = MainWindow.BLUEGENE ? (Object)new int[CommWindow.this.validPEs.size()][] : (int[][])null;
                    CommWindow.this.getData();
                    return null;
                }

                public void finished() {
                    CommWindow.this.setDataSource("Communications", CommWindow.this.sentMsgCount, (GenericGraphWindow)CommWindow.this.thisWindow);
                    CommWindow.this.setPopupText("sentMsgCount");
                    CommWindow.this.setYAxis("Messages Sent", "");
                    CommWindow.this.setXAxis("Processor", CommWindow.this.peList);
                    CommWindow.this.thisWindow.setVisible(true);
                    CommWindow.this.thisWindow.repaint();
                }
            };
            worker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        super.getDialogData();
    }

    public void setDialogData() {
        super.setDialogData();
    }

    public void getData() {
        int k;
        int min;
        int max;
        LogEntryData logdata = new LogEntryData();
        this.peList = this.validPEs.copyOf();
        int numPe = this.peList.size();
        int numEPs = MainWindow.runObject[myRun].getNumUserEntries();
        this.histogram = new ArrayList();
        int curPeArrayIndex = 0;
        ProgressMonitor progressBar = new ProgressMonitor(this, "Reading log files", "", 0, numPe);
        while (this.peList.hasMoreElements()) {
            int pe = this.peList.nextElement();
            if (progressBar.isCanceled()) {
                progressBar.close();
                return;
            }
            progressBar.setNote("[PE: " + pe + " ] Reading data.");
            progressBar.setProgress(curPeArrayIndex + 1);
            this.validate();
            GenericLogReader glr = new GenericLogReader(MainWindow.runObject[myRun].getLogName(pe), MainWindow.runObject[myRun].getVersion());
            try {
                this.sentMsgCount[curPeArrayIndex] = new double[numEPs];
                this.sentByteCount[curPeArrayIndex] = new double[numEPs];
                this.receivedMsgCount[curPeArrayIndex] = new double[numEPs];
                this.receivedByteCount[curPeArrayIndex] = new double[numEPs];
                this.exclusiveRecv[curPeArrayIndex] = new double[numEPs];
                this.exclusiveBytesRecv[curPeArrayIndex] = new double[numEPs];
                if (MainWindow.BLUEGENE) {
                    this.hopCount[curPeArrayIndex] = new int[numEPs];
                }
                glr.nextEventOnOrAfter(this.startTime, logdata);
                while (logdata.time <= this.endTime || logdata.type != 1 && logdata.type != 2) {
                    int EPid;
                    glr.nextEvent(logdata);
                    if (logdata.type == 1) {
                        EPid = MainWindow.runObject[myRun].getEntryIndex(logdata.entry);
                        double[] dArray = this.sentMsgCount[curPeArrayIndex];
                        int n = EPid;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray2 = this.sentByteCount[curPeArrayIndex];
                        int n2 = EPid;
                        dArray2[n2] = dArray2[n2] + (double)logdata.msglen;
                        this.histogram.add(new Integer(logdata.msglen));
                        continue;
                    }
                    if (logdata.type == 20 || logdata.type == 21) {
                        EPid = MainWindow.runObject[myRun].getEntryIndex(logdata.entry);
                        double[] dArray = this.sentMsgCount[curPeArrayIndex];
                        int n = EPid;
                        dArray[n] = dArray[n] + (double)logdata.numPEs;
                        double[] dArray3 = this.sentByteCount[curPeArrayIndex];
                        int n3 = EPid;
                        dArray3[n3] = dArray3[n3] + (double)(logdata.msglen * logdata.numPEs);
                        continue;
                    }
                    if (logdata.type != 2) continue;
                    EPid = MainWindow.runObject[myRun].getEntryIndex(logdata.entry);
                    double[] dArray = this.receivedMsgCount[curPeArrayIndex];
                    int n = EPid;
                    dArray[n] = dArray[n] + 1.0;
                    double[] dArray4 = this.receivedByteCount[curPeArrayIndex];
                    int n4 = EPid;
                    dArray4[n4] = dArray4[n4] + (double)logdata.msglen;
                    if (logdata.pe == pe) continue;
                    double[] dArray5 = this.exclusiveRecv[curPeArrayIndex];
                    int n5 = EPid;
                    dArray5[n5] = dArray5[n5] + 1.0;
                    double[] dArray6 = this.exclusiveBytesRecv[curPeArrayIndex];
                    int n6 = EPid;
                    dArray6[n6] = dArray6[n6] + (double)logdata.msglen;
                    if (!MainWindow.BLUEGENE) continue;
                    int[] nArray = this.hopCount[curPeArrayIndex];
                    int n7 = EPid;
                    nArray[n7] = nArray[n7] + this.manhattenDistance(pe, logdata.pe);
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                System.out.println("Exception: " + e);
                e.printStackTrace();
            }
            ++curPeArrayIndex;
        }
        progressBar.close();
        if (this.histogram.size() > 0) {
            max = (Integer)this.histogram.get(0);
            min = (Integer)this.histogram.get(0);
        } else {
            min = 0;
            max = 0;
        }
        for (k = 1; k < this.histogram.size(); ++k) {
            if ((Integer)this.histogram.get(k) < min) {
                min = (Integer)this.histogram.get(k);
            }
            if ((Integer)this.histogram.get(k) <= max) continue;
            max = (Integer)this.histogram.get(k);
        }
        this.histArray = new int[max + 1];
        for (k = 0; k < Array.getLength(this.histArray); ++k) {
            this.histArray[k] = 0;
        }
        for (int k2 = 0; k2 < this.histogram.size(); ++k2) {
            int index;
            int n = index = ((Integer)this.histogram.get(k2)).intValue();
            this.histArray[n] = this.histArray[n] + 1;
        }
    }

    private int manhattenDistance(int destPe, int srcPe) {
        int distance = 0;
        int dimDistance = 0;
        int[] destTriple = this.peToTriple(destPe);
        int[] srcTriple = this.peToTriple(srcPe);
        for (int dim = 0; dim < 3; ++dim) {
            dimDistance = destTriple[dim] < srcTriple[dim] ? srcTriple[dim] - destTriple[dim] : destTriple[dim] - srcTriple[dim];
            if ((double)dimDistance > (double)MainWindow.BLUEGENE_SIZE[dim] / 2.0) {
                dimDistance = MainWindow.BLUEGENE_SIZE[dim] - dimDistance;
            }
            distance += dimDistance;
        }
        if (distance < 0) {
            System.err.println("Internal Error: Negative Manhatten distance " + distance + " Destination PE [" + destPe + "], Source PE [" + srcPe + "]");
            System.err.println("[" + destTriple[0] + "][" + destTriple[1] + "][" + destTriple[2] + "] by [" + srcTriple[0] + "][" + srcTriple[1] + "][" + srcTriple[2] + "] on a [" + MainWindow.BLUEGENE_SIZE[0] + "][" + MainWindow.BLUEGENE_SIZE[1] + "][" + MainWindow.BLUEGENE_SIZE[2] + "] BG Torus");
            System.exit(-1);
        }
        return distance;
    }

    private int[] peToTriple(int pe) {
        int[] returnTriple = new int[3];
        returnTriple[2] = pe / (MainWindow.BLUEGENE_SIZE[1] * MainWindow.BLUEGENE_SIZE[0]);
        returnTriple[1] = pe / MainWindow.BLUEGENE_SIZE[0] - returnTriple[2] * MainWindow.BLUEGENE_SIZE[1];
        returnTriple[0] = pe % MainWindow.BLUEGENE_SIZE[0];
        if (returnTriple[0] < 0 || returnTriple[1] < 0 || returnTriple[2] < 0) {
            System.err.println("Internal Error: Triple [" + returnTriple[0] + "][" + returnTriple[1] + "][" + returnTriple[2] + "]");
            System.exit(-1);
        }
        return returnTriple;
    }

    private double[][] averageHops(int[][] hopArray, double[][] msgReceived) {
        double[][] returnValue = new double[hopArray.length][hopArray[0].length];
        for (int i = 0; i < hopArray.length; ++i) {
            for (int j = 0; j < hopArray[i].length; ++j) {
                returnValue[i][j] = msgReceived[i][j] > 0.0 ? (double)hopArray[i][j] / msgReceived[i][j] : 0.0;
            }
        }
        return returnValue;
    }

    private double[][] averagePEHops(int[][] hopArray, double[][] msgReceived) {
        double[][] returnValue = new double[hopArray.length][1];
        double[] totalRecv = new double[hopArray.length];
        for (int pe = 0; pe < hopArray.length; ++pe) {
            for (int ep = 0; ep < hopArray[pe].length; ++ep) {
                int n = pe;
                totalRecv[n] = totalRecv[n] + msgReceived[pe][ep];
                double[] dArray = returnValue[pe];
                dArray[0] = dArray[0] + (double)hopArray[pe][ep];
            }
            if (!(totalRecv[pe] > 0.0)) continue;
            double[] dArray = returnValue[pe];
            dArray[0] = dArray[0] / totalRecv[pe];
        }
        return returnValue;
    }

    public static int[] peToTripleA(int pe) {
        int[] returnTriple = new int[3];
        int[] BG = new int[]{8, 8, 16};
        System.out.println("BG triplet = " + BG[0] + " " + BG[1] + " " + BG[2]);
        returnTriple[2] = pe / (BG[0] * BG[1]);
        returnTriple[1] = pe / BG[0] - returnTriple[2] * BG[0];
        returnTriple[0] = pe % BG[0];
        return returnTriple;
    }

    public static int manhattenDistanceA(int srcPe, int destPe) {
        int distance = 0;
        int dimDistance = 0;
        int[] BG = new int[]{8, 8, 16};
        int[] destTriple = CommWindow.peToTripleA(destPe);
        int[] srcTriple = CommWindow.peToTripleA(srcPe);
        System.out.println("Source triple = " + srcTriple[0] + " " + srcTriple[1] + " " + srcTriple[2]);
        System.out.println("Dest triple = " + destTriple[0] + " " + destTriple[1] + " " + destTriple[2]);
        for (int dim = 0; dim < 3; ++dim) {
            dimDistance = destTriple[dim] < srcTriple[dim] ? srcTriple[dim] - destTriple[dim] : destTriple[dim] - srcTriple[dim];
            if ((double)dimDistance > (double)BG[dim] / 2.0) {
                dimDistance = BG[dim] - dimDistance;
            }
            distance += dimDistance;
        }
        return distance;
    }

    public static void main(String[] args) {
        int distance = CommWindow.manhattenDistanceA(1018, 1023);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 1020);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 972);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 996);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(442, 663);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 324);
        System.out.println(distance);
    }
}

