/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import projections.gui.GraphData;
import projections.gui.MainWindow;
import projections.gui.Util;

public class GraphXAxisCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private GraphData data;
    private FontMetrics fm;
    private int maxvalue;
    private int tickincrement;
    private int numintervals;
    private int labelincrement;
    private double pixelincrement;
    private Image offscreen;

    public GraphXAxisCanvas() {
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
    }

    private void drawAxis(Graphics g) {
        if (this.data == null) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(MainWindow.runObject[this.myRun].background);
        g.fillRect(0, 0, w, h);
        int hsbval = this.data.displayPanel.getHSBValue();
        g.translate(-hsbval, 0);
        int mini = (int)Math.floor((double)(hsbval - this.data.offset3) / this.pixelincrement);
        int maxi = (int)Math.ceil((double)(hsbval - this.data.offset3 + w) / this.pixelincrement);
        this.data.minx = mini * this.tickincrement;
        this.data.maxx = maxi * this.tickincrement;
        if (this.data.minx < 0) {
            this.data.minx = 0;
        }
        if (this.data.maxx > this.maxvalue) {
            this.data.maxx = this.maxvalue;
        }
        if (mini < 0) {
            mini = 0;
        }
        if (maxi > this.numintervals) {
            maxi = this.numintervals;
        }
        int linemin = this.data.offset3 + (int)((double)mini * this.pixelincrement);
        int linemax = this.data.offset3 + (int)((double)maxi * this.pixelincrement);
        if (this.data.graphtype == 21) {
            linemax += (int)this.pixelincrement;
        }
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.drawLine(linemin, 5, linemax, 5);
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        String label = this.data.xmode == 0 ? "Processor" : "Time (in s)";
        int x = hsbval + (w - this.fm.stringWidth(label)) / 2;
        int y = h - 5;
        g.drawString(label, x, y);
        for (int i = mini; i <= maxi; ++i) {
            int curx = this.data.offset3 + (int)((double)i * this.pixelincrement);
            if (this.data.graphtype == 21) {
                curx += (int)(this.pixelincrement / 2.0);
            }
            if (i % this.labelincrement == 0) {
                String s;
                g.drawLine(curx, 0, curx, 10);
                if (this.data.xmode == 0) {
                    this.data.origProcList.reset();
                    int pe = this.data.origProcList.nextElement();
                    for (int j = 0; j < i * this.tickincrement; ++j) {
                        pe = this.data.origProcList.nextElement();
                    }
                    s = "" + pe;
                } else {
                    double tickVal = (double)(i * this.tickincrement + this.data.intervalStart) * (double)this.data.interval.size / 1000000.0;
                    s = "" + tickVal;
                }
                g.drawString(s, curx - this.fm.stringWidth(s) / 2, 15 + this.fm.getHeight());
                continue;
            }
            g.drawLine(curx, 3, curx, 7);
        }
    }

    public int getPreferredHeight() {
        Graphics g;
        int h = 0;
        if (this.fm == null && (g = this.getGraphics()) != null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        if (this.fm != null) {
            h = this.fm.getHeight() * 2 + 20;
        }
        return h;
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            return;
        }
        Graphics og = this.offscreen.getGraphics();
        this.drawAxis(og);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.drawImage(this.offscreen, 0, 0, w, h, 0, 0, w, h, null);
    }

    public void print(Graphics pg) {
        ((Graphics2D)pg).setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawAxis(pg);
        ((Graphics2D)pg).setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.fm == null) {
            Graphics g = this.getGraphics();
            this.fm = g.getFontMetrics(g.getFont());
            g.dispose();
        }
        this.maxvalue = this.data.xmode == 0 ? this.data.processor.num - 1 : this.data.interval.num - 1;
        int sw = this.fm.stringWidth("" + this.maxvalue);
        this.data.offset3 = sw / 2;
        if (this.data.graphtype == 21) {
            ++this.maxvalue;
        }
        int width = (int)((float)w * this.data.scale) - 2 * this.data.offset3;
        this.tickincrement = (int)Math.ceil(5.0 / ((double)width / (double)this.maxvalue));
        this.tickincrement = Util.getBestIncrement(this.tickincrement);
        this.numintervals = (int)Math.ceil((double)this.maxvalue / (double)this.tickincrement);
        this.pixelincrement = (double)width / (double)this.numintervals;
        this.labelincrement = (int)Math.ceil((double)(sw + 20) / this.pixelincrement);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        this.data.xscale = this.pixelincrement / (double)this.tickincrement;
        if (this.data.graphtype == 21) {
            --this.numintervals;
            --this.maxvalue;
        }
        if (this.getSize().width != w || this.getSize().height != h) {
            try {
                this.offscreen = this.createImage(w, h);
            }
            catch (OutOfMemoryError e) {
                System.out.println("NOT ENOUGH MEMORY!");
            }
        }
        super.setBounds(x, y, w, h);
    }

    public void setData(GraphData data) {
        this.data = data;
        this.maxvalue = 0;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

