/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.analysis.GenericLogReader;
import projections.gui.BinDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class HistogramWindow
extends GenericGraphWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private static final int NUM_TYPES = 2;
    private static final int TYPE_TIME = 0;
    private static final int TYPE_MSG_SIZE = 1;
    JButton entrySelectionButton;
    JButton epTableButton;
    JRadioButton timeBinButton;
    JRadioButton msgSizeBinButton;
    ButtonGroup binTypeGroup;
    double[][][] counts;
    int binType = 0;
    public int timeNumBins;
    public long timeBinSize;
    public long timeMinBinSize;
    public int msgNumBins;
    public long msgBinSize;
    public long msgMinBinSize;
    HistogramWindow thisWindow = this;
    boolean newDialog;
    private DecimalFormat _format = new DecimalFormat();

    protected void windowInit() {
        this.timeNumBins = 100;
        this.timeBinSize = 1000L;
        this.timeMinBinSize = 0L;
        this.msgNumBins = 200;
        this.msgBinSize = 100L;
        this.msgMinBinSize = 0L;
        super.windowInit();
    }

    public HistogramWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Histograms", mainWindow, myWindowID);
        this.setTitle("Projections Histograms - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
    }

    public void close() {
        super.close();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new BinDialog(this, "Select Histogram Time Range");
            this.newDialog = true;
        } else {
            this.setDialogData();
            this.newDialog = false;
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (HistogramWindow.this.dialog.isModified()) {
                        HistogramWindow.this.counts = HistogramWindow.this.thisWindow.getCounts();
                    } else if (HistogramWindow.this.newDialog) {
                        HistogramWindow.this.counts = HistogramWindow.this.thisWindow.getCounts();
                    }
                    return null;
                }

                public void finished() {
                    HistogramWindow.this.setGraphSpecificData();
                    HistogramWindow.this.refreshGraph();
                    HistogramWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        BinDialog dialog = (BinDialog)this.dialog;
        this.timeNumBins = dialog.getTimeNumBins();
        this.timeBinSize = dialog.getTimeBinSize();
        this.timeMinBinSize = dialog.getTimeMinBinSize();
        this.msgNumBins = dialog.getMsgNumBins();
        this.msgBinSize = dialog.getMsgBinSize();
        this.msgMinBinSize = dialog.getMsgMinBinSize();
        super.getDialogData();
    }

    public void setDialogData() {
        BinDialog dialog = (BinDialog)this.dialog;
        dialog.setTimeBinSize(this.timeBinSize);
        dialog.setTimeNumBins(this.timeNumBins);
        dialog.setTimeMinBinSize(this.timeMinBinSize);
        dialog.setMsgBinSize(this.msgBinSize);
        dialog.setMsgNumBins(this.msgNumBins);
        dialog.setMsgMinBinSize(this.msgMinBinSize);
        super.setDialogData();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)evt.getSource();
            if (m.getText().equals("Set Range")) {
                this.showDialog();
            } else if (m.getText().equals("Close")) {
                this.close();
            }
        } else if (evt.getSource() instanceof JRadioButton) {
            JRadioButton b = (JRadioButton)evt.getSource();
            if (b.getActionCommand().equals("Execution Time")) {
                if (this.binType != 0) {
                    SwingWorker worker = new SwingWorker(){

                        public Object construct() {
                            HistogramWindow.this.binType = 0;
                            HistogramWindow.this.setGraphSpecificData();
                            HistogramWindow.this.refreshGraph();
                            return null;
                        }

                        public void finished() {
                        }
                    };
                    worker.start();
                }
            } else if (b.getActionCommand().equals("Message Size") && this.binType != 1) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        HistogramWindow.this.binType = 1;
                        HistogramWindow.this.setGraphSpecificData();
                        HistogramWindow.this.refreshGraph();
                        return null;
                    }

                    public void finished() {
                    }
                };
                worker.start();
            }
        } else if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b.getText().equals("Select Entries")) {
                System.out.println("selecting entries for display");
            } else if (b.getText().equals("Out-of-Range EPs")) {
                System.out.println("Showing out of range entries");
            }
        }
    }

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        mainPanel.setLayout(gbl);
        JPanel graphPanel = super.getMainPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Histogram Controls"));
        this.entrySelectionButton = new JButton("Select Entries");
        this.entrySelectionButton.addActionListener(this);
        this.epTableButton = new JButton("Out-of-Range EPs");
        this.epTableButton.addActionListener(this);
        this.timeBinButton = new JRadioButton("Execution Time", true);
        this.timeBinButton.addActionListener(this);
        this.msgSizeBinButton = new JRadioButton("Message Size");
        this.msgSizeBinButton.addActionListener(this);
        this.binTypeGroup = new ButtonGroup();
        this.binTypeGroup.add(this.timeBinButton);
        this.binTypeGroup.add(this.msgSizeBinButton);
        buttonPanel.add(this.timeBinButton);
        buttonPanel.add(this.msgSizeBinButton);
        buttonPanel.add(this.entrySelectionButton);
        buttonPanel.add(this.epTableButton);
        Util.gblAdd(mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(mainPanel, buttonPanel, gbc, 0, 1, 1, 1, 0, 0);
        return mainPanel;
    }

    protected void setGraphSpecificData() {
        if (this.binType == 0) {
            this.setXAxis("Bin Interval Size (" + U.t(this.timeBinSize) + ")", "Time", this.timeMinBinSize, this.timeBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[0], (GenericGraphWindow)this.thisWindow);
        } else if (this.binType == 1) {
            this.setXAxis("Bin Interval Size (" + this._format.format(this.msgBinSize) + " bytes)", "", this.msgMinBinSize, this.msgBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[1], (GenericGraphWindow)this.thisWindow);
        }
    }

    protected void refreshGraph() {
        super.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (this.binType == 0) {
            return this.getTimePopup(xVal, yVal);
        }
        if (this.binType == 1) {
            return this.getMsgSizePopup(xVal, yVal);
        }
        return null;
    }

    private String[] getTimePopup(int xVal, int yVal) {
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts[0][xVal][yVal], xVal < this.timeNumBins ? "Bin: " + U.t((long)xVal * this.timeBinSize + this.timeMinBinSize) + " to " + U.t((long)(xVal + 1) * this.timeBinSize + this.timeMinBinSize) : "Bin: > " + U.t((long)this.timeNumBins * this.timeBinSize + this.timeMinBinSize)};
        return bubbleText;
    }

    private String[] getMsgSizePopup(int xVal, int yVal) {
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts[1][xVal][yVal], xVal < this.msgNumBins ? "Bin: " + this._format.format((long)xVal * this.msgBinSize + this.msgMinBinSize) + " bytes to " + this._format.format((long)(xVal + 1) * this.msgBinSize + this.msgMinBinSize) + " bytes" : "Bin: > " + this._format.format((long)this.msgNumBins * this.msgBinSize + this.msgMinBinSize) + " bytes"};
        return bubbleText;
    }

    double[][][] getCounts() {
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        OrderedIntList tmpPEs = this.validPEs.copyOf();
        double[][][] countData = new double[][][]{new double[this.timeNumBins + 1][numEPs], new double[this.msgNumBins + 1][numEPs]};
        LogEntryData logdata = new LogEntryData();
        LogEntryData[] typeLogs = new LogEntryData[2];
        for (int i = 0; i < 2; ++i) {
            typeLogs[i] = new LogEntryData();
        }
        boolean[] isActive = new boolean[2];
        ProgressMonitor progressBar = new ProgressMonitor(this, "Reading log files", "", 0, tmpPEs.size());
        int curPeCount = 0;
        while (tmpPEs.hasMoreElements()) {
            int pe = tmpPEs.nextElement();
            if (!progressBar.isCanceled()) {
                progressBar.setNote("[PE: " + pe + " ] Reading data.");
                progressBar.setProgress(curPeCount);
            } else {
                progressBar.close();
            }
            ++curPeCount;
            GenericLogReader r = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(pe), MainWindow.runObject[this.myRun].getVersion());
            try {
                r.nextEventOnOrAfter(this.startTime, logdata);
                boolean done = false;
                while (!done) {
                    switch (logdata.type) {
                        case 2: {
                            if (logdata.time > this.endTime) {
                                done = true;
                                break;
                            }
                            LogEntryData tmpLogPtr = logdata;
                            logdata = typeLogs[0];
                            typeLogs[0] = tmpLogPtr;
                            isActive[0] = true;
                            break;
                        }
                        case 3: {
                            int targetBin;
                            if (!isActive[0]) {
                                if (logdata.time <= this.endTime) break;
                                done = true;
                                break;
                            }
                            if (logdata.entry != typeLogs[0].entry) {
                                isActive[0] = false;
                                break;
                            }
                            long executionTime = logdata.time - typeLogs[0].time;
                            long adjustedTime = executionTime - this.timeMinBinSize;
                            if (adjustedTime >= 0L) {
                                targetBin = (int)(adjustedTime / this.timeBinSize);
                                if (targetBin >= this.timeNumBins) {
                                    targetBin = this.timeNumBins;
                                }
                                double[] dArray = countData[0][targetBin];
                                int n = logdata.entry;
                                dArray[n] = dArray[n] + 1.0;
                            }
                            isActive[0] = false;
                            break;
                        }
                        case 1: {
                            long adjustedSize;
                            if (logdata.time > this.endTime || (adjustedSize = (long)logdata.msglen - this.msgMinBinSize) < 0L) break;
                            int targetBin = (int)(adjustedSize / this.msgBinSize);
                            if (targetBin >= this.msgNumBins) {
                                targetBin = this.msgNumBins;
                            }
                            double[] dArray = countData[1][targetBin];
                            int n = logdata.entry;
                            dArray[n] = dArray[n] + 1.0;
                        }
                    }
                    if (done) continue;
                    r.nextEvent(logdata);
                }
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                System.out.println("Exception " + e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
        progressBar.close();
        return countData;
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Select Entry Points"}, null, this);
        this.menuBar.add(Util.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("Show Longest EPs", true)}, null, this));
        super.createMenus();
    }
}

