/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.gui.FloatJTextField;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Timeline.ColorChooser;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.ImageFilter;
import projections.gui.Timeline.SaveImage;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Timeline.UserEventWindow;
import projections.gui.Timeline.UserSuppliedAnalyzer;
import projections.gui.Util;

public class WindowControls
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private TimelineWindow parentWindow;
    private ColorChooser colorWindow;
    Data data;
    private JButton bDecrease;
    private JButton bIncrease;
    private JButton bReset;
    private JButton bZoomSelected;
    private JButton bLoadSelected;
    private JTextField highlightTime;
    private JTextField selectionBeginTime;
    private JTextField selectionEndTime;
    private JTextField selectionDiff;
    private DecimalFormat format;
    private FloatJTextField scaleField;
    private JCheckBox cbPacks;
    private JCheckBox cbMsgs;
    private JCheckBox cbIdle;
    private JCheckBox cbUser;
    private JCheckBox cbUserTable;
    private JCheckBoxMenuItem cbTraceMessages;
    private JCheckBoxMenuItem cbTraceArrayElementID;
    private JCheckBoxMenuItem cbCompactView;
    private UserEventWindow userEventWindow;

    public WindowControls(TimelineWindow parentWindow_, Data data_) {
        this.data = data_;
        this.parentWindow = parentWindow_;
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(true);
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
        this.CreateLayout();
        this.userEventWindow = new UserEventWindow(this.cbUserTable);
    }

    public void showDialog() {
        if (this.parentWindow.dialog == null) {
            this.parentWindow.dialog = new RangeDialog(this.parentWindow, "Select Timeline Range");
        } else {
            this.parentWindow.setDialogData();
        }
        this.parentWindow.dialog.displayDialog();
        if (!this.parentWindow.dialog.isCancelled()) {
            this.parentWindow.getDialogData();
            if (this.parentWindow.dialog.isModified()) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ((WindowControls)WindowControls.this).parentWindow.mainPanel.loadTimelineObjects(true, null);
                        WindowControls.this.cbUserTable.setText("View User Events (" + WindowControls.this.data.getNumUserEvents() + ")");
                        return null;
                    }

                    public void finished() {
                        WindowControls.this.parentWindow.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                        WindowControls.this.parentWindow.setVisible(true);
                    }
                };
                worker.start();
            } else {
                this.parentWindow.setVisible(true);
            }
        }
    }

    public void setHighlightTime(double time) {
        this.highlightTime.setText(this.format.format(time));
    }

    public void unsetHighlightTime() {
        this.highlightTime.setText("");
    }

    public void setSelectedTime(double time1, double time2) {
        this.selectionBeginTime.setText(this.format.format(time1));
        this.selectionEndTime.setText(this.format.format(time2));
        this.format.setMinimumFractionDigits(3);
        this.format.setMaximumFractionDigits(3);
        this.selectionDiff.setText(this.format.format((time2 - time1) / 1000.0) + " ms");
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
        this.bZoomSelected.setEnabled(true);
        this.bLoadSelected.setEnabled(true);
    }

    public void unsetSelectedTime() {
        this.selectionBeginTime.setText("");
        this.selectionEndTime.setText("");
        this.selectionDiff.setText("");
        this.bZoomSelected.setEnabled(false);
        this.bLoadSelected.setEnabled(false);
    }

    public void zoomSelected() {
        if (this.data.selectionValid()) {
            double selectionStartTime = this.data.leftSelectionTime();
            double selectionEndTime = this.data.rightSelectionTime();
            this.unsetSelectedTime();
            this.data.setPreferredViewTimeCenter((selectionStartTime + selectionEndTime) / 2.0);
            this.data.setScaleFactor((float)((double)(this.data.endTime() - this.data.beginTime()) / (selectionEndTime - selectionStartTime)));
        }
    }

    public void loadSelected() {
        if (this.data.selectionValid()) {
            double startTime = this.data.leftSelectionTime();
            double endTime = this.data.rightSelectionTime();
            this.data.invalidateSelection();
            this.unsetSelectedTime();
            if (startTime < (double)this.data.beginTime()) {
                startTime = this.data.beginTime();
            }
            if (endTime > (double)this.data.endTime()) {
                endTime = this.data.endTime();
            }
            this.data.setNewRange((long)(startTime + 0.5), (long)(endTime + 0.5));
            this.scaleField.setText("1.0");
            this.parentWindow.mainPanel.loadTimelineObjects(true, null);
            this.cbUserTable.setText("View User Events (" + this.data.getNumUserEvents() + ")");
        } else {
            System.out.println("ERROR: somehow you clicked the loadSelected button which shouldn't have been enabled!");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JComponent b;
        block45: {
            if (evt.getSource() instanceof JMenuItem) {
                String arg = ((JMenuItem)evt.getSource()).getText();
                if (arg.equals("Close")) {
                    this.parentWindow.close();
                } else if (arg.equals("Modify Ranges")) {
                    this.showDialog();
                } else if (arg.equals("Change Entry Point Colors")) {
                    this.ShowColorWindow();
                } else if (arg.equals("Save Entry Point Colors")) {
                    MainWindow.runObject[this.myRun].saveColors();
                } else if (arg.equals("Restore Entry Point Colors")) {
                    try {
                        Util.restoreColors(this.data.entryColor(), "Timeline Graph");
                        this.parentWindow.refreshDisplay(false);
                    }
                    catch (Exception e) {
                        System.err.println("Attempt to read from color.map failed");
                    }
                } else if (arg.equals("Default Entry Point Colors")) {
                    for (int i = 0; i < this.data.entryColor().length; ++i) {
                        this.data.entryColor()[i] = MainWindow.runObject[this.myRun].getEntryColor(i);
                    }
                    this.parentWindow.refreshDisplay(false);
                } else if (arg.equals("Save as JPG or PNG")) {
                    try {
                        SaveImage p = new SaveImage(this.parentWindow.scrollingPanel);
                        JFileChooser fc = new JFileChooser();
                        ImageFilter imageFilter = new ImageFilter();
                        fc.setFileFilter(imageFilter);
                        fc.setSelectedFile(new File("./TimelineScreenshot.png"));
                        int returnVal = fc.showSaveDialog(this.parentWindow);
                        if (returnVal != 0) break block45;
                        File file = fc.getSelectedFile();
                        if (imageFilter.isJPEG(file)) {
                            p.saveImageJPEG(file.getCanonicalPath());
                        }
                        if (imageFilter.isPNG(file)) {
                            p.saveImagePNG(file.getCanonicalPath());
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, "Error occurred while saving file:" + e.getLocalizedMessage());
                    }
                } else if (arg.equals("Color by Default")) {
                    this.data.setColorByDefault();
                } else if (arg.equals("Color by Event Index")) {
                    this.data.setColorByIndex();
                } else if (arg.equals("Color by User Supplied Parameter(timestep)")) {
                    this.data.setColorByUserSupplied();
                } else if (arg.equals("Color by Memory Usage")) {
                    this.data.setColorByMemoryUsage();
                } else if (arg.equals("Shift Timelines to fix inconsistent clocks")) {
                    this.data.fixTachyons();
                } else if (arg.equals("Determine Time Ranges for User Supplied Values")) {
                    UserSuppliedAnalyzer userSuppliedAnalyzer = new UserSuppliedAnalyzer(this.data);
                }
            } else if (evt.getSource() instanceof JButton) {
                b = (JButton)evt.getSource();
                if (b == this.bZoomSelected) {
                    this.zoomSelected();
                } else if (b == this.bLoadSelected) {
                    this.loadSelected();
                    this.parentWindow.refreshDisplay(true);
                } else if (b == this.bDecrease) {
                    this.data.keepViewCentered(true);
                    this.data.decreaseScaleFactor();
                    this.scaleField.setText("" + this.data.getScaleFactor());
                    this.parentWindow.refreshDisplay(true);
                } else if (b == this.bIncrease) {
                    this.data.keepViewCentered(true);
                    this.data.increaseScaleFactor();
                    this.scaleField.setText("" + this.data.getScaleFactor());
                    this.parentWindow.refreshDisplay(true);
                } else if (b == this.bReset) {
                    this.data.setScaleFactor(1.0f);
                    this.scaleField.setText("" + this.data.getScaleFactor());
                    this.parentWindow.refreshDisplay(true);
                }
            }
        }
        if (evt.getSource() instanceof FloatJTextField && (b = (FloatJTextField)evt.getSource()) == this.scaleField) {
            this.data.keepViewCentered(true);
            this.data.setScaleFactor(((FloatJTextField)b).getValue());
            this.parentWindow.refreshDisplay(true);
        }
    }

    public void CreateMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem i3 = new JMenuItem("Close");
        fileMenu.add(i3);
        i3.addActionListener(this);
        mbar.add(fileMenu);
        JMenu toolsMenu = new JMenu("Ranges");
        JMenuItem i4 = new JMenuItem("Modify Ranges");
        toolsMenu.add(i4);
        i4.addActionListener(this);
        mbar.add(toolsMenu);
        JMenu saveMenu = new JMenu("Screenshot");
        JMenuItem i9 = new JMenuItem("Save as JPG or PNG");
        saveMenu.add(i9);
        i9.addActionListener(this);
        mbar.add(saveMenu);
        JMenu colorMenu = new JMenu("Colors");
        JMenuItem i5 = new JMenuItem("Change Entry Point Colors");
        JMenuItem i6 = new JMenuItem("Save Entry Point Colors");
        JMenuItem i7 = new JMenuItem("Restore Entry Point Colors");
        JMenuItem i8 = new JMenuItem("Default Entry Point Colors");
        JMenuItem i10 = new JMenuItem("Color by Default");
        JMenuItem i11 = new JMenuItem("Color by Event Index");
        JMenuItem i12 = new JMenuItem("Color by User Supplied Parameter(timestep)");
        JMenuItem i13 = new JMenuItem("Color by Memory Usage");
        colorMenu.add(i5);
        colorMenu.add(i6);
        colorMenu.add(i7);
        colorMenu.add(i8);
        colorMenu.addSeparator();
        colorMenu.add(i10);
        colorMenu.add(i11);
        colorMenu.add(i12);
        colorMenu.add(i13);
        i5.addActionListener(this);
        i6.addActionListener(this);
        i7.addActionListener(this);
        i8.addActionListener(this);
        i10.addActionListener(this);
        i11.addActionListener(this);
        i12.addActionListener(this);
        i13.addActionListener(this);
        mbar.add(colorMenu);
        JMenu tracingMenu = new JMenu("Tracing");
        this.cbTraceMessages = new JCheckBoxMenuItem("Trace Messages");
        this.cbTraceArrayElementID = new JCheckBoxMenuItem("Trace Event ID(Chare Array Index)");
        tracingMenu.add(this.cbTraceMessages);
        tracingMenu.add(this.cbTraceArrayElementID);
        this.cbTraceMessages.addItemListener(this);
        this.cbTraceArrayElementID.addItemListener(this);
        mbar.add(tracingMenu);
        JMenu experimentalMenu = new JMenu("Experimental Features");
        JMenuItem i40 = new JMenuItem("Shift Timelines to fix inconsistent clocks");
        i40.addActionListener(this);
        experimentalMenu.add(i40);
        this.cbCompactView = new JCheckBoxMenuItem("Compact View");
        this.cbCompactView.addItemListener(this);
        experimentalMenu.add(this.cbCompactView);
        JMenuItem i50 = new JMenuItem("Determine Time Ranges for User Supplied Values");
        i50.addActionListener(this);
        experimentalMenu.add(i50);
        mbar.add(experimentalMenu);
        this.parentWindow.setJMenuBar(mbar);
    }

    public void userEventWindowSetData() {
        this.userEventWindow.setData(this.data);
    }

    private void CreateLayout() {
        this.cbPacks = new JCheckBox("Display Pack Times", this.data.showPacks());
        this.cbMsgs = new JCheckBox("Display Message Sends", this.data.showMsgs());
        this.cbIdle = new JCheckBox("Display Idle Time", this.data.showIdle());
        this.cbUser = new JCheckBox("Display User Events", true);
        this.cbUserTable = new JCheckBox("Display User Events Window", false);
        this.cbPacks.addItemListener(this);
        this.cbMsgs.addItemListener(this);
        this.cbIdle.addItemListener(this);
        this.cbUser.addItemListener(this);
        this.cbUserTable.addItemListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(gbl);
        Util.gblAdd(cbPanel, this.cbPacks, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbMsgs, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbIdle, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbUser, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbUserTable, gbc, 4, 0, 1, 1, 1, 1);
        URL zoomInURL = this.getClass().getResource("/projections/images/ZoomIn24.gif");
        URL zoomOutURL = this.getClass().getResource("/projections/images/ZoomOut24.gif");
        this.bDecrease = new JButton(new ImageIcon(zoomOutURL));
        this.bIncrease = new JButton(new ImageIcon(zoomInURL));
        this.bReset = new JButton("Reset Zoom");
        this.bDecrease.addActionListener(this);
        this.bIncrease.addActionListener(this);
        this.bReset.addActionListener(this);
        JLabel lScale = new JLabel("Zoom Ratio: ", 0);
        this.scaleField = new FloatJTextField(this.data.getScaleFactor(), 5);
        this.scaleField.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(buttonPanel, this.bDecrease, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, lScale, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.scaleField, gbc, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.bIncrease, gbc, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.bReset, gbc, 7, 0, 1, 1, 1, 1);
        this.bZoomSelected = new JButton("Zoom Selection");
        this.bLoadSelected = new JButton("Load Selection");
        this.bZoomSelected.setEnabled(false);
        this.bLoadSelected.setEnabled(false);
        this.bZoomSelected.addActionListener(this);
        this.bLoadSelected.addActionListener(this);
        this.highlightTime = new JTextField("");
        this.selectionBeginTime = new JTextField("");
        this.selectionEndTime = new JTextField("");
        this.selectionDiff = new JTextField("");
        this.highlightTime.setEditable(false);
        this.selectionBeginTime.setEditable(false);
        this.selectionEndTime.setEditable(false);
        this.selectionDiff.setEditable(false);
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(zoomPanel, new JLabel(" "), gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.bZoomSelected, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.bLoadSelected, gbc, 1, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.highlightTime, gbc, 2, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionBeginTime, gbc, 3, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionEndTime, gbc, 4, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionDiff, gbc, 5, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Time At Mouse Cursor", 0), gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection Begin Time", 0), gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection End Time", 0), gbc, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection Length", 0), gbc, 5, 1, 1, 1, 1, 1);
        this.setLayout(gbl);
        Util.gblAdd(this, cbPanel, gbc, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(this, buttonPanel, gbc, 0, 3, 1, 1, 1, 0);
        Util.gblAdd(this, zoomPanel, gbc, 0, 4, 1, 1, 1, 0);
    }

    public long getBeginTime() {
        return this.data.beginTime();
    }

    public long getEndTime() {
        return this.data.endTime();
    }

    public int[] getEntries() {
        return this.data.entries();
    }

    public Color[] getEntryColors() {
        if (this.data == null) {
            return null;
        }
        return this.data.entryColor();
    }

    public OrderedUsageList[] getEntryUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.entryUsageList;
    }

    public Color getGraphColor(int e) {
        return MainWindow.runObject[this.myRun].getEntryColor(e);
    }

    public float[] getIdleUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.idleUsage;
    }

    public float[] getPackUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.packUsage;
    }

    public OrderedIntList getProcessorList() {
        if (this.data == null) {
            return null;
        }
        return this.data.processorList();
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.data == null) {
            return;
        }
        ItemSelectable c = evt.getItemSelectable();
        if (c == this.cbPacks) {
            this.data.showPacks(evt.getStateChange() == 1);
        } else if (c == this.cbMsgs) {
            this.data.showMsgs(evt.getStateChange() == 1);
        } else if (c == this.cbIdle) {
            this.data.showIdle(evt.getStateChange() == 1);
        } else if (c == this.cbTraceMessages) {
            this.data.setTraceMessagesOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbCompactView) {
            this.data.setCompactView(evt.getStateChange() == 1);
        } else if (c == this.cbTraceArrayElementID) {
            this.data.setTraceOIDOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbUser) {
            this.data.showUserEvents(evt.getStateChange() == 1);
        } else if (c == this.cbUserTable) {
            if (evt.getStateChange() == 1) {
                this.userEventWindow.pack();
                this.userEventWindow.setVisible(true);
            } else {
                this.userEventWindow.setVisible(false);
            }
        }
        this.parentWindow.refreshDisplay(false);
    }

    private void ShowColorWindow() {
        if (this.colorWindow == null) {
            this.colorWindow = new ColorChooser((Frame)this.parentWindow, this.data, this.parentWindow);
        }
        this.colorWindow.setVisible(true);
    }

    public void CloseColorWindow() {
        this.colorWindow = null;
    }

    public void updateScaleField() {
        this.scaleField.setText("" + this.data.getScaleFactor());
    }
}

