/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import charm.debug.PasswordDialog;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;

public class ServThread
extends Thread {
    String hostName = null;
    String portno = null;
    Runtime runtime = null;
    Process p = null;
    ParDebug mainThread = null;
    volatile int flag;
    public FileWriter debugOutput;
    public static String infoStr;

    public ServThread(ParDebug d, Process par) {
        this.mainThread = d;
        this.p = par;
        this.flag = 0;
    }

    @Override
    public void run() {
        this.runtime = Runtime.getRuntime();
        try {
            System.out.println("ServThread started");
            BufferedReader prout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            BufferedReader prerr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            boolean foundPort = false;
            try {
                String outline;
                do {
                    StringBuffer outlinechunk = new StringBuffer();
                    int maxChunk = 51200;
                    while ((outline = prout.readLine()) != null) {
                        if (!foundPort) {
                            if (outline.indexOf("ccs: Server IP =", 0) != -1) {
                                int nameStart = outline.indexOf("Server IP = ", 0);
                                int nameEnd = outline.indexOf(",", nameStart += 12);
                                this.hostName = outline.substring(nameStart, nameEnd);
                                int portStart = outline.indexOf("Server port = ", 0);
                                int portEnd = outline.indexOf("$", 0);
                                this.portno = outline.substring(portStart += 14, portEnd - 1);
                                foundPort = true;
                                this.flag = 1;
                            }
                            if (outline.indexOf("Password:", 0) != -1) {
                                System.out.println("Password requested");
                                char[] passwd = null;
                                new PasswordDialog(passwd);
                                System.out.println(passwd);
                            }
                        }
                        if (outline.indexOf("Break point reached", 0) != -1) {
                            this.mainThread.setStatusMessage(outline);
                            Notify doWorkRunnable = new Notify(outline){

                                @Override
                                public void run() {
                                    ServThread.this.mainThread.notifyBreakpoint(this.text);
                                }
                            };
                            SwingUtilities.invokeLater(doWorkRunnable);
                        } else if (outline.indexOf("Frozen processor") != -1) {
                            this.mainThread.setStatusMessage(outline);
                            Notify doWorkRunnable = new Notify(outline){

                                @Override
                                public void run() {
                                    ServThread.this.mainThread.notifyFreeze(this.text);
                                }
                            };
                            SwingUtilities.invokeLater(doWorkRunnable);
                        } else if (outline.indexOf("CPD: CmiAbort called") != -1) {
                            this.mainThread.setStatusMessage(outline.substring(5));
                            Notify doWorkRunnable = new Notify(outline){

                                @Override
                                public void run() {
                                    ServThread.this.mainThread.notifyAbort(this.text);
                                }
                            };
                            SwingUtilities.invokeLater(doWorkRunnable);
                        } else if (outline.indexOf("CPD: Signal received") != -1) {
                            this.mainThread.setStatusMessage(outline.substring(5));
                            Notify doWorkRunnable = new Notify(outline){

                                @Override
                                public void run() {
                                    ServThread.this.mainThread.notifySignal(this.text);
                                }
                            };
                            SwingUtilities.invokeLater(doWorkRunnable);
                        } else {
                            outlinechunk.append(outline + "\n");
                        }
                        if (prout.ready() && outlinechunk.length() < 51200) continue;
                    }
                    System.out.println("Parallel program printed: " + outlinechunk.toString());
                    this.mainThread.displayProgramOutput(outlinechunk.toString());
                } while (outline != null);
                System.out.println("ServThread terminated");
                this.flag = 2;
            }
            catch (Exception e) {
                System.out.println("Failed to print");
                e.printStackTrace();
            }
            System.out.println("Finished running parallel program");
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    ServThread.this.mainThread.quitProgram();
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error in ServThread. Exception caught");
        }
    }

    public int getFlag() {
        return this.flag;
    }

    public abstract class Notify
    implements Runnable {
        public String text;

        public Notify(String txt) {
            this.text = txt;
        }
    }
}

