/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import projections.analysis.AmpiFunctionData;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class UsageCalc
extends ProjDefs {
    int myRun = 0;
    private long beginTime;
    private long endTime;
    private long startTime;
    private int pnum;
    private int dataLen;
    private long packtime;
    private long packstarttime;
    private long unpacktime;
    private long unpackstarttime;
    private int numUserEntries;
    private double version;
    private int countflag = 0;
    private int curEntry = -1;
    private boolean deltaEncoded = false;

    private void intervalCalc(float[][] data, int type, int entry, long time) {
        if (type != 1) {
            if (time <= this.beginTime + 1L) {
                time = this.beginTime;
                this.countflag = 0;
            } else if (this.countflag != 2) {
                this.countflag = 1;
            }
            if (time > this.endTime) {
                time = this.endTime;
                this.countflag = 2;
            } else if (this.countflag != 0) {
                this.countflag = 1;
            }
        } else if (this.countflag != 1) {
            time = 0L;
        }
        switch (type) {
            case 2: {
                this.packtime = 0L;
                this.unpacktime = 0L;
                this.curEntry = MainWindow.runObject[this.myRun].getEntryIndex(entry);
                this.startTime = time;
                break;
            }
            case 3: {
                if (this.curEntry == -1) break;
                float[] fArray = data[0];
                int n = this.curEntry;
                fArray[n] = fArray[n] + (float)(time - this.startTime - this.packtime - this.unpacktime);
                break;
            }
            case 1: {
                if (this.curEntry == -1) break;
                float[] fArray = data[1];
                int n = this.curEntry;
                fArray[n] = fArray[n] + (float)time;
                break;
            }
            case 21: {
                break;
            }
            case 14: {
                this.startTime = time;
                break;
            }
            case 15: {
                float[] fArray = data[0];
                int n = this.numUserEntries + 2;
                fArray[n] = fArray[n] + (float)(time - this.startTime);
                break;
            }
            case 16: {
                this.packstarttime = time;
                break;
            }
            case 17: {
                this.packtime += time - this.packstarttime;
                float[] fArray = data[0];
                int n = this.numUserEntries;
                fArray[n] = fArray[n] + (float)(time - this.packstarttime);
                break;
            }
            case 18: {
                this.unpackstarttime = time;
                break;
            }
            case 19: {
                this.unpacktime += time - this.unpackstarttime;
                float[] fArray = data[0];
                int n = this.numUserEntries + 1;
                fArray[n] = fArray[n] + (float)(time - this.unpackstarttime);
            }
        }
    }

    public float[] ampiUsage(int procnum, long begintime, long endtime, double v) {
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        long[] accTime = new long[numFunc + 1];
        float[] data = new float[numFunc + 1];
        int i = 0;
        while (i < numFunc) {
            accTime[i] = 0L;
            ++i;
        }
        GenericLogReader reader = new GenericLogReader(procnum, v);
        LogEntryData LE = new LogEntryData();
        AmpiFunctionData curFunc = null;
        long time = 0L;
        boolean isProcessing = false;
        CallStackManager funcStack = new CallStackManager();
        try {
            do {
                reader.nextEvent(LE);
                time = LE.time;
            } while (LE.type != 2 || LE.entry == -1 || LE.time < begintime);
            while (time < endtime) {
                switch (LE.type) {
                    case 2: {
                        if (isProcessing) break;
                        isProcessing = true;
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.setLastBeginTime(time);
                        break;
                    }
                    case 3: {
                        if (!isProcessing) break;
                        isProcessing = false;
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.incrAccExecTimeNow(time);
                        break;
                    }
                    case 22: {
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc != null) {
                            curFunc.incrAccExecTimeNow(time);
                        }
                        AmpiFunctionData thisFunc = LogEntry.adapt((LogEntryData)LE).ampiData;
                        thisFunc.setLastBeginTime(time);
                        funcStack.push(thisFunc, LE.id[0], LE.id[1], LE.id[2]);
                        break;
                    }
                    case 23: {
                        AmpiFunctionData lastFunc = (AmpiFunctionData)funcStack.pop(LE.id[0], LE.id[1], LE.id[2]);
                        lastFunc.incrAccExecTimeNow(time);
                        int n = LE.entry;
                        accTime[n] = accTime[n] + lastFunc.getAccExecTime();
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.setLastBeginTime(time);
                        break;
                    }
                }
                reader.nextEvent(LE);
                time = LE.time;
            }
        }
        catch (EOFException thisFunc) {
        }
        catch (IOException e) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        float accumulated = 0.0f;
        int j = 1;
        while (j < numFunc) {
            data[j] = (float)(100.0 * (double)accTime[j]) / (float)(endtime - begintime);
            accumulated += data[j];
            ++j;
        }
        if (accumulated > 100.0f) {
            System.out.println("ERROR: accTime > 100%");
            return null;
        }
        data[numFunc] = 100.0f - accumulated;
        return data;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[][] usage(int procnum, long begintime, long endtime, double v) {
        this.version = v;
        this.beginTime = begintime;
        this.endTime = endtime;
        this.pnum = procnum;
        this.numUserEntries = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.dataLen = this.numUserEntries + 4;
        data = new float[2][this.dataLen];
        i = 0;
        while (i < this.dataLen) {
            data[0][i] = 0.0f;
            data[1][i] = 0.0f;
            ++i;
        }
        reader = new GenericLogReader(procnum, this.version);
        logEntry = new LogEntryData();
        this.curEntry = -1;
        this.startTime = 0L;
        time = 0L;
        isProcessing = false;
        try lbl-1000:
        // 17 sources

        {
            block18: while (time < this.endTime) {
                reader.nextEvent(logEntry);
                time = logEntry.time;
                switch (logEntry.type) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        this.intervalCalc(data, logEntry.type, 0, time);
                        ** break;
                    }
                    case 2: {
                        if (isProcessing) continue block18;
                        this.intervalCalc(data, logEntry.type, logEntry.entry, time);
                        isProcessing = true;
                        ** break;
                    }
                    case 3: {
                        if (!isProcessing) continue block18;
                        this.intervalCalc(data, logEntry.type, logEntry.entry, time);
                        isProcessing = false;
                        ** break;
                    }
                    case 11: {
                        ** break;
                    }
                    case 12: {
                        ** break;
                    }
                    case 10: {
                        ** break;
                    }
                    case 1: {
                        this.intervalCalc(data, logEntry.type, 0, logEntry.sendTime);
                        ** break;
                    }
                    case 21: {
                        ** break;
                    }
                    case 13: 
                    case 100: {
                        ** break;
                    }
                    case 4: 
                    case 5: {
                        ** break;
                    }
                    case 8: 
                    case 9: {
                        ** break;
                    }
                    case 7: {
                        ** break;
                    }
                }
                if (!this.deltaEncoded) continue;
                System.out.println("Warning: Unknown Event! This can mess up delta encoding!");
            }
        }
        catch (EOFException var14_11) {
        }
        catch (IOException e) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        j = 0;
        while (j < this.dataLen) {
            data[0][j] = data[0][j] - data[1][j];
            data[0][j] = (float)(100.0 * (double)data[0][j]) / (float)(this.endTime - this.beginTime);
            data[1][j] = (float)(100.0 * (double)data[1][j]) / (float)(this.endTime - this.beginTime);
            ++j;
        }
        return data;
    }
}

