/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.JFloatTextField;
import projections.gui.MainWindow;
import projections.gui.PieChartWindow;
import projections.gui.ProfileData;
import projections.gui.ProfileGraph;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class ProfileWindow
extends ProjectionsWindow
implements ActionListener,
ColorSelectable,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int NUM_SYS_EPS = 3;
    int myRun = 0;
    public ProfileWindow thisWindow = this;
    private ProfileData data;
    private boolean colorsSet = false;
    private Color[] colors = null;
    private float[][] dataSource = null;
    private int[][] colorMap = null;
    private String[][] nameMap = null;
    private String[] procNames = null;
    private float[] sDataSrc = null;
    private int[] sColorMap = null;
    private String[] sNameMap = null;
    private JTabbedPane tabPane;
    private ProfileGraph displayCanvas;
    private JScrollPane displayPanel;
    private int displayPanelTabIndex;
    private ProfileGraph ampiDisplayCanvas;
    private JScrollPane ampiDisplayPanel;
    private int ampiDisplayPanelTabIndex;
    private JButton btnIncX;
    private JButton btnDecX;
    private JButton btnResX;
    private JButton btnIncY;
    private JButton btnDecY;
    private JButton btnResY;
    private JFloatTextField txtScaleX;
    private JFloatTextField txtScaleY;
    private float thresh = 0.01f;
    public PieChartWindow pieChartWindow;
    private float[][] avgData;
    private EntrySelectionDialog entryDialog;
    boolean ampiTraceOn = false;

    public ProfileWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        if (MainWindow.runObject[this.myRun].getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Usage Profile - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
    }

    protected void windowInit() {
        this.data = new ProfileData(this);
        this.data.plist = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.data.pstring = MainWindow.runObject[this.myRun].getValidProcessorString();
        this.data.begintime = 0L;
        this.data.endtime = MainWindow.runObject[this.myRun].getTotalTime();
    }

    private void CreateMenus() {
        JMenuBar mbar = new JMenuBar();
        Object[] objectArray = new Object[4];
        objectArray[0] = "Select Processors";
        objectArray[1] = "Print Profile";
        objectArray[3] = "Close";
        mbar.add(Util.makeJMenu("File", objectArray, null, this));
        if (this.ampiTraceOn) {
            mbar.add(Util.makeJMenu("Tools", new Object[]{"Pie Chart", "Change Colors", "Usage Table", new String[]{"AMPI", "Usage Profile"}}, null, this));
        } else {
            mbar.add(Util.makeJMenu("Tools", new Object[]{"Pie Chart", "Change Colors", "Usage Table"}, null, this));
        }
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    private void CreateLayout() {
        JPanel wholePanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.displayCanvas = new ProfileGraph();
        this.displayPanel = new JScrollPane(this.displayCanvas);
        if (this.ampiTraceOn) {
            this.ampiDisplayCanvas = new ProfileGraph();
            this.ampiDisplayPanel = new JScrollPane(this.ampiDisplayCanvas);
            this.tabPane = new JTabbedPane();
            this.tabPane.add("Entry Points", this.displayPanel);
            this.tabPane.add("AMPI Functions", this.ampiDisplayPanel);
            this.displayPanelTabIndex = this.tabPane.indexOfComponent(this.displayPanel);
            this.ampiDisplayPanelTabIndex = this.tabPane.indexOfComponent(this.ampiDisplayPanel);
            this.tabPane.addChangeListener(this);
        }
        JPanel xScalePanel = new JPanel();
        xScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        xScalePanel.setLayout(gbl);
        this.btnDecX = new JButton("<<");
        JLabel lScaleX = new JLabel("X-Axis Scale: ", 0);
        this.txtScaleX = new JFloatTextField(1.0f, 5);
        this.btnIncX = new JButton(">>");
        this.btnResX = new JButton("Reset");
        this.btnDecX.addActionListener(this);
        this.txtScaleX.addActionListener(this);
        this.btnIncX.addActionListener(this);
        this.btnResX.addActionListener(this);
        Util.gblAdd(xScalePanel, this.btnDecX, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, lScaleX, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.txtScaleX, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(xScalePanel, this.btnIncX, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.btnResX, gbc, 4, 0, 1, 1, 0, 0);
        JPanel yScalePanel = new JPanel();
        yScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        yScalePanel.setLayout(gbl);
        this.btnDecY = new JButton("<<");
        JLabel lScaleY = new JLabel("Y-Axis Scale: ", 0);
        this.txtScaleY = new JFloatTextField(1.0f, 5);
        this.btnIncY = new JButton(">>");
        this.btnResY = new JButton("Reset");
        this.btnDecY.addActionListener(this);
        this.txtScaleY.addActionListener(this);
        this.btnIncY.addActionListener(this);
        this.btnResY.addActionListener(this);
        Util.gblAdd(yScalePanel, this.btnDecY, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, lScaleY, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.txtScaleY, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(yScalePanel, this.btnIncY, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.btnResY, gbc, 4, 0, 1, 1, 0, 0);
        Container wholeContainer = this.getContentPane();
        wholeContainer.setLayout(gbl);
        if (this.ampiTraceOn) {
            Util.gblAdd(wholeContainer, this.tabPane, gbc, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        } else {
            Util.gblAdd(wholeContainer, this.displayPanel, gbc, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        }
        Util.gblAdd(wholeContainer, xScalePanel, gbc, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
        Util.gblAdd(wholeContainer, yScalePanel, gbc, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = !MainWindow.runObject[this.myRun].hasLogData() && !MainWindow.runObject[this.myRun].hasSumDetailData() ? new RangeDialog(this, "Usage Profile", true) : new RangeDialog(this, "Usage Profile");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            Thread t = new Thread(){

                public void run() {
                    ProfileWindow.this.setDisplayProfileData();
                    if (ProfileWindow.this.ampiTraceOn) {
                        ProfileWindow.this.setAmpiDisplayProfileData();
                    }
                    ProfileWindow.this.setLocationRelativeTo(ProfileWindow.this.parentWindow);
                    ProfileWindow.this.setVisible(true);
                }
            };
            t.start();
        }
    }

    public void getDialogData() {
        this.data.plist = this.dialog.getValidProcessors();
        this.data.pstring = this.dialog.getValidProcessorString();
        this.data.begintime = this.dialog.getStartTime();
        this.data.endtime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.data.plist);
        this.dialog.setStartTime(this.data.begintime);
        this.dialog.setEndTime(this.data.endtime);
        super.setDialogData();
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent evt) {
        float oldScaleX = this.txtScaleX.getValue();
        float oldScaleY = this.txtScaleY.getValue();
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.btnDecX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) - 1) / 4.0f;
                if ((double)scaleX < 1.0) {
                    scaleX = 1.0f;
                }
            } else if (b == this.btnIncX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) + 1) / 4.0f;
            } else if (b == this.btnResX) {
                scaleX = 1.0f;
            } else if (b == this.btnDecY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) - 1) / 4.0f;
                if ((double)scaleY < 1.0) {
                    scaleY = 1.0f;
                }
            } else if (b == this.btnIncY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) + 1) / 4.0f;
            } else if (b == this.btnResY) {
                scaleY = 1.0f;
            }
            if (scaleX != oldScaleX && (double)scaleX > 0.0) {
                this.txtScaleX.setText("" + scaleX);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(scaleX);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(scaleX);
                    }
                } else {
                    this.displayCanvas.setScaleX(scaleX);
                }
            }
            if (scaleY != oldScaleY && (double)scaleY > 0.0) {
                this.txtScaleY.setText("" + scaleY);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(scaleY);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(scaleY);
                    }
                } else {
                    this.displayCanvas.setScaleY(scaleY);
                }
            }
        } else if (evt.getSource() instanceof JFloatTextField) {
            JFloatTextField field = (JFloatTextField)evt.getSource();
            if (field == this.txtScaleX) {
                scaleX = oldScaleX;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(scaleX);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(scaleX);
                    }
                } else {
                    this.displayCanvas.setScaleX(scaleX);
                }
            } else if (field == this.txtScaleY) {
                scaleY = oldScaleY;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(scaleY);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(scaleY);
                    }
                } else {
                    this.displayCanvas.setScaleY(scaleY);
                }
            }
        } else if (evt.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)evt.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            } else if (arg.equals("Pie Chart")) {
                this.pieChartWindow = new PieChartWindow(this.parentWindow, this.avgData[0], this.avgData[0].length, this.thresh, this.colors);
            } else if (arg.equals("Change Colors")) {
                this.showChangeColorDialog();
            } else if (arg.equals("Usage Table")) {
                this.showUsageTable();
            } else if (arg.equals("Usage Profile")) {
                this.showAMPIUsageProfile();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabPane) {
            if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                this.txtScaleX.setText(String.valueOf(this.displayCanvas.getScaleX()));
                this.txtScaleY.setText(String.valueOf(this.displayCanvas.getScaleY()));
            } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                this.txtScaleX.setText(String.valueOf(this.ampiDisplayCanvas.getScaleX()));
                this.txtScaleY.setText(String.valueOf(this.ampiDisplayCanvas.getScaleY()));
            }
        }
    }

    public void applyDialogColors() {
        int eps = MainWindow.runObject[this.myRun].getNumUserEntries();
        System.out.println(this.colors[eps + 2]);
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    public void showChangeColorDialog() {
        int noEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (this.entryDialog == null) {
            String[] typeLabelStrings = new String[]{"Entry Points"};
            boolean[][] existsArray = new boolean[1][noEPs + 3];
            int i = 0;
            while (i < noEPs + 3) {
                existsArray[0][i] = true;
                ++i;
            }
            boolean[][] stateArray = new boolean[1][noEPs + 3];
            int i2 = 0;
            while (i2 < noEPs + 3) {
                stateArray[0][i2] = true;
                ++i2;
            }
            String[] entryNames = new String[noEPs + 3];
            int i3 = 0;
            while (i3 < noEPs) {
                entryNames[i3] = MainWindow.runObject[this.myRun].getEntryNameByIndex(i3);
                ++i3;
            }
            entryNames[noEPs] = "Pack Time";
            entryNames[noEPs + 1] = "Unpack Time";
            entryNames[noEPs + 2] = "Idle Time";
            Color[][] newColors = new Color[][]{this.colors};
            this.entryDialog = new EntrySelectionDialog(this, this, typeLabelStrings, stateArray, newColors, existsArray, entryNames);
        }
        this.entryDialog.showDialog();
    }

    private void showUsageTable() {
        if (this.dataSource == null) {
            return;
        }
        JFrame usageFrame = new JFrame();
        usageFrame.setTitle("Entry Points Usage Percent Table");
        usageFrame.setDefaultCloseOperation(2);
        Object[] tHeading = new String[]{"Proc#", "Entry Name", "Usage Percent (%)"};
        int totalEntry = 0;
        int i = 1;
        while (i < this.dataSource.length) {
            totalEntry += this.dataSource[i].length;
            ++i;
        }
        Object[][] tData = new Object[totalEntry][];
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        int entryCnt = 0;
        int i2 = 1;
        while (i2 < this.dataSource.length) {
            int j = 0;
            while (j < this.dataSource[i2].length) {
                tData[entryCnt] = new Object[3];
                tData[entryCnt][0] = this.procNames[i2];
                tData[entryCnt][1] = this.nameMap[i2][j];
                tData[entryCnt][2] = String.valueOf(df.format(this.dataSource[i2][j])) + "%";
                ++entryCnt;
                ++j;
            }
            ++i2;
        }
        JTable t = new JTable(tData, tHeading);
        JScrollPane sp = new JScrollPane(t);
        usageFrame.getContentPane().add(sp);
        usageFrame.setLocationRelativeTo(this.parentWindow);
        usageFrame.setSize(500, 250);
        usageFrame.setVisible(true);
    }

    private void showAMPIUsageProfile() {
        JFrame profileFrame = new JFrame();
        profileFrame.setTitle("AMPI Function Profile Table");
        profileFrame.setDefaultCloseOperation(2);
        Object[] tHeading = new String[]{"Processor#", "Function Name", "Source File Name", "Line#", "%/Total", "%/Process"};
        int curPe = -1;
        this.data.plist.reset();
        Vector[] ampiProcessVec = new Vector[this.data.plist.size()];
        int pCnt = 0;
        int totalLine = 0;
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            ampiProcessVec[pCnt] = new Vector();
            MainWindow.runObject[this.myRun].createAMPIUsage(curPe, this.data.begintime, this.data.endtime, ampiProcessVec[pCnt]);
            Vector v = ampiProcessVec[pCnt];
            int i = 0;
            while (i < v.size()) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(i);
                totalLine += p.getFinalCallFuncStack().size();
                ++i;
            }
            ++pCnt;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        long totalExecTime = this.data.endtime - this.data.begintime;
        Object[][] tData = new Object[totalLine][];
        curPe = -1;
        this.data.plist.reset();
        pCnt = 0;
        int lineCnt = 0;
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            Vector v = ampiProcessVec[pCnt++];
            int i = 0;
            while (i < v.size()) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(i);
                long processTotalExecTime = p.getAccExecTime();
                Stack stk = p.getFinalCallFuncStack();
                Enumeration e = stk.elements();
                while (e.hasMoreElements()) {
                    AmpiFunctionData d = (AmpiFunctionData)e.nextElement();
                    tData[lineCnt] = new Object[tHeading.length];
                    tData[lineCnt][0] = "" + curPe;
                    tData[lineCnt][1] = MainWindow.runObject[this.myRun].getFunctionName(d.FunctionID);
                    tData[lineCnt][2] = d.sourceFileName;
                    tData[lineCnt][3] = "" + d.LineNo;
                    tData[lineCnt][4] = String.valueOf(df.format((double)d.getAccExecTime() / (double)totalExecTime * 100.0)) + "%";
                    tData[lineCnt][5] = String.valueOf(df.format((double)d.getAccExecTime() / (double)processTotalExecTime * 100.0)) + "%";
                    ++lineCnt;
                }
                ++i;
            }
        }
        JTable t = new JTable(tData, tHeading);
        JScrollPane sp = new JScrollPane(t);
        profileFrame.getContentPane().add(sp);
        profileFrame.setLocationRelativeTo(this);
        profileFrame.setSize(500, 250);
        profileFrame.setVisible(true);
    }

    void setAmpiDisplayProfileData() {
        int i;
        String[] xNames = new String[this.data.plist.size()];
        int curPe = -1;
        this.data.plist.reset();
        Vector ampiProcess = null;
        int pCnt = 0;
        float[][] ampiDataSrc = new float[this.data.plist.size()][];
        String[][] ampiFuncNameMap = new String[this.data.plist.size()][];
        long totalExecTime = this.data.endtime - this.data.begintime;
        while (this.data.plist.hasMoreElements()) {
            AmpiProcessProfile p;
            curPe = this.data.plist.nextElement();
            ampiProcess = new Vector();
            MainWindow.runObject[this.myRun].createAMPIUsage(curPe, this.data.begintime, this.data.endtime, ampiProcess);
            int total = 0;
            i = 0;
            while (i < ampiProcess.size()) {
                p = (AmpiProcessProfile)ampiProcess.get(i);
                total += p.getFinalCallFuncStack().size();
                ++i;
            }
            ampiDataSrc[pCnt] = new float[total];
            ampiFuncNameMap[pCnt] = new String[total];
            total = 0;
            i = 0;
            while (i < ampiProcess.size()) {
                p = (AmpiProcessProfile)ampiProcess.get(i);
                Stack stk = p.getFinalCallFuncStack();
                Enumeration e = stk.elements();
                while (e.hasMoreElements()) {
                    AmpiFunctionData d = (AmpiFunctionData)e.nextElement();
                    ampiFuncNameMap[pCnt][total] = String.valueOf(MainWindow.runObject[this.myRun].getFunctionName(d.FunctionID)) + "@" + d.sourceFileName + "(" + d.LineNo + ")";
                    ampiDataSrc[pCnt][total] = (float)d.getAccExecTime() / (float)totalExecTime * 100.0f;
                    ++total;
                }
                ++i;
            }
            xNames[pCnt] = String.valueOf(curPe);
            ++pCnt;
        }
        int colorNum = 0;
        i = 0;
        while (i < ampiDataSrc.length) {
            colorNum += ampiDataSrc[i].length;
            ++i;
        }
        Color[] ampiFuncColors = ColorManager.createColorMap(colorNum);
        int[][] ampiFuncColorMap = new int[ampiDataSrc.length][];
        colorNum = 0;
        int i2 = 0;
        while (i2 < ampiDataSrc.length) {
            ampiFuncColorMap[i2] = new int[ampiDataSrc[i2].length];
            int j = 0;
            while (j < ampiDataSrc[i2].length) {
                ampiFuncColorMap[i2][j] = colorNum++;
                ++j;
            }
            ++i2;
        }
        String[] gTitles = new String[]{"Profile of Usage for Functions in AMPI programs " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.ampiDisplayCanvas.setGraphTiltes(gTitles);
        this.ampiDisplayCanvas.setXAxis("", "", xNames);
        this.ampiDisplayCanvas.setYAxis("Usage Percent % (over processor)");
        this.ampiDisplayCanvas.setDisplayDataSource(ampiDataSrc, ampiFuncColorMap, ampiFuncColors, ampiFuncNameMap);
        this.ampiDisplayCanvas.repaint();
    }

    void setDisplayProfileData() {
        this.createDisplayDataSource();
        String[] gTitles = new String[]{"Profile of Usage for Processors " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.displayCanvas.setGraphTiltes(gTitles);
        String[] xNames = new String[this.data.plist.size() + 1];
        xNames[0] = "Avg";
        this.data.plist.reset();
        int cnt = 1;
        while (this.data.plist.hasMoreElements()) {
            xNames[cnt++] = "" + this.data.plist.nextElement();
        }
        this.procNames = xNames;
        this.displayCanvas.setXAxis("", "", xNames);
        this.displayCanvas.setYAxis("Usage Percent %");
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    private void createDisplayDataSource() {
        int i;
        int procCnt;
        this.data.numPs = procCnt = this.data.plist.size() + 1;
        this.dataSource = new float[procCnt][];
        this.colorMap = new int[procCnt][];
        this.nameMap = new String[procCnt][];
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        float[][] avg = new float[2][numEPs + 3];
        int i2 = 0;
        while (i2 < numEPs + 3) {
            avg[0][i2] = 0.0f;
            avg[1][i2] = 0.0f;
            ++i2;
        }
        this.avgData = avg;
        double avgScale = 1.0 / (double)this.data.plist.size();
        int progressCount = 0;
        int curPe = -1;
        ProgressMonitor progressBar = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            if (progressBar.isCanceled()) break;
            progressBar.setNote("[PE: " + curPe + " ] Computing Average.");
            progressBar.setProgress(progressCount);
            float[][] cur = MainWindow.runObject[this.myRun].GetUsageData(curPe, this.data.begintime, this.data.endtime, this.data.phaselist);
            i = 0;
            while (i < avg[0].length && i < cur[0].length) {
                float[] fArray = avg[0];
                int n = i;
                fArray[n] = fArray[n] + (float)((double)cur[0][i] * avgScale);
                float[] fArray2 = avg[1];
                int n2 = i;
                fArray2[n2] = fArray2[n2] + (float)((double)cur[1][i] * avgScale);
                ++i;
            }
            ++progressCount;
        }
        Vector<Integer> sigElements = new Vector<Integer>();
        i = 0;
        while (i < numEPs) {
            if ((double)(avg[0][i] + avg[1][i]) > 1.0) {
                sigElements.add(new Integer(i));
            }
            ++i;
        }
        int[] sigIndices = new int[sigElements.size()];
        int i3 = 0;
        while (i3 < sigIndices.length) {
            sigIndices[i3] = (Integer)sigElements.elementAt(i3);
            ++i3;
        }
        if (!this.colorsSet) {
            Color[] entryColors = MainWindow.runObject[this.myRun].getColorMap();
            this.colors = new Color[numEPs + 3];
            int i4 = 0;
            while (i4 < numEPs) {
                this.colors[i4] = entryColors[i4];
                ++i4;
            }
            this.colors[numEPs] = Color.black;
            this.colors[numEPs + 1] = Color.orange;
            this.colors[numEPs + 2] = Color.white;
            this.colorsSet = true;
        }
        this.createSingleProcSource(avg, -1);
        this.dataSource[0] = this.sDataSrc;
        this.colorMap[0] = this.sColorMap;
        this.nameMap[0] = this.sNameMap;
        progressCount = 0;
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            if (progressBar.isCanceled()) break;
            progressBar.setNote("[PE: " + curPe + " ] Reading Entry Point Usage.");
            progressBar.setProgress(progressCount);
            float[][] rawData = MainWindow.runObject[this.myRun].GetUsageData(curPe, this.data.begintime, this.data.endtime, this.data.phaselist);
            this.createSingleProcSource(rawData, curPe);
            this.dataSource[++progressCount] = this.sDataSrc;
            this.colorMap[progressCount] = this.sColorMap;
            this.nameMap[progressCount] = this.sNameMap;
        }
        progressBar.close();
    }

    public void createSingleProcSource(float[][] rawData, int procNum) {
        float usage;
        int numSigSections = 0;
        int i = 0;
        while (i < rawData[0].length) {
            if (rawData[0][i] > this.thresh) {
                ++numSigSections;
            }
            if (rawData[1][i] > this.thresh) {
                ++numSigSections;
            }
            ++i;
        }
        float[] dSrc = new float[numSigSections];
        int[] cMap = new int[numSigSections];
        String[] nMap = new String[numSigSections];
        this.sDataSrc = dSrc;
        this.sColorMap = cMap;
        this.sNameMap = nMap;
        DecimalFormat format_ = new DecimalFormat();
        format_.setMaximumFractionDigits(5);
        format_.setMinimumFractionDigits(5);
        int sigCnt = -1;
        int numUserEntries = MainWindow.runObject[this.myRun].getNumUserEntries();
        int epIndex = 0;
        while (epIndex < rawData[0].length) {
            usage = rawData[0][epIndex];
            if (!(usage <= this.thresh)) {
                dSrc[++sigCnt] = usage;
                cMap[sigCnt] = epIndex;
                nMap[sigCnt] = epIndex == numUserEntries ? "PACKING" : (epIndex == numUserEntries + 1 ? "UNPACKING" : (epIndex == numUserEntries + 2 ? "IDLE" : MainWindow.runObject[this.myRun].getEntryFullNameByIndex(epIndex)));
                if (procNum >= 0 && MainWindow.PRINT_USAGE) {
                    System.out.println(String.valueOf(procNum) + " " + epIndex + " " + format_.format(usage) + " " + nMap[sigCnt]);
                }
            }
            ++epIndex;
        }
        if (MainWindow.runObject[this.myRun].getVersion() > 4.9) {
            String prefix = "Message Send Time: ";
            epIndex = 0;
            while (epIndex < rawData[1].length) {
                usage = rawData[1][epIndex];
                if (!(usage <= this.thresh)) {
                    dSrc[++sigCnt] = usage;
                    cMap[sigCnt] = epIndex;
                    nMap[sigCnt] = epIndex == numUserEntries ? String.valueOf(prefix) + "PACKING" : (epIndex == numUserEntries + 1 ? String.valueOf(prefix) + "UNPACKING" : (epIndex == numUserEntries + 2 ? String.valueOf(prefix) + "IDLE" : MainWindow.runObject[this.myRun].getEntryFullNameByIndex(epIndex)));
                    if (procNum >= 0 && MainWindow.PRINT_USAGE) {
                        System.out.println(String.valueOf(procNum) + " " + epIndex + " " + format_.format(usage) + " " + nMap[sigCnt]);
                    }
                }
                ++epIndex;
            }
        }
    }

    public void MakePOArray(long bt, long et) {
    }

    public int getHSBValue() {
        return 0;
    }

    public int getVSBValue() {
        return 0;
    }
}

