/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import projections.gui.MainWindow;
import projections.gui.Timeline.Data;

public class UserEventObject
extends JComponent
implements Comparable,
MouseListener {
    private static final long serialVersionUID = 1L;
    static int myRun = 0;
    public static final int SINGLE = 1;
    public static final int PAIR = 2;
    public int Type;
    public long BeginTime;
    public long EndTime;
    public int UserEventID;
    public int CharmEventID;
    private Data data;
    private int pe;
    private int nestedRow;

    public UserEventObject(int pe, long t, int e, int event, int type) {
        this.setFocusable(false);
        this.Type = type;
        this.BeginTime = this.EndTime = t;
        this.UserEventID = e;
        this.CharmEventID = event;
        this.pe = pe;
        this.addMouseListener(this);
    }

    public String getName() {
        return MainWindow.runObject[myRun].getUserEventName(this.UserEventID);
    }

    public Color getColor() {
        Color c = MainWindow.runObject[myRun].getUserEventColor(this.UserEventID);
        if (c != null) {
            return c;
        }
        return Color.white;
    }

    public void setLocationAndSize(Data data, int actualDisplayWidth) {
        this.data = data;
        int leftCoord = data.timeToScreenPixel(this.BeginTime, actualDisplayWidth);
        int rightCoord = data.timeToScreenPixel(this.EndTime, actualDisplayWidth);
        if (this.EndTime > data.endTime()) {
            rightCoord = data.timeToScreenPixel(data.endTime(), actualDisplayWidth) - 5;
        }
        if (this.BeginTime < data.beginTime()) {
            leftCoord = data.timeToScreenPixel(data.beginTime(), actualDisplayWidth) + 5;
        }
        int width = rightCoord - leftCoord + 1;
        int heightPerRow = data.userEventRectHeight() / data.getNumUserEventRows();
        int bottom = data.userEventLocationBottom(this.pe);
        if (data.drawNestedUserEventRows) {
            bottom -= heightPerRow * this.nestedRow;
        }
        int top = bottom - heightPerRow;
        this.setToolTipText("<html><body><b>" + this.getName() + "</b></p><p><i>Duration:</i> " + (this.EndTime - this.BeginTime) + " us</p><p><i>event:</i> " + this.UserEventID + "</p></html></body>");
        this.setBounds(leftCoord, top, width, heightPerRow);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data.showUserEvents()) {
            g.setColor(this.getColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.getName() != null) {
                int leftpad = 3;
                int rightpad = 3;
                int toppad = 1;
                int bottompad = 1;
                int fontsize = this.getHeight() - toppad - bottompad;
                g.setFont(this.data.labelFont);
                FontMetrics fm = g.getFontMetrics();
                int stringWidth = fm.stringWidth(this.getName());
                if (fontsize >= 9 && stringWidth < this.getWidth() - leftpad - rightpad) {
                    g.setColor(Color.black);
                    g.drawString(this.getName(), leftpad, toppad + fontsize);
                    g.setPaintMode();
                }
            }
        }
    }

    public void shiftTimesBy(long shift) {
        this.BeginTime += shift;
        this.EndTime += shift;
    }

    public int compareTo(Object o) {
        UserEventObject ueo = (UserEventObject)o;
        if (this.pe != ueo.pe) {
            return this.pe - ueo.pe;
        }
        if (this.BeginTime != ueo.BeginTime) {
            return (int)(this.BeginTime - ueo.BeginTime);
        }
        if (this.EndTime != ueo.EndTime) {
            return (int)(ueo.EndTime - this.EndTime);
        }
        if (this != ueo) {
            return this.UserEventID - ueo.UserEventID;
        }
        System.err.println("ERROR: compareTo not working correctly for class UserEventObject");
        return 0;
    }

    public int verticalDisplayPosition() {
        return this.data.whichTimelineVerticalPosition(this.pe);
    }

    public void setNestedRow(int row) {
        this.nestedRow = row;
    }

    public void mouseClicked(MouseEvent e) {
        Color c = JColorChooser.showDialog(null, "Choose color for " + this.getName(), this.getColor());
        if (c != null) {
            MainWindow.runObject[myRun].setUserEventColor(this.UserEventID, c);
            this.data.displayMustBeRepainted();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

