/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.ParseTokenizer;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;

public class PoseDopReader {
    int myRun = 0;
    private static final int NUM_SIM_STATES = 2;
    private static final int FORWARD_SIM_PROGRESS = 0;
    private static final int NO_SIM_PROGRESS = 1;
    private int[][] dopRealTime;
    private int[] dopVirtTime;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private long totalRealTime;
    private long totalVirtualTime;
    private OrderedIntList validPEs = MainWindow.runObject[this.myRun].getValidProcessorList(3);

    public long getTotalRealTime() {
        if (this.totalRealTime > 0L) {
            return this.totalRealTime;
        }
        this.computeEndTimes();
        return this.totalRealTime;
    }

    public long getTotalVirtualTime() {
        if (this.totalVirtualTime > 0L) {
            return this.totalVirtualTime;
        }
        this.computeEndTimes();
        return this.totalVirtualTime;
    }

    private void computeEndTimes() {
        int curPeIdx = 0;
        int numProcessors = this.validPEs.size();
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Computing End Times", "", 0, numProcessors);
        this.validPEs.reset();
        long eventCount = 0L;
        int curPe = this.validPEs.nextElement();
        while (curPe != -1) {
            progressBar.setProgress(curPeIdx);
            progressBar.setNote("[PE: " + curPe + "] Getting End Time ...");
            try {
                this.reader = new BufferedReader(new FileReader(MainWindow.runObject[this.myRun].getPoseDopName(curPe)));
                this.initTokenizer(this.reader);
                try {
                    while (true) {
                        double eventEnd = this.tokenizer.nextNumber("Fake Start event");
                        eventEnd = this.tokenizer.nextNumber("end of event");
                        long virtualEnd = (long)this.tokenizer.nextNumber("Fake S VT");
                        virtualEnd = (long)this.tokenizer.nextNumber("end VT");
                        if ((long)(eventEnd * 1000000.0) > this.totalRealTime) {
                            this.totalRealTime = (long)(eventEnd * 1000000.0);
                        }
                        if (virtualEnd > this.totalVirtualTime) {
                            this.totalVirtualTime = virtualEnd;
                        }
                        this.tokenizer.nextToken();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
                System.exit(-1);
            }
            curPe = this.validPEs.nextElement();
            ++curPeIdx;
        }
        progressBar.close();
    }

    public void read(long realIntervalSize, int realStartInterval, int realEndInterval, long virtIntervalSize, int virtStartInterval, int virtEndInterval, OrderedIntList processorList) {
        int curPeIdx = 0;
        int numProcessors = processorList.size();
        long realStartTime = (long)realStartInterval * realIntervalSize;
        long realEndTime = (long)realEndInterval * realIntervalSize;
        long virtStartTime = (long)virtStartInterval * virtIntervalSize;
        long virtEndTime = (long)virtEndInterval * virtIntervalSize;
        int[][] tempRealData = new int[2][10000000];
        int[] tempVirtData = new int[10000000];
        long eventCount = 0L;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Reading dop files", "", 0, numProcessors);
        int curPe = processorList.nextElement();
        while (curPe != -1) {
            progressBar.setProgress(curPeIdx);
            progressBar.setNote("[PE: " + curPe + "] Reading ...");
            try {
                this.reader = new BufferedReader(new FileReader(MainWindow.runObject[this.myRun].getPoseDopName(curPe)));
                this.initTokenizer(this.reader);
                try {
                    while (true) {
                        long eventStart = (long)(this.tokenizer.nextNumber("start of event") * 1000000.0);
                        long eventEnd = (long)(this.tokenizer.nextNumber("end of event") * 1000000.0);
                        long virtualStart = (long)this.tokenizer.nextNumber("start VT");
                        long virtualEnd = (long)this.tokenizer.nextNumber("end VT");
                        int realState = virtualEnd - virtualStart > 0L ? 0 : 1;
                        if (eventStart < realStartTime && eventEnd >= realStartTime) {
                            int[] nArray = tempRealData[realState];
                            nArray[0] = nArray[0] + 1;
                            if (eventEnd <= realEndTime) {
                                int[] nArray2 = tempRealData[realState];
                                int n = (int)(eventEnd - realStartTime);
                                nArray2[n] = nArray2[n] - 1;
                            }
                        } else if (eventStart >= realStartTime) {
                            if (eventStart <= realEndTime) {
                                int[] nArray = tempRealData[realState];
                                int n = (int)(eventStart - realStartTime);
                                nArray[n] = nArray[n] + 1;
                            }
                            if (eventEnd == eventStart && eventEnd < realEndTime) {
                                int[] nArray = tempRealData[realState];
                                int n = (int)(eventEnd - realStartTime + 1L);
                                nArray[n] = nArray[n] - 1;
                            } else if (eventEnd <= realEndTime) {
                                int[] nArray = tempRealData[realState];
                                int n = (int)(eventEnd - realStartTime);
                                nArray[n] = nArray[n] - 1;
                            }
                        }
                        if (virtualStart == -1L || virtualEnd == -1L) {
                            this.tokenizer.nextToken();
                            continue;
                        }
                        if (virtualStart < virtStartTime && virtualEnd >= virtStartTime) {
                            tempVirtData[0] = tempVirtData[0] + 1;
                            if (virtualEnd < virtEndTime) {
                                int n = (int)(virtualEnd - virtStartTime + 1L);
                                tempVirtData[n] = tempVirtData[n] - 1;
                            }
                        } else if (virtualStart >= virtStartTime) {
                            if (virtualStart <= virtEndTime) {
                                int n = (int)(virtualStart - virtStartTime);
                                tempVirtData[n] = tempVirtData[n] + 1;
                            }
                            if (virtualEnd < virtEndTime) {
                                int n = (int)(virtualEnd - virtStartTime + 1L);
                                tempVirtData[n] = tempVirtData[n] - 1;
                            }
                        }
                        this.tokenizer.nextToken();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
                System.exit(-1);
            }
            curPe = processorList.nextElement();
            ++curPeIdx;
        }
        progressBar.close();
        int numIntervals = realEndInterval - realStartInterval + 1;
        int numVTIntervals = virtEndInterval - virtStartInterval + 1;
        this.dopRealTime = new int[numIntervals][2];
        this.dopVirtTime = new int[numVTIntervals];
        long[] runningCount = new long[2];
        int i = 0;
        while (i < numIntervals) {
            int state = 0;
            while (state < 2) {
                double[] intervalSum = new double[2];
                int j = 0;
                while ((long)j < realIntervalSize) {
                    int n = state;
                    runningCount[n] = runningCount[n] + (long)tempRealData[state][(int)((long)i * realIntervalSize + (long)j)];
                    int n2 = state;
                    intervalSum[n2] = intervalSum[n2] + (double)runningCount[state];
                    ++j;
                }
                this.dopRealTime[i][state] = (int)Math.floor(intervalSum[state] / (double)realIntervalSize);
                ++state;
            }
            ++i;
        }
        long runningVTCount = 0L;
        int i2 = 0;
        while (i2 < numVTIntervals) {
            double intervalSum = 0.0;
            int j = 0;
            while ((long)j < virtIntervalSize) {
                intervalSum += (double)(runningVTCount += (long)tempVirtData[(int)((long)i2 * virtIntervalSize + (long)j)]);
                ++j;
            }
            this.dopVirtTime[i2] = (int)Math.floor(intervalSum / (double)virtIntervalSize);
            ++i2;
        }
    }

    public int[][] getRealTimeDopData() {
        return this.dopRealTime;
    }

    public int[] getVirtualTimeDopData() {
        return this.dopVirtTime;
    }

    private void initTokenizer(BufferedReader reader) {
        this.tokenizer = new ParseTokenizer(reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
    }
}

