/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.ProgressMonitor;
import projections.analysis.AccumulatedSummaryReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.gui.MainWindow;
import projections.misc.SummaryFormatException;

public class SumAnalyzer
extends ProjDefs {
    int myRun = 0;
    public static final int NUM_MODES = 2;
    public static final int ACC_MODE = 0;
    public static final int NORMAL_MODE = 1;
    private StreamTokenizer tokenizer;
    private long[][] ChareTime;
    private int[][] NumEntryMsgs;
    private int[][] MaxEntryTime;
    private int PhaseCount;
    private long IntervalSize;
    private int IntervalCount;
    private long TotalTime;
    private long[][][] PhaseChareTime;
    private int[][][] PhaseNumEntryMsgs;
    private int[][] ProcessorUtilization;
    private int mode = 1;
    private AccumulatedSummaryReader accumulatedReader;

    public SumAnalyzer(StsReader stsReader, int mode) {
        this.mode = mode;
        this.accumulatedReader = new AccumulatedSummaryReader(MainWindow.runObject[this.myRun].getSumAccumulatedName(), "5.0");
        this.TotalTime = (long)this.accumulatedReader.totalTime;
        this.IntervalCount = (int)this.accumulatedReader.numIntervals;
        this.IntervalSize = (long)this.accumulatedReader.intervalSize;
    }

    public SumAnalyzer() throws IOException, SummaryFormatException {
        int myCount;
        int myProcessor;
        BufferedReader b;
        FileReader file;
        int nPe = 1;
        int numEntry = 0;
        int versionNum = 0;
        this.IntervalCount = 0;
        this.TotalTime = 0L;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Determining max intervals", "", 0, nPe);
        int p = 0;
        while (p < nPe) {
            if (!progressBar.isCanceled()) {
                progressBar.setNote(String.valueOf(p) + " of " + nPe);
                progressBar.setProgress(p);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper number of summary intervals!");
                System.exit(-1);
            }
            file = new FileReader(MainWindow.runObject[this.myRun].getSumName(p));
            b = new BufferedReader(file);
            this.tokenizer = new StreamTokenizer(b);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            versionNum = (int)this.nextNumber("Version Number");
            myProcessor = (int)this.nextNumber("processor number");
            nPe = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            myCount = (int)this.nextNumber("count");
            this.checkNextString("ep");
            int numEPs = (int)this.nextNumber("ep");
            this.checkNextString("interval");
            double interval = this.nextScientific("intervalsize");
            long myIntervalSize = (long)Math.floor(interval * 1000000.0);
            double factor = 1.0;
            if (myIntervalSize != this.IntervalSize) {
                if (this.IntervalSize == 0L) {
                    this.IntervalSize = myIntervalSize;
                } else {
                    factor = (double)myIntervalSize / ((double)this.IntervalSize * 1.0);
                    if (myIntervalSize < this.IntervalSize) {
                        this.IntervalSize = myIntervalSize;
                    }
                }
            }
            if (factor < 1.0) {
                this.IntervalCount = (int)((double)this.IntervalCount / factor);
            }
            if ((double)this.IntervalCount < (double)myCount * factor) {
                this.IntervalCount = (int)((double)myCount * factor);
            }
            this.tokenizer = null;
            file.close();
            ++p;
        }
        progressBar.close();
        progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Reading summary data", "", 0, nPe);
        p = 0;
        while (p < nPe) {
            int tokenType;
            if (progressBar.isCanceled()) {
                progressBar.close();
                return;
            }
            progressBar.setNote(String.valueOf(p) + " of " + nPe);
            progressBar.setProgress(p);
            file = new FileReader(MainWindow.runObject[this.myRun].getSumName(p));
            b = new BufferedReader(file);
            this.tokenizer = new StreamTokenizer(b);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            versionNum = (int)this.nextNumber("Version Number");
            myProcessor = (int)this.nextNumber("processor number");
            nPe = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            myCount = (int)this.nextNumber("count");
            this.checkNextString("ep");
            numEntry = (int)this.nextNumber("number of entry methods");
            this.checkNextString("interval");
            double interval = this.nextScientific("processor usage sample interval");
            long myIntervalSize = (long)Math.floor(interval * 1000000.0);
            if (this.TotalTime < (long)myCount * myIntervalSize) {
                this.TotalTime = (long)myCount * myIntervalSize;
            }
            int factor = (int)(myIntervalSize / this.IntervalSize);
            if (versionNum > 2) {
                this.checkNextString("phases");
                this.PhaseCount = (int)this.nextNumber("phases");
            } else {
                this.PhaseCount = 1;
            }
            if (10 != this.tokenizer.nextToken()) {
                throw new SummaryFormatException("extra garbage at end of line 1");
            }
            if (p == 0) {
                this.ProcessorUtilization = new int[nPe][];
                this.ChareTime = new long[nPe][numEntry];
                this.NumEntryMsgs = new int[nPe][numEntry];
                this.MaxEntryTime = new int[nPe][numEntry];
            }
            this.ProcessorUtilization[p] = new int[this.IntervalCount];
            int nUsageRead = 0;
            int val = 0;
            int extraCount = 0;
            while ((tokenType = this.tokenizer.nextToken()) != 10) {
                if (tokenType == -2) {
                    val = (int)this.tokenizer.nval;
                    int f = 0;
                    while (f < factor) {
                        this.ProcessorUtilization[p][nUsageRead++] = val;
                        ++f;
                    }
                    tokenType = this.tokenizer.nextToken();
                    if (tokenType == 43) {
                        tokenType = this.tokenizer.nextToken();
                        if (tokenType != -2) {
                            System.out.println("Unrecorgnized syntax at end of line 2");
                        }
                        if ((extraCount = (int)this.tokenizer.nval) > myCount) {
                            System.err.println("[" + p + "] Token read = [" + val + "+" + extraCount + "] is impossible as the " + "count is larger than the " + "total count of " + myCount);
                            System.exit(-1);
                        }
                        int i = 1;
                        while (i < extraCount) {
                            int f2 = 0;
                            while (f2 < factor) {
                                this.ProcessorUtilization[p][nUsageRead++] = val;
                                ++f2;
                            }
                            ++i;
                        }
                    } else {
                        this.tokenizer.pushBack();
                    }
                }
                if (nUsageRead <= myCount * factor) continue;
                System.err.println("[" + p + "] Corrupted data: " + "Number of datapoints read exceeds " + "file recorded value of " + myCount + "adjusted by factor " + factor);
                System.err.print("The violating token is [" + val);
                if (extraCount > 1) {
                    System.err.println("+" + extraCount + "]");
                } else {
                    System.err.println("]");
                }
                System.exit(-1);
            }
            if (myCount * factor != nUsageRead) {
                System.err.println("numIntervals not agree" + myCount * factor + "v.s. " + nUsageRead + "!");
            }
            int CurrentUserEntry = 0;
            tokenType = this.tokenizer.nextToken();
            if (-3 != tokenType) {
                this.tokenizer.pushBack();
            }
            while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                this.ChareTime[p][CurrentUserEntry++] = (int)this.tokenizer.nval;
            }
            if (10 != tokenType) {
                throw new SummaryFormatException("extra garbage at end of line 3");
            }
            tokenType = this.tokenizer.nextToken();
            if (-3 != tokenType) {
                this.tokenizer.pushBack();
            }
            CurrentUserEntry = 0;
            while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                this.NumEntryMsgs[p][CurrentUserEntry] = (int)this.tokenizer.nval;
                ++CurrentUserEntry;
            }
            if (10 != tokenType) {
                throw new SummaryFormatException("extra garbage at end of line 4");
            }
            if ((double)versionNum > 3.0) {
                tokenType = this.tokenizer.nextToken();
                if (-3 != tokenType) {
                    this.tokenizer.pushBack();
                }
                CurrentUserEntry = 0;
                while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                    this.MaxEntryTime[p][CurrentUserEntry] = (int)this.tokenizer.nval;
                    ++CurrentUserEntry;
                }
                if (10 != tokenType) {
                    throw new SummaryFormatException("extra garbage at end of line 5");
                }
            }
            if (-3 != (tokenType = this.tokenizer.nextToken())) {
                this.tokenizer.pushBack();
            }
            int NumberofPairs = (int)this.nextNumber("Number of Marked Events");
            int g = 0;
            while (g < NumberofPairs) {
                this.nextNumber("Number of Marked Events");
                this.nextNumber("Number of Marked Events");
                ++g;
            }
            if (this.PhaseCount > 1) {
                if (p == 0) {
                    this.PhaseChareTime = new long[this.PhaseCount][nPe][numEntry];
                    this.PhaseNumEntryMsgs = new int[this.PhaseCount][nPe][numEntry];
                }
                int m = 0;
                while (m < this.PhaseCount) {
                    CurrentUserEntry = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                        this.PhaseNumEntryMsgs[m][p][CurrentUserEntry] = (int)this.tokenizer.nval;
                        ++CurrentUserEntry;
                    }
                    if (10 != tokenType) {
                        throw new SummaryFormatException("extra garbage at end of line 3");
                    }
                    CurrentUserEntry = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                        this.PhaseChareTime[m][p][CurrentUserEntry] = (int)this.tokenizer.nval;
                        ++CurrentUserEntry;
                    }
                    if (10 != tokenType) {
                        throw new SummaryFormatException("extra garbage at end of line 4");
                    }
                    ++m;
                }
            }
            this.tokenizer = null;
            file.close();
            ++p;
        }
        progressBar.close();
        MainWindow.runObject[this.myRun].setTotalTime(this.TotalTime);
    }

    private void checkNextString(String expected) throws IOException, SummaryFormatException {
        String ret = this.nextString(expected);
        if (!expected.equals(ret)) {
            throw new SummaryFormatException("Expected " + expected + " got " + ret);
        }
    }

    public long getIntervalSize() {
        return this.IntervalSize;
    }

    public long[][] getChareTime() {
        return this.ChareTime;
    }

    public int[][] getNumEntryMsgs() {
        return this.NumEntryMsgs;
    }

    public long[][] getPhaseChareTime(int Phase) {
        return this.PhaseChareTime[Phase];
    }

    public int getPhaseCount() {
        return this.PhaseCount;
    }

    public int[][] getPhaseNumEntryMsgs(int Phase) {
        return this.PhaseNumEntryMsgs[Phase];
    }

    public int[][] getSystemUsageData(int intervalStart, int intervalEnd, long outIntervalSize) {
        int numProcessors = this.ProcessorUtilization.length;
        int intervalRange = intervalEnd - intervalStart + 1;
        int[][] ret = new int[numProcessors][intervalRange];
        if (outIntervalSize == this.IntervalSize) {
            int p = 0;
            while (p < numProcessors) {
                int i = intervalStart;
                while (i < intervalEnd && i < this.ProcessorUtilization[p].length) {
                    ret[p][i - intervalStart] = this.ProcessorUtilization[p][i];
                    ++i;
                }
                ++p;
            }
            return ret;
        }
        int sourceStartInterval = (int)((long)intervalStart * outIntervalSize / this.IntervalSize);
        double[][] tempData = new double[numProcessors][intervalRange];
        int p = 0;
        while (p < numProcessors) {
            int interval = sourceStartInterval;
            while (interval < this.ProcessorUtilization[p].length && interval < sourceStartInterval + intervalRange) {
                if (this.ProcessorUtilization[p][interval] > 0) {
                    IntervalUtils.fillIntervals(tempData[p], outIntervalSize, intervalStart, (long)interval * this.IntervalSize, (long)(interval + 1) * this.IntervalSize, IntervalUtils.utilToTime(this.ProcessorUtilization[p][interval], (double)this.IntervalSize), false);
                }
                ++interval;
            }
            ++p;
        }
        p = 0;
        while (p < tempData.length) {
            int i = 0;
            while (i < tempData[p].length) {
                tempData[p][i] = IntervalUtils.timeToUtil(tempData[p][i], (double)outIntervalSize);
                ret[p][i] = (int)tempData[p][i];
                ++i;
            }
            ++p;
        }
        return ret;
    }

    public double[] getSummaryAverageData() {
        if (this.mode == 1) {
            int numProcessors = this.ProcessorUtilization.length;
            double[] ret = new double[this.IntervalCount];
            int p = 0;
            while (p < numProcessors) {
                int interval = 0;
                while (interval < this.IntervalCount) {
                    int n = interval;
                    ret[n] = ret[n] + (double)this.ProcessorUtilization[p][interval];
                    ++interval;
                }
                ++p;
            }
            int interval = 0;
            while (interval < this.IntervalCount) {
                int n = interval++;
                ret[n] = ret[n] / ((double)numProcessors * 1.0);
            }
            return ret;
        }
        if (this.mode == 0) {
            try {
                this.accumulatedReader.loadIntervalData(0L, this.IntervalCount - 1);
            }
            catch (IOException e) {
                System.err.println("Exception caught!");
                System.exit(-1);
            }
            double[] ret = this.accumulatedReader.getUtilData();
            return ret;
        }
        return null;
    }

    public long getTotalTime() {
        return this.TotalTime;
    }

    private double nextNumber(String description) throws IOException, SummaryFormatException {
        if (-2 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read " + description);
        }
        return this.tokenizer.nval;
    }

    private double nextScientific(String description) throws IOException, SummaryFormatException {
        int exponent;
        double mantissa = this.nextNumber(String.valueOf(description) + " mantissa");
        String expString = this.nextString(String.valueOf(description) + " exponent");
        char expChar = expString.charAt(0);
        if (expChar != 'e' && expChar != 'd' && expChar != 'E' && expChar != 'D') {
            throw new SummaryFormatException("Couldn't find exponent in " + expString);
        }
        if ((expString = expString.substring(1)).equals("")) {
            this.tokenizer.nextToken();
            exponent = (int)this.nextNumber("exponent");
        } else {
            try {
                exponent = Integer.parseInt(expString);
            }
            catch (NumberFormatException e) {
                throw new SummaryFormatException("Couldn't parse exponent " + expString);
            }
        }
        return mantissa * Math.pow(10.0, exponent);
    }

    private String nextString(String description) throws IOException, SummaryFormatException {
        if (-3 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read string " + description);
        }
        return this.tokenizer.sval;
    }
}

