/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import projections.gui.AnimationWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;

public class AnimationDisplayPanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private float MAXHUE = 0.65f;
    int numPs = -1;
    private int numIs = -1;
    int pwidth;
    int pheight;
    int numrows;
    int numcols;
    private int pold = -1;
    int phoffset;
    int pvoffset;
    int hoffset;
    int voffset;
    float psize = 0.75f;
    private float fontOffset = 0.9f;
    private FontMetrics fm = null;
    private Font font = null;
    private int curI = -1;
    private int curP = -1;
    private long Isize = 0L;
    private int[][] data;
    Image offscreen;
    private Color[] colors;
    int w;
    int h;
    private AnimationWindow animationWindow;

    public AnimationDisplayPanel(AnimationWindow animationWindow) {
        this.animationWindow = animationWindow;
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
                if (AnimationDisplayPanel.this.w > 0 && AnimationDisplayPanel.this.h > 0) {
                    AnimationDisplayPanel.this.offscreen = AnimationDisplayPanel.this.createImage(AnimationDisplayPanel.this.w, AnimationDisplayPanel.this.h);
                    AnimationDisplayPanel.this.numcols = (int)Math.sqrt(AnimationDisplayPanel.this.numPs) - (int)(Math.sqrt(AnimationDisplayPanel.this.numPs) % 5.0);
                    if (AnimationDisplayPanel.this.numcols == 0) {
                        AnimationDisplayPanel.this.numcols = Math.min(AnimationDisplayPanel.this.numPs, 10);
                    }
                    AnimationDisplayPanel.this.numrows = (int)Math.ceil((double)AnimationDisplayPanel.this.numPs / (double)AnimationDisplayPanel.this.numcols);
                    AnimationDisplayPanel.this.pheight = AnimationDisplayPanel.this.pwidth = Math.min(AnimationDisplayPanel.this.w / AnimationDisplayPanel.this.numcols, AnimationDisplayPanel.this.h / AnimationDisplayPanel.this.numrows);
                    AnimationDisplayPanel.this.hoffset = (AnimationDisplayPanel.this.w - AnimationDisplayPanel.this.numcols * AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.voffset = (AnimationDisplayPanel.this.h - AnimationDisplayPanel.this.numrows * AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.phoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.pvoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.clearScreen();
                }
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.colors = new Color[101];
        int i = 0;
        while (i <= 100) {
            this.colors[i] = Color.getHSBColor((float)((double)(100 - i) / 100.0) * this.MAXHUE, 1.0f, 1.0f);
            ++i;
        }
        this.setParameters();
    }

    void clearScreen() {
        if (this.offscreen == null) {
            return;
        }
        Graphics og = this.offscreen.getGraphics();
        if (og != null) {
            og.clearRect(0, 0, this.w, this.h);
        }
        this.repaint();
    }

    public int getCurI() {
        return this.curI;
    }

    public int getNumI() {
        return this.numIs;
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    public void makeNextImage(Graphics g, int I) {
        int tothoffset = this.phoffset + this.hoffset;
        int totvoffset = this.pvoffset + this.voffset;
        int pw = (int)((float)this.pwidth * this.psize);
        int ph = (int)((float)this.pheight * this.psize);
        g.translate(tothoffset, totvoffset);
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            g.setFont(this.font);
            this.fm = g.getFontMetrics(this.font);
        }
        int p = 0;
        int r = 0;
        while (r < this.numrows) {
            int c = 0;
            while (c < this.numcols) {
                int usage;
                if ((usage = this.data[p++][I]) >= 0 && usage <= 100) {
                    g.setColor(this.colors[usage]);
                    g.fillRect(c * this.pwidth, r * this.pheight, pw, ph);
                    if ((float)this.fm.stringWidth(String.valueOf(this.numPs)) <= this.fontOffset * (float)pw && (float)this.fm.getHeight() <= this.fontOffset * (float)ph) {
                        g.setColor(Color.black);
                        g.drawString(String.valueOf(p - 1), c * this.pwidth + (pw - this.fm.stringWidth(String.valueOf(p - 1))) / 2, r * this.pheight + (ph + this.fm.getHeight()) / 2);
                    }
                }
                if (p >= this.numPs) break;
                ++c;
            }
            ++r;
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
        this.pold = -1;
        this.animationWindow.setStatusInfo(-1, -1, -1);
    }

    public void mouseMoved(MouseEvent evt) {
        if (this.pwidth <= 0 || this.pheight <= 0) {
            return;
        }
        int row = (evt.getY() - this.voffset) / this.pheight;
        int col = (evt.getX() - this.hoffset) / this.pwidth;
        this.curP = row * this.numcols + col;
        if (this.curP >= this.numPs || this.curP < 0 || row < 0 || col < 0 || row >= this.numrows || col >= this.numcols) {
            this.curP = -1;
        }
        if (this.curP != this.pold) {
            this.pold = this.curP;
            int count = 0;
            int pe = 0;
            OrderedIntList validPEs = this.animationWindow.validPEs;
            validPEs.reset();
            while (count <= this.curP) {
                pe = validPEs.nextElement();
                ++count;
            }
            if (this.curP >= 0 && this.curI != -1) {
                this.animationWindow.setStatusInfo(pe, this.curI, this.data[this.curP][this.curI]);
            } else {
                this.animationWindow.setStatusInfo(-1, -1, -1);
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            return;
        }
        if (this.curI != -1) {
            this.makeNextImage(this.offscreen.getGraphics(), this.curI);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public void setCurI(int i) {
        this.curI = i % this.numIs;
        if (this.curI < 0) {
            this.curI += this.numIs;
        }
        if (this.curP >= 0 && this.curP < this.numPs) {
            this.animationWindow.setStatusInfo(this.curP, this.curI, this.data[this.curP][this.curI]);
        }
        this.repaint();
    }

    public void setParameters() {
        OrderedIntList validPEs = this.animationWindow.validPEs;
        this.numPs = validPEs.size();
        this.Isize = this.animationWindow.intervalSize;
        this.data = this.getAnimationData(this.Isize, this.animationWindow.startTime, this.animationWindow.endTime, validPEs);
        this.numIs = this.data[0].length;
        if (this.numIs > 0) {
            this.curI = 0;
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.w > 0 && this.h > 0) {
            this.numcols = (int)Math.sqrt(this.numPs) - (int)(Math.sqrt(this.numPs) % 5.0);
            if (this.numcols == 0) {
                this.numcols = Math.min(this.numPs, 10);
            }
            this.numrows = (int)Math.ceil((double)this.numPs / (double)this.numcols);
            this.pheight = this.pwidth = Math.min(this.w / this.numcols, this.h / this.numrows);
            this.hoffset = (this.w - this.numcols * this.pwidth) / 2;
            this.voffset = (this.h - this.numrows * this.pheight) / 2;
            this.phoffset = (int)((1.0f - this.psize) * (float)this.pwidth) / 2;
            this.pvoffset = (int)((1.0f - this.psize) * (float)this.pheight) / 2;
            this.animationWindow.setTitleInfo(this.curI);
            this.clearScreen();
        }
    }

    public int[][] getAnimationData(long intervalSize, long startTime, long endTime, OrderedIntList desiredPEs) {
        if (intervalSize >= endTime - startTime) {
            intervalSize = endTime - startTime;
        }
        int startI = (int)(startTime / intervalSize);
        int endI = (int)(endTime / intervalSize);
        int numPs = desiredPEs.size();
        MainWindow.runObject[this.myRun].LoadGraphData(intervalSize, startI, endI - 1, false, null);
        int[][] animationdata = new int[numPs][endI - startI];
        int pInfo = desiredPEs.nextElement();
        int p = 0;
        while (pInfo != -1) {
            int t = 0;
            while (t < endI - startI) {
                animationdata[p][t] = MainWindow.runObject[this.myRun].getSystemUsageData(1)[pInfo][t];
                ++t;
            }
            pInfo = desiredPEs.nextElement();
            ++p;
        }
        return animationdata;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

