/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import projections.gui.MainWindow;

public class ColorManager {
    static int myRun = 0;
    private static String filename = null;

    public static void setDefaultLocation(String fname) {
        filename = fname;
    }

    public static Color[][] initializeColors() {
        Color[][] retColors = new Color[4][];
        int i = 0;
        while (i < retColors.length) {
            retColors[i] = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(i));
            ++i;
        }
        return retColors;
    }

    /*
     * Unable to fully structure code
     */
    public static Color[][] initializeColors(String filename) throws IOException {
        block11: {
            block10: {
                in = new ObjectInputStream(new FileInputStream(filename));
                retColors = new Color[4][];
                names = null;
                tempColors = null;
                index = 0;
                names = (String[])in.readObject();
                tempColors = (Color[][])in.readObject();
                if (names.length == tempColors.length) break block10;
                System.err.println("WARNING: Color file corrupted. Number of names do not match number of sets of colors.");
                return null;
            }
            try {
                i = 0;
                while (i < tempColors.length) {
                    index = MainWindow.runObject[ColorManager.myRun].stringToActivity(names[i]);
                    if (index != -1) {
                        retColors[index] = tempColors[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < retColors.length) {
                    if (retColors[i] == null) {
                        retColors[i] = ColorManager.createColorMap(MainWindow.runObject[ColorManager.myRun].getNumActivity(i));
                    }
                    ++i;
                }
            }
            catch (ClassCastException e) {
                in.close();
                activity = 0;
                retColors[activity] = new Color[MainWindow.runObject[ColorManager.myRun].getNumActivity(activity)];
                ColorManager.loadActivityColors(activity, retColors[activity]);
                i = 0;
                ** while (i < retColors.length)
            }
lbl-1000:
            // 1 sources

            {
                if (retColors[i] == null) {
                    retColors[i] = ColorManager.createColorMap(MainWindow.runObject[ColorManager.myRun].getNumActivity(i));
                }
                ++i;
                continue;
lbl39:
                // 1 sources

                break block11;
            }
            catch (Exception e) {
                System.err.println("WARNING: Failed to read saved color object");
                System.err.println(e);
                return null;
            }
        }
        in.close();
        return retColors;
    }

    public static void loadActivityColors(int type, Color[] origColors) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        Color[][] retColors = null;
        try {
            retColors = (Color[][])in.readObject();
        }
        catch (ClassCastException e) {
            retColors[type] = ColorManager.loadActivityColorsFallback(type);
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to read saved color object");
            System.err.println(e);
        }
        in.close();
        if (type >= 0 && type < 4) {
            if (origColors.length == retColors[type].length) {
                int i = 0;
                while (i < origColors.length) {
                    origColors[i] = retColors[type][i];
                    ++i;
                }
            } else {
                System.err.println("WARNING: Current color array length of " + origColors.length + " does not match " + "stored color array length of " + retColors[type].length + ". Load " + "request rejected.");
            }
        } else {
            System.err.println("WARNING - Internal Error: Activity type " + type + " unknown when requesting load " + "colors. Please inform developers");
        }
    }

    public static Color[] loadActivityColorsFallback(int type) throws IOException {
        Color[] retColors = null;
        if (type == 0) {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
            try {
                retColors = (Color[])in.readObject();
            }
            catch (ClassCastException e) {
                System.err.println("WARNING: Unexpected object format when attempting to read color file");
                System.err.println(e);
                return null;
            }
            catch (Exception e) {
                System.err.println("WARNING: Failed to read saved color object");
                System.err.println(e);
                return null;
            }
            in.close();
        } else {
            retColors = ColorManager.createColorMap(MainWindow.runObject[myRun].getNumActivity(type));
        }
        return retColors;
    }

    public static void saveColors(Color[][] colors) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(colors);
            out.close();
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to save color file to " + filename);
            System.err.println(e);
        }
    }

    public static Color[] createGrayscaleColorMap(int numColors) {
        Color[] colors = new Color[numColors];
        float H = 1.0f;
        float S = 0.0f;
        float B = 0.9f;
        float delta = (float)(0.8 / (double)numColors);
        int i = 0;
        while (i < numColors) {
            colors[i] = Color.getHSBColor(H, S, B);
            if ((double)(B -= delta) < 0.1) {
                B = 0.1f;
            }
            ++i;
        }
        return colors;
    }

    public static Color[] createColorMap(int numColors) {
        Color[] colors = new Color[numColors];
        float H = 1.0f;
        float S = 1.0f;
        float B = 1.0f;
        float delta = (float)(1.0 / (double)numColors);
        int i = 0;
        while (i < numColors) {
            colors[i] = Color.getHSBColor(H, S, B);
            if ((double)(H -= delta) < 0.0) {
                H = 1.0f;
            }
            ++i;
        }
        return colors;
    }

    public static Color[] createColorMap(int numEPs, int[] epMap) {
        int numSignificant = epMap.length;
        int[] weights = new int[numSignificant];
        if (numSignificant > 0) {
            int acceleration = 2;
            int increment = 7;
            weights[numSignificant - 1] = 5;
            int ep = numSignificant - 2;
            while (ep >= 0) {
                weights[ep] = weights[ep + 1] + increment;
                increment += acceleration;
                --ep;
            }
        }
        return ColorManager.createColorMap(numEPs, epMap, weights);
    }

    public static Color[] createColorMap(int numEPs, int[] epMap, int[] weights) {
        Color[] colors = new Color[numEPs];
        int numSignificant = epMap.length;
        if (numSignificant == 0) {
            return ColorManager.createColorMap(numEPs);
        }
        int total = 0;
        int ep = 0;
        while (ep < numSignificant) {
            total += weights[ep];
            ++ep;
        }
        double k = (double)weights[numSignificant - 1] / (double)total;
        int c = numEPs - numSignificant;
        double x = 1.0 / (k * (double)c + 1.0);
        if (x < 0.67) {
            x = 0.67;
        }
        double currentHue = 1.0;
        double saturation = 1.0;
        double brightness = 1.0;
        int ep2 = 0;
        while (ep2 < numSignificant) {
            colors[epMap[ep2]] = Color.getHSBColor((float)currentHue, (float)saturation, (float)brightness);
            currentHue -= (double)weights[ep2] / (double)total * x;
            ++ep2;
        }
        double delta = currentHue / (double)c;
        int ep3 = 0;
        while (ep3 < numEPs) {
            if (colors[ep3] == null) {
                colors[ep3] = Color.getHSBColor((float)currentHue, (float)saturation, (float)brightness);
                currentHue -= delta;
            }
            ++ep3;
        }
        return colors;
    }
}

