/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.Processor;
import charm.debug.fmt.PConsumer;
import charm.debug.fmt.PList;
import java.io.IOException;
import java.util.Iterator;

public class CpdUtil {
    private CcsServer ccs;

    CpdUtil(CcsServer ccs_) {
        this.ccs = ccs_;
    }

    public void abort(String problem) {
        System.out.println(problem);
        System.exit(1);
    }

    public int getListLength(String listName, int forPE) {
        try {
            int reqStr = listName.length();
            int reqLen = 4 + reqStr + 1;
            byte[] req = new byte[reqLen];
            CcsServer.writeInt(req, 0, reqStr);
            CcsServer.writeString(req, 4, reqStr + 1, listName);
            CcsServer.Request r = this.ccs.sendRequest("ccs_list_len", forPE, req);
            byte[] resp = this.ccs.recvResponse(r);
            if (resp.length < 4) {
                return -1;
            }
            return CcsServer.readInt(resp, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.abort("Network error connecting to PE " + forPE + " to access list " + listName);
            return 0;
        }
    }

    public byte[] byteList(String listName, String fmt, int forPE, int lo, int hiPlusOne, byte[] extra) {
        try {
            int reqStr = listName.length();
            int extraLen = extra != null ? extra.length : 0;
            int reqLen = 12 + extraLen + 4 + reqStr + 1;
            byte[] req = new byte[reqLen];
            System.out.println("byteList: " + lo + " " + hiPlusOne + " " + extraLen);
            for (int i = 0; i < extraLen; ++i) {
                System.out.print(extra[i]);
            }
            System.out.println("");
            CcsServer.writeInt(req, 0, lo);
            CcsServer.writeInt(req, 4, hiPlusOne);
            CcsServer.writeInt(req, 8, extraLen);
            if (extraLen > 0) {
                CcsServer.writeBytes(req, 12, extraLen, extra);
            }
            CcsServer.writeInt(req, 12 + extraLen, reqStr);
            CcsServer.writeString(req, 16 + extraLen, reqStr + 1, listName);
            CcsServer.Request r = this.ccs.sendRequest("ccs_list_items." + fmt, forPE, req);
            byte[] answer = this.ccs.recvResponse(r);
            return answer;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.abort("Network error connecting to PE " + forPE + " to access list " + listName);
            return null;
        }
    }

    public String stringList(String listName, int forPE, int lo, int hiPlusOne, byte[] extra) {
        return new String(this.byteList(listName, "txt", forPE, lo, hiPlusOne, extra));
    }

    public String stringList(String listName, int forPE, int lo, int hiPlusOne) {
        return this.stringList(listName, forPE, lo, hiPlusOne, null);
    }

    public String stringList(String listName, int forPE, byte[] extra) {
        return this.stringList(listName, forPE, 0, this.getListLength(listName, forPE), extra);
    }

    public String stringList(String listName, int forPE) {
        return this.stringList(listName, forPE, null);
    }

    public PList getPList(String listName, int forPE, int lo, int hiPlusOne, byte[] extra) {
        byte[] buf = this.byteList(listName, "fmt", forPE, lo, hiPlusOne, extra);
        PConsumer cons = new PConsumer();
        cons.decode(buf);
        return cons.getList();
    }

    public PList getPList(String listName, int forPE, int lo, int hiPlusOne) {
        return this.getPList(listName, forPE, lo, hiPlusOne, null);
    }

    public PList getPList(String listName, int forPE, byte[] extra) {
        return this.getPList(listName, forPE, 0, this.getListLength(listName, forPE), extra);
    }

    public PList getPList(String listName, int forPE) {
        return this.getPList(listName, forPE, null);
    }

    public void setListItem(String listName, int forPE, int listIdx, byte[] to) {
        try {
            int reqStr = listName.length();
            int reqLen = 12 + to.length + 4 + reqStr + 1;
            byte[] req = new byte[reqLen];
            int o = 0;
            CcsServer.writeInt(req, o, listIdx);
            CcsServer.writeInt(req, o += 4, listIdx + 1);
            CcsServer.writeInt(req, o += 4, to.length);
            o += 4;
            for (int i = 0; i < to.length; ++i) {
                req[o++] = to[i];
            }
            CcsServer.writeInt(req, o, reqStr);
            CcsServer.writeString(req, o += 4, reqStr + 1, listName);
            if ((o += reqStr + 1) != reqLen) {
                this.abort("Size mismatch during CpdList set");
            }
            CcsServer.Request r = this.ccs.sendRequest("ccs_list_items.set", forPE, req);
            this.ccs.recvResponse(r);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.abort("Network error connecting to PE " + forPE + " to write list " + listName);
        }
    }

    public String sendCcsRequest(String ccsHandlerName, String parameterName, int destPE) {
        byte[] reply = this.sendCcsRequestBytes(ccsHandlerName, parameterName, destPE);
        if (reply != null) {
            return new String(reply);
        }
        return null;
    }

    public byte[] sendCcsRequestBytes(String ccsHandlerName, String parameterName, int destPE) {
        int reqStr = parameterName.length();
        int reqLen = reqStr + 1;
        byte[] req = new byte[reqLen];
        CcsServer.writeString(req, 0, reqStr + 1, parameterName);
        boolean waiting = !parameterName.equalsIgnoreCase("freeze") && !ccsHandlerName.equalsIgnoreCase("ccs_debug_quit") && !ccsHandlerName.equalsIgnoreCase("ccs_remove_all_break_points") && !ccsHandlerName.equalsIgnoreCase("ccs_set_break_point") && !ccsHandlerName.equalsIgnoreCase("ccs_remove_break_point") && !ccsHandlerName.equalsIgnoreCase("ccs_continue_break_point");
        return this.sendCcsRequestBytes(ccsHandlerName, req, destPE, waiting);
    }

    public byte[] sendCcsRequestBytes(String ccsHandlerName, byte[] req, int destPE, boolean waitForReply) {
        try {
            CcsServer.Request r = this.ccs.sendRequest(ccsHandlerName, destPE, req);
            if (waitForReply) {
                byte[] resp = this.ccs.recvResponse(r);
                return resp;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.abort("Network error connecting to PE " + destPE + " to perform " + ccsHandlerName);
            return null;
        }
    }

    public void bcastCcsRequest(String ccsHandlerName, String parameterName, int forSelectedPes, int numberPes, boolean[] peList) {
        if (forSelectedPes <= 0) {
            for (int indexPE = 0; indexPE < numberPes; ++indexPE) {
                this.sendCcsRequest(ccsHandlerName, parameterName, indexPE);
            }
        } else {
            for (int indexPE = 0; indexPE < numberPes; ++indexPE) {
                if (!peList[indexPE]) continue;
                this.sendCcsRequest(ccsHandlerName, parameterName, indexPE);
            }
        }
    }

    public void bcastCcsRequest(String ccsHandlerName, String parameterName, Iterator peList) {
        while (peList.hasNext()) {
            this.sendCcsRequest(ccsHandlerName, parameterName, ((Processor)peList.next()).getId());
        }
    }

    public void bcastCcsRequest(String ccsHandlerName, String parameterName, int npes) {
        for (int pe = 0; pe < npes; ++pe) {
            this.sendCcsRequest(ccsHandlerName, parameterName, pe);
        }
    }
}

