/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.inspect.FunctionType;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.SuperClassElement;
import charm.debug.inspect.TypeVisitor;
import charm.debug.inspect.TypedefType;
import charm.debug.inspect.UnknownType;
import charm.debug.inspect.VariableElement;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataType
extends GenericType {
    String desc;
    Vector superclasses;
    Vector variables;
    boolean isVirtual;
    boolean isUnion;
    boolean isEnum;
    int size;
    static final Matcher functionMatcher = Pattern.compile("[^()]+ \\Q(*)(\\E.*\\)").matcher("");

    @Override
    public GenericType build(String n, String d) {
        String line;
        int opening;
        this.name = n;
        if (n == null) {
            this.name = "";
        }
        this.desc = d;
        this.isVirtual = false;
        this.isUnion = false;
        this.isEnum = false;
        this.superclasses = new Vector();
        this.variables = new Vector();
        if (this.desc == null) {
            this.desc = DataType.getDescription(this.name);
        }
        if (this.desc == null) {
            return this;
        }
        GenericType resultType = this;
        if (this.desc.indexOf("virtual") != -1) {
            this.isVirtual = true;
        }
        if ((opening = this.desc.indexOf("{")) == -1) {
            System.out.println(this.name + "|" + this.desc + "|");
            this.desc = null;
            return this;
        }
        String[] firstLine = this.desc.substring(0, opening - 1).split("\\s:\\s");
        if (firstLine.length > 2) {
            this.desc = null;
            return this;
        }
        int nameStart = firstLine[0].trim().indexOf(" ");
        String type = firstLine[0].trim();
        if (nameStart > 0) {
            type = type.substring(0, nameStart);
        }
        if (!firstLine[0].trim().substring(nameStart + 1).equals(this.name)) {
            TypedefType dt = new TypedefType();
            int endClass = this.desc.lastIndexOf("}");
            int pointers = this.desc.substring(endClass + 1).trim().length();
            dt.build(this.name, this, pointers);
            Inspector.putType(this.name, dt);
            this.name = firstLine[0].trim().substring(nameStart + 1);
            Inspector.putType(this.name, this);
            resultType = dt;
        }
        if (!type.equals("class") && !type.equals("struct")) {
            if (type.equals("union")) {
                this.isUnion = true;
            } else if (type.equals("enum")) {
                this.isEnum = true;
            } else {
                System.out.println(this.name);
                System.out.println(this.desc);
                System.out.println("The returned info is not correct, type " + type);
                this.desc = null;
                return this;
            }
        }
        if (firstLine.length == 2) {
            line = firstLine[1].trim() + ",";
            int startCut = 0;
            int templateDepth = 0;
            for (int endCut = 0; endCut < line.length(); ++endCut) {
                int offset;
                if (line.charAt(endCut) == '<') {
                    ++templateDepth;
                }
                if (line.charAt(endCut) == '>') {
                    --templateDepth;
                }
                if (line.charAt(endCut) != ',' || templateDepth != 0) continue;
                String superName = line.substring(startCut, endCut);
                if (superName.startsWith("public") || superName.startsWith("protected") || superName.startsWith("private")) {
                    superName = superName.substring(superName.indexOf(" ") + 1);
                }
                System.out.println("superName: " + superName);
                GenericType superType = Inspector.getType(superName);
                if (superType == null) {
                    superType = new DataType();
                    Inspector.putType(superName, superType);
                    superType.build(superName, DataType.getDescription(superName));
                }
                if (superType instanceof DataType) {
                    if (((DataType)superType).isVirtual) {
                        this.isVirtual = true;
                    }
                } else if (superType instanceof TypedefType && ((TypedefType)superType).isVirtual()) {
                    this.isVirtual = true;
                }
                String offsetValue = ParDebug.infoCommand("print (class " + superName + "*)((class " + this.name + "*)" + ParDebug.dataPos + ")\n");
                System.out.println("info:print (class " + superName + "*)((class " + this.name + "*)" + ParDebug.dataPos + ") = " + offsetValue);
                if (offsetValue.indexOf(" 0x") != -1) {
                    int start = offsetValue.indexOf(" 0x") + 1;
                    int end = offsetValue.indexOf(" ", start);
                    if (end == -1) {
                        end = offsetValue.length() - 1;
                    }
                    offset = Integer.decode(offsetValue.substring(start, end)) - ParDebug.dataPos;
                } else {
                    offset = -1;
                }
                this.superclasses.add(new SuperClassElement(superType, offset));
                startCut = ++endCut + 1;
            }
        }
        String[] piece = this.desc.substring(opening).split("[:;][\n\r]");
        for (int i = 1; i < piece.length - 1; ++i) {
            int offset;
            line = piece[i].trim();
            System.out.println("|" + line + "|");
            if (line.equals("public") || line.equals("protected") || line.equals("private") || line.indexOf("(") != -1 || line.indexOf("static") != -1) continue;
            if (line.startsWith("volatile")) {
                line = line.substring(9);
            }
            int variableStart = line.lastIndexOf(" ");
            int arrayStart = line.indexOf("[");
            boolean isArray = arrayStart != -1;
            int pointerCount = 0;
            while (line.charAt(variableStart + 1 + pointerCount) == '*') {
                ++pointerCount;
            }
            String varType = line.substring(0, variableStart).trim();
            if (varType.startsWith("class") || varType.startsWith("struct")) {
                varType = varType.substring(varType.indexOf(" ") + 1);
            }
            String varName = line.substring(variableStart + pointerCount + 1, isArray ? arrayStart : line.length());
            int arraySize = 0;
            if (isArray) {
                arraySize = Integer.parseInt(line.substring(arrayStart + 1, line.indexOf("]")));
            }
            System.out.println("Result: |" + varType + "|" + varName + "|" + (pointerCount > 0 ? "pointer" : "") + (isArray ? Integer.toString(arraySize) : ""));
            GenericType dt = null;
            if (varType.startsWith("{")) {
                System.out.println("Conctructing anonymous type");
                StringBuffer concatenation = new StringBuffer();
                int anonymousDepth = 1;
                int startCut = piece[i].indexOf("{");
                int j = startCut + 1;
                while (i < piece.length - 1) {
                    concatenation.append(piece[i]).append(";\n");
                    System.out.println("line: " + piece[i]);
                    while (j < concatenation.length()) {
                        if (concatenation.charAt(j) == '{') {
                            ++anonymousDepth;
                        }
                        if (concatenation.charAt(j) == '}') {
                            --anonymousDepth;
                        }
                        System.out.println("j: " + j + " val: " + concatenation.charAt(j) + " depth: " + anonymousDepth);
                        if (anonymousDepth == 0) {
                            String anonymousDesc = concatenation.substring(0, j + 1);
                            System.out.println("anon desc: " + anonymousDesc);
                            dt = new DataType();
                            dt.build("", anonymousDesc);
                            break;
                        }
                        ++j;
                    }
                    if (j < concatenation.length()) {
                        varName = concatenation.substring(j + 1, concatenation.indexOf(";", j + 1)).trim();
                        break;
                    }
                    ++i;
                }
            } else {
                dt = Inspector.getType(varType);
                if (dt == null) {
                    String varTypeDesc = DataType.getDescription(varType);
                    dt = varTypeDesc == null ? new UnknownType() : (varTypeDesc.indexOf("{") != -1 ? new DataType() : (functionMatcher.reset(varTypeDesc).matches() ? new FunctionType() : new TypedefType()));
                    Inspector.putType(varType, dt);
                    dt = dt.build(varType, varTypeDesc);
                }
            }
            String offsetValue = ParDebug.infoCommand("print &((class " + this.name + "*)" + ParDebug.dataPos + ")->" + varName + "\n");
            System.out.println("info:print &((class " + this.name + "*)" + ParDebug.dataPos + ")->" + varName + " = " + offsetValue);
            if (offsetValue.indexOf(" 0x") == -1) {
                offsetValue = ParDebug.infoCommand("print &((" + this.name + "*)" + ParDebug.dataPos + ")->" + varName + "\n");
                System.out.println("info:print &((" + this.name + "*)" + ParDebug.dataPos + ")->" + varName + " = " + offsetValue);
            }
            if (offsetValue.indexOf(" 0x") != -1) {
                int start = offsetValue.indexOf(" 0x") + 1;
                int end = offsetValue.indexOf(" ", start);
                if (end == -1) {
                    end = offsetValue.length() - 1;
                }
                offset = Integer.decode(offsetValue.substring(start, end)) - ParDebug.dataPos;
            } else {
                offset = -1;
            }
            this.variables.add(new VariableElement(dt, varName, arraySize, pointerCount, offset));
        }
        return resultType;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public int getChildren() {
        return this.superclasses.size() + this.variables.size();
    }

    @Override
    public GenericElement getChild(int i) {
        if (i >= this.superclasses.size()) {
            if ((i -= this.superclasses.size()) >= this.variables.size()) {
                return null;
            }
            return (VariableElement)this.variables.elementAt(i);
        }
        return (SuperClassElement)this.superclasses.elementAt(i);
    }

    @Override
    public String getValue(TypeVisitor v) {
        return null;
    }

    public boolean hasSuperclass(GenericType s) {
        for (int i = 0; i < this.superclasses.size(); ++i) {
            SuperClassElement sup = (SuperClassElement)this.superclasses.elementAt(i);
            if (sup.getType().equals(s)) {
                return true;
            }
            GenericType gt = sup.getType().getType();
            if (!(gt instanceof DataType) || !((DataType)gt).hasSuperclass(s)) continue;
            return true;
        }
        return false;
    }

    public int getSuperclassOffset(GenericType s) {
        for (int i = 0; i < this.superclasses.size(); ++i) {
            int result;
            SuperClassElement sup = (SuperClassElement)this.superclasses.elementAt(i);
            if (sup.getType().equals(s)) {
                return sup.getOffset();
            }
            GenericType gt = sup.getType().getType();
            if (!(gt instanceof DataType) || (result = ((DataType)gt).getSuperclassOffset(s)) < 0) continue;
            return result + sup.getOffset();
        }
        return -1;
    }

    public boolean hasVariable(String name) {
        int i;
        for (i = 0; i < this.variables.size(); ++i) {
            VariableElement el = (VariableElement)this.variables.elementAt(i);
            if (!el.getName().equals(name)) continue;
            return true;
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            SuperClassElement sup = (SuperClassElement)this.superclasses.elementAt(i);
            GenericType gt = sup.getType().getType();
            if (!(gt instanceof DataType) || !((DataType)gt).hasVariable(name)) continue;
            return true;
        }
        return false;
    }

    public int getVariableOffset(String name) {
        int i;
        for (i = 0; i < this.variables.size(); ++i) {
            VariableElement el = (VariableElement)this.variables.elementAt(i);
            if (!el.getName().equals(name)) continue;
            return el.getOffset();
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            int result;
            SuperClassElement sup = (SuperClassElement)this.superclasses.elementAt(i);
            GenericType gt = sup.getType().getType();
            if (!(gt instanceof DataType) || (result = ((DataType)gt).getVariableOffset(name)) < 0) continue;
            return result + sup.getOffset();
        }
        return -1;
    }

    public GenericType getVariableType(String name) {
        int i;
        for (i = 0; i < this.variables.size(); ++i) {
            VariableElement el = (VariableElement)this.variables.elementAt(i);
            if (!el.getName().equals(name)) continue;
            return el.getType();
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            GenericType result;
            SuperClassElement sup = (SuperClassElement)this.superclasses.elementAt(i);
            GenericType gt = sup.getType().getType();
            if (!(gt instanceof DataType) || (result = ((DataType)gt).getVariableType(name)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String toString(String ind) {
        int i;
        if (this.name == null) {
            return "";
        }
        if (this.desc == null) {
            return "(no info available)";
        }
        StringBuffer buf = new StringBuffer();
        if (this.isEnum) {
            return "enum " + this.name;
        }
        String indent = "  " + ind;
        if (this.isUnion) {
            buf.append("union ");
        } else {
            buf.append("class ");
        }
        buf.append(this.name).append(" {\n");
        if (this.isVirtual) {
            buf.append(indent).append("(virtual)").append("\n");
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            buf.append(indent).append("super ").append(((SuperClassElement)this.superclasses.elementAt(i)).toString(indent)).append("\n");
        }
        for (i = 0; i < this.variables.size(); ++i) {
            buf.append(indent).append(((VariableElement)this.variables.elementAt(i)).toString(indent)).append("\n");
        }
        buf.append(ind).append("}");
        return buf.toString();
    }

    @Override
    public String memoryToString(String ind, ByteBuffer mem, int start) {
        int i;
        if (this.name == null) {
            return "?";
        }
        if (this.desc == null) {
            return "(no info available)";
        }
        System.out.println(this.name + " start = " + start);
        StringBuffer buf = new StringBuffer();
        String indent = "  " + ind;
        buf.append("{\n");
        if (this.isVirtual) {
            buf.append(indent).append("virtual table: ").append(DataType.printPointer(mem, start)).append("\n");
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            buf.append(indent).append("super ").append(((SuperClassElement)this.superclasses.elementAt(i)).memoryToString(indent, mem, start)).append("\n");
        }
        for (i = 0; i < this.variables.size(); ++i) {
            buf.append(indent).append(((VariableElement)this.variables.elementAt(i)).memoryToString(indent, mem, start)).append("\n");
        }
        if (this.isEnum) {
            buf.append(indent).append("enum\n");
        }
        buf.append(ind).append("}");
        return buf.toString();
    }

    @Override
    public void visit(TypeVisitor v) {
        int i;
        if (this.name == null || this.desc == null) {
            return;
        }
        v.push();
        if (this.isVirtual) {
            v.addType("virtual table");
            v.addValue(v.printPointer());
        }
        for (i = 0; i < this.superclasses.size(); ++i) {
            ((SuperClassElement)this.superclasses.elementAt(i)).visit(v);
        }
        for (i = 0; i < this.variables.size(); ++i) {
            ((VariableElement)this.variables.elementAt(i)).visit(v);
        }
        v.pop();
    }
}

