/* DEFS: message KMeansStatsMessage{
bool filter[];
double kSeedsPos[];
double stats[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_KMeansStatsMessage::operator new(size_t s){
  return KMeansStatsMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_KMeansStatsMessage::operator new(size_t s, int* sz){
  return KMeansStatsMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_KMeansStatsMessage::operator new(size_t s, int* sz,const int pb){
  return KMeansStatsMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_KMeansStatsMessage::operator new(size_t s, int sz0, int sz1, int sz2) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return KMeansStatsMessage::alloc(__idx, s, sizes, 0);
}
void *CMessage_KMeansStatsMessage::operator new(size_t s, int sz0, int sz1, int sz2, const int p) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return KMeansStatsMessage::alloc(__idx, s, sizes, p);
}
void* CMessage_KMeansStatsMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[4];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(bool)*sizes[0]);
  if(sizes==0)
    offsets[2] = offsets[0];
  else
    offsets[2] = offsets[1] + ALIGN8(sizeof(double)*sizes[1]);
  if(sizes==0)
    offsets[3] = offsets[0];
  else
    offsets[3] = offsets[2] + ALIGN8(sizeof(double)*sizes[2]);
  KMeansStatsMessage *newmsg = (KMeansStatsMessage *) CkAllocMsg(msgnum, offsets[3], pb);
  newmsg->filter = (bool *) ((char *)newmsg + offsets[0]);
  newmsg->kSeedsPos = (double *) ((char *)newmsg + offsets[1]);
  newmsg->stats = (double *) ((char *)newmsg + offsets[2]);
  return (void *) newmsg;
}
void CMessage_KMeansStatsMessage::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_KMeansStatsMessage::pack(KMeansStatsMessage *msg) {
  msg->filter = (bool *) ((char *)msg->filter - (char *)msg);
  msg->kSeedsPos = (double *) ((char *)msg->kSeedsPos - (char *)msg);
  msg->stats = (double *) ((char *)msg->stats - (char *)msg);
  return (void *) msg;
}
KMeansStatsMessage* CMessage_KMeansStatsMessage::unpack(void* buf) {
  KMeansStatsMessage *msg = (KMeansStatsMessage *) buf;
  msg->filter = (bool *) ((size_t)msg->filter + (char *)msg);
  msg->kSeedsPos = (double *) ((size_t)msg->kSeedsPos + (char *)msg);
  msg->stats = (double *) ((size_t)msg->stats + (char *)msg);
  return msg;
}
int CMessage_KMeansStatsMessage::__idx=0;
#endif

/* DEFS: message KSeedsMessage{
double kSeedsPos[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_KSeedsMessage::operator new(size_t s){
  return KSeedsMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_KSeedsMessage::operator new(size_t s, int* sz){
  return KSeedsMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_KSeedsMessage::operator new(size_t s, int* sz,const int pb){
  return KSeedsMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_KSeedsMessage::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return KSeedsMessage::alloc(__idx, s, sizes, 0);
}
void *CMessage_KSeedsMessage::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return KSeedsMessage::alloc(__idx, s, sizes, p);
}
void* CMessage_KSeedsMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(double)*sizes[0]);
  KSeedsMessage *newmsg = (KSeedsMessage *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->kSeedsPos = (double *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void CMessage_KSeedsMessage::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_KSeedsMessage::pack(KSeedsMessage *msg) {
  msg->kSeedsPos = (double *) ((char *)msg->kSeedsPos - (char *)msg);
  return (void *) msg;
}
KSeedsMessage* CMessage_KSeedsMessage::unpack(void* buf) {
  KSeedsMessage *msg = (KSeedsMessage *) buf;
  msg->kSeedsPos = (double *) ((size_t)msg->kSeedsPos + (char *)msg);
  return msg;
}
int CMessage_KSeedsMessage::__idx=0;
#endif

/* DEFS: message KSelectionMessage{
int minIDs[];
int maxIDs[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_KSelectionMessage::operator new(size_t s){
  return KSelectionMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_KSelectionMessage::operator new(size_t s, int* sz){
  return KSelectionMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_KSelectionMessage::operator new(size_t s, int* sz,const int pb){
  return KSelectionMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_KSelectionMessage::operator new(size_t s, int sz0, int sz1) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return KSelectionMessage::alloc(__idx, s, sizes, 0);
}
void *CMessage_KSelectionMessage::operator new(size_t s, int sz0, int sz1, const int p) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return KSelectionMessage::alloc(__idx, s, sizes, p);
}
void* CMessage_KSelectionMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[3];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(int)*sizes[0]);
  if(sizes==0)
    offsets[2] = offsets[0];
  else
    offsets[2] = offsets[1] + ALIGN8(sizeof(int)*sizes[1]);
  KSelectionMessage *newmsg = (KSelectionMessage *) CkAllocMsg(msgnum, offsets[2], pb);
  newmsg->minIDs = (int *) ((char *)newmsg + offsets[0]);
  newmsg->maxIDs = (int *) ((char *)newmsg + offsets[1]);
  return (void *) newmsg;
}
void CMessage_KSelectionMessage::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_KSelectionMessage::pack(KSelectionMessage *msg) {
  msg->minIDs = (int *) ((char *)msg->minIDs - (char *)msg);
  msg->maxIDs = (int *) ((char *)msg->maxIDs - (char *)msg);
  return (void *) msg;
}
KSelectionMessage* CMessage_KSelectionMessage::unpack(void* buf) {
  KSelectionMessage *msg = (KSelectionMessage *) buf;
  msg->minIDs = (int *) ((size_t)msg->minIDs + (char *)msg);
  msg->maxIDs = (int *) ((size_t)msg->maxIDs + (char *)msg);
  return msg;
}
int CMessage_KSelectionMessage::__idx=0;
#endif

/* DEFS: mainchare TraceProjectionsInit: Chare{
TraceProjectionsInit(CkArgMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_TraceProjectionsInit::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: TraceProjectionsInit(CkArgMsg* impl_msg);
 */
CkChareID CProxy_TraceProjectionsInit::ckNew(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  return impl_ret;
}
void CProxy_TraceProjectionsInit::ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int impl_onPE)
{
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, pcid, impl_onPE);
}
  CProxy_TraceProjectionsInit::CProxy_TraceProjectionsInit(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_TraceProjectionsInit::__idx, CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  ckSetChareID(impl_ret);
}
 int CkIndex_TraceProjectionsInit::__idx_TraceProjectionsInit_CkArgMsg=0;
void CkIndex_TraceProjectionsInit::_call_TraceProjectionsInit_CkArgMsg(void* impl_msg,TraceProjectionsInit * impl_obj)
{
  new (impl_obj) TraceProjectionsInit((CkArgMsg*)impl_msg);
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_TraceProjectionsInit::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeMainChare);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_Chare::__idx);
// REG: TraceProjectionsInit(CkArgMsg* impl_msg);
  __idx_TraceProjectionsInit_CkArgMsg = CkRegisterEp("TraceProjectionsInit(CkArgMsg* impl_msg)",
     (CkCallFnPtr)_call_TraceProjectionsInit_CkArgMsg, CMessage_CkArgMsg::__idx, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMainChare(__idx, __idx_TraceProjectionsInit_CkArgMsg);

}
#endif



/* DEFS: readonly CkGroupID traceProjectionsGID;
 */
extern CkGroupID traceProjectionsGID;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_traceProjectionsGID(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|traceProjectionsGID;
}
#endif

/* DEFS: readonly CkGroupID kMeansGID;
 */
extern CkGroupID kMeansGID;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_kMeansGID(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|kMeansGID;
}
#endif

/* DEFS: group KMeansBOC: IrrGroup{
KMeansBOC(CkMigrateMessage* impl_msg);
KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
void startKMeansAnalysis(void);
void flushCheck(CkReductionMsg* impl_msg);
void flushCheckDone(void);
void getNextPhaseMetrics(void);
void globalMetricRefinement(CkReductionMsg* impl_msg);
void findInitialClusters(KMeansStatsMessage* impl_msg);
void updateKSeeds(CkReductionMsg* impl_msg);
void updateSeedMembership(KSeedsMessage* impl_msg);
void collectDistances(KSelectionMessage* impl_msg);
void findNextMinMax(CkReductionMsg* impl_msg);
void phaseDone(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_KMeansBOC::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: KMeansBOC(CkMigrateMessage* impl_msg);
 */

/* DEFS: KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
 */

/* DEFS: void startKMeansAnalysis(void);
 */
void CProxyElement_KMeansBOC::startKMeansAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void flushCheck(CkReductionMsg* impl_msg);
 */
void CProxyElement_KMeansBOC::flushCheck(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void flushCheckDone(void);
 */
void CProxyElement_KMeansBOC::flushCheckDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void getNextPhaseMetrics(void);
 */
void CProxyElement_KMeansBOC::getNextPhaseMetrics(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void globalMetricRefinement(CkReductionMsg* impl_msg);
 */
void CProxyElement_KMeansBOC::globalMetricRefinement(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void findInitialClusters(KMeansStatsMessage* impl_msg);
 */
void CProxyElement_KMeansBOC::findInitialClusters(KMeansStatsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void updateKSeeds(CkReductionMsg* impl_msg);
 */
void CProxyElement_KMeansBOC::updateKSeeds(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void updateSeedMembership(KSeedsMessage* impl_msg);
 */
void CProxyElement_KMeansBOC::updateSeedMembership(KSeedsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void collectDistances(KSelectionMessage* impl_msg);
 */
void CProxyElement_KMeansBOC::collectDistances(KSelectionMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void findNextMinMax(CkReductionMsg* impl_msg);
 */
void CProxyElement_KMeansBOC::findNextMinMax(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void phaseDone(void);
 */
void CProxyElement_KMeansBOC::phaseDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: KMeansBOC(CkMigrateMessage* impl_msg);
 */
 int CkIndex_KMeansBOC::__idx_KMeansBOC_CkMigrateMessage=0;
void CkIndex_KMeansBOC::_call_KMeansBOC_CkMigrateMessage(void* impl_msg,KMeansBOC * impl_obj)
{
  new (impl_obj) KMeansBOC((CkMigrateMessage*)impl_msg);
}

/* DEFS: KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
 */
CkGroupID CProxy_KMeansBOC::ckNew(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    implP|impl_noname_3;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_4;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    implP|impl_noname_3;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_4;
  }
  return CkCreateGroup(CkIndex_KMeansBOC::__idx, CkIndex_KMeansBOC::__idx_KMeansBOC_marshall1, impl_msg);
}
  CProxy_KMeansBOC::CProxy_KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    implP|impl_noname_3;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_4;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    implP|impl_noname_3;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_4;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_KMeansBOC::__idx, CkIndex_KMeansBOC::__idx_KMeansBOC_marshall1, impl_msg));
}
 int CkIndex_KMeansBOC::__idx_KMeansBOC_marshall1=0;
void CkIndex_KMeansBOC::_call_KMeansBOC_marshall1(void* impl_msg,KMeansBOC * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  double impl_noname_3; implP|impl_noname_3;
  bool impl_noname_4; implP|impl_noname_4;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) KMeansBOC(impl_noname_0, impl_noname_1, impl_noname_2, impl_noname_3, impl_noname_4);
}
int CkIndex_KMeansBOC::_callmarshall_KMeansBOC_marshall1(char* impl_buf,KMeansBOC * impl_obj) {
  /*Unmarshall pup'd fields: const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  double impl_noname_3; implP|impl_noname_3;
  bool impl_noname_4; implP|impl_noname_4;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) KMeansBOC(impl_noname_0, impl_noname_1, impl_noname_2, impl_noname_3, impl_noname_4);
  return implP.size();
}
void CkIndex_KMeansBOC::_marshallmessagepup_KMeansBOC_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  double impl_noname_3; implP|impl_noname_3;
  bool impl_noname_4; implP|impl_noname_4;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("impl_noname_0");
  implDestP|impl_noname_0;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_1");
  implDestP|impl_noname_1;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_2");
  implDestP|impl_noname_2;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_3");
  implDestP|impl_noname_3;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_4");
  implDestP|impl_noname_4;
}

/* DEFS: void startKMeansAnalysis(void);
 */
void CProxy_KMeansBOC::startKMeansAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::startKMeansAnalysis(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void=0;
void CkIndex_KMeansBOC::_call_startKMeansAnalysis_void(void* impl_msg,KMeansBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->startKMeansAnalysis();
}

/* DEFS: void flushCheck(CkReductionMsg* impl_msg);
 */
void CProxy_KMeansBOC::flushCheck(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::flushCheck(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg=0;
void CkIndex_KMeansBOC::_call_flushCheck_CkReductionMsg(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->flushCheck((CkReductionMsg*)impl_msg);
}

/* DEFS: void flushCheckDone(void);
 */
void CProxy_KMeansBOC::flushCheckDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::flushCheckDone(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_flushCheckDone_void=0;
void CkIndex_KMeansBOC::_call_flushCheckDone_void(void* impl_msg,KMeansBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->flushCheckDone();
}

/* DEFS: void getNextPhaseMetrics(void);
 */
void CProxy_KMeansBOC::getNextPhaseMetrics(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::getNextPhaseMetrics(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void=0;
void CkIndex_KMeansBOC::_call_getNextPhaseMetrics_void(void* impl_msg,KMeansBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->getNextPhaseMetrics();
}

/* DEFS: void globalMetricRefinement(CkReductionMsg* impl_msg);
 */
void CProxy_KMeansBOC::globalMetricRefinement(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::globalMetricRefinement(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg=0;
void CkIndex_KMeansBOC::_call_globalMetricRefinement_CkReductionMsg(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->globalMetricRefinement((CkReductionMsg*)impl_msg);
}

/* DEFS: void findInitialClusters(KMeansStatsMessage* impl_msg);
 */
void CProxy_KMeansBOC::findInitialClusters(KMeansStatsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::findInitialClusters(KMeansStatsMessage* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage=0;
void CkIndex_KMeansBOC::_call_findInitialClusters_KMeansStatsMessage(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->findInitialClusters((KMeansStatsMessage*)impl_msg);
}

/* DEFS: void updateKSeeds(CkReductionMsg* impl_msg);
 */
void CProxy_KMeansBOC::updateKSeeds(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::updateKSeeds(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg=0;
void CkIndex_KMeansBOC::_call_updateKSeeds_CkReductionMsg(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->updateKSeeds((CkReductionMsg*)impl_msg);
}

/* DEFS: void updateSeedMembership(KSeedsMessage* impl_msg);
 */
void CProxy_KMeansBOC::updateSeedMembership(KSeedsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::updateSeedMembership(KSeedsMessage* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage=0;
void CkIndex_KMeansBOC::_call_updateSeedMembership_KSeedsMessage(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->updateSeedMembership((KSeedsMessage*)impl_msg);
}

/* DEFS: void collectDistances(KSelectionMessage* impl_msg);
 */
void CProxy_KMeansBOC::collectDistances(KSelectionMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::collectDistances(KSelectionMessage* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage=0;
void CkIndex_KMeansBOC::_call_collectDistances_KSelectionMessage(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->collectDistances((KSelectionMessage*)impl_msg);
}

/* DEFS: void findNextMinMax(CkReductionMsg* impl_msg);
 */
void CProxy_KMeansBOC::findNextMinMax(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::findNextMinMax(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg=0;
void CkIndex_KMeansBOC::_call_findNextMinMax_CkReductionMsg(void* impl_msg,KMeansBOC * impl_obj)
{
  impl_obj->findNextMinMax((CkReductionMsg*)impl_msg);
}

/* DEFS: void phaseDone(void);
 */
void CProxy_KMeansBOC::phaseDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_KMeansBOC::phaseDone(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_KMeansBOC::__idx_phaseDone_void=0;
void CkIndex_KMeansBOC::_call_phaseDone_void(void* impl_msg,KMeansBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->phaseDone();
}

/* DEFS: KMeansBOC(CkMigrateMessage* impl_msg);
 */

/* DEFS: KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
 */

/* DEFS: void startKMeansAnalysis(void);
 */
void CProxySection_KMeansBOC::startKMeansAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_startKMeansAnalysis_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void flushCheck(CkReductionMsg* impl_msg);
 */
void CProxySection_KMeansBOC::flushCheck(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_flushCheck_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void flushCheckDone(void);
 */
void CProxySection_KMeansBOC::flushCheckDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_flushCheckDone_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void getNextPhaseMetrics(void);
 */
void CProxySection_KMeansBOC::getNextPhaseMetrics(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_getNextPhaseMetrics_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void globalMetricRefinement(CkReductionMsg* impl_msg);
 */
void CProxySection_KMeansBOC::globalMetricRefinement(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_globalMetricRefinement_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void findInitialClusters(KMeansStatsMessage* impl_msg);
 */
void CProxySection_KMeansBOC::findInitialClusters(KMeansStatsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_findInitialClusters_KMeansStatsMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void updateKSeeds(CkReductionMsg* impl_msg);
 */
void CProxySection_KMeansBOC::updateKSeeds(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_updateKSeeds_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void updateSeedMembership(KSeedsMessage* impl_msg);
 */
void CProxySection_KMeansBOC::updateSeedMembership(KSeedsMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_updateSeedMembership_KSeedsMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void collectDistances(KSelectionMessage* impl_msg);
 */
void CProxySection_KMeansBOC::collectDistances(KSelectionMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_collectDistances_KSelectionMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void findNextMinMax(CkReductionMsg* impl_msg);
 */
void CProxySection_KMeansBOC::findNextMinMax(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_findNextMinMax_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void phaseDone(void);
 */
void CProxySection_KMeansBOC::phaseDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_KMeansBOC::__idx_phaseDone_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_KMeansBOC::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,KMeansBOC::isIrreducible());
// REG: KMeansBOC(CkMigrateMessage* impl_msg);
  __idx_KMeansBOC_CkMigrateMessage = CkRegisterEp("KMeansBOC(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_KMeansBOC_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_KMeansBOC_CkMigrateMessage);

// REG: KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
  __idx_KMeansBOC_marshall1 = CkRegisterEp("KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4)",
     (CkCallFnPtr)_call_KMeansBOC_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_KMeansBOC_marshall1,(CkMarshallUnpackFn)_callmarshall_KMeansBOC_marshall1);
  CkRegisterMessagePupFn(__idx_KMeansBOC_marshall1,(CkMessagePupFn)_marshallmessagepup_KMeansBOC_marshall1);

// REG: void startKMeansAnalysis(void);
  __idx_startKMeansAnalysis_void = CkRegisterEp("startKMeansAnalysis(void)",
     (CkCallFnPtr)_call_startKMeansAnalysis_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void flushCheck(CkReductionMsg* impl_msg);
  __idx_flushCheck_CkReductionMsg = CkRegisterEp("flushCheck(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_flushCheck_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void flushCheckDone(void);
  __idx_flushCheckDone_void = CkRegisterEp("flushCheckDone(void)",
     (CkCallFnPtr)_call_flushCheckDone_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void getNextPhaseMetrics(void);
  __idx_getNextPhaseMetrics_void = CkRegisterEp("getNextPhaseMetrics(void)",
     (CkCallFnPtr)_call_getNextPhaseMetrics_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void globalMetricRefinement(CkReductionMsg* impl_msg);
  __idx_globalMetricRefinement_CkReductionMsg = CkRegisterEp("globalMetricRefinement(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_globalMetricRefinement_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void findInitialClusters(KMeansStatsMessage* impl_msg);
  __idx_findInitialClusters_KMeansStatsMessage = CkRegisterEp("findInitialClusters(KMeansStatsMessage* impl_msg)",
     (CkCallFnPtr)_call_findInitialClusters_KMeansStatsMessage, CMessage_KMeansStatsMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void updateKSeeds(CkReductionMsg* impl_msg);
  __idx_updateKSeeds_CkReductionMsg = CkRegisterEp("updateKSeeds(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_updateKSeeds_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void updateSeedMembership(KSeedsMessage* impl_msg);
  __idx_updateSeedMembership_KSeedsMessage = CkRegisterEp("updateSeedMembership(KSeedsMessage* impl_msg)",
     (CkCallFnPtr)_call_updateSeedMembership_KSeedsMessage, CMessage_KSeedsMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void collectDistances(KSelectionMessage* impl_msg);
  __idx_collectDistances_KSelectionMessage = CkRegisterEp("collectDistances(KSelectionMessage* impl_msg)",
     (CkCallFnPtr)_call_collectDistances_KSelectionMessage, CMessage_KSelectionMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void findNextMinMax(CkReductionMsg* impl_msg);
  __idx_findNextMinMax_CkReductionMsg = CkRegisterEp("findNextMinMax(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_findNextMinMax_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void phaseDone(void);
  __idx_phaseDone_void = CkRegisterEp("phaseDone(void)",
     (CkCallFnPtr)_call_phaseDone_void, 0, __idx, 0+CK_EP_INTRINSIC);

}
#endif

/* DEFS: group TraceProjectionsBOC: IrrGroup{
TraceProjectionsBOC(CkMigrateMessage* impl_msg);
TraceProjectionsBOC(const bool &impl_noname_5);
void traceProjectionsParallelShutdown(void);
void startEndTimeAnalysis(void);
void endTimeDone(CkReductionMsg* impl_msg);
void kMeansDone(void);
void kMeansDone(CkReductionMsg* impl_msg);
void finalize(void);
void closingTraces(void);
void closeParallelShutdown(CkReductionMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_TraceProjectionsBOC::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
 */

/* DEFS: TraceProjectionsBOC(const bool &impl_noname_5);
 */

/* DEFS: void traceProjectionsParallelShutdown(void);
 */
void CProxyElement_TraceProjectionsBOC::traceProjectionsParallelShutdown(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void startEndTimeAnalysis(void);
 */
void CProxyElement_TraceProjectionsBOC::startEndTimeAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void endTimeDone(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::endTimeDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void kMeansDone(void);
 */
void CProxyElement_TraceProjectionsBOC::kMeansDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void kMeansDone(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::kMeansDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void finalize(void);
 */
void CProxyElement_TraceProjectionsBOC::finalize(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void closingTraces(void);
 */
void CProxyElement_TraceProjectionsBOC::closingTraces(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void closeParallelShutdown(CkReductionMsg* impl_msg);
 */
void CProxyElement_TraceProjectionsBOC::closeParallelShutdown(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
 */
 int CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_CkMigrateMessage=0;
void CkIndex_TraceProjectionsBOC::_call_TraceProjectionsBOC_CkMigrateMessage(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  new (impl_obj) TraceProjectionsBOC((CkMigrateMessage*)impl_msg);
}

/* DEFS: TraceProjectionsBOC(const bool &impl_noname_5);
 */
CkGroupID CProxy_TraceProjectionsBOC::ckNew(const bool &impl_noname_5, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const bool &impl_noname_5
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_5;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_5;
  }
  return CkCreateGroup(CkIndex_TraceProjectionsBOC::__idx, CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_marshall1, impl_msg);
}
  CProxy_TraceProjectionsBOC::CProxy_TraceProjectionsBOC(const bool &impl_noname_5, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const bool &impl_noname_5
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_5;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(bool &)impl_noname_5;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_TraceProjectionsBOC::__idx, CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_marshall1, impl_msg));
}
 int CkIndex_TraceProjectionsBOC::__idx_TraceProjectionsBOC_marshall1=0;
void CkIndex_TraceProjectionsBOC::_call_TraceProjectionsBOC_marshall1(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const bool &impl_noname_5*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_5; implP|impl_noname_5;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) TraceProjectionsBOC(impl_noname_5);
}
int CkIndex_TraceProjectionsBOC::_callmarshall_TraceProjectionsBOC_marshall1(char* impl_buf,TraceProjectionsBOC * impl_obj) {
  /*Unmarshall pup'd fields: const bool &impl_noname_5*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_5; implP|impl_noname_5;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) TraceProjectionsBOC(impl_noname_5);
  return implP.size();
}
void CkIndex_TraceProjectionsBOC::_marshallmessagepup_TraceProjectionsBOC_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const bool &impl_noname_5*/
  PUP::fromMem implP(impl_buf);
  bool impl_noname_5; implP|impl_noname_5;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("impl_noname_5");
  implDestP|impl_noname_5;
}

/* DEFS: void traceProjectionsParallelShutdown(void);
 */
void CProxy_TraceProjectionsBOC::traceProjectionsParallelShutdown(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::traceProjectionsParallelShutdown(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void=0;
void CkIndex_TraceProjectionsBOC::_call_traceProjectionsParallelShutdown_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->traceProjectionsParallelShutdown();
}

/* DEFS: void startEndTimeAnalysis(void);
 */
void CProxy_TraceProjectionsBOC::startEndTimeAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::startEndTimeAnalysis(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void=0;
void CkIndex_TraceProjectionsBOC::_call_startEndTimeAnalysis_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->startEndTimeAnalysis();
}

/* DEFS: void endTimeDone(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::endTimeDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::endTimeDone(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_endTimeDone_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->endTimeDone((CkReductionMsg*)impl_msg);
}

/* DEFS: void kMeansDone(void);
 */
void CProxy_TraceProjectionsBOC::kMeansDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::kMeansDone(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void=0;
void CkIndex_TraceProjectionsBOC::_call_kMeansDone_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->kMeansDone();
}

/* DEFS: void kMeansDone(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::kMeansDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::kMeansDone(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_kMeansDone_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->kMeansDone((CkReductionMsg*)impl_msg);
}

/* DEFS: void finalize(void);
 */
void CProxy_TraceProjectionsBOC::finalize(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::finalize(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_finalize_void=0;
void CkIndex_TraceProjectionsBOC::_call_finalize_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->finalize();
}

/* DEFS: void closingTraces(void);
 */
void CProxy_TraceProjectionsBOC::closingTraces(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::closingTraces(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_closingTraces_void=0;
void CkIndex_TraceProjectionsBOC::_call_closingTraces_void(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->closingTraces();
}

/* DEFS: void closeParallelShutdown(CkReductionMsg* impl_msg);
 */
void CProxy_TraceProjectionsBOC::closeParallelShutdown(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_TraceProjectionsBOC::closeParallelShutdown(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg=0;
void CkIndex_TraceProjectionsBOC::_call_closeParallelShutdown_CkReductionMsg(void* impl_msg,TraceProjectionsBOC * impl_obj)
{
  impl_obj->closeParallelShutdown((CkReductionMsg*)impl_msg);
}

/* DEFS: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
 */

/* DEFS: TraceProjectionsBOC(const bool &impl_noname_5);
 */

/* DEFS: void traceProjectionsParallelShutdown(void);
 */
void CProxySection_TraceProjectionsBOC::traceProjectionsParallelShutdown(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_traceProjectionsParallelShutdown_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void startEndTimeAnalysis(void);
 */
void CProxySection_TraceProjectionsBOC::startEndTimeAnalysis(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_startEndTimeAnalysis_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void endTimeDone(CkReductionMsg* impl_msg);
 */
void CProxySection_TraceProjectionsBOC::endTimeDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_endTimeDone_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void kMeansDone(void);
 */
void CProxySection_TraceProjectionsBOC::kMeansDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void kMeansDone(CkReductionMsg* impl_msg);
 */
void CProxySection_TraceProjectionsBOC::kMeansDone(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_kMeansDone_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void finalize(void);
 */
void CProxySection_TraceProjectionsBOC::finalize(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_finalize_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void closingTraces(void);
 */
void CProxySection_TraceProjectionsBOC::closingTraces(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_closingTraces_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void closeParallelShutdown(CkReductionMsg* impl_msg);
 */
void CProxySection_TraceProjectionsBOC::closeParallelShutdown(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_TraceProjectionsBOC::__idx_closeParallelShutdown_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_TraceProjectionsBOC::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,TraceProjectionsBOC::isIrreducible());
// REG: TraceProjectionsBOC(CkMigrateMessage* impl_msg);
  __idx_TraceProjectionsBOC_CkMigrateMessage = CkRegisterEp("TraceProjectionsBOC(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_TraceProjectionsBOC_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_TraceProjectionsBOC_CkMigrateMessage);

// REG: TraceProjectionsBOC(const bool &impl_noname_5);
  __idx_TraceProjectionsBOC_marshall1 = CkRegisterEp("TraceProjectionsBOC(const bool &impl_noname_5)",
     (CkCallFnPtr)_call_TraceProjectionsBOC_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_TraceProjectionsBOC_marshall1,(CkMarshallUnpackFn)_callmarshall_TraceProjectionsBOC_marshall1);
  CkRegisterMessagePupFn(__idx_TraceProjectionsBOC_marshall1,(CkMessagePupFn)_marshallmessagepup_TraceProjectionsBOC_marshall1);

// REG: void traceProjectionsParallelShutdown(void);
  __idx_traceProjectionsParallelShutdown_void = CkRegisterEp("traceProjectionsParallelShutdown(void)",
     (CkCallFnPtr)_call_traceProjectionsParallelShutdown_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void startEndTimeAnalysis(void);
  __idx_startEndTimeAnalysis_void = CkRegisterEp("startEndTimeAnalysis(void)",
     (CkCallFnPtr)_call_startEndTimeAnalysis_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void endTimeDone(CkReductionMsg* impl_msg);
  __idx_endTimeDone_CkReductionMsg = CkRegisterEp("endTimeDone(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_endTimeDone_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void kMeansDone(void);
  __idx_kMeansDone_void = CkRegisterEp("kMeansDone(void)",
     (CkCallFnPtr)_call_kMeansDone_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void kMeansDone(CkReductionMsg* impl_msg);
  __idx_kMeansDone_CkReductionMsg = CkRegisterEp("kMeansDone(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_kMeansDone_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void finalize(void);
  __idx_finalize_void = CkRegisterEp("finalize(void)",
     (CkCallFnPtr)_call_finalize_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void closingTraces(void);
  __idx_closingTraces_void = CkRegisterEp("closingTraces(void)",
     (CkCallFnPtr)_call_closingTraces_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void closeParallelShutdown(CkReductionMsg* impl_msg);
  __idx_closeParallelShutdown_CkReductionMsg = CkRegisterEp("closeParallelShutdown(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_closeParallelShutdown_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_INTRINSIC);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerTraceProjections(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message KMeansStatsMessage{
bool filter[];
double kSeedsPos[];
double stats[];
}
;
*/
CMessage_KMeansStatsMessage::__register("KMeansStatsMessage", sizeof(KMeansStatsMessage),(CkPackFnPtr) KMeansStatsMessage::pack,(CkUnpackFnPtr) KMeansStatsMessage::unpack);

/* REG: message KSeedsMessage{
double kSeedsPos[];
}
;
*/
CMessage_KSeedsMessage::__register("KSeedsMessage", sizeof(KSeedsMessage),(CkPackFnPtr) KSeedsMessage::pack,(CkUnpackFnPtr) KSeedsMessage::unpack);

/* REG: message KSelectionMessage{
int minIDs[];
int maxIDs[];
}
;
*/
CMessage_KSelectionMessage::__register("KSelectionMessage", sizeof(KSelectionMessage),(CkPackFnPtr) KSelectionMessage::pack,(CkUnpackFnPtr) KSelectionMessage::unpack);

/* REG: mainchare TraceProjectionsInit: Chare{
TraceProjectionsInit(CkArgMsg* impl_msg);
};
*/
  CkIndex_TraceProjectionsInit::__register("TraceProjectionsInit", sizeof(TraceProjectionsInit));

      _registerInitCall(registerOutlierReduction,0);

      _registerInitCall(initTraceProjectionsBOC,1);

  CkRegisterReadonly("traceProjectionsGID","CkGroupID",sizeof(traceProjectionsGID),(void *) &traceProjectionsGID,__xlater_roPup_traceProjectionsGID);

  CkRegisterReadonly("kMeansGID","CkGroupID",sizeof(kMeansGID),(void *) &kMeansGID,__xlater_roPup_kMeansGID);

/* REG: group KMeansBOC: IrrGroup{
KMeansBOC(CkMigrateMessage* impl_msg);
KMeansBOC(const bool &impl_noname_0, int impl_noname_1, int impl_noname_2, double impl_noname_3, const bool &impl_noname_4);
void startKMeansAnalysis(void);
void flushCheck(CkReductionMsg* impl_msg);
void flushCheckDone(void);
void getNextPhaseMetrics(void);
void globalMetricRefinement(CkReductionMsg* impl_msg);
void findInitialClusters(KMeansStatsMessage* impl_msg);
void updateKSeeds(CkReductionMsg* impl_msg);
void updateSeedMembership(KSeedsMessage* impl_msg);
void collectDistances(KSelectionMessage* impl_msg);
void findNextMinMax(CkReductionMsg* impl_msg);
void phaseDone(void);
};
*/
  CkIndex_KMeansBOC::__register("KMeansBOC", sizeof(KMeansBOC));

/* REG: group TraceProjectionsBOC: IrrGroup{
TraceProjectionsBOC(CkMigrateMessage* impl_msg);
TraceProjectionsBOC(const bool &impl_noname_5);
void traceProjectionsParallelShutdown(void);
void startEndTimeAnalysis(void);
void endTimeDone(CkReductionMsg* impl_msg);
void kMeansDone(void);
void kMeansDone(CkReductionMsg* impl_msg);
void finalize(void);
void closingTraces(void);
void closeParallelShutdown(CkReductionMsg* impl_msg);
};
*/
  CkIndex_TraceProjectionsBOC::__register("TraceProjectionsBOC", sizeof(TraceProjectionsBOC));

}
#endif
