/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestTreeGrammarRewriteAST
extends BaseTest {
    protected boolean debug = false;

    public void testFlatList() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID INT -> INT ID\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34 abc\n", (String)string3);
    }

    public void testSimpleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID INT) -> ^(INT ID)\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(34 abc)\n", (String)string3);
    }

    public void testNonImaginaryWithCtor() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : INT ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : INT -> INT[\"99\"]\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "34");
        TestTreeGrammarRewriteAST.assertEquals((String)"99\n", (String)string3);
    }

    public void testCombinedRewriteAndAuto() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT) | INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID INT) -> ^(INT ID) | INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(34 abc)\n", (String)string3);
        string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34\n", (String)string3);
    }

    public void testAvoidDup() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID -> ^(ID ID)\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc");
        TestTreeGrammarRewriteAST.assertEquals((String)"(abc abc)\n", (String)string3);
    }

    public void testLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID+ INT+ -> (^(ID INT))+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : (^(ID INT))+ -> INT+ ID+\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a b c 3 4 5");
        TestTreeGrammarRewriteAST.assertEquals((String)"3 4 5 a b c\n", (String)string3);
    }

    public void testAutoDup() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID \n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc");
        TestTreeGrammarRewriteAST.assertEquals((String)"abc\n", (String)string3);
    }

    public void testAutoDupRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : b c ;\nb : ID ;\nc : INT ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1");
        TestTreeGrammarRewriteAST.assertEquals((String)"a 1\n", (String)string3);
    }

    public void testAutoDupMultiple() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID ID INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a b 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"a b 3\n", (String)string3);
    }

    public void testAutoDupTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID INT)\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupTree2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT INT -> ^(ID INT INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID b b)\n  ;\nb : INT ;";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3 4");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3 4)\n", (String)string3);
    }

    public void testAutoDupTreeWithLabels() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(x=ID y=INT)\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupTreeWithListLabels() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(x+=ID y+=INT)\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupTreeWithRuleRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(b INT) ;\nb : ID ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupTreeWithRuleRootAndLabels() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(x=b INT) ;\nb : ID ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupTreeWithRuleRootAndListLabels() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(x+=b y+=c) ;\nb : ID ;\nc : INT ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a 3)\n", (String)string3);
    }

    public void testAutoDupNestedTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x=ID y=ID INT -> ^($x ^($y INT));\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID ^(ID INT))\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a b 3");
        TestTreeGrammarRewriteAST.assertEquals((String)"(a (b 3))\n", (String)string3);
    }

    public void testAutoDupTreeWithSubruleInside() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {OP;}\na : (x=ID|x=INT) -> ^(OP $x) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(OP (b|c)) ;\nb : ID ;\nc : INT ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a");
        TestTreeGrammarRewriteAST.assertEquals((String)"(OP a)\n", (String)string3);
    }

    public void testDelete() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ID -> \n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc");
        TestTreeGrammarRewriteAST.assertEquals((String)"", (String)string3);
    }

    public void testSetMatchNoRewrite() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : b INT\n  ;\nb : ID | INT ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"abc 34\n", (String)string3);
    }

    public void testSetMatchNoRewriteLevel2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x=ID INT -> ^($x INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^(ID (ID | INT) ) ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(abc 34)\n", (String)string3);
    }

    public void testSetMatchNoRewriteLevel2Root() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x=ID INT -> ^($x INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\na : ^((ID | INT) INT) ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(abc 34)\n", (String)string3);
    }

    public void testRewriteModeCombinedRewriteAndAuto() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT) | INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\na : ^(ID INT) -> ^(ID[\"ick\"] INT)\n  | INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(ick 34)\n", (String)string3);
        string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34\n", (String)string3);
    }

    public void testRewriteModeFlatTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ID INT | INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ns : ID a ;\na : INT -> INT[\"1\"]\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"abc 1\n", (String)string3);
    }

    public void testRewriteModeChainRuleFlatTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ID INT | INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ns : a ;\na : b ;\nb : ID INT -> INT ID\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34 abc\n", (String)string3);
    }

    public void testRewriteModeChainRuleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ns : a ;\na : b ;\nb : ^(ID INT) -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34\n", (String)string3);
    }

    public void testRewriteModeChainRuleTree2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ntokens { X; }\ns : a* b ;\na : X ;\nb : ^(ID INT) -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34\n", (String)string3);
    }

    public void testRewriteModeChainRuleTree3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'boo' ID INT -> 'boo' ^(ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ntokens { X; }\ns : 'boo' a* b ;\na : X ;\nb : ^(ID INT) -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "boo abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"boo 34\n", (String)string3);
    }

    public void testRewriteModeChainRuleTree4() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'boo' ID INT -> ^('boo' ^(ID INT)) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ntokens { X; }\ns : ^('boo' a* b) ;\na : X ;\nb : ^(ID INT) -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "boo abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(boo 34)\n", (String)string3);
    }

    public void testRewriteModeChainRuleTree5() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'boo' ID INT -> ^('boo' ^(ID INT)) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ntokens { X; }\ns : ^(a b) ;\na : 'boo' ;\nb : ^(ID INT) -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "boo abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"(boo 34)\n", (String)string3);
    }

    public void testRewriteModeWithPredicatedRewrites() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID[\"root\"] ^(ID INT)) | INT -> ^(ID[\"root\"] INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T; rewrite=true;}\ns : ^(ID a) {System.out.println(\"altered tree=\"+$s.start.toStringTree());};\na : ^(ID INT) -> {true}? ^(ID[\"ick\"] INT)\n              -> INT\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"altered tree=(root (ick 34))\n(root (ick 34))\n", (String)string3);
    }

    public void testWildcard() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID[\"root\"] INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=AST; ASTLabelType=CommonTree; tokenVocab=T;}\ns : ^(ID c=.) -> $c\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeGrammarRewriteAST.assertEquals((String)"34\n", (String)string3);
    }
}

