/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Rule;

public class TestSymbolDefinitions
extends BaseTest {
    public void testParserSimpleTokens() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A | B;\nb : C ;");
        String string = "a, b";
        String string2 = "A, B, C";
        this.checkSymbols(grammar, string, string2);
    }

    public void testParserTokensSection() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ntokens {\n  C;\n  D;}\na : A | B;\nb : C ;");
        String string = "a, b";
        String string2 = "A, B, C, D";
        this.checkSymbols(grammar, string, string2);
    }

    public void testLexerTokensSection() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\ntokens {\n  C;\n  D;}\nA : 'a';\nC : 'c' ;");
        String string = "A, C, Tokens";
        String string2 = "A, C, D";
        this.checkSymbols(grammar, string, string2);
    }

    public void testTokensSectionWithAssignmentSection() throws Exception {
        Grammar grammar = new Grammar("grammar t;\ntokens {\n  C='c';\n  D;}\na : A | B;\nb : C ;");
        String string = "a, b";
        String string2 = "A, B, C, D, 'c'";
        this.checkSymbols(grammar, string, string2);
    }

    public void testCombinedGrammarLiterals() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : 'begin' b 'end';\nb : C ';' ;\nID : 'a' ;\nFOO : 'foo' ;\nC : 'c' ;\n");
        String string = "a, b";
        String string2 = "C, FOO, ID, 'begin', 'end', ';'";
        this.checkSymbols(grammar, string, string2);
    }

    public void testLiteralInParserAndLexer() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : 'x' E ; \nE: 'x' '0' ;\n");
        String string = "['x']";
        String string2 = grammar.getStringLiterals().toString();
        TestSymbolDefinitions.assertEquals((String)string, (String)string2);
        String string3 = "lexer grammar t;\n\nT__5 : 'x' ;\n\n// $ANTLR src \"<string>\" 3\nE: 'x' '0' ;\n";
        TestSymbolDefinitions.assertEquals((String)string3, (String)grammar.getLexerGrammar());
    }

    public void testCombinedGrammarWithRefToLiteralButNoTokenIDRef() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : 'a' ;\nA : 'a' ;\n");
        String string = "a";
        String string2 = "A, 'a'";
        this.checkSymbols(grammar, string, string2);
    }

    public void testSetDoesNotMissTokenAliases() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : 'a'|'b' ;\nA : 'a' ;\nB : 'b' ;\n");
        String string = "a";
        String string2 = "A, 'a', B, 'b'";
        this.checkSymbols(grammar, string, string2);
    }

    public void testSimplePlusEqualLabel() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ids+=ID ( COMMA ids+=ID )* ;\n");
        String string = "a";
        String string2 = "ids";
        String string3 = null;
        this.checkPlusEqualsLabels(grammar, string, string2, string3);
    }

    public void testMixedPlusEqualLabel() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {output=AST;}\na : id+=ID ( ',' e+=expr )* ;\nexpr : 'e';\nID : 'a';\n");
        String string = "a";
        String string2 = "id";
        String string3 = "e";
        this.checkPlusEqualsLabels(grammar, string, string2, string3);
    }

    public void testParserCharLiteralWithEscape() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : '\\n';\n");
        Set<String> set = grammar.getStringLiterals();
        TestSymbolDefinitions.assertEquals((Object)"'\\n'", (Object)set.toArray()[0]);
    }

    public void testTokenInTokensSectionAndTokenRuleDef() throws Exception {
        String string = "grammar P;\ntokens { B='}'; }\na : A B {System.out.println(input);} ;\nA : 'a' ;\nB : '}' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "a}", false);
        TestSymbolDefinitions.assertEquals((String)"a}\n", (String)string2);
    }

    public void testTokenInTokensSectionAndTokenRuleDef2() throws Exception {
        String string = "grammar P;\ntokens { B='}'; }\na : A '}' {System.out.println(input);} ;\nA : 'a' ;\nB : '}' {/* */} ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "a}", false);
        TestSymbolDefinitions.assertEquals((String)"a}\n", (String)string2);
    }

    public void testRefToRuleWithNoReturnValue() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar P;\na : x=b ;\nb : B ;\nB : 'b' ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        StringTemplate stringTemplate = codeGenerator.genRecognizer();
        String string2 = stringTemplate.toString();
        TestSymbolDefinitions.assertTrue((String)"not expecting label", (string2.indexOf("x=b();") < 0 ? 1 : 0) != 0);
        TestSymbolDefinitions.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testParserStringLiterals() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : 'begin' b ;\nb : C ;");
        String string = "'begin'";
        int n = 107;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testParserCharLiterals() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : '(' b ;\nb : C ;");
        String string = "'('";
        int n = 107;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testEmptyNotChar() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar foo;\na : (~'x')+ ;\n");
        grammar.buildNFA();
        String string = "'x'";
        int n = 139;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testEmptyNotToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar foo;\na : (~A)+ ;\n");
        grammar.buildNFA();
        String string = "A";
        int n = 139;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testEmptyNotSet() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar foo;\na : (~(A|B))+ ;\n");
        grammar.buildNFA();
        Object var3_3 = null;
        int n = 139;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, var3_3);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testStringLiteralInParserTokensSection() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\ntokens {\n  B='begin';\n}\na : A B;\nb : C ;");
        String string = "'begin'";
        int n = 107;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testCharLiteralInParserTokensSection() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\ntokens {\n  B='(';\n}\na : A B;\nb : C ;");
        String string = "'('";
        int n = 107;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testCharLiteralInLexerTokensSection() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\ntokens {\n  B='(';\n}\nID : 'a';\n");
        String string = "'('";
        int n = 108;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleRedefinition() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : A | B;\na : C ;");
        String string = "a";
        int n = 101;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLexerRuleRedefinition() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nID : 'a' ;\nID : 'd' ;");
        String string = "ID";
        int n = 101;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testCombinedRuleRedefinition() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nx : ID ;\nID : 'a' ;\nx : ID ID ;");
        String string = "x";
        int n = 101;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testUndefinedToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nx : ID ;");
        String string = "ID";
        int n = 105;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsWarning(errorQueue, grammarSemanticsMessage);
    }

    public void testUndefinedTokenOkInParser() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\nx : ID ;");
        TestSymbolDefinitions.assertEquals((String)"should not be an error", (int)0, (int)errorQueue.errors.size());
    }

    public void testUndefinedRule() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nx : r ;");
        String string = "r";
        int n = 106;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLexerRuleInParser() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\nX : ;");
        String string = "X";
        int n = 102;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testParserRuleInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\na : ;");
        String string = "a";
        int n = 103;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope a {\n  int n;\n}\na : \n  ;\n");
        String string = "a";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenRuleScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\nscope ID {\n  int n;\n}\nID : 'a'\n  ;\n");
        String string = "ID";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\ntokens { ID; }\nscope ID {\n  int n;\n}\na : \n  ;\n");
        String string = "ID";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenRuleScopeConflictInLexerGrammar() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("lexer grammar t;\nscope ID {\n  int n;\n}\nID : 'a'\n  ;\n");
        String string = "ID";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenLabelScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\nscope s {\n  int n;\n}\na : s=ID \n  ;\n");
        String string = "s";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleLabelScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\nscope s {\n  int n;\n}\na : s=b \n  ;\nb : ;\n");
        String string = "s";
        int n = 118;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelAndRuleNameConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : c=b \n  ;\nb : ;\nc : ;\n");
        String string = "c";
        int n = 119;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelAndTokenNameConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : ID=b \n  ;\nb : ID ;\nc : ;\n");
        String string = "ID";
        int n = 120;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelAndArgConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int i] returns [int x]: i=ID \n  ;\n");
        String string = "i";
        int n = 122;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelAndParameterConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int i] returns [int x]: x=ID \n  ;\n");
        String string = "x";
        int n = 122;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testLabelRuleScopeConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na\nscope {  int n;}\n  : n=ID\n  ;\n");
        String string = "n";
        String string2 = "a";
        int n = 121;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleScopeArgConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na[int n]\nscope {  int n;}\n  : \n  ;\n");
        String string = "n";
        String string2 = "a";
        int n = 124;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleScopeReturnValueConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na returns [int n]\nscope {  int n;}\n  : \n  ;\n");
        String string = "n";
        String string2 = "a";
        int n = 124;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, string2);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testRuleScopeRuleNameConflict() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na\nscope {  int a;}\n  : \n  ;\n");
        String string = "a";
        Object var4_4 = null;
        int n = 123;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string, var4_4);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testBadGrammarOption() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Tool tool = this.newTool();
        Grammar grammar = new Grammar(tool, "grammar t;\noptions {foo=3; language=Java;}\na : 'a';\n");
        String string = "foo";
        int n = 133;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testBadRuleOption() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na\noptions {k=3; tokenVocab=blort;}\n  : 'a';\n");
        String string = "tokenVocab";
        int n = 133;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testBadSubRuleOption() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("grammar t;\na : ( options {k=3; language=Java;}\n    : 'a'\n    | 'b'\n    )\n  ;\n");
        String string = "language";
        int n = 133;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
    }

    public void testTokenVocabStringUsedInLexer() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "';'=4\n";
        this.writeFile(tmpdir, "T.tokens", string);
        String string2 = "lexer grammar B; \noptions\t{tokenVocab=T;} \nSEMI:';' ; \n";
        this.writeFile(tmpdir, "B.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/B.g", compositeGrammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string3 = "[SEMI=4]";
        String string4 = "{';'=4}";
        String string5 = "[SEMI]";
        TestSymbolDefinitions.assertEquals((String)string3, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestSymbolDefinitions.assertEquals((String)string4, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestSymbolDefinitions.assertEquals((String)string5, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestSymbolDefinitions.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testTokenVocabStringUsedInCombined() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "';'=4\n";
        this.writeFile(tmpdir, "T.tokens", string);
        String string2 = "grammar B; \noptions\t{tokenVocab=T;} \nSEMI:';' ; \n";
        this.writeFile(tmpdir, "B.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/B.g", compositeGrammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string3 = "[SEMI=4]";
        String string4 = "{';'=4}";
        String string5 = "[SEMI]";
        TestSymbolDefinitions.assertEquals((String)string3, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestSymbolDefinitions.assertEquals((String)string4, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestSymbolDefinitions.assertEquals((String)string5, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestSymbolDefinitions.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    protected void checkPlusEqualsLabels(Grammar grammar, String string, String string2, String string3) throws Exception {
        Object object;
        Rule rule = grammar.getRule(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
        HashSet<String> hashSet = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            object = stringTokenizer.nextToken();
            hashSet.add((String)object);
        }
        object = null;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ", ");
            object = new HashSet();
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                object.add(string4);
            }
        }
        TestSymbolDefinitions.assertTrue((String)("token += labels mismatch; " + hashSet + "!=" + rule.tokenListLabels), (hashSet != null && rule.tokenListLabels != null || hashSet == null && rule.tokenListLabels == null ? 1 : 0) != 0);
        TestSymbolDefinitions.assertTrue((String)("rule += labels mismatch; " + object + "!=" + rule.ruleListLabels), (object != null && rule.ruleListLabels != null || object == null && rule.ruleListLabels == null ? 1 : 0) != 0);
        if (hashSet != null) {
            TestSymbolDefinitions.assertEquals(hashSet, rule.tokenListLabels.keySet());
        }
        if (object != null) {
            TestSymbolDefinitions.assertEquals((Object)object, rule.ruleListLabels.keySet());
        }
    }

    protected void checkSymbols(Grammar grammar, String string, String string2) throws Exception {
        Object object;
        Object object2;
        Set<String> set = grammar.getTokenDisplayNames();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            TestSymbolDefinitions.assertTrue((String)("token " + (String)object2 + " expected"), (grammar.getTokenType((String)object2) != -7 ? 1 : 0) != 0);
            set.remove(object2);
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            TestSymbolDefinitions.assertTrue((String)("unexpected token name " + (String)object), (grammar.getTokenType((String)object) < 4 ? 1 : 0) != 0);
        }
        stringTokenizer = new StringTokenizer(string, ", ");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            TestSymbolDefinitions.assertNotNull((String)("rule " + (String)object + " expected"), (Object)grammar.getRule((String)object));
            ++n;
        }
        object = grammar.getRules();
        TestSymbolDefinitions.assertEquals((String)("number of rules mismatch; expecting " + n + "; found " + object.size()), (int)n, (int)object.size());
    }
}

