#ifndef _DECL_CentralLB_H_
#define _DECL_CentralLB_H_
#include "charm++.h"
#include "BaseLB.decl.h"

#include "LBDatabase.decl.h"

#include "CentralLBMsg.h"

/* DECLS: readonly CkGroupID loadbalancer;
 */


/* DECLS: group CentralLB: BaseLB{
CentralLB(CkMigrateMessage* impl_msg);
void CentralLB(const CkLBOptions &impl_noname_0);
void ProcessAtSync(void);
void SendStats(void);
void ReceiveStats(const CkMarshalledCLBStatsMessage &data);
void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data);
void ReceiveCounts(CkReductionMsg* impl_msg);
void LoadBalance(void);
void ResumeClients(int impl_noname_1);
void ResumeClients(CkReductionMsg* impl_msg);
void ReceiveMigration(LBMigrateMsg* impl_msg);
void MissMigrate(int impl_noname_2);
};
 */
 class CentralLB;
 class CkIndex_CentralLB;
 class CProxy_CentralLB;
 class CProxyElement_CentralLB;
 class CProxySection_CentralLB;
/* --------------- index object ------------------ */
class CkIndex_CentralLB:public CProxyElement_BaseLB{
  public:
    typedef CentralLB local_t;
    typedef CkIndex_CentralLB index_t;
    typedef CProxy_CentralLB proxy_t;
    typedef CProxyElement_CentralLB element_t;
    typedef CProxySection_CentralLB section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: CentralLB(CkMigrateMessage* impl_msg);
 */
    static int __idx_CentralLB_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_CentralLB_CkMigrateMessage; }
    static void _call_CentralLB_CkMigrateMessage(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void CentralLB(const CkLBOptions &impl_noname_0);
 */
    static int __idx_CentralLB_marshall1;
    static int ckNew(const CkLBOptions &impl_noname_0) { return __idx_CentralLB_marshall1; }
    static void _call_CentralLB_marshall1(void* impl_msg,CentralLB* impl_obj);
    static int _callmarshall_CentralLB_marshall1(char* impl_buf,CentralLB* impl_obj);
    static void _marshallmessagepup_CentralLB_marshall1(PUP::er &p,void *msg);

/* DECLS: void ProcessAtSync(void);
 */
    static int __idx_ProcessAtSync_void;
    static int ProcessAtSync(void) { return __idx_ProcessAtSync_void; }
    static void _call_ProcessAtSync_void(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void SendStats(void);
 */
    static int __idx_SendStats_void;
    static int SendStats(void) { return __idx_SendStats_void; }
    static void _call_SendStats_void(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data);
 */
    static int __idx_ReceiveStats_marshall4;
    static int ReceiveStats(const CkMarshalledCLBStatsMessage &data) { return __idx_ReceiveStats_marshall4; }
    static void _call_ReceiveStats_marshall4(void* impl_msg,CentralLB* impl_obj);
    static int _callmarshall_ReceiveStats_marshall4(char* impl_buf,CentralLB* impl_obj);
    static void _marshallmessagepup_ReceiveStats_marshall4(PUP::er &p,void *msg);

/* DECLS: void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data);
 */
    static int __idx_ReceiveStatsViaTree_marshall5;
    static int ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data) { return __idx_ReceiveStatsViaTree_marshall5; }
    static void _call_ReceiveStatsViaTree_marshall5(void* impl_msg,CentralLB* impl_obj);
    static int _callmarshall_ReceiveStatsViaTree_marshall5(char* impl_buf,CentralLB* impl_obj);
    static void _marshallmessagepup_ReceiveStatsViaTree_marshall5(PUP::er &p,void *msg);

/* DECLS: void ReceiveCounts(CkReductionMsg* impl_msg);
 */
    static int __idx_ReceiveCounts_CkReductionMsg;
    static int ReceiveCounts(CkReductionMsg* impl_msg) { return __idx_ReceiveCounts_CkReductionMsg; }
    static void _call_ReceiveCounts_CkReductionMsg(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void LoadBalance(void);
 */
    static int __idx_LoadBalance_void;
    static int LoadBalance(void) { return __idx_LoadBalance_void; }
    static void _call_LoadBalance_void(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void ResumeClients(int impl_noname_1);
 */
    static int __idx_ResumeClients_marshall8;
    static int ResumeClients(int impl_noname_1) { return __idx_ResumeClients_marshall8; }
    static void _call_ResumeClients_marshall8(void* impl_msg,CentralLB* impl_obj);
    static int _callmarshall_ResumeClients_marshall8(char* impl_buf,CentralLB* impl_obj);
    static void _marshallmessagepup_ResumeClients_marshall8(PUP::er &p,void *msg);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    static int __idx_ResumeClients_CkReductionMsg;
    static int ResumeClients(CkReductionMsg* impl_msg) { return __idx_ResumeClients_CkReductionMsg; }
    static void _call_ResumeClients_CkReductionMsg(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    static int __idx_ReceiveMigration_LBMigrateMsg;
    static int ReceiveMigration(LBMigrateMsg* impl_msg) { return __idx_ReceiveMigration_LBMigrateMsg; }
    static void _call_ReceiveMigration_LBMigrateMsg(void* impl_msg,CentralLB* impl_obj);

/* DECLS: void MissMigrate(int impl_noname_2);
 */
    static int __idx_MissMigrate_marshall11;
    static int MissMigrate(int impl_noname_2) { return __idx_MissMigrate_marshall11; }
    static void _call_MissMigrate_marshall11(void* impl_msg,CentralLB* impl_obj);
    static int _callmarshall_MissMigrate_marshall11(char* impl_buf,CentralLB* impl_obj);
    static void _marshallmessagepup_MissMigrate_marshall11(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
class CProxyElement_CentralLB: public CProxyElement_BaseLB{
  public:
    typedef CentralLB local_t;
    typedef CkIndex_CentralLB index_t;
    typedef CProxy_CentralLB proxy_t;
    typedef CProxyElement_CentralLB element_t;
    typedef CProxySection_CentralLB section_t;

    CProxyElement_CentralLB(void) {}
    CProxyElement_CentralLB(const IrrGroup *g) : CProxyElement_BaseLB(g){  }
    CProxyElement_CentralLB(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_BaseLB(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_CentralLB(CkGroupID _gid,int _onPE) : CProxyElement_BaseLB(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_BaseLB::ckSetGroupID(g);
    }
    CentralLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CentralLB* ckLocalBranch(CkGroupID gID) {
      return (CentralLB*)CkLocalBranch(gID);
    }
/* DECLS: CentralLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void CentralLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);

/* DECLS: void SendStats(void);
 */
    void SendStats(void);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveCounts(CkReductionMsg* impl_msg);
 */
    void ReceiveCounts(CkReductionMsg* impl_msg);

/* DECLS: void LoadBalance(void);
 */
    void LoadBalance(void);

/* DECLS: void ResumeClients(int impl_noname_1);
 */
    void ResumeClients(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);

/* DECLS: void MissMigrate(int impl_noname_2);
 */
    void MissMigrate(int impl_noname_2, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxyElement_CentralLB)
/* ---------------- collective proxy -------------- */
class CProxy_CentralLB: public CProxy_BaseLB{
  public:
    typedef CentralLB local_t;
    typedef CkIndex_CentralLB index_t;
    typedef CProxy_CentralLB proxy_t;
    typedef CProxyElement_CentralLB element_t;
    typedef CProxySection_CentralLB section_t;

    CProxy_CentralLB(void) {}
    CProxy_CentralLB(const IrrGroup *g) : CProxy_BaseLB(g){  }
    CProxy_CentralLB(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_BaseLB(_gid,CK_DELCTOR_ARGS){  }
    CProxy_CentralLB(CkGroupID _gid) : CProxy_BaseLB(_gid){  }
    CProxyElement_CentralLB operator[](int onPE) const
      {return CProxyElement_CentralLB(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_BaseLB::ckSetGroupID(g);
    }
    CentralLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CentralLB* ckLocalBranch(CkGroupID gID) {
      return (CentralLB*)CkLocalBranch(gID);
    }
/* DECLS: CentralLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void CentralLB(const CkLBOptions &impl_noname_0);
 */
    static CkGroupID ckNew(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_CentralLB(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);
    void ProcessAtSync(int npes, int *pes);

/* DECLS: void SendStats(void);
 */
    void SendStats(void);
    void SendStats(int npes, int *pes);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);
    void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveCounts(CkReductionMsg* impl_msg);
 */
    void ReceiveCounts(CkReductionMsg* impl_msg);
    void ReceiveCounts(CkReductionMsg* impl_msg, int npes, int *pes);

/* DECLS: void LoadBalance(void);
 */
    void LoadBalance(void);
    void LoadBalance(int npes, int *pes);

/* DECLS: void ResumeClients(int impl_noname_1);
 */
    void ResumeClients(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);
    void ResumeClients(int impl_noname_1, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);
    void ResumeClients(CkReductionMsg* impl_msg, int npes, int *pes);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);
    void ReceiveMigration(LBMigrateMsg* impl_msg, int npes, int *pes);

/* DECLS: void MissMigrate(int impl_noname_2);
 */
    void MissMigrate(int impl_noname_2, const CkEntryOptions *impl_e_opts=NULL);
    void MissMigrate(int impl_noname_2, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxy_CentralLB)
/* ---------------- section proxy -------------- */
class CProxySection_CentralLB: public CProxySection_BaseLB{
  public:
    typedef CentralLB local_t;
    typedef CkIndex_CentralLB index_t;
    typedef CProxy_CentralLB proxy_t;
    typedef CProxyElement_CentralLB element_t;
    typedef CProxySection_CentralLB section_t;

    CProxySection_CentralLB(void) {}
    CProxySection_CentralLB(const IrrGroup *g) : CProxySection_BaseLB(g){  }
    CProxySection_CentralLB(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_BaseLB(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_CentralLB(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_BaseLB(_gid,_pelist,_npes){  }
    CProxySection_CentralLB(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_BaseLB(n,_gid,_pelist,_npes){  }
    CProxySection_CentralLB(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_BaseLB(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
   CK_DISAMBIG_GROUP_SECTION(CProxySection_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_BaseLB::ckSetGroupID(g);
    }
    CentralLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CentralLB* ckLocalBranch(CkGroupID gID) {
      return (CentralLB*)CkLocalBranch(gID);
    }
/* DECLS: CentralLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void CentralLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);

/* DECLS: void SendStats(void);
 */
    void SendStats(void);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data);
 */
    void ReceiveStatsViaTree(const CkMarshalledCLBStatsMessage &data, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveCounts(CkReductionMsg* impl_msg);
 */
    void ReceiveCounts(CkReductionMsg* impl_msg);

/* DECLS: void LoadBalance(void);
 */
    void LoadBalance(void);

/* DECLS: void ResumeClients(int impl_noname_1);
 */
    void ResumeClients(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);

/* DECLS: void MissMigrate(int impl_noname_2);
 */
    void MissMigrate(int impl_noname_2, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxySection_CentralLB)
typedef CBaseT<BaseLB,CProxy_CentralLB>  CBase_CentralLB;

extern void _registerCentralLB(void);
#endif
