/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;

public class TestCompositeGrammars
extends BaseTest {
    protected boolean debug = false;

    public void testWildcardStillWorks() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\na : B . C ;\n";
        Grammar grammar = new Grammar(string);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testDelegatorInvokesDelegateRule() throws Exception {
        String string = "parser grammar S;\na : B {System.out.println(\"S.a\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : a ;\nB : 'b' ;WS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "s", "b", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.a\n", (String)string3);
    }

    public void testDelegatorInvokesDelegateRuleWithArgs() throws Exception {
        String string = "parser grammar S;\na[int x] returns [int y] : B {System.out.print(\"S.a\"); $y=1000;} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : label=a[3] {System.out.println($label.y);} ;\nB : 'b' ;WS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "s", "b", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.a1000\n", (String)string3);
    }

    public void testDelegatorInvokesDelegateRuleWithReturnStruct() throws Exception {
        String string = "parser grammar S;\na : B {System.out.print(\"S.a\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : a {System.out.println($a.text);} ;\nB : 'b' ;WS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "s", "b", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.ab\n", (String)string3);
    }

    public void testDelegatorAccessesDelegateMembers() throws Exception {
        String string = "parser grammar S;\n@members {\n  public void foo() {System.out.println(\"foo\");}\n}\na : B ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : 'b' {gS.foo();} ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "s", "b", this.debug);
        TestCompositeGrammars.assertEquals((String)"foo\n", (String)string3);
    }

    public void testDelegatorInvokesFirstVersionOfDelegateRule() throws Exception {
        String string = "parser grammar S;\na : b {System.out.println(\"S.a\");} ;\nb : B ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "parser grammar T;\na : B {System.out.println(\"T.a\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string2);
        String string3 = "grammar M;\nimport S,T;\ns : a ;\nB : 'b' ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string4 = this.execParser("M.g", string3, "MParser", "MLexer", "s", "b", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.a\n", (String)string4);
    }

    public void testDelegatesSeeSameTokenType() throws Exception {
        String string = "parser grammar S;\ntokens { A; B; C; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "parser grammar T;\ntokens { C; B; A; }\ny : A {System.out.println(\"T.y\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string2);
        String string3 = "grammar M;\nimport S,T;\ns : x y ;\nB : 'b' ;\nA : 'a' ;\nC : 'c' ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string4 = this.execParser("M.g", string3, "MParser", "MLexer", "s", "aa", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.x\nT.y\n", (String)string4);
    }

    public void testDelegatesSeeSameTokenType2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\ntokens { A; B; C; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "parser grammar T;\ntokens { C; B; A; }\ny : A {System.out.println(\"T.y\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string2);
        String string3 = "grammar M;\nimport S,T;\ns : x y ;\nB : 'b' ;\nA : 'a' ;\nC : 'c' ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string4 = "[A=4, B=5, C=6, WS=7]";
        String string5 = "{}";
        String string6 = "[A, B, C, WS]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testCombinedImportsCombined() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar S;\ntokens { A; B; C; }\nx : 'x' INT {System.out.println(\"S.x\");} ;\nINT : '0'..'9'+ ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : x INT ;\n";
        this.writeFile(tmpdir, "M.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.errors.size());
        String string3 = "error(161): /tmp/antlr3/M.g:2:8: combined grammar M cannot import combined grammar S";
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (String)string3, (String)errorQueue.errors.get(0).toString());
    }

    public void testSameStringTwoNames() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\ntokens { A='a'; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "parser grammar T;\ntokens { X='a'; }\ny : X {System.out.println(\"T.y\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string2);
        String string3 = "grammar M;\nimport S,T;\ns : x y ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string4 = "[A=4, WS=6, X=5]";
        String string5 = "{'a'=4}";
        String string6 = "[A, X, WS]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        String string7 = "X='a'";
        String string8 = "A";
        int n = 158;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string7, string8);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.errors.size());
        String string9 = "error(158): T.g:2:10: cannot alias X='a'; string already assigned to A";
        TestCompositeGrammars.assertEquals((String)string9, (String)errorQueue.errors.get(0).toString());
    }

    public void testSameNameTwoStrings() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\ntokens { A='a'; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "parser grammar T;\ntokens { A='x'; }\ny : A {System.out.println(\"T.y\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string2);
        String string3 = "grammar M;\nimport S,T;\ns : x y ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string4 = "[A=4, T__6=6, WS=5]";
        String string5 = "{'x'=6, 'a'=4}";
        String string6 = "[A, WS, T__6]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        String string7 = "A='x'";
        String string8 = "'a'";
        int n = 159;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string7, string8);
        this.checkGrammarSemanticsError(errorQueue, grammarSemanticsMessage);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.errors.size());
        String string9 = "error(159): T.g:2:10: cannot alias A='x'; token name already assigned to 'a'";
        TestCompositeGrammars.assertEquals((String)string9, (String)errorQueue.errors.get(0).toString());
    }

    public void testImportedTokenVocabIgnoredWithWarning() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\noptions {tokenVocab=whatever;}\ntokens { A='a'; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : x ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string3 = "S";
        int n = 160;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string3);
        this.checkGrammarSemanticsWarning(errorQueue, grammarSemanticsMessage);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.warnings.size());
        String string4 = "warning(160): S.g:2:10: tokenVocab option ignored in imported grammar S";
        TestCompositeGrammars.assertEquals((String)string4, (String)errorQueue.warnings.get(0).toString());
    }

    public void testImportedTokenVocabWorksInRoot() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\ntokens { A='a'; }\nx : A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "A=99\n";
        this.writeFile(tmpdir, "Test.tokens", string2);
        String string3 = "grammar M;\noptions {tokenVocab=Test;}\nimport S;\ns : x ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        String string4 = "[A=99, WS=101]";
        String string5 = "{'a'=100}";
        String string6 = "[A, 'a', WS]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testSyntaxErrorsInImportsNotThrownOut() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\noptions {toke\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : x ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)5, (int)errorQueue.errors.size());
    }

    public void testSyntaxErrorsInImportsNotThrownOut2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar S;\n: A {System.out.println(\"S.x\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\ns : x ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "M.g", string2);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)3, (int)errorQueue.errors.size());
    }

    public void testDelegatorRuleOverridesDelegate() throws Exception {
        String string = "parser grammar S;\na : b {System.out.println(\"S.a\");} ;\nb : B ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\nb : 'b'|'c' ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "a", "c", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.a\n", (String)string3);
    }

    public void testDelegatorRuleOverridesLookaheadInDelegate() throws Exception {
        String string = "parser grammar JavaDecl;\ntype : 'int' ;\ndecl : type ID ';'\n     | type ID init ';' {System.out.println(\"JavaDecl: \"+$decl.text);}\n     ;\ninit : '=' INT ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "JavaDecl.g", string);
        String string2 = "grammar Java;\nimport JavaDecl;\nprog : decl ;\ntype : 'int' | 'float' ;\n\nID  : 'a'..'z'+ ;\nINT : '0'..'9'+ ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("Java.g", string2, "JavaParser", "JavaLexer", "prog", "float x = 3;", this.debug);
        TestCompositeGrammars.assertEquals((String)"JavaDecl: floatx=3;\n", (String)string3);
    }

    public void testLexerDelegatorInvokesDelegateRule() throws Exception {
        String string = "lexer grammar S;\nA : 'a' {System.out.println(\"S.A\");} ;\nC : 'c' ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "lexer grammar M;\nimport S;\nB : 'b' ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execLexer("M.g", string2, "M", "abc", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.A\nabc\n", (String)string3);
    }

    public void testLexerDelegatorRuleOverridesDelegate() throws Exception {
        String string = "lexer grammar S;\nA : 'a' {System.out.println(\"S.A\");} ;\nB : 'b' {System.out.println(\"S.B\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "lexer grammar M;\nimport S;\nA : 'a' B {System.out.println(\"M.A\");} ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execLexer("M.g", string2, "M", "ab", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.B\nM.A\nab\n", (String)string3);
    }

    public void testLexerDelegatorRuleOverridesDelegateLeavingNoRules() throws Exception {
        String string = "lexer grammar S;\nA : 'a' {System.out.println(\"S.A\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "lexer grammar M;\nimport S;\nA : 'a' {System.out.println(\"M.A\");} ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.writeFile(tmpdir, "/M.g", string2);
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        compositeGrammar.assignTokenTypes();
        compositeGrammar.defineGrammarSymbols();
        compositeGrammar.createNFAs();
        grammar.createLookaheadDFAs(false);
        String string3 = ".s0-'a'->.s1\n.s0-{'\\n', ' '}->:s3=>2\n.s1-<EOT>->:s2=>1\n";
        DFA dFA = grammar.getLookaheadDFA(1);
        FASerializer fASerializer = new FASerializer(grammar);
        String string4 = fASerializer.serialize(dFA.startState);
        TestCompositeGrammars.assertEquals((String)string3, (String)string4);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testInvalidImportMechanism() throws Exception {
        String string = "lexer grammar S;\nA : 'a' {System.out.println(\"S.A\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "tree grammar M;\nimport S;\na : A ;";
        this.writeFile(tmpdir, "/M.g", string2);
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.errors.size());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.warnings.size());
        String string3 = "error(161): /tmp/antlr3/M.g:2:8: tree grammar M cannot import lexer grammar S";
        TestCompositeGrammars.assertEquals((String)string3, (String)errorQueue.errors.get(0).toString());
    }

    public void testSyntacticPredicateRulesAreNotInherited() throws Exception {
        String string = "parser grammar S;\na : 'a' {System.out.println(\"S.a1\");}\n  | 'a' {System.out.println(\"S.a2\");}\n  ;\nb : 'x' | 'y' {;} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\noptions {backtrack=true;}\nimport S;\nstart : a b ;\nnonsense : 'q' | 'q' {;} ;WS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "start", "ax", this.debug);
        TestCompositeGrammars.assertEquals((String)"S.a1\n", (String)string3);
    }

    public void testKeywordVSIDGivesNoWarning() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "lexer grammar S;\nA : 'abc' {System.out.println(\"S.A\");} ;\nID : 'a'..'z'+ ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\na : A {System.out.println(\"M.a\");} ;\nWS : (' '|'\\n') {skip();} ;\n";
        String string3 = this.execParser("M.g", string2, "MParser", "MLexer", "a", "abc", this.debug);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestCompositeGrammars.assertEquals((String)("unexpected warnings: " + errorQueue), (int)0, (int)errorQueue.warnings.size());
        TestCompositeGrammars.assertEquals((String)"S.A\nM.a\n", (String)string3);
    }

    public void testWarningForUndefinedToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "lexer grammar S;\nA : 'abc' {System.out.println(\"S.A\");} ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string);
        String string2 = "grammar M;\nimport S;\na : ABC A {System.out.println(\"M.a\");} ;\nWS : (' '|'\\n') {skip();} ;\n";
        this.rawGenerateAndBuildRecognizer("M.g", string2, "MParser", "MLexer", this.debug);
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
        TestCompositeGrammars.assertEquals((String)("unexpected warnings: " + errorQueue), (int)1, (int)errorQueue.warnings.size());
        String string3 = "warning(105): /tmp/antlr3/M.g:3:5: no lexer rule corresponding to token: ABC";
        TestCompositeGrammars.assertEquals((String)string3, (String)errorQueue.warnings.get(0).toString());
    }

    public void test3LevelImport() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar T;\na : T ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string);
        String string2 = "parser grammar S;\nimport T;\na : S ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string2);
        String string3 = "grammar M;\nimport S;\na : M ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        grammar.composite.defineGrammarSymbols();
        String string4 = "[M=6, S=5, T=4]";
        String string5 = "{}";
        String string6 = "[T, S, M]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }

    public void testRulesVisibleThroughMultilevelImport() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "parser grammar T;\nx : T ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "T.g", string);
        String string2 = "parser grammar S;\nimport T;\na : S ;\n";
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, "S.g", string2);
        String string3 = "grammar M;\nimport S;\na : M x ;\n";
        this.writeFile(tmpdir, "M.g", string3);
        Tool tool = this.newTool(new String[]{"-lib", tmpdir});
        CompositeGrammar compositeGrammar = new CompositeGrammar();
        Grammar grammar = new Grammar(tool, tmpdir + "/M.g", compositeGrammar);
        compositeGrammar.setDelegationRoot(grammar);
        grammar.parseAndBuildAST();
        grammar.composite.assignTokenTypes();
        grammar.composite.defineGrammarSymbols();
        String string4 = "[M=6, S=5, T=4]";
        String string5 = "{}";
        String string6 = "[T, S, M]";
        TestCompositeGrammars.assertEquals((String)string4, (String)this.realElements(grammar.composite.tokenIDToTypeMap).toString());
        TestCompositeGrammars.assertEquals((String)string5, (String)grammar.composite.stringLiteralToTypeMap.toString());
        TestCompositeGrammars.assertEquals((String)string6, (String)this.realElements(grammar.composite.typeToTokenList).toString());
        TestCompositeGrammars.assertEquals((String)("unexpected errors: " + errorQueue), (int)0, (int)errorQueue.errors.size());
    }
}

