#ifndef _DECL_HybridBaseLB_H_
#define _DECL_HybridBaseLB_H_
#include "charm++.h"
#include "LBDatabase.decl.h"

#include "BaseLB.decl.h"

#include "NeighborLBMsg.h"

#include "CentralLBMsg.h"

#include "HybridLBMsg.h"

/* DECLS: message DummyMsg;
 */
class DummyMsg;
class CMessage_DummyMsg:public CkMessage{
  public:
    static int __idx;
    void* operator new(size_t, void*p) { return p; }
    void* operator new(size_t);
    void* operator new(size_t, int*, const int);
    void* operator new(size_t, int*);
#if CMK_MULTIPLE_DELETE
    void operator delete(void*p, void*){dealloc(p);}
    void operator delete(void*p){dealloc(p);}
    void operator delete(void*p, int*, const int){dealloc(p);}
    void operator delete(void*p, int*){dealloc(p);}
#endif
    void operator delete(void*p, size_t){dealloc(p);}
    static void* alloc(int,size_t, int*, int);
    static void dealloc(void *p);
    CMessage_DummyMsg() {};
    static void *pack(DummyMsg *p);
    static DummyMsg* unpack(void* p);
    void *operator new(size_t, const int);
#if CMK_MULTIPLE_DELETE
    void operator delete(void *p, const int){dealloc(p);}
#endif
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, dealloc, size);
    }
};


/* DECLS: group HybridBaseLB: BaseLB{
HybridBaseLB(CkMigrateMessage* impl_msg);
void HybridBaseLB(const CkLBOptions &impl_noname_0);
void ProcessAtSync(void);
void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
void ResumeClients(CkReductionMsg* impl_msg);
void ResumeClients(int balancing);
void ReceiveMigration(LBMigrateMsg* impl_msg);
void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
void TotalObjMigrated(int count, int level);
void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level);
void Loadbalancing(int level);
void NotifyObjectMigrationDone(int impl_noname_1);
void StartCollectInfo(DummyMsg* impl_msg);
void CollectInfo(const Location *loc, int n, int fromlevel);
void PropagateInfo(const Location *loc, int n, int fromlevel);
void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
void reportLBMem(double impl_noname_7);
};
 */
 class HybridBaseLB;
 class CkIndex_HybridBaseLB;
 class CProxy_HybridBaseLB;
 class CProxyElement_HybridBaseLB;
 class CProxySection_HybridBaseLB;
/* --------------- index object ------------------ */
class CkIndex_HybridBaseLB:public CProxyElement_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;
    typedef CProxySection_HybridBaseLB section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */
    static int __idx_HybridBaseLB_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_HybridBaseLB_CkMigrateMessage; }
    static void _call_HybridBaseLB_CkMigrateMessage(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */
    static int __idx_HybridBaseLB_marshall1;
    static int ckNew(const CkLBOptions &impl_noname_0) { return __idx_HybridBaseLB_marshall1; }
    static void _call_HybridBaseLB_marshall1(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_HybridBaseLB_marshall1(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_HybridBaseLB_marshall1(PUP::er &p,void *msg);

/* DECLS: void ProcessAtSync(void);
 */
    static int __idx_ProcessAtSync_void;
    static int ProcessAtSync(void) { return __idx_ProcessAtSync_void; }
    static void _call_ProcessAtSync_void(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    static int __idx_ReceiveStats_marshall3;
    static int ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level) { return __idx_ReceiveStats_marshall3; }
    static void _call_ReceiveStats_marshall3(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ReceiveStats_marshall3(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ReceiveStats_marshall3(PUP::er &p,void *msg);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    static int __idx_ResumeClients_CkReductionMsg;
    static int ResumeClients(CkReductionMsg* impl_msg) { return __idx_ResumeClients_CkReductionMsg; }
    static void _call_ResumeClients_CkReductionMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ResumeClients(int balancing);
 */
    static int __idx_ResumeClients_marshall5;
    static int ResumeClients(int balancing) { return __idx_ResumeClients_marshall5; }
    static void _call_ResumeClients_marshall5(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ResumeClients_marshall5(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ResumeClients_marshall5(PUP::er &p,void *msg);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    static int __idx_ReceiveMigration_LBMigrateMsg;
    static int ReceiveMigration(LBMigrateMsg* impl_msg) { return __idx_ReceiveMigration_LBMigrateMsg; }
    static void _call_ReceiveMigration_LBMigrateMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    static int __idx_ReceiveVectorMigration_LBVectorMigrateMsg;
    static int ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg) { return __idx_ReceiveVectorMigration_LBVectorMigrateMsg; }
    static void _call_ReceiveVectorMigration_LBVectorMigrateMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    static int __idx_TotalObjMigrated_marshall8;
    static int TotalObjMigrated(int count, int level) { return __idx_TotalObjMigrated_marshall8; }
    static void _call_TotalObjMigrated_marshall8(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_TotalObjMigrated_marshall8(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_TotalObjMigrated_marshall8(PUP::er &p,void *msg);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    static int __idx_ObjMigrated_marshall9;
    static int ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level) { return __idx_ObjMigrated_marshall9; }
    static void _call_ObjMigrated_marshall9(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ObjMigrated_marshall9(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ObjMigrated_marshall9(PUP::er &p,void *msg);

/* DECLS: void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level);
 */
    static int __idx_ObjsMigrated_marshall10;
    static int ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level) { return __idx_ObjsMigrated_marshall10; }
    static void _call_ObjsMigrated_marshall10(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ObjsMigrated_marshall10(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ObjsMigrated_marshall10(PUP::er &p,void *msg);

/* DECLS: void Loadbalancing(int level);
 */
    static int __idx_Loadbalancing_marshall11;
    static int Loadbalancing(int level) { return __idx_Loadbalancing_marshall11; }
    static void _call_Loadbalancing_marshall11(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_Loadbalancing_marshall11(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_Loadbalancing_marshall11(PUP::er &p,void *msg);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    static int __idx_NotifyObjectMigrationDone_marshall12;
    static int NotifyObjectMigrationDone(int impl_noname_1) { return __idx_NotifyObjectMigrationDone_marshall12; }
    static void _call_NotifyObjectMigrationDone_marshall12(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_NotifyObjectMigrationDone_marshall12(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_NotifyObjectMigrationDone_marshall12(PUP::er &p,void *msg);

/* DECLS: void StartCollectInfo(DummyMsg* impl_msg);
 */
    static int __idx_StartCollectInfo_DummyMsg;
    static int StartCollectInfo(DummyMsg* impl_msg) { return __idx_StartCollectInfo_DummyMsg; }
    static void _call_StartCollectInfo_DummyMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    static int __idx_CollectInfo_marshall14;
    static int CollectInfo(const Location *loc, int n, int fromlevel) { return __idx_CollectInfo_marshall14; }
    static void _call_CollectInfo_marshall14(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_CollectInfo_marshall14(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_CollectInfo_marshall14(PUP::er &p,void *msg);

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    static int __idx_PropagateInfo_marshall15;
    static int PropagateInfo(const Location *loc, int n, int fromlevel) { return __idx_PropagateInfo_marshall15; }
    static void _call_PropagateInfo_marshall15(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_PropagateInfo_marshall15(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_PropagateInfo_marshall15(PUP::er &p,void *msg);

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    static int __idx_reportLBQulity_marshall16;
    static int reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6) { return __idx_reportLBQulity_marshall16; }
    static void _call_reportLBQulity_marshall16(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_reportLBQulity_marshall16(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_reportLBQulity_marshall16(PUP::er &p,void *msg);

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    static int __idx_reportLBMem_marshall17;
    static int reportLBMem(double impl_noname_7) { return __idx_reportLBMem_marshall17; }
    static void _call_reportLBMem_marshall17(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_reportLBMem_marshall17(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_reportLBMem_marshall17(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
class CProxyElement_HybridBaseLB: public CProxyElement_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;
    typedef CProxySection_HybridBaseLB section_t;

    CProxyElement_HybridBaseLB(void) {}
    CProxyElement_HybridBaseLB(const IrrGroup *g) : CProxyElement_BaseLB(g){  }
    CProxyElement_HybridBaseLB(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_BaseLB(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_HybridBaseLB(CkGroupID _gid,int _onPE) : CProxyElement_BaseLB(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_BaseLB::ckSetGroupID(g);
    }
    HybridBaseLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HybridBaseLB* ckLocalBranch(CkGroupID gID) {
      return (HybridBaseLB*)CkLocalBranch(gID);
    }
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    void TotalObjMigrated(int count, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level);
 */
    void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    void NotifyObjectMigrationDone(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void StartCollectInfo(DummyMsg* impl_msg);
 */
    void StartCollectInfo(DummyMsg* impl_msg);

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    void CollectInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    void PropagateInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    void reportLBMem(double impl_noname_7, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxyElement_HybridBaseLB)
/* ---------------- collective proxy -------------- */
class CProxy_HybridBaseLB: public CProxy_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;
    typedef CProxySection_HybridBaseLB section_t;

    CProxy_HybridBaseLB(void) {}
    CProxy_HybridBaseLB(const IrrGroup *g) : CProxy_BaseLB(g){  }
    CProxy_HybridBaseLB(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_BaseLB(_gid,CK_DELCTOR_ARGS){  }
    CProxy_HybridBaseLB(CkGroupID _gid) : CProxy_BaseLB(_gid){  }
    CProxyElement_HybridBaseLB operator[](int onPE) const
      {return CProxyElement_HybridBaseLB(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_BaseLB::ckSetGroupID(g);
    }
    HybridBaseLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HybridBaseLB* ckLocalBranch(CkGroupID gID) {
      return (HybridBaseLB*)CkLocalBranch(gID);
    }
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */
    static CkGroupID ckNew(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_HybridBaseLB(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);
    void ProcessAtSync(int npes, int *pes);
    void ProcessAtSync(CmiGroup &grp);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, const CkEntryOptions *impl_e_opts=NULL);
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);
    void ResumeClients(CkReductionMsg* impl_msg, int npes, int *pes);
    void ResumeClients(CkReductionMsg* impl_msg, CmiGroup &grp);

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL);
    void ResumeClients(int balancing, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void ResumeClients(int balancing, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);
    void ReceiveMigration(LBMigrateMsg* impl_msg, int npes, int *pes);
    void ReceiveMigration(LBMigrateMsg* impl_msg, CmiGroup &grp);

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg, int npes, int *pes);
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg, CmiGroup &grp);

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    void TotalObjMigrated(int count, int level, const CkEntryOptions *impl_e_opts=NULL);
    void TotalObjMigrated(int count, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void TotalObjMigrated(int count, int level, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level);
 */
    void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);
    void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL);
    void Loadbalancing(int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void Loadbalancing(int level, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    void NotifyObjectMigrationDone(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);
    void NotifyObjectMigrationDone(int impl_noname_1, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void NotifyObjectMigrationDone(int impl_noname_1, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void StartCollectInfo(DummyMsg* impl_msg);
 */
    void StartCollectInfo(DummyMsg* impl_msg);
    void StartCollectInfo(DummyMsg* impl_msg, int npes, int *pes);
    void StartCollectInfo(DummyMsg* impl_msg, CmiGroup &grp);

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    void CollectInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);
    void CollectInfo(const Location *loc, int n, int fromlevel, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void CollectInfo(const Location *loc, int n, int fromlevel, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    void PropagateInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);
    void PropagateInfo(const Location *loc, int n, int fromlevel, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void PropagateInfo(const Location *loc, int n, int fromlevel, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, const CkEntryOptions *impl_e_opts=NULL);
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    void reportLBMem(double impl_noname_7, const CkEntryOptions *impl_e_opts=NULL);
    void reportLBMem(double impl_noname_7, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void reportLBMem(double impl_noname_7, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxy_HybridBaseLB)
/* ---------------- section proxy -------------- */
class CProxySection_HybridBaseLB: public CProxySection_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;
    typedef CProxySection_HybridBaseLB section_t;

    CProxySection_HybridBaseLB(void) {}
    CProxySection_HybridBaseLB(const IrrGroup *g) : CProxySection_BaseLB(g){  }
    CProxySection_HybridBaseLB(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_BaseLB(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_HybridBaseLB(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_BaseLB(_gid,_pelist,_npes){  }
    CProxySection_HybridBaseLB(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_BaseLB(n,_gid,_pelist,_npes){  }
    CProxySection_HybridBaseLB(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_BaseLB(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
   CK_DISAMBIG_GROUP_SECTION(CProxySection_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_BaseLB::ckSetGroupID(g);
    }
    HybridBaseLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HybridBaseLB* ckLocalBranch(CkGroupID gID) {
      return (HybridBaseLB*)CkLocalBranch(gID);
    }
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg);

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg);

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    void TotalObjMigrated(int count, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level);
 */
    void ObjsMigrated(const LDObjData *data, int m, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    void NotifyObjectMigrationDone(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void StartCollectInfo(DummyMsg* impl_msg);
 */
    void StartCollectInfo(DummyMsg* impl_msg);

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    void CollectInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    void PropagateInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    void reportLBMem(double impl_noname_7, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxySection_HybridBaseLB)
typedef CBaseT<BaseLB,CProxy_HybridBaseLB>  CBase_HybridBaseLB;

extern void _registerHybridBaseLB(void);
#endif
