/* DEFS: message cookieMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_cookieMsg::operator new(size_t s){
  return cookieMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_cookieMsg::operator new(size_t s, int* sz){
  return cookieMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_cookieMsg::operator new(size_t s, int* sz,const int pb){
  return cookieMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_cookieMsg::operator new(size_t s, const int p) {
  return cookieMsg::alloc(__idx, s, 0, p);
}
void* CMessage_cookieMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[1];
  offsets[0] = ALIGN8(sz);
  cookieMsg *newmsg = (cookieMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void CMessage_cookieMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_cookieMsg::pack(cookieMsg *msg) {
  return (void *) msg;
}
cookieMsg* CMessage_cookieMsg::unpack(void* buf) {
  cookieMsg *msg = (cookieMsg *) buf;
  return msg;
}
int CMessage_cookieMsg::__idx=0;
#endif

/* DEFS: message multicastSetupMsg{
CkArrayIndexMax arrIdx[];
int lastKnown[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_multicastSetupMsg::operator new(size_t s){
  return multicastSetupMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_multicastSetupMsg::operator new(size_t s, int* sz){
  return multicastSetupMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_multicastSetupMsg::operator new(size_t s, int* sz,const int pb){
  return multicastSetupMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_multicastSetupMsg::operator new(size_t s, int sz0, int sz1) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return multicastSetupMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_multicastSetupMsg::operator new(size_t s, int sz0, int sz1, const int p) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return multicastSetupMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_multicastSetupMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[3];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(CkArrayIndexMax)*sizes[0]);
  if(sizes==0)
    offsets[2] = offsets[0];
  else
    offsets[2] = offsets[1] + ALIGN8(sizeof(int)*sizes[1]);
  multicastSetupMsg *newmsg = (multicastSetupMsg *) CkAllocMsg(msgnum, offsets[2], pb);
  newmsg->arrIdx = (CkArrayIndexMax *) ((char *)newmsg + offsets[0]);
  newmsg->lastKnown = (int *) ((char *)newmsg + offsets[1]);
  return (void *) newmsg;
}
void CMessage_multicastSetupMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_multicastSetupMsg::pack(multicastSetupMsg *msg) {
  msg->arrIdx = (CkArrayIndexMax *) ((char *)msg->arrIdx - (char *)msg);
  msg->lastKnown = (int *) ((char *)msg->lastKnown - (char *)msg);
  return (void *) msg;
}
multicastSetupMsg* CMessage_multicastSetupMsg::unpack(void* buf) {
  multicastSetupMsg *msg = (multicastSetupMsg *) buf;
  msg->arrIdx = (CkArrayIndexMax *) ((size_t)msg->arrIdx + (char *)msg);
  msg->lastKnown = (int *) ((size_t)msg->lastKnown + (char *)msg);
  return msg;
}
int CMessage_multicastSetupMsg::__idx=0;
#endif

/* DEFS: message multicastGrpMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_multicastGrpMsg::operator new(size_t s){
  return multicastGrpMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_multicastGrpMsg::operator new(size_t s, int* sz){
  return multicastGrpMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_multicastGrpMsg::operator new(size_t s, int* sz,const int pb){
  return multicastGrpMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_multicastGrpMsg::operator new(size_t s, const int p) {
  return multicastGrpMsg::alloc(__idx, s, 0, p);
}
void* CMessage_multicastGrpMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[1];
  offsets[0] = ALIGN8(sz);
  multicastGrpMsg *newmsg = (multicastGrpMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void CMessage_multicastGrpMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_multicastGrpMsg::pack(multicastGrpMsg *msg) {
  return (void *) msg;
}
multicastGrpMsg* CMessage_multicastGrpMsg::unpack(void* buf) {
  multicastGrpMsg *msg = (multicastGrpMsg *) buf;
  return msg;
}
int CMessage_multicastGrpMsg::__idx=0;
#endif

/* DEFS: group CkMulticastMgr: IrrGroup{
CkMulticastMgr(CkMigrateMessage* impl_msg);
CkMulticastMgr(void);
CkMulticastMgr(int factor);
void setup(multicastSetupMsg* impl_msg);
void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
void teardown(const CkSectionInfo &sid);
void freeup(const CkSectionInfo &sid);
void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
void recvCookieInfo(const CkSectionInfo &s, int red);
void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
void recvMsg(multicastGrpMsg* impl_msg);
void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
void recvRedMsg(CkReductionMsg* impl_msg);
void updateRedNo(const mCastEntryPtr &e, int no);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CkMulticastMgr::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CkMulticastMgr(CkMigrateMessage* impl_msg);
 */

/* DEFS: CkMulticastMgr(void);
 */

/* DEFS: CkMulticastMgr(int factor);
 */

/* DEFS: void setup(multicastSetupMsg* impl_msg);
 */
void CProxyElement_CkMulticastMgr::setup(multicastSetupMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
 */
void CProxyElement_CkMulticastMgr::recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &child
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void teardown(const CkSectionInfo &sid);
 */
void CProxyElement_CkMulticastMgr::teardown(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void freeup(const CkSectionInfo &sid);
 */
void CProxyElement_CkMulticastMgr::freeup(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
 */
void CProxyElement_CkMulticastMgr::retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, const CkSectionInfo &srcInfo
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void recvCookieInfo(const CkSectionInfo &s, int red);
 */
void CProxyElement_CkMulticastMgr::recvCookieInfo(const CkSectionInfo &s, int red, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, int red
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
 */
void CProxyElement_CkMulticastMgr::retire(const CkSectionInfo &sid, const CkSectionInfo &root, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &root
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void recvMsg(multicastGrpMsg* impl_msg);
 */
void CProxyElement_CkMulticastMgr::recvMsg(multicastGrpMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0+CK_MSG_EXPEDITED);
}

/* DEFS: void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
 */
void CProxyElement_CkMulticastMgr::recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_data, impl_cnt_data;
  impl_off_data=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_data=sizeof(char)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_data,data,impl_cnt_data);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID(),0+CK_MSG_EXPEDITED);
}

/* DEFS: void recvRedMsg(CkReductionMsg* impl_msg);
 */
void CProxyElement_CkMulticastMgr::recvRedMsg(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0+CK_MSG_EXPEDITED);
}

/* DEFS: void updateRedNo(const mCastEntryPtr &e, int no);
 */
void CProxyElement_CkMulticastMgr::updateRedNo(const mCastEntryPtr &e, int no, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const mCastEntryPtr &e, int no
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: CkMulticastMgr(CkMigrateMessage* impl_msg);
 */
 int CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_CkMigrateMessage=0;
void CkIndex_CkMulticastMgr::_call_CkMulticastMgr_CkMigrateMessage(void* impl_msg,CkMulticastMgr * impl_obj)
{
  new (impl_obj) CkMulticastMgr((CkMigrateMessage*)impl_msg);
}

/* DEFS: CkMulticastMgr(void);
 */
CkGroupID CProxy_CkMulticastMgr::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_CkMulticastMgr::__idx, CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_void, impl_msg);
}
 int CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_void=0;
void CkIndex_CkMulticastMgr::_call_CkMulticastMgr_void(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) CkMulticastMgr();
}

/* DEFS: CkMulticastMgr(int factor);
 */
CkGroupID CProxy_CkMulticastMgr::ckNew(int factor, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int factor
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|factor;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|factor;
  }
  return CkCreateGroup(CkIndex_CkMulticastMgr::__idx, CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_marshall2, impl_msg);
}
  CProxy_CkMulticastMgr::CProxy_CkMulticastMgr(int factor, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int factor
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|factor;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|factor;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_CkMulticastMgr::__idx, CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_marshall2, impl_msg));
}
 int CkIndex_CkMulticastMgr::__idx_CkMulticastMgr_marshall2=0;
void CkIndex_CkMulticastMgr::_call_CkMulticastMgr_marshall2(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int factor*/
  PUP::fromMem implP(impl_buf);
  int factor; implP|factor;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) CkMulticastMgr(factor);
}
int CkIndex_CkMulticastMgr::_callmarshall_CkMulticastMgr_marshall2(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: int factor*/
  PUP::fromMem implP(impl_buf);
  int factor; implP|factor;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) CkMulticastMgr(factor);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_CkMulticastMgr_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int factor*/
  PUP::fromMem implP(impl_buf);
  int factor; implP|factor;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("factor");
  implDestP|factor;
}

/* DEFS: void setup(multicastSetupMsg* impl_msg);
 */
void CProxy_CkMulticastMgr::setup(multicastSetupMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::setup(multicastSetupMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::setup(multicastSetupMsg* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg=0;
void CkIndex_CkMulticastMgr::_call_setup_multicastSetupMsg(void* impl_msg,CkMulticastMgr * impl_obj)
{
  impl_obj->setup((multicastSetupMsg*)impl_msg);
}

/* DEFS: void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
 */
void CProxy_CkMulticastMgr::recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &child
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &child
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &child
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4=0;
void CkIndex_CkMulticastMgr::_call_recvCookie_marshall4(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &child*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo child; implP|child;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recvCookie(sid, child);
}
int CkIndex_CkMulticastMgr::_callmarshall_recvCookie_marshall4(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &child*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo child; implP|child;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recvCookie(sid, child);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_recvCookie_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &child*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo child; implP|child;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("sid");
  implDestP|sid;
  if (implDestP.hasComments()) implDestP.comment("child");
  implDestP|child;
}

/* DEFS: void teardown(const CkSectionInfo &sid);
 */
void CProxy_CkMulticastMgr::teardown(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::teardown(const CkSectionInfo &sid, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::teardown(const CkSectionInfo &sid, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_teardown_marshall5=0;
void CkIndex_CkMulticastMgr::_call_teardown_marshall5(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->teardown(sid);
}
int CkIndex_CkMulticastMgr::_callmarshall_teardown_marshall5(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->teardown(sid);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_teardown_marshall5(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("sid");
  implDestP|sid;
}

/* DEFS: void freeup(const CkSectionInfo &sid);
 */
void CProxy_CkMulticastMgr::freeup(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::freeup(const CkSectionInfo &sid, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::freeup(const CkSectionInfo &sid, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_freeup_marshall6=0;
void CkIndex_CkMulticastMgr::_call_freeup_marshall6(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->freeup(sid);
}
int CkIndex_CkMulticastMgr::_callmarshall_freeup_marshall6(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->freeup(sid);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_freeup_marshall6(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("sid");
  implDestP|sid;
}

/* DEFS: void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
 */
void CProxy_CkMulticastMgr::retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, const CkSectionInfo &srcInfo
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &s, const CkSectionInfo &srcInfo
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &s, const CkSectionInfo &srcInfo
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7=0;
void CkIndex_CkMulticastMgr::_call_retrieveCookie_marshall7(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &s, const CkSectionInfo &srcInfo*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  CkSectionInfo srcInfo; implP|srcInfo;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->retrieveCookie(s, srcInfo);
}
int CkIndex_CkMulticastMgr::_callmarshall_retrieveCookie_marshall7(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &s, const CkSectionInfo &srcInfo*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  CkSectionInfo srcInfo; implP|srcInfo;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->retrieveCookie(s, srcInfo);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_retrieveCookie_marshall7(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &s, const CkSectionInfo &srcInfo*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  CkSectionInfo srcInfo; implP|srcInfo;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
  if (implDestP.hasComments()) implDestP.comment("srcInfo");
  implDestP|srcInfo;
}

/* DEFS: void recvCookieInfo(const CkSectionInfo &s, int red);
 */
void CProxy_CkMulticastMgr::recvCookieInfo(const CkSectionInfo &s, int red, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, int red
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::recvCookieInfo(const CkSectionInfo &s, int red, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &s, int red
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::recvCookieInfo(const CkSectionInfo &s, int red, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &s, int red
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8=0;
void CkIndex_CkMulticastMgr::_call_recvCookieInfo_marshall8(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &s, int red*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  int red; implP|red;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recvCookieInfo(s, red);
}
int CkIndex_CkMulticastMgr::_callmarshall_recvCookieInfo_marshall8(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &s, int red*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  int red; implP|red;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recvCookieInfo(s, red);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_recvCookieInfo_marshall8(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &s, int red*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo s; implP|s;
  int red; implP|red;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
  if (implDestP.hasComments()) implDestP.comment("red");
  implDestP|red;
}

/* DEFS: void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
 */
void CProxy_CkMulticastMgr::retire(const CkSectionInfo &sid, const CkSectionInfo &root, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &root
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::retire(const CkSectionInfo &sid, const CkSectionInfo &root, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &root
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::retire(const CkSectionInfo &sid, const CkSectionInfo &root, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &root
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_retire_marshall9=0;
void CkIndex_CkMulticastMgr::_call_retire_marshall9(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &root*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo root; implP|root;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->retire(sid, root);
}
int CkIndex_CkMulticastMgr::_callmarshall_retire_marshall9(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &root*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo root; implP|root;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->retire(sid, root);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_retire_marshall9(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &sid, const CkSectionInfo &root*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo sid; implP|sid;
  CkSectionInfo root; implP|root;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("sid");
  implDestP|sid;
  if (implDestP.hasComments()) implDestP.comment("root");
  implDestP|root;
}

/* DEFS: void recvMsg(multicastGrpMsg* impl_msg);
 */
void CProxy_CkMulticastMgr::recvMsg(multicastGrpMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID(),0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvMsg(multicastGrpMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID(), npes, pes,0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvMsg(multicastGrpMsg* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID(), grp,0+CK_MSG_EXPEDITED);
}
 int CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg=0;
void CkIndex_CkMulticastMgr::_call_recvMsg_multicastGrpMsg(void* impl_msg,CkMulticastMgr * impl_obj)
{
  impl_obj->recvMsg((multicastGrpMsg*)impl_msg);
}

/* DEFS: void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
 */
void CProxy_CkMulticastMgr::recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_data, impl_cnt_data;
  impl_off_data=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_data=sizeof(char)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_data,data,impl_cnt_data);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID(),0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_data, impl_cnt_data;
  impl_off_data=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_data=sizeof(char)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_data,data,impl_cnt_data);
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID(), npes, pes,0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_data, impl_cnt_data;
  impl_off_data=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_data=sizeof(char)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_data,data,impl_cnt_data);
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID(), grp,0+CK_MSG_EXPEDITED);
}
 int CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11=0;
void CkIndex_CkMulticastMgr::_call_recvPacket_marshall11(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo _cookie; implP|_cookie;
  int n; implP|n;
  int impl_off_data, impl_cnt_data; 
  implP|impl_off_data;
  implP|impl_cnt_data;
  int seqno; implP|seqno;
  int count; implP|count;
  int totalsize; implP|totalsize;
  int frombufer; implP|frombufer;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *data=(char *)(impl_buf+impl_off_data);
  impl_obj->recvPacket(_cookie, n, data, seqno, count, totalsize, frombufer);
}
int CkIndex_CkMulticastMgr::_callmarshall_recvPacket_marshall11(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo _cookie; implP|_cookie;
  int n; implP|n;
  int impl_off_data, impl_cnt_data; 
  implP|impl_off_data;
  implP|impl_cnt_data;
  int seqno; implP|seqno;
  int count; implP|count;
  int totalsize; implP|totalsize;
  int frombufer; implP|frombufer;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *data=(char *)(impl_buf+impl_off_data);
  impl_obj->recvPacket(_cookie, n, data, seqno, count, totalsize, frombufer);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_recvPacket_marshall11(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer*/
  PUP::fromMem implP(impl_buf);
  CkSectionInfo _cookie; implP|_cookie;
  int n; implP|n;
  int impl_off_data, impl_cnt_data; 
  implP|impl_off_data;
  implP|impl_cnt_data;
  int seqno; implP|seqno;
  int count; implP|count;
  int totalsize; implP|totalsize;
  int frombufer; implP|frombufer;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *data=(char *)(impl_buf+impl_off_data);
  if (implDestP.hasComments()) implDestP.comment("_cookie");
  implDestP|_cookie;
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("data");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*data))<impl_cnt_data;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|data[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("seqno");
  implDestP|seqno;
  if (implDestP.hasComments()) implDestP.comment("count");
  implDestP|count;
  if (implDestP.hasComments()) implDestP.comment("totalsize");
  implDestP|totalsize;
  if (implDestP.hasComments()) implDestP.comment("frombufer");
  implDestP|frombufer;
}

/* DEFS: void recvRedMsg(CkReductionMsg* impl_msg);
 */
void CProxy_CkMulticastMgr::recvRedMsg(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID(),0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvRedMsg(CkReductionMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID(), npes, pes,0+CK_MSG_EXPEDITED);
}
void CProxy_CkMulticastMgr::recvRedMsg(CkReductionMsg* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID(), grp,0+CK_MSG_EXPEDITED);
}
 int CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg=0;
void CkIndex_CkMulticastMgr::_call_recvRedMsg_CkReductionMsg(void* impl_msg,CkMulticastMgr * impl_obj)
{
  impl_obj->recvRedMsg((CkReductionMsg*)impl_msg);
}

/* DEFS: void updateRedNo(const mCastEntryPtr &e, int no);
 */
void CProxy_CkMulticastMgr::updateRedNo(const mCastEntryPtr &e, int no, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const mCastEntryPtr &e, int no
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkMulticastMgr::updateRedNo(const mCastEntryPtr &e, int no, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const mCastEntryPtr &e, int no
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
  }
  CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkMulticastMgr::updateRedNo(const mCastEntryPtr &e, int no, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const mCastEntryPtr &e, int no
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
  }
  CkSendMsgBranchGroup(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13=0;
void CkIndex_CkMulticastMgr::_call_updateRedNo_marshall13(void* impl_msg,CkMulticastMgr * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const mCastEntryPtr &e, int no*/
  PUP::fromMem implP(impl_buf);
  mCastEntryPtr e; implP|e;
  int no; implP|no;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->updateRedNo(e, no);
}
int CkIndex_CkMulticastMgr::_callmarshall_updateRedNo_marshall13(char* impl_buf,CkMulticastMgr * impl_obj) {
  /*Unmarshall pup'd fields: const mCastEntryPtr &e, int no*/
  PUP::fromMem implP(impl_buf);
  mCastEntryPtr e; implP|e;
  int no; implP|no;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->updateRedNo(e, no);
  return implP.size();
}
void CkIndex_CkMulticastMgr::_marshallmessagepup_updateRedNo_marshall13(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const mCastEntryPtr &e, int no*/
  PUP::fromMem implP(impl_buf);
  mCastEntryPtr e; implP|e;
  int no; implP|no;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("e");
  implDestP|e;
  if (implDestP.hasComments()) implDestP.comment("no");
  implDestP|no;
}

/* DEFS: CkMulticastMgr(CkMigrateMessage* impl_msg);
 */

/* DEFS: CkMulticastMgr(void);
 */

/* DEFS: CkMulticastMgr(int factor);
 */

/* DEFS: void setup(multicastSetupMsg* impl_msg);
 */
void CProxySection_CkMulticastMgr::setup(multicastSetupMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_setup_multicastSetupMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
 */
void CProxySection_CkMulticastMgr::recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &child
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)child;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvCookie_marshall4, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void teardown(const CkSectionInfo &sid);
 */
void CProxySection_CkMulticastMgr::teardown(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_teardown_marshall5, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void freeup(const CkSectionInfo &sid);
 */
void CProxySection_CkMulticastMgr::freeup(const CkSectionInfo &sid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_freeup_marshall6, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
 */
void CProxySection_CkMulticastMgr::retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, const CkSectionInfo &srcInfo
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)srcInfo;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_retrieveCookie_marshall7, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void recvCookieInfo(const CkSectionInfo &s, int red);
 */
void CProxySection_CkMulticastMgr::recvCookieInfo(const CkSectionInfo &s, int red, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &s, int red
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)s;
    implP|red;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvCookieInfo_marshall8, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
 */
void CProxySection_CkMulticastMgr::retire(const CkSectionInfo &sid, const CkSectionInfo &root, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &sid, const CkSectionInfo &root
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)sid;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)root;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_retire_marshall9, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void recvMsg(multicastGrpMsg* impl_msg);
 */
void CProxySection_CkMulticastMgr::recvMsg(multicastGrpMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvMsg_multicastGrpMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0+CK_MSG_EXPEDITED);
    }
  }
}

/* DEFS: void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
 */
void CProxySection_CkMulticastMgr::recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_data, impl_cnt_data;
  impl_off_data=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_data=sizeof(char)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkSectionInfo &)_cookie;
    implP|n;
    implP|impl_off_data;
    implP|impl_cnt_data;
    implP|seqno;
    implP|count;
    implP|totalsize;
    implP|frombufer;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_data,data,impl_cnt_data);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvPacket_marshall11, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0+CK_MSG_EXPEDITED);
    }
  }
}

/* DEFS: void recvRedMsg(CkReductionMsg* impl_msg);
 */
void CProxySection_CkMulticastMgr::recvRedMsg(CkReductionMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_recvRedMsg_CkReductionMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0+CK_MSG_EXPEDITED);
    }
  }
}

/* DEFS: void updateRedNo(const mCastEntryPtr &e, int no);
 */
void CProxySection_CkMulticastMgr::updateRedNo(const mCastEntryPtr &e, int no, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const mCastEntryPtr &e, int no
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(mCastEntryPtr &)e;
    implP|no;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkMulticastMgr::__idx_updateRedNo_marshall13, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CkMulticastMgr::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CkMulticastMgr::isIrreducible());
// REG: CkMulticastMgr(CkMigrateMessage* impl_msg);
  __idx_CkMulticastMgr_CkMigrateMessage = CkRegisterEp("CkMulticastMgr(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_CkMulticastMgr_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_CkMulticastMgr_CkMigrateMessage);

// REG: CkMulticastMgr(void);
  __idx_CkMulticastMgr_void = CkRegisterEp("CkMulticastMgr(void)",
     (CkCallFnPtr)_call_CkMulticastMgr_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_CkMulticastMgr_void);

// REG: CkMulticastMgr(int factor);
  __idx_CkMulticastMgr_marshall2 = CkRegisterEp("CkMulticastMgr(int factor)",
     (CkCallFnPtr)_call_CkMulticastMgr_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_CkMulticastMgr_marshall2,(CkMarshallUnpackFn)_callmarshall_CkMulticastMgr_marshall2);
  CkRegisterMessagePupFn(__idx_CkMulticastMgr_marshall2,(CkMessagePupFn)_marshallmessagepup_CkMulticastMgr_marshall2);

// REG: void setup(multicastSetupMsg* impl_msg);
  __idx_setup_multicastSetupMsg = CkRegisterEp("setup(multicastSetupMsg* impl_msg)",
     (CkCallFnPtr)_call_setup_multicastSetupMsg, CMessage_multicastSetupMsg::__idx, __idx, 0);

// REG: void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
  __idx_recvCookie_marshall4 = CkRegisterEp("recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child)",
     (CkCallFnPtr)_call_recvCookie_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_recvCookie_marshall4,(CkMarshallUnpackFn)_callmarshall_recvCookie_marshall4);
  CkRegisterMessagePupFn(__idx_recvCookie_marshall4,(CkMessagePupFn)_marshallmessagepup_recvCookie_marshall4);

// REG: void teardown(const CkSectionInfo &sid);
  __idx_teardown_marshall5 = CkRegisterEp("teardown(const CkSectionInfo &sid)",
     (CkCallFnPtr)_call_teardown_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_teardown_marshall5,(CkMarshallUnpackFn)_callmarshall_teardown_marshall5);
  CkRegisterMessagePupFn(__idx_teardown_marshall5,(CkMessagePupFn)_marshallmessagepup_teardown_marshall5);

// REG: void freeup(const CkSectionInfo &sid);
  __idx_freeup_marshall6 = CkRegisterEp("freeup(const CkSectionInfo &sid)",
     (CkCallFnPtr)_call_freeup_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_freeup_marshall6,(CkMarshallUnpackFn)_callmarshall_freeup_marshall6);
  CkRegisterMessagePupFn(__idx_freeup_marshall6,(CkMessagePupFn)_marshallmessagepup_freeup_marshall6);

// REG: void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
  __idx_retrieveCookie_marshall7 = CkRegisterEp("retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo)",
     (CkCallFnPtr)_call_retrieveCookie_marshall7, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_retrieveCookie_marshall7,(CkMarshallUnpackFn)_callmarshall_retrieveCookie_marshall7);
  CkRegisterMessagePupFn(__idx_retrieveCookie_marshall7,(CkMessagePupFn)_marshallmessagepup_retrieveCookie_marshall7);

// REG: void recvCookieInfo(const CkSectionInfo &s, int red);
  __idx_recvCookieInfo_marshall8 = CkRegisterEp("recvCookieInfo(const CkSectionInfo &s, int red)",
     (CkCallFnPtr)_call_recvCookieInfo_marshall8, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_recvCookieInfo_marshall8,(CkMarshallUnpackFn)_callmarshall_recvCookieInfo_marshall8);
  CkRegisterMessagePupFn(__idx_recvCookieInfo_marshall8,(CkMessagePupFn)_marshallmessagepup_recvCookieInfo_marshall8);

// REG: void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
  __idx_retire_marshall9 = CkRegisterEp("retire(const CkSectionInfo &sid, const CkSectionInfo &root)",
     (CkCallFnPtr)_call_retire_marshall9, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_retire_marshall9,(CkMarshallUnpackFn)_callmarshall_retire_marshall9);
  CkRegisterMessagePupFn(__idx_retire_marshall9,(CkMessagePupFn)_marshallmessagepup_retire_marshall9);

// REG: void recvMsg(multicastGrpMsg* impl_msg);
  __idx_recvMsg_multicastGrpMsg = CkRegisterEp("recvMsg(multicastGrpMsg* impl_msg)",
     (CkCallFnPtr)_call_recvMsg_multicastGrpMsg, CMessage_multicastGrpMsg::__idx, __idx, 0+CK_EP_TRACEDISABLE);

// REG: void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
  __idx_recvPacket_marshall11 = CkRegisterEp("recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer)",
     (CkCallFnPtr)_call_recvPacket_marshall11, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_TRACEDISABLE);
  CkRegisterMarshallUnpackFn(__idx_recvPacket_marshall11,(CkMarshallUnpackFn)_callmarshall_recvPacket_marshall11);
  CkRegisterMessagePupFn(__idx_recvPacket_marshall11,(CkMessagePupFn)_marshallmessagepup_recvPacket_marshall11);

// REG: void recvRedMsg(CkReductionMsg* impl_msg);
  __idx_recvRedMsg_CkReductionMsg = CkRegisterEp("recvRedMsg(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_recvRedMsg_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0+CK_EP_TRACEDISABLE);

// REG: void updateRedNo(const mCastEntryPtr &e, int no);
  __idx_updateRedNo_marshall13 = CkRegisterEp("updateRedNo(const mCastEntryPtr &e, int no)",
     (CkCallFnPtr)_call_updateRedNo_marshall13, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_updateRedNo_marshall13,(CkMarshallUnpackFn)_callmarshall_updateRedNo_marshall13);
  CkRegisterMessagePupFn(__idx_updateRedNo_marshall13,(CkMessagePupFn)_marshallmessagepup_updateRedNo_marshall13);

}
#endif


#ifndef CK_TEMPLATES_ONLY
void _registerCkMulticast(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message cookieMsg;
*/
CMessage_cookieMsg::__register("cookieMsg", sizeof(cookieMsg),(CkPackFnPtr) cookieMsg::pack,(CkUnpackFnPtr) cookieMsg::unpack);

/* REG: message multicastSetupMsg{
CkArrayIndexMax arrIdx[];
int lastKnown[];
}
;
*/
CMessage_multicastSetupMsg::__register("multicastSetupMsg", sizeof(multicastSetupMsg),(CkPackFnPtr) multicastSetupMsg::pack,(CkUnpackFnPtr) multicastSetupMsg::unpack);

/* REG: message multicastGrpMsg;
*/
CMessage_multicastGrpMsg::__register("multicastGrpMsg", sizeof(multicastGrpMsg),(CkPackFnPtr) multicastGrpMsg::pack,(CkUnpackFnPtr) multicastGrpMsg::unpack);

/* REG: group CkMulticastMgr: IrrGroup{
CkMulticastMgr(CkMigrateMessage* impl_msg);
CkMulticastMgr(void);
CkMulticastMgr(int factor);
void setup(multicastSetupMsg* impl_msg);
void recvCookie(const CkSectionInfo &sid, const CkSectionInfo &child);
void teardown(const CkSectionInfo &sid);
void freeup(const CkSectionInfo &sid);
void retrieveCookie(const CkSectionInfo &s, const CkSectionInfo &srcInfo);
void recvCookieInfo(const CkSectionInfo &s, int red);
void retire(const CkSectionInfo &sid, const CkSectionInfo &root);
void recvMsg(multicastGrpMsg* impl_msg);
void recvPacket(const CkSectionInfo &_cookie, int n, const char *data, int seqno, int count, int totalsize, int frombufer);
void recvRedMsg(CkReductionMsg* impl_msg);
void updateRedNo(const mCastEntryPtr &e, int no);
};
*/
  CkIndex_CkMulticastMgr::__register("CkMulticastMgr", sizeof(CkMulticastMgr));

      _registerInitCall(_ckMulticastInit,1);

}
#endif
