

/* DEFS: template < class dtype > message MeshStreamerMessage{
int destinationPes[];
dtype data[];
}
;
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  void *CMessage_MeshStreamerMessage < dtype > ::operator new(size_t s){
  return MeshStreamerMessage < dtype > ::alloc(__idx, s, 0, 0);
}
template < class dtype >  void *CMessage_MeshStreamerMessage < dtype > ::operator new(size_t s, int* sz){
  return MeshStreamerMessage < dtype > ::alloc(__idx, s, sz, 0);
}
template < class dtype >  void *CMessage_MeshStreamerMessage < dtype > ::operator new(size_t s, int* sz,const int pb){
  return MeshStreamerMessage < dtype > ::alloc(__idx, s, sz, pb);
}
template < class dtype >  void *CMessage_MeshStreamerMessage < dtype > ::operator new(size_t s, int sz0, int sz1) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return MeshStreamerMessage < dtype > ::alloc(__idx, s, sizes, 0);
}
template < class dtype >  void *CMessage_MeshStreamerMessage < dtype > ::operator new(size_t s, int sz0, int sz1, const int p) {
  int sizes[2];
  sizes[0] = sz0;
  sizes[1] = sz1;
  return MeshStreamerMessage < dtype > ::alloc(__idx, s, sizes, p);
}
template < class dtype >  void* CMessage_MeshStreamerMessage < dtype > ::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  CkpvAccess(_offsets)[0] = ALIGN8(sz);
  if(sizes==0)
    CkpvAccess(_offsets)[1] = CkpvAccess(_offsets)[0];
  else
    CkpvAccess(_offsets)[1] = CkpvAccess(_offsets)[0] + ALIGN8(sizeof(int)*sizes[0]);
  if(sizes==0)
    CkpvAccess(_offsets)[2] = CkpvAccess(_offsets)[0];
  else
    CkpvAccess(_offsets)[2] = CkpvAccess(_offsets)[1] + ALIGN8(sizeof(dtype)*sizes[1]);
  return CkAllocMsg(msgnum, CkpvAccess(_offsets)[2], pb);
}
template < class dtype >  CMessage_MeshStreamerMessage < dtype > ::CMessage_MeshStreamerMessage() {
MeshStreamerMessage < dtype >  *newmsg = (MeshStreamerMessage < dtype >  *)this;
  newmsg->destinationPes = (int *) ((char *)newmsg + CkpvAccess(_offsets)[0]);
  newmsg->data = (dtype *) ((char *)newmsg + CkpvAccess(_offsets)[1]);
}
template < class dtype >  void CMessage_MeshStreamerMessage < dtype > ::dealloc(void *p) {
  CkFreeMsg(p);
}
template < class dtype >  void* CMessage_MeshStreamerMessage < dtype > ::pack(MeshStreamerMessage < dtype >  *msg) {
  msg->destinationPes = (int *) ((char *)msg->destinationPes - (char *)msg);
  msg->data = (dtype *) ((char *)msg->data - (char *)msg);
  return (void *) msg;
}
template < class dtype >  MeshStreamerMessage < dtype > * CMessage_MeshStreamerMessage < dtype > ::unpack(void* buf) {
  MeshStreamerMessage < dtype >  *msg = (MeshStreamerMessage < dtype >  *) buf;
  msg->destinationPes = (int *) ((size_t)msg->destinationPes + (char *)msg);
  msg->data = (dtype *) ((size_t)msg->data + (char *)msg);
  return msg;
}
template < class dtype >  int CMessage_MeshStreamerMessage < dtype > ::__idx=0;
#endif /* CK_TEMPLATES_ONLY */

/* DEFS: template < class dtype > group MeshStreamerGroupClient: IrrGroup{
void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  int CkIndex_MeshStreamerGroupClient < dtype > ::__idx=0;
/* DEFS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxyElement_MeshStreamerGroupClient < dtype > ::receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxy_MeshStreamerGroupClient < dtype > ::receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_MeshStreamerGroupClient < dtype > ::receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_MeshStreamerGroupClient < dtype > ::receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage=0;
template < class dtype >  void CkIndex_MeshStreamerGroupClient < dtype > ::_call_receiveCombinedData_MeshStreamerMessage(void* impl_msg,MeshStreamerGroupClient < dtype >  * impl_obj)
{
  impl_obj->receiveCombinedData((MeshStreamerMessage<dtype >*)impl_msg);
}

/* DEFS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxySection_MeshStreamerGroupClient < dtype > ::receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_MeshStreamerGroupClient < dtype > ::__idx_receiveCombinedData_MeshStreamerMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /* CK_TEMPLATES_ONLY */
#ifdef CK_TEMPLATES_ONLY
template < class dtype > void CkIndex_MeshStreamerGroupClient < dtype > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,MeshStreamerGroupClient < dtype > ::isIrreducible());
// REG: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
  __idx_receiveCombinedData_MeshStreamerMessage = CkRegisterEp("receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg)",
     (CkCallFnPtr)_call_receiveCombinedData_MeshStreamerMessage, CMessage_MeshStreamerMessage<dtype >::__idx, __idx, 0);

}
#endif /* CK_TEMPLATES_ONLY */

/* DEFS: template < class dtype > array MeshStreamerArrayClient: ArrayElement{
MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
void receiveRedeliveredItem(const dtype &data);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  int CkIndex_MeshStreamerArrayClient < dtype > ::__idx=0;
/* DEFS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */

/* DEFS: void receiveRedeliveredItem(const dtype &data);
 */
template < class dtype >  void CProxyElement_MeshStreamerArrayClient < dtype > ::receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const dtype &data
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MeshStreamerArrayClient < dtype > ::__idx_receiveRedeliveredItem_marshall1,0);
}

/* DEFS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */
template < class dtype >  int CkIndex_MeshStreamerArrayClient < dtype > ::__idx_MeshStreamerArrayClient_CkMigrateMessage=0;
template < class dtype >  void CkIndex_MeshStreamerArrayClient < dtype > ::_call_MeshStreamerArrayClient_CkMigrateMessage(void* impl_msg,MeshStreamerArrayClient < dtype >  * impl_obj)
{
  new (impl_obj) MeshStreamerArrayClient < dtype > ((CkMigrateMessage*)impl_msg);
}

/* DEFS: void receiveRedeliveredItem(const dtype &data);
 */
template < class dtype >  void CProxy_MeshStreamerArrayClient < dtype > ::receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const dtype &data
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MeshStreamerArrayClient < dtype > ::__idx_receiveRedeliveredItem_marshall1,0);
}
template < class dtype >  int CkIndex_MeshStreamerArrayClient < dtype > ::__idx_receiveRedeliveredItem_marshall1=0;
template < class dtype >  void CkIndex_MeshStreamerArrayClient < dtype > ::_call_receiveRedeliveredItem_marshall1(void* impl_msg,MeshStreamerArrayClient < dtype >  * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const dtype &data*/
  PUP::fromMem implP(impl_buf);
  dtype data; implP|data;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveRedeliveredItem(data);
}
template < class dtype >  int CkIndex_MeshStreamerArrayClient < dtype > ::_callmarshall_receiveRedeliveredItem_marshall1(char* impl_buf,MeshStreamerArrayClient < dtype >  * impl_obj) {
  /*Unmarshall pup'd fields: const dtype &data*/
  PUP::fromMem implP(impl_buf);
  dtype data; implP|data;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveRedeliveredItem(data);
  return implP.size();
}
template < class dtype >  void CkIndex_MeshStreamerArrayClient < dtype > ::_marshallmessagepup_receiveRedeliveredItem_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const dtype &data*/
  PUP::fromMem implP(impl_buf);
  dtype data; implP|data;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("data");
  implDestP|data;
}

/* DEFS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */

/* DEFS: void receiveRedeliveredItem(const dtype &data);
 */
template < class dtype >  void CProxySection_MeshStreamerArrayClient < dtype > ::receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const dtype &data
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(dtype &)data;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MeshStreamerArrayClient < dtype > ::__idx_receiveRedeliveredItem_marshall1,0);
}

#endif /* CK_TEMPLATES_ONLY */
#ifdef CK_TEMPLATES_ONLY
template < class dtype > void CkIndex_MeshStreamerArrayClient < dtype > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeArray);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
  __idx_MeshStreamerArrayClient_CkMigrateMessage = CkRegisterEp("MeshStreamerArrayClient(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_MeshStreamerArrayClient_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_MeshStreamerArrayClient_CkMigrateMessage);

// REG: void receiveRedeliveredItem(const dtype &data);
  __idx_receiveRedeliveredItem_marshall1 = CkRegisterEp("receiveRedeliveredItem(const dtype &data)",
     (CkCallFnPtr)_call_receiveRedeliveredItem_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_receiveRedeliveredItem_marshall1,(CkMarshallUnpackFn)_callmarshall_receiveRedeliveredItem_marshall1);
  CkRegisterMessagePupFn(__idx_receiveRedeliveredItem_marshall1,(CkMessagePupFn)_marshallmessagepup_receiveRedeliveredItem_marshall1);

}
#endif /* CK_TEMPLATES_ONLY */

/* DEFS: template < class dtype > group MeshStreamer: IrrGroup{
void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
void flushDirect(void);
void finish(void);
void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::__idx=0;
/* DEFS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxyElement_MeshStreamer < dtype > ::receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void flushDirect(void);
 */
template < class dtype >  void CProxyElement_MeshStreamer < dtype > ::flushDirect(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void finish(void);
 */
template < class dtype >  void CProxyElement_MeshStreamer < dtype > ::finish(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
template < class dtype >  void CProxyElement_MeshStreamer < dtype > ::associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxy_MeshStreamer < dtype > ::receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage=0;
template < class dtype >  void CkIndex_MeshStreamer < dtype > ::_call_receiveAlongRoute_MeshStreamerMessage(void* impl_msg,MeshStreamer < dtype >  * impl_obj)
{
  impl_obj->receiveAlongRoute((MeshStreamerMessage<dtype >*)impl_msg);
}

/* DEFS: void flushDirect(void);
 */
template < class dtype >  void CProxy_MeshStreamer < dtype > ::flushDirect(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::flushDirect(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::flushDirect(CmiGroup &grp) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchGroup(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void=0;
template < class dtype >  void CkIndex_MeshStreamer < dtype > ::_call_flushDirect_void(void* impl_msg,MeshStreamer < dtype >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->flushDirect();
}

/* DEFS: void finish(void);
 */
template < class dtype >  void CProxy_MeshStreamer < dtype > ::finish(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::finish(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::finish(CmiGroup &grp) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchGroup(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::__idx_finish_void=0;
template < class dtype >  void CkIndex_MeshStreamer < dtype > ::_call_finish_void(void* impl_msg,MeshStreamer < dtype >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->finish();
}

/* DEFS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
template < class dtype >  void CProxy_MeshStreamer < dtype > ::associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
  }
  CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_MeshStreamer < dtype > ::associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
  }
  CkSendMsgBranchGroup(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4=0;
template < class dtype >  void CkIndex_MeshStreamer < dtype > ::_call_associateCallback_marshall4(void* impl_msg,MeshStreamer < dtype >  * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector*/
  PUP::fromMem implP(impl_buf);
  CkCallback startCb; implP|startCb;
  CkCallback endCb; implP|endCb;
  CProxy_CompletionDetector detector; implP|detector;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->associateCallback(startCb, endCb, detector);
}
template < class dtype >  int CkIndex_MeshStreamer < dtype > ::_callmarshall_associateCallback_marshall4(char* impl_buf,MeshStreamer < dtype >  * impl_obj) {
  /*Unmarshall pup'd fields: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector*/
  PUP::fromMem implP(impl_buf);
  CkCallback startCb; implP|startCb;
  CkCallback endCb; implP|endCb;
  CProxy_CompletionDetector detector; implP|detector;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->associateCallback(startCb, endCb, detector);
  return implP.size();
}
template < class dtype >  void CkIndex_MeshStreamer < dtype > ::_marshallmessagepup_associateCallback_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector*/
  PUP::fromMem implP(impl_buf);
  CkCallback startCb; implP|startCb;
  CkCallback endCb; implP|endCb;
  CProxy_CompletionDetector detector; implP|detector;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("startCb");
  implDestP|startCb;
  if (implDestP.hasComments()) implDestP.comment("endCb");
  implDestP|endCb;
  if (implDestP.hasComments()) implDestP.comment("detector");
  implDestP|detector;
}

/* DEFS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
template < class dtype >  void CProxySection_MeshStreamer < dtype > ::receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_receiveAlongRoute_MeshStreamerMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void flushDirect(void);
 */
template < class dtype >  void CProxySection_MeshStreamer < dtype > ::flushDirect(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_flushDirect_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void finish(void);
 */
template < class dtype >  void CProxySection_MeshStreamer < dtype > ::finish(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_finish_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
template < class dtype >  void CProxySection_MeshStreamer < dtype > ::associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)startCb;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)endCb;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_CompletionDetector &)detector;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_MeshStreamer < dtype > ::__idx_associateCallback_marshall4, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /* CK_TEMPLATES_ONLY */
#ifdef CK_TEMPLATES_ONLY
template < class dtype > void CkIndex_MeshStreamer < dtype > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,MeshStreamer < dtype > ::isIrreducible());
// REG: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
  __idx_receiveAlongRoute_MeshStreamerMessage = CkRegisterEp("receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg)",
     (CkCallFnPtr)_call_receiveAlongRoute_MeshStreamerMessage, CMessage_MeshStreamerMessage<dtype >::__idx, __idx, 0);

// REG: void flushDirect(void);
  __idx_flushDirect_void = CkRegisterEp("flushDirect(void)",
     (CkCallFnPtr)_call_flushDirect_void, 0, __idx, 0);

// REG: void finish(void);
  __idx_finish_void = CkRegisterEp("finish(void)",
     (CkCallFnPtr)_call_finish_void, 0, __idx, 0);

// REG: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
  __idx_associateCallback_marshall4 = CkRegisterEp("associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector)",
     (CkCallFnPtr)_call_associateCallback_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_associateCallback_marshall4,(CkMarshallUnpackFn)_callmarshall_associateCallback_marshall4);
  CkRegisterMessagePupFn(__idx_associateCallback_marshall4,(CkMessagePupFn)_marshallmessagepup_associateCallback_marshall4);

}
#endif /* CK_TEMPLATES_ONLY */

/* DEFS: template < class dtype > group GroupMeshStreamer: MeshStreamer<dtype >{
GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  int CkIndex_GroupMeshStreamer < dtype > ::__idx=0;
/* DEFS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

/* DEFS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
template < class dtype >  CkGroupID CProxy_GroupMeshStreamer < dtype > ::ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes;
  impl_off_dimensionSizes=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_dimensionSizes=sizeof(int)*(numDimensions));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerGroupClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerGroupClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dimensionSizes,dimensionSizes,impl_cnt_dimensionSizes);
  return CkCreateGroup(CkIndex_GroupMeshStreamer < dtype > ::__idx, CkIndex_GroupMeshStreamer < dtype > ::__idx_GroupMeshStreamer_marshall1, impl_msg);
}
template < class dtype >    CProxy_GroupMeshStreamer < dtype > ::CProxy_GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes;
  impl_off_dimensionSizes=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_dimensionSizes=sizeof(int)*(numDimensions));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerGroupClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerGroupClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dimensionSizes,dimensionSizes,impl_cnt_dimensionSizes);
  ckSetGroupID(CkCreateGroup(CkIndex_GroupMeshStreamer < dtype > ::__idx, CkIndex_GroupMeshStreamer < dtype > ::__idx_GroupMeshStreamer_marshall1, impl_msg));
}
template < class dtype >  int CkIndex_GroupMeshStreamer < dtype > ::__idx_GroupMeshStreamer_marshall1=0;
template < class dtype >  void CkIndex_GroupMeshStreamer < dtype > ::_call_GroupMeshStreamer_marshall1(void* impl_msg,GroupMeshStreamer < dtype >  * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerGroupClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  new (impl_obj) GroupMeshStreamer < dtype > (totalBufferCapacity, numDimensions, dimensionSizes, clientProxy, yieldFlag, progressPeriodInMs);
}
template < class dtype >  int CkIndex_GroupMeshStreamer < dtype > ::_callmarshall_GroupMeshStreamer_marshall1(char* impl_buf,GroupMeshStreamer < dtype >  * impl_obj) {
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerGroupClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  new (impl_obj) GroupMeshStreamer < dtype > (totalBufferCapacity, numDimensions, dimensionSizes, clientProxy, yieldFlag, progressPeriodInMs);
  return implP.size();
}
template < class dtype >  void CkIndex_GroupMeshStreamer < dtype > ::_marshallmessagepup_GroupMeshStreamer_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerGroupClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  if (implDestP.hasComments()) implDestP.comment("totalBufferCapacity");
  implDestP|totalBufferCapacity;
  if (implDestP.hasComments()) implDestP.comment("numDimensions");
  implDestP|numDimensions;
  if (implDestP.hasComments()) implDestP.comment("dimensionSizes");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*dimensionSizes))<impl_cnt_dimensionSizes;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|dimensionSizes[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("clientProxy");
  implDestP|clientProxy;
  if (implDestP.hasComments()) implDestP.comment("yieldFlag");
  implDestP|yieldFlag;
  if (implDestP.hasComments()) implDestP.comment("progressPeriodInMs");
  implDestP|progressPeriodInMs;
}

/* DEFS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

#endif /* CK_TEMPLATES_ONLY */
#ifdef CK_TEMPLATES_ONLY
template < class dtype > void CkIndex_GroupMeshStreamer < dtype > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_MeshStreamer<dtype >::__idx);
   CkRegisterGroupIrr(__idx,GroupMeshStreamer < dtype > ::isIrreducible());
// REG: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
  __idx_GroupMeshStreamer_marshall1 = CkRegisterEp("GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs)",
     (CkCallFnPtr)_call_GroupMeshStreamer_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_GroupMeshStreamer_marshall1,(CkMarshallUnpackFn)_callmarshall_GroupMeshStreamer_marshall1);
  CkRegisterMessagePupFn(__idx_GroupMeshStreamer_marshall1,(CkMessagePupFn)_marshallmessagepup_GroupMeshStreamer_marshall1);

}
#endif /* CK_TEMPLATES_ONLY */

/* DEFS: template < class dtype > group ArrayMeshStreamer: MeshStreamer<ArrayDataItem<dtype > >{
ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class dtype >  int CkIndex_ArrayMeshStreamer < dtype > ::__idx=0;
/* DEFS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

/* DEFS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
template < class dtype >  void CProxyElement_ArrayMeshStreamer < dtype > ::receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
template < class dtype >  CkGroupID CProxy_ArrayMeshStreamer < dtype > ::ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes;
  impl_off_dimensionSizes=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_dimensionSizes=sizeof(int)*(numDimensions));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerArrayClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerArrayClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dimensionSizes,dimensionSizes,impl_cnt_dimensionSizes);
  return CkCreateGroup(CkIndex_ArrayMeshStreamer < dtype > ::__idx, CkIndex_ArrayMeshStreamer < dtype > ::__idx_ArrayMeshStreamer_marshall1, impl_msg);
}
template < class dtype >    CProxy_ArrayMeshStreamer < dtype > ::CProxy_ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes;
  impl_off_dimensionSizes=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_dimensionSizes=sizeof(int)*(numDimensions));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerArrayClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|totalBufferCapacity;
    implP|numDimensions;
    implP|impl_off_dimensionSizes;
    implP|impl_cnt_dimensionSizes;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MeshStreamerArrayClient<dtype > &)clientProxy;
    implP|yieldFlag;
    implP|progressPeriodInMs;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dimensionSizes,dimensionSizes,impl_cnt_dimensionSizes);
  ckSetGroupID(CkCreateGroup(CkIndex_ArrayMeshStreamer < dtype > ::__idx, CkIndex_ArrayMeshStreamer < dtype > ::__idx_ArrayMeshStreamer_marshall1, impl_msg));
}
template < class dtype >  int CkIndex_ArrayMeshStreamer < dtype > ::__idx_ArrayMeshStreamer_marshall1=0;
template < class dtype >  void CkIndex_ArrayMeshStreamer < dtype > ::_call_ArrayMeshStreamer_marshall1(void* impl_msg,ArrayMeshStreamer < dtype >  * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerArrayClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  new (impl_obj) ArrayMeshStreamer < dtype > (totalBufferCapacity, numDimensions, dimensionSizes, clientProxy, yieldFlag, progressPeriodInMs);
}
template < class dtype >  int CkIndex_ArrayMeshStreamer < dtype > ::_callmarshall_ArrayMeshStreamer_marshall1(char* impl_buf,ArrayMeshStreamer < dtype >  * impl_obj) {
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerArrayClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  new (impl_obj) ArrayMeshStreamer < dtype > (totalBufferCapacity, numDimensions, dimensionSizes, clientProxy, yieldFlag, progressPeriodInMs);
  return implP.size();
}
template < class dtype >  void CkIndex_ArrayMeshStreamer < dtype > ::_marshallmessagepup_ArrayMeshStreamer_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs*/
  PUP::fromMem implP(impl_buf);
  int totalBufferCapacity; implP|totalBufferCapacity;
  int numDimensions; implP|numDimensions;
  int impl_off_dimensionSizes, impl_cnt_dimensionSizes; 
  implP|impl_off_dimensionSizes;
  implP|impl_cnt_dimensionSizes;
  CProxy_MeshStreamerArrayClient<dtype > clientProxy; implP|clientProxy;
  bool yieldFlag; implP|yieldFlag;
  double progressPeriodInMs; implP|progressPeriodInMs;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *dimensionSizes=(int *)(impl_buf+impl_off_dimensionSizes);
  if (implDestP.hasComments()) implDestP.comment("totalBufferCapacity");
  implDestP|totalBufferCapacity;
  if (implDestP.hasComments()) implDestP.comment("numDimensions");
  implDestP|numDimensions;
  if (implDestP.hasComments()) implDestP.comment("dimensionSizes");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*dimensionSizes))<impl_cnt_dimensionSizes;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|dimensionSizes[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("clientProxy");
  implDestP|clientProxy;
  if (implDestP.hasComments()) implDestP.comment("yieldFlag");
  implDestP|yieldFlag;
  if (implDestP.hasComments()) implDestP.comment("progressPeriodInMs");
  implDestP|progressPeriodInMs;
}

/* DEFS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
template < class dtype >  void CProxy_ArrayMeshStreamer < dtype > ::receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID(),0);
}
template < class dtype >  void CProxy_ArrayMeshStreamer < dtype > ::receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID(), npes, pes,0);
}
template < class dtype >  void CProxy_ArrayMeshStreamer < dtype > ::receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID(), grp,0);
}
template < class dtype >  int CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage=0;
template < class dtype >  void CkIndex_ArrayMeshStreamer < dtype > ::_call_receiveArrayData_MeshStreamerMessage(void* impl_msg,ArrayMeshStreamer < dtype >  * impl_obj)
{
  impl_obj->receiveArrayData((MeshStreamerMessage<ArrayDataItem<dtype > >*)impl_msg);
}

/* DEFS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

/* DEFS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
template < class dtype >  void CProxySection_ArrayMeshStreamer < dtype > ::receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_ArrayMeshStreamer < dtype > ::__idx_receiveArrayData_MeshStreamerMessage, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /* CK_TEMPLATES_ONLY */
#ifdef CK_TEMPLATES_ONLY
template < class dtype > void CkIndex_ArrayMeshStreamer < dtype > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_MeshStreamer<ArrayDataItem<dtype > >::__idx);
   CkRegisterGroupIrr(__idx,ArrayMeshStreamer < dtype > ::isIrreducible());
// REG: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
  __idx_ArrayMeshStreamer_marshall1 = CkRegisterEp("ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs)",
     (CkCallFnPtr)_call_ArrayMeshStreamer_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ArrayMeshStreamer_marshall1,(CkMarshallUnpackFn)_callmarshall_ArrayMeshStreamer_marshall1);
  CkRegisterMessagePupFn(__idx_ArrayMeshStreamer_marshall1,(CkMessagePupFn)_marshallmessagepup_ArrayMeshStreamer_marshall1);

// REG: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
  __idx_receiveArrayData_MeshStreamerMessage = CkRegisterEp("receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg)",
     (CkCallFnPtr)_call_receiveArrayData_MeshStreamerMessage, CMessage_MeshStreamerMessage<ArrayDataItem<dtype > >::__idx, __idx, 0);

}
#endif /* CK_TEMPLATES_ONLY */

#ifndef CK_TEMPLATES_ONLY
void _registerNDMeshStreamer(void)
{
  static int _done = 0; if(_done) return; _done = 1;
      _registercompletion();








}
#endif /* CK_TEMPLATES_ONLY */
